/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownBlocks;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownRangedFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownWrappingFormattingBlock;
import org.intellij.plugins.markdown.util.ASTUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r0\fJ@\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r0\fJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownBlocks;", "", "()V", "create", "Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownFormattingBlock;", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacing", "Lcom/intellij/formatting/SpacingBuilder;", "align", "Lkotlin/Function1;", "Lcom/intellij/formatting/Alignment;", "Lkotlin/sequences/Sequence;", "nodes", "filterFromWhitespaces", "sequence", "intellij.markdown"})
public final class MarkdownBlocks {
    @NotNull
    public static final MarkdownBlocks INSTANCE;

    @NotNull
    public final Sequence<MarkdownFormattingBlock> create(@NotNull Sequence<? extends ASTNode> nodes, @NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull Function1<? super ASTNode, ? extends Alignment> align) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        Intrinsics.checkNotNullParameter(align, (String)"align");
        return SequencesKt.map(this.filterFromWhitespaces(nodes), (Function1)((Function1)new Function1<ASTNode, MarkdownFormattingBlock>(settings, spacing, align){
            final /* synthetic */ CodeStyleSettings $settings;
            final /* synthetic */ SpacingBuilder $spacing;
            final /* synthetic */ Function1 $align;

            @NotNull
            public final MarkdownFormattingBlock invoke(@NotNull ASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MarkdownBlocks.INSTANCE.create(it, this.$settings, this.$spacing, (Function1<? super ASTNode, ? extends Alignment>)this.$align);
            }
            {
                this.$settings = codeStyleSettings;
                this.$spacing = spacingBuilder;
                this.$align = function1;
                super(1);
            }
        }));
    }

    @NotNull
    public final MarkdownFormattingBlock create(@NotNull ASTNode node, @NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull Function1<? super ASTNode, ? extends Alignment> align) {
        MarkdownFormattingBlock markdownFormattingBlock;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        Intrinsics.checkNotNullParameter(align, (String)"align");
        IElementType iElementType = node.getElementType();
        if (MarkdownTokenTypeSets.LIST_MARKERS.contains(iElementType) || MarkdownTokenTypeSets.WHITE_SPACES.contains(iElementType) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BLOCK_QUOTE)) {
            markdownFormattingBlock = MarkdownRangedFormattingBlock.Companion.trimmed(node, settings, spacing, (Alignment)align.invoke((Object)node), null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.EMPH) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRIKETHROUGH)) {
            boolean bl;
            block5: {
                Sequence<ASTNode> $this$any$iv = ASTUtilsKt.parents(node);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)MarkdownTokenTypeSets.BLOCK_QUOTE)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            markdownFormattingBlock = bl ? new MarkdownFormattingBlock(node, settings, spacing, (Alignment)align.invoke((Object)node), null, 16, null) : (MarkdownFormattingBlock)new MarkdownWrappingFormattingBlock(settings, spacing, node, (Alignment)align.invoke((Object)node), null, 16, null);
        } else {
            markdownFormattingBlock = new MarkdownFormattingBlock(node, settings, spacing, (Alignment)align.invoke((Object)node), null, 16, null);
        }
        return markdownFormattingBlock;
    }

    @NotNull
    public final Sequence<ASTNode> filterFromWhitespaces(@NotNull Sequence<? extends ASTNode> sequence) {
        Intrinsics.checkNotNullParameter(sequence, (String)"sequence");
        return SequencesKt.filter(sequence, (Function1)filterFromWhitespaces.1.INSTANCE);
    }

    private MarkdownBlocks() {
    }

    static {
        MarkdownBlocks markdownBlocks;
        INSTANCE = markdownBlocks = new MarkdownBlocks();
    }
}

