/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionWithExternalFiles;
import org.intellij.plugins.markdown.settings.MarkdownExtensionsSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\u0004J\u001a\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/settings/MarkdownSettingsUtil;", "", "()V", "downloadExtension", "", "extension", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithExternalFiles;", "project", "Lcom/intellij/openapi/project/Project;", "enableAfterDownload", "downloadExtensionFiles", "parentComponent", "Ljavax/swing/JComponent;", "intellij.markdown"})
public final class MarkdownSettingsUtil {
    @NotNull
    public static final MarkdownSettingsUtil INSTANCE;

    public final boolean downloadExtensionFiles(@NotNull MarkdownExtensionWithExternalFiles extension, @Nullable JComponent parentComponent) {
        List list;
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        DownloadableFileService downloader = DownloadableFileService.getInstance();
        String string = extension.getDownloadLink();
        if (string == null) {
            String string2 = "Could not download files with empty link!";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        DownloadableFileDescription downloadableFileDescription = downloader.createFileDescription(string, extension.getDownloadFilename());
        Intrinsics.checkNotNullExpressionValue((Object)downloadableFileDescription, (String)"downloader.createFileDes\u2026on.downloadFilename\n    )");
        DownloadableFileDescription description = downloadableFileDescription;
        if (extension.getDirectory().exists()) {
            extension.getDirectory().delete();
        }
        List list2 = downloader.createDownloader(CollectionsKt.listOf((Object)description), extension.getDownloadFilename()).downloadFilesWithProgress(extension.getDirectory().getAbsolutePath(), null, parentComponent);
        if (list2 != null) {
            List list3 = list2;
            boolean bl = false;
            boolean bl2 = false;
            List it = list3;
            boolean bl3 = false;
            extension.afterDownload();
            list = list3;
        } else {
            list = null;
        }
        List result = list;
        return result != null;
    }

    public static /* synthetic */ boolean downloadExtensionFiles$default(MarkdownSettingsUtil markdownSettingsUtil, MarkdownExtensionWithExternalFiles markdownExtensionWithExternalFiles, JComponent jComponent, int n, Object object) {
        if ((n & 2) != 0) {
            jComponent = null;
        }
        return markdownSettingsUtil.downloadExtensionFiles(markdownExtensionWithExternalFiles, jComponent);
    }

    public final boolean downloadExtension(@NotNull MarkdownExtensionWithExternalFiles extension, @Nullable Project project, boolean enableAfterDownload) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        if (MarkdownSettingsUtil.downloadExtensionFiles$default(this, extension, null, 2, null)) {
            if (enableAfterDownload) {
                MarkdownExtensionsSettings.Companion.getInstance().getExtensionsEnabledState().put(extension.getId(), true);
            }
            Notifications.Bus.notify((Notification)new Notification("Markdown", MarkdownBundle.message("markdown.settings.download.extension.notification.title", new Object[0]), MarkdownBundle.message("markdown.settings.download.extension.notification.success.content", new Object[0]), NotificationType.INFORMATION));
            return true;
        }
        Notifications.Bus.notify((Notification)new Notification("Markdown", MarkdownBundle.message("markdown.settings.download.extension.notification.title", new Object[0]), MarkdownBundle.message("markdown.settings.download.extension.notification.failure.content", new Object[0]), NotificationType.ERROR));
        return false;
    }

    public static /* synthetic */ boolean downloadExtension$default(MarkdownSettingsUtil markdownSettingsUtil, MarkdownExtensionWithExternalFiles markdownExtensionWithExternalFiles, Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return markdownSettingsUtil.downloadExtension(markdownExtensionWithExternalFiles, project, bl);
    }

    private MarkdownSettingsUtil() {
    }

    static {
        MarkdownSettingsUtil markdownSettingsUtil;
        INSTANCE = markdownSettingsUtil = new MarkdownSettingsUtil();
    }
}

