/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownEditorWithPreview
extends TextEditorWithPreview {
    public static final Key<MarkdownEditorWithPreview> PARENT_SPLIT_EDITOR_KEY = Key.create((String)"parentSplit");
    private boolean myAutoScrollPreview;
    private final List<SplitLayoutListener> myLayoutListeners;

    public MarkdownEditorWithPreview(@NotNull TextEditor editor2, @NotNull MarkdownPreviewFileEditor preview) {
        if (editor2 == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(0);
        }
        if (preview == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(1);
        }
        super(editor2, (FileEditor)preview, MarkdownBundle.message("markdown.editor.name", new Object[0]), TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW, !MarkdownSettings.getInstance(ProjectUtil.currentOrDefaultProject((Project)editor2.getEditor().getProject())).isVerticalSplit());
        this.myLayoutListeners = new ArrayList<SplitLayoutListener>();
        editor2.putUserData(PARENT_SPLIT_EDITOR_KEY, (Object)this);
        preview.putUserData(PARENT_SPLIT_EDITOR_KEY, (Object)this);
        preview.setMainEditor(editor2.getEditor());
        Project project = ProjectUtil.currentOrDefaultProject((Project)editor2.getEditor().getProject());
        MarkdownSettings settings = MarkdownSettings.getInstance(project);
        this.myAutoScrollPreview = settings.isAutoScrollEnabled();
        MarkdownSettings.ChangeListener settingsChangedListener = new MarkdownSettings.ChangeListener(){

            @Override
            public void beforeSettingsChanged(@NotNull MarkdownSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void settingsChanged(@NotNull MarkdownSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                MarkdownEditorWithPreview.this.setAutoScrollPreview(settings.isAutoScrollEnabled());
                MarkdownEditorWithPreview.this.handleLayoutChange(!settings.isVerticalSplit());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeSettingsChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "settingsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(MarkdownSettings.ChangeListener.TOPIC, (Object)settingsChangedListener);
        this.getTextEditor().getEditor().getScrollingModel().addVisibleAreaListener((VisibleAreaListener)new MyVisibleAreaListener());
    }

    public void addLayoutListener(SplitLayoutListener listener) {
        this.myLayoutListeners.add(listener);
    }

    public void removeLayoutListener(SplitLayoutListener listener) {
        this.myLayoutListeners.remove(listener);
    }

    protected void onLayoutChange(TextEditorWithPreview.Layout oldValue, TextEditorWithPreview.Layout newValue) {
        this.myLayoutListeners.forEach(listener -> listener.onLayoutChange(oldValue, newValue));
        super.onLayoutChange(oldValue, newValue);
    }

    public boolean isAutoScrollPreview() {
        return this.myAutoScrollPreview;
    }

    public void setAutoScrollPreview(boolean autoScrollPreview) {
        this.myAutoScrollPreview = autoScrollPreview;
    }

    @Nullable
    protected ActionGroup createLeftToolbarActionGroup() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "preview";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private int previousLine = 0;

        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent event) {
            int currentLine;
            if (event == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(0);
            }
            if (!MarkdownEditorWithPreview.this.isAutoScrollPreview()) {
                return;
            }
            Editor editor2 = event.getEditor();
            int y = editor2.getScrollingModel().getVerticalScrollOffset();
            int n = currentLine = editor2 instanceof EditorImpl ? editor2.yToVisualLine(y) : y / editor2.getLineHeight();
            if (currentLine == this.previousLine) {
                return;
            }
            this.previousLine = currentLine;
            ((MarkdownPreviewFileEditor)MarkdownEditorWithPreview.this.getPreviewEditor()).scrollToSrcOffset(EditorUtil.getVisualLineEndOffset((Editor)editor2, (int)currentLine));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview$MyVisibleAreaListener", "visibleAreaChanged"));
        }
    }

    public static interface SplitLayoutListener
    extends EventListener {
        public void onLayoutChange(TextEditorWithPreview.Layout var1, TextEditorWithPreview.Layout var2);
    }
}

