/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.client.common;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.client.common.Renderer;
import org.jetbrains.projector.client.common.canvas.Canvas;
import org.jetbrains.projector.client.common.canvas.Context2d;
import org.jetbrains.projector.client.common.canvas.Context2dDrawOperations;
import org.jetbrains.projector.client.common.canvas.Context2dStateOperations;
import org.jetbrains.projector.client.common.canvas.Extensions;
import org.jetbrains.projector.client.common.canvas.PaintColor;
import org.jetbrains.projector.client.common.canvas.buffering.RenderingSurface;
import org.jetbrains.projector.client.common.misc.ParamsProvider;
import org.jetbrains.projector.client.common.misc.RepaintAreaSetting;
import org.jetbrains.projector.common.misc.Defaults;
import org.jetbrains.projector.common.misc.Do;
import org.jetbrains.projector.common.protocol.data.AlphaCompositeRule;
import org.jetbrains.projector.common.protocol.data.CommonAlphaComposite;
import org.jetbrains.projector.common.protocol.data.CommonComposite;
import org.jetbrains.projector.common.protocol.data.CommonPath;
import org.jetbrains.projector.common.protocol.data.CommonRectangle;
import org.jetbrains.projector.common.protocol.data.CommonShape;
import org.jetbrains.projector.common.protocol.data.PaintType;
import org.jetbrains.projector.common.protocol.data.Point;
import org.jetbrains.projector.common.protocol.data.StrokeData;
import org.jetbrains.projector.common.protocol.data.UnknownComposite;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 s2\u00020\u0001:\u0001sB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u0018H\u0002J\u0016\u0010$\u001a\u00020\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120&H\u0002J6\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u0012J\u001e\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u0012J.\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012JN\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u0012J\u001c\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u0002002\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00120&J\u000e\u00108\u001a\u00020\u00102\u0006\u0010/\u001a\u000200J&\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u0012J\u0014\u0010>\u001a\u00020\u00102\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0&J&\u0010A\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010C\u001a\u00020\u0012J\b\u0010D\u001a\u00020\u0010H\u0002J\b\u0010E\u001a\u00020\u0010H\u0002J\b\u0010F\u001a\u00020\u0010H\u0002J\b\u0010G\u001a\u00020\u0010H\u0002J\b\u0010H\u001a\u00020\u0010H\u0002J\u0010\u0010I\u001a\u00020\u00102\u0006\u0010J\u001a\u00020KH\u0002J\b\u0010L\u001a\u00020\u0010H\u0002J\b\u0010M\u001a\u00020\u0010H\u0002J\b\u0010N\u001a\u00020\u0010H\u0002J\b\u0010O\u001a\u00020\u0010H\u0002J.\u0010P\u001a\u00020\u00102\u0006\u0010J\u001a\u00020K2\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012J\u0016\u0010Q\u001a\u00020\u00102\u0006\u0010J\u001a\u00020K2\u0006\u0010R\u001a\u00020SJ\u001c\u0010T\u001a\u00020\u00102\u0006\u0010J\u001a\u00020K2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0&J.\u0010U\u001a\u00020\u00102\u0006\u0010J\u001a\u00020K2\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012J>\u0010V\u001a\u00020\u00102\u0006\u0010J\u001a\u00020K2\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010W\u001a\u00020\u00122\u0006\u0010X\u001a\u00020\u00122\u0006\u0010Y\u001a\u00020\u00122\u0006\u0010Z\u001a\u00020\u0012J\u0010\u0010[\u001a\u00020\u00102\b\u0010\\\u001a\u0004\u0018\u00010\u0015J\u000e\u0010]\u001a\u00020\u00102\u0006\u0010^\u001a\u00020_J\u000e\u0010`\u001a\u00020\u00102\u0006\u0010a\u001a\u00020bJ%\u0010c\u001a\u00020\u00102\b\u0010d\u001a\u0004\u0018\u00010e2\u0006\u0010f\u001a\u00020_2\u0006\u0010g\u001a\u00020h\u00a2\u0006\u0002\u0010iJ&\u0010j\u001a\u00020\u00102\u0006\u0010k\u001a\u00020@2\u0006\u0010l\u001a\u00020@2\u0006\u0010m\u001a\u00020_2\u0006\u0010n\u001a\u00020_J\u000e\u0010o\u001a\u00020\u00102\u0006\u0010p\u001a\u00020!J\u0014\u0010q\u001a\u00020\u00102\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00120&J\f\u0010r\u001a\u00020\u001b*\u00020hH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006t"}, d2={"Lorg/jetbrains/projector/client/common/Renderer;", "", "renderingSurface", "Lorg/jetbrains/projector/client/common/canvas/buffering/RenderingSurface;", "(Lorg/jetbrains/projector/client/common/canvas/buffering/RenderingSurface;)V", "canvasState", "Lorg/jetbrains/projector/client/common/Renderer$Companion$CanvasRenderingState;", "ctx", "Lorg/jetbrains/projector/client/common/canvas/Context2d;", "getCtx", "()Lorg/jetbrains/projector/client/common/canvas/Context2d;", "requestedState", "Lorg/jetbrains/projector/client/common/Renderer$Companion$RequestedRenderingState;", "getRequestedState", "()Lorg/jetbrains/projector/client/common/Renderer$Companion$RequestedRenderingState;", "applyAlpha", "", "newAlpha", "", "applyClip", "newIdentitySpaceClip", "Lorg/jetbrains/projector/common/protocol/data/CommonShape;", "applyFillStyle", "newFillStyle", "Lorg/jetbrains/projector/client/common/canvas/PaintColor;", "applyFont", "newFont", "", "applyRule", "newRule", "Lorg/jetbrains/projector/common/protocol/data/AlphaCompositeRule;", "applyStroke", "newStrokeData", "Lorg/jetbrains/projector/common/protocol/data/StrokeData;", "applyStrokeStyle", "newStrokeStyle", "applyTransform", "newTransform", "", "copyArea", "x", "y", "width", "height", "dx", "dy", "drawImage", "image", "Lorg/jetbrains/projector/client/common/canvas/Canvas$ImageSource;", "sx", "sy", "sw", "sh", "dw", "dh", "tx", "drawImageRaw", "drawLine", "x1", "y1", "x2", "y2", "drawPolyline", "points", "Lorg/jetbrains/projector/common/protocol/data/Point;", "drawString", "string", "desiredWidth", "ensureAlpha", "ensureClip", "ensureComposite", "ensureFillStyle", "ensureFont", "ensurePaint", "paintType", "Lorg/jetbrains/projector/common/protocol/data/PaintType;", "ensureRule", "ensureStroke", "ensureStrokeStyle", "ensureTransform", "paintOval", "paintPath", "path", "Lorg/jetbrains/projector/common/protocol/data/CommonPath;", "paintPolygon", "paintRect", "paintRoundRect", "w", "h", "r1", "r2", "setClip", "identitySpaceClip", "setColor", "color", "", "setComposite", "composite", "Lorg/jetbrains/projector/common/protocol/data/CommonComposite;", "setFont", "fontId", "", "fontSize", "ligaturesOn", "", "(Ljava/lang/Short;IZ)V", "setGradientPaint", "p1", "p2", "color1", "color2", "setStroke", "strokeData", "setTransform", "toLigatureVariant", "Companion", "projector-client-common"})
public final class Renderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderingSurface renderingSurface;
    @NotNull
    private final Companion.CanvasRenderingState canvasState;
    @NotNull
    private final Companion.RequestedRenderingState requestedState;
    @NotNull
    private static final Logger logger;

    public Renderer(@NotNull RenderingSurface renderingSurface) {
        Intrinsics.checkNotNullParameter((Object)renderingSurface, (String)"renderingSurface");
        this.renderingSurface = renderingSurface;
        this.canvasState = new Companion.CanvasRenderingState(null, null, null, null, null, 0.0, null, null, 255, null);
        this.requestedState = new Companion.RequestedRenderingState(null, null, null, null, null, 0.0, null, 127, null);
    }

    private final Context2d getCtx() {
        return this.renderingSurface.getCanvas().getContext2d();
    }

    @NotNull
    public final Companion.RequestedRenderingState getRequestedState() {
        return this.requestedState;
    }

    private final void applyFillStyle(PaintColor newFillStyle) {
        this.getCtx().setFillStyle(newFillStyle);
        this.canvasState.setFillStyle(newFillStyle);
    }

    private final void ensureFillStyle() {
        Do do_ = Do.INSTANCE;
        RepaintAreaSetting repaintArea = ParamsProvider.INSTANCE.getREPAINT_AREA();
        if (repaintArea instanceof RepaintAreaSetting.Disabled) {
            Renderer.ensureFillStyle$realEnsureFillStyle(this);
        } else if (repaintArea instanceof RepaintAreaSetting.Enabled) {
            Do do_2 = Do.INSTANCE;
            boolean bl = ((RepaintAreaSetting.Enabled)repaintArea).getShow();
            if (!bl) {
                Renderer.ensureFillStyle$realEnsureFillStyle(this);
            } else if (bl) {
                this.applyFillStyle(Renderer.Companion.createNextRandomColor());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Unit unit = Unit.INSTANCE;
            boolean $i$f$exhaustive = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Unit any$iv = Unit.INSTANCE;
        boolean $i$f$exhaustive = false;
    }

    private final void applyStrokeStyle(PaintColor newStrokeStyle) {
        this.getCtx().setStrokeStyle(newStrokeStyle);
        this.canvasState.setStrokeStyle(newStrokeStyle);
    }

    private final void ensureStrokeStyle() {
        Do do_ = Do.INSTANCE;
        RepaintAreaSetting repaintArea = ParamsProvider.INSTANCE.getREPAINT_AREA();
        if (repaintArea instanceof RepaintAreaSetting.Disabled) {
            Renderer.ensureStrokeStyle$realEnsureStrokeStyle(this);
        } else if (repaintArea instanceof RepaintAreaSetting.Enabled) {
            Do do_2 = Do.INSTANCE;
            boolean bl = ((RepaintAreaSetting.Enabled)repaintArea).getShow();
            if (!bl) {
                Renderer.ensureStrokeStyle$realEnsureStrokeStyle(this);
            } else if (bl) {
                this.applyStrokeStyle(Renderer.Companion.createNextRandomColor());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Unit unit = Unit.INSTANCE;
            boolean $i$f$exhaustive = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Unit any$iv = Unit.INSTANCE;
        boolean $i$f$exhaustive = false;
    }

    private final void applyTransform(List<Double> newTransform) {
        double d = this.renderingSurface.getScalingRatio();
        boolean bl = false;
        boolean bl2 = false;
        double it = d;
        boolean bl3 = false;
        this.getCtx().setTransform(it, 0.0, 0.0, it, 0.0, 0.0);
        Context2d.Matrix matrix = new Context2d.Matrix(newTransform);
        bl = false;
        bl2 = false;
        Context2d.Matrix $this$applyTransform_u24lambda_u2d5 = matrix;
        boolean bl4 = false;
        this.getCtx().transform($this$applyTransform_u24lambda_u2d5.getA(), $this$applyTransform_u24lambda_u2d5.getB(), $this$applyTransform_u24lambda_u2d5.getC(), $this$applyTransform_u24lambda_u2d5.getD(), $this$applyTransform_u24lambda_u2d5.getE(), $this$applyTransform_u24lambda_u2d5.getF());
        this.canvasState.setTransform(newTransform);
    }

    private final void ensureTransform() {
        List<Double> list = this.requestedState.getTransform();
        boolean bl = false;
        boolean bl2 = false;
        List<Double> requestedTransform = list;
        boolean bl3 = false;
        List<Double> list2 = this.canvasState.getTransform();
        boolean bl4 = false;
        boolean bl5 = false;
        List<Double> currentTransform = list2;
        boolean bl6 = false;
        if (!Intrinsics.areEqual(currentTransform, requestedTransform)) {
            this.applyTransform(requestedTransform);
        }
    }

    private final void applyClip(CommonShape newIdentitySpaceClip) {
        this.getCtx().restore();
        this.getCtx().save();
        double d = this.renderingSurface.getScalingRatio();
        boolean bl = false;
        boolean bl2 = false;
        double it2 = d;
        boolean bl3 = false;
        this.getCtx().setTransform(it2, 0.0, 0.0, it2, 0.0, 0.0);
        Object object = newIdentitySpaceClip;
        if (object != null) {
            Object any$iv;
            Do this_$iv;
            CommonShape commonShape = object;
            bl2 = false;
            boolean it2 = false;
            CommonShape $this$applyClip_u24lambda_u2d9 = commonShape;
            boolean bl4 = false;
            this.getCtx().beginPath();
            Do do_ = Do.INSTANCE;
            CommonShape commonShape2 = $this$applyClip_u24lambda_u2d9;
            if (commonShape2 instanceof CommonRectangle) {
                this.getCtx().rect(((CommonRectangle)$this$applyClip_u24lambda_u2d9).getX(), ((CommonRectangle)$this$applyClip_u24lambda_u2d9).getY(), ((CommonRectangle)$this$applyClip_u24lambda_u2d9).getWidth(), ((CommonRectangle)$this$applyClip_u24lambda_u2d9).getHeight());
            } else if (commonShape2 instanceof CommonPath) {
                this.getCtx().moveBySegments(((CommonPath)$this$applyClip_u24lambda_u2d9).getSegments());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            commonShape2 = Unit.INSTANCE;
            boolean $i$f$exhaustive22 = false;
            if (ParamsProvider.INSTANCE.getCLIPPING_BORDERS()) {
                PaintColor.SolidColor solidColor;
                this.getCtx().save();
                this_$iv = Do.INSTANCE;
                any$iv = $this$applyClip_u24lambda_u2d9;
                if (any$iv instanceof CommonRectangle) {
                    solidColor = new PaintColor.SolidColor(0xFFCC0000L);
                } else if (any$iv instanceof CommonPath) {
                    solidColor = new PaintColor.SolidColor(0xFF0000CCL);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                any$iv = solidColor;
                Context2d $i$f$exhaustive22 = this.getCtx();
                boolean bl5 = false;
                boolean bl6 = false;
                PaintColor p0 = (PaintColor)any$iv;
                boolean bl7 = false;
                $i$f$exhaustive22.setStrokeStyle(p0);
                any$iv = Unit.INSTANCE;
                $i$f$exhaustive22 = false;
                this.getCtx().stroke();
                this.getCtx().restore();
            }
            this_$iv = Do.INSTANCE;
            any$iv = $this$applyClip_u24lambda_u2d9;
            if (any$iv instanceof CommonRectangle) {
                Context2dStateOperations.DefaultImpls.clip$default(this.getCtx(), null, 1, null);
            } else if (any$iv instanceof CommonPath) {
                this.getCtx().clip(Extensions.INSTANCE.toFillRule(((CommonPath)$this$applyClip_u24lambda_u2d9).getWinding()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            any$iv = Unit.INSTANCE;
            $i$f$exhaustive22 = false;
        }
        this.canvasState.setIdentitySpaceClip(newIdentitySpaceClip);
        object = this.canvasState;
        bl = false;
        bl2 = false;
        Object $this$applyClip_u24lambda_u2d10 = object;
        boolean bl8 = false;
        this.applyTransform(((Companion.CanvasRenderingState)$this$applyClip_u24lambda_u2d10).getTransform());
        this.applyStrokeStyle(((Companion.CanvasRenderingState)$this$applyClip_u24lambda_u2d10).getStrokeStyle());
        this.applyFillStyle(((Companion.CanvasRenderingState)$this$applyClip_u24lambda_u2d10).getFillStyle());
        this.applyStroke(((Companion.CanvasRenderingState)$this$applyClip_u24lambda_u2d10).getStrokeData());
        this.applyFont(((Companion.CanvasRenderingState)$this$applyClip_u24lambda_u2d10).getFont());
        this.applyRule(((Companion.CanvasRenderingState)$this$applyClip_u24lambda_u2d10).getRule());
        this.applyAlpha(((Companion.CanvasRenderingState)$this$applyClip_u24lambda_u2d10).getAlpha());
    }

    private final void ensureClip() {
        CommonShape commonShape = this.requestedState.getIdentitySpaceClip();
        boolean bl = false;
        boolean bl2 = false;
        CommonShape requestedClip = commonShape;
        boolean bl3 = false;
        CommonShape commonShape2 = this.canvasState.getIdentitySpaceClip();
        boolean bl4 = false;
        boolean bl5 = false;
        CommonShape currentClip = commonShape2;
        boolean bl6 = false;
        if (!Intrinsics.areEqual((Object)currentClip, (Object)requestedClip)) {
            this.applyClip(requestedClip);
        }
    }

    private final void applyStroke(StrokeData newStrokeData) {
        Extensions.INSTANCE.applyStrokeData(this.getCtx(), newStrokeData);
        this.canvasState.setStrokeData(newStrokeData);
    }

    private final void ensureStroke() {
        StrokeData strokeData = this.requestedState.getStrokeData();
        boolean bl = false;
        boolean bl2 = false;
        StrokeData requestedStroke = strokeData;
        boolean bl3 = false;
        StrokeData strokeData2 = this.canvasState.getStrokeData();
        boolean bl4 = false;
        boolean bl5 = false;
        StrokeData currentStroke = strokeData2;
        boolean bl6 = false;
        if (!Intrinsics.areEqual((Object)currentStroke, (Object)requestedStroke)) {
            this.applyStroke(requestedStroke);
        }
    }

    private final void ensurePaint(PaintType paintType) {
        Unit unit;
        Do do_ = Do.INSTANCE;
        PaintType paintType2 = paintType;
        int n = WhenMappings.$EnumSwitchMapping$0[paintType2.ordinal()];
        switch (n) {
            case 1: {
                this.ensureStrokeStyle();
                this.ensureStroke();
                unit = Unit.INSTANCE;
                break;
            }
            case 2: {
                this.ensureFillStyle();
                unit = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Unit any$iv = unit;
        boolean $i$f$exhaustive = false;
    }

    private final void applyFont(String newFont) {
        this.getCtx().setFont(newFont);
        this.canvasState.setFont(newFont);
    }

    private final void ensureFont() {
        String string = this.requestedState.getFont();
        boolean bl = false;
        boolean bl2 = false;
        String requestedFont = string;
        boolean bl3 = false;
        String string2 = this.canvasState.getFont();
        boolean bl4 = false;
        boolean bl5 = false;
        String currentFont = string2;
        boolean bl6 = false;
        if (!Intrinsics.areEqual((Object)currentFont, (Object)requestedFont)) {
            this.applyFont(requestedFont);
        }
    }

    private final void applyRule(AlphaCompositeRule newRule) {
        this.getCtx().setGlobalCompositeOperation(Extensions.INSTANCE.toContext2dRule(newRule));
        this.canvasState.setRule(newRule);
    }

    private final void ensureRule() {
        AlphaCompositeRule alphaCompositeRule = this.requestedState.getRule();
        boolean bl = false;
        boolean bl2 = false;
        AlphaCompositeRule requestedRule = alphaCompositeRule;
        boolean bl3 = false;
        AlphaCompositeRule alphaCompositeRule2 = this.canvasState.getRule();
        boolean bl4 = false;
        boolean bl5 = false;
        AlphaCompositeRule currentRule = alphaCompositeRule2;
        boolean bl6 = false;
        if (currentRule != requestedRule) {
            this.applyRule(requestedRule);
        }
    }

    private final void applyAlpha(double newAlpha) {
        this.getCtx().setGlobalAlpha(newAlpha);
        this.canvasState.setAlpha(newAlpha);
    }

    private final void ensureAlpha() {
        double d = this.requestedState.getAlpha();
        boolean bl = false;
        boolean bl2 = false;
        double requestedAlpha = d;
        boolean bl3 = false;
        double d2 = this.canvasState.getAlpha();
        boolean bl4 = false;
        boolean bl5 = false;
        double currentAlpha = d2;
        boolean bl6 = false;
        if (!(currentAlpha == requestedAlpha)) {
            this.applyAlpha(requestedAlpha);
        }
    }

    private final void ensureComposite() {
        this.ensureRule();
        this.ensureAlpha();
    }

    public final void setColor(int color) {
        this.requestedState.setPaint(Companion.toColor(color));
    }

    public final void setGradientPaint(@NotNull Point p1, @NotNull Point p2, int color1, int color2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        PaintColor.Gradient gradient = this.getCtx().createLinearGradient(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        boolean bl = false;
        boolean bl2 = false;
        PaintColor.Gradient $this$setGradientPaint_u24lambda_u2d21 = gradient;
        boolean bl3 = false;
        $this$setGradientPaint_u24lambda_u2d21.addColorStop(0.0, color1);
        $this$setGradientPaint_u24lambda_u2d21.addColorStop(1.0, color2);
        PaintColor.Gradient linearGradient = gradient;
        this.requestedState.setPaint(linearGradient);
    }

    public final void setComposite(@NotNull CommonComposite composite) {
        Companion.RequestedRenderingState requestedRenderingState;
        boolean bl;
        boolean bl2;
        Companion.RequestedRenderingState requestedRenderingState2;
        Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
        Do do_ = Do.INSTANCE;
        CommonComposite commonComposite = composite;
        if (commonComposite instanceof CommonAlphaComposite) {
            requestedRenderingState2 = this.requestedState;
            bl2 = false;
            bl = false;
            Companion.RequestedRenderingState $this$setComposite_u24lambda_u2d22 = requestedRenderingState2;
            boolean bl3 = false;
            $this$setComposite_u24lambda_u2d22.setAlpha(((CommonAlphaComposite)composite).getAlpha());
            $this$setComposite_u24lambda_u2d22.setRule(((CommonAlphaComposite)composite).getRule());
            requestedRenderingState = requestedRenderingState2;
        } else if (commonComposite instanceof UnknownComposite) {
            requestedRenderingState2 = this.requestedState;
            bl2 = false;
            bl = false;
            Companion.RequestedRenderingState $this$setComposite_u24lambda_u2d23 = requestedRenderingState2;
            boolean bl4 = false;
            $this$setComposite_u24lambda_u2d23.setAlpha(1.0);
            $this$setComposite_u24lambda_u2d23.setRule(AlphaCompositeRule.SRC_OVER);
            Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(composite){
                final /* synthetic */ CommonComposite $composite;
                {
                    this.$composite = $composite;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "setComposite: " + this.$composite;
                }
            }), (int)1, null);
            requestedRenderingState = requestedRenderingState2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Companion.RequestedRenderingState any$iv = requestedRenderingState;
        boolean $i$f$exhaustive = false;
    }

    public final void drawString(@NotNull String string, double x, double y, double desiredWidth) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.ensureClip();
        this.ensureTransform();
        this.ensureFillStyle();
        this.ensureFont();
        this.ensureComposite();
        if (ParamsProvider.INSTANCE.getSHOW_TEXT_WIDTH()) {
            this.ensureStrokeStyle();
        }
        Context2d context2d2 = this.getCtx();
        boolean bl = false;
        boolean bl2 = false;
        Context2d $this$drawString_u24lambda_u2d24 = context2d2;
        boolean bl3 = false;
        Point textDimensions = $this$drawString_u24lambda_u2d24.measureText(string);
        $this$drawString_u24lambda_u2d24.save();
        double width = textDimensions.getX();
        $this$drawString_u24lambda_u2d24.translate(x, y);
        $this$drawString_u24lambda_u2d24.scale(desiredWidth / width, 1.0);
        $this$drawString_u24lambda_u2d24.fillText(string, 0.0, 0.0);
        $this$drawString_u24lambda_u2d24.restore();
        if (ParamsProvider.INSTANCE.getSHOW_TEXT_WIDTH()) {
            $this$drawString_u24lambda_u2d24.beginPath();
            $this$drawString_u24lambda_u2d24.moveTo(x, y);
            $this$drawString_u24lambda_u2d24.lineTo(x + desiredWidth, y);
            $this$drawString_u24lambda_u2d24.stroke();
            double height = textDimensions.getY();
            $this$drawString_u24lambda_u2d24.beginPath();
            $this$drawString_u24lambda_u2d24.moveTo(x, y - height);
            $this$drawString_u24lambda_u2d24.lineTo(x + width, y - height);
            $this$drawString_u24lambda_u2d24.stroke();
        }
    }

    public final void drawLine(double x1, double y1, double x2, double y2) {
        this.ensureClip();
        this.ensureTransform();
        this.ensureStrokeStyle();
        this.ensureStroke();
        this.ensureComposite();
        Context2d context2d2 = this.getCtx();
        boolean bl = false;
        boolean bl2 = false;
        Context2d $this$drawLine_u24lambda_u2d25 = context2d2;
        boolean bl3 = false;
        $this$drawLine_u24lambda_u2d25.beginPath();
        $this$drawLine_u24lambda_u2d25.moveTo(x1, y1);
        $this$drawLine_u24lambda_u2d25.lineTo(x2, y2);
        $this$drawLine_u24lambda_u2d25.stroke();
    }

    public final void paintRoundRect(@NotNull PaintType paintType, double x, double y, double w, double h, double r1, double r2) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)paintType, (String)"paintType");
        this.ensureClip();
        this.ensureTransform();
        this.ensurePaint(paintType);
        this.ensureComposite();
        double d = w / (double)2;
        boolean bl = false;
        double r12 = Math.min(r1, d);
        double d2 = h / (double)2;
        boolean bl2 = false;
        double r22 = Math.min(r2, d2);
        Context2d context2d2 = this.getCtx();
        boolean bl3 = false;
        bl2 = false;
        Context2d $this$paintRoundRect_u24lambda_u2d26 = context2d2;
        boolean bl4 = false;
        $this$paintRoundRect_u24lambda_u2d26.beginPath();
        $this$paintRoundRect_u24lambda_u2d26.roundedRect(x, y, w, h, r12, r22);
        Do do_ = Do.INSTANCE;
        PaintType paintType2 = paintType;
        int n = WhenMappings.$EnumSwitchMapping$0[paintType2.ordinal()];
        switch (n) {
            case 2: {
                Context2dDrawOperations.DefaultImpls.fill$default($this$paintRoundRect_u24lambda_u2d26, null, 1, null);
                unit = Unit.INSTANCE;
                break;
            }
            case 1: {
                $this$paintRoundRect_u24lambda_u2d26.stroke();
                unit = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        paintType2 = unit;
        boolean $i$f$exhaustive = false;
    }

    public final void paintPath(@NotNull PaintType paintType, @NotNull CommonPath path) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)paintType, (String)"paintType");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.ensureClip();
        this.ensureTransform();
        this.ensurePaint(paintType);
        this.ensureComposite();
        Context2d context2d2 = this.getCtx();
        boolean bl = false;
        boolean bl2 = false;
        Context2d $this$paintPath_u24lambda_u2d27 = context2d2;
        boolean bl3 = false;
        $this$paintPath_u24lambda_u2d27.beginPath();
        $this$paintPath_u24lambda_u2d27.moveBySegments(path.getSegments());
        Do do_ = Do.INSTANCE;
        PaintType paintType2 = paintType;
        int n = WhenMappings.$EnumSwitchMapping$0[paintType2.ordinal()];
        switch (n) {
            case 2: {
                $this$paintPath_u24lambda_u2d27.fill(Extensions.INSTANCE.toFillRule(path.getWinding()));
                unit = Unit.INSTANCE;
                break;
            }
            case 1: {
                $this$paintPath_u24lambda_u2d27.stroke();
                unit = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        paintType2 = unit;
        boolean $i$f$exhaustive = false;
    }

    public final void paintRect(@NotNull PaintType paintType, double x, double y, double width, double height) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)paintType, (String)"paintType");
        this.ensureClip();
        this.ensureTransform();
        this.ensurePaint(paintType);
        this.ensureComposite();
        Do do_ = Do.INSTANCE;
        PaintType paintType2 = paintType;
        int n = WhenMappings.$EnumSwitchMapping$0[paintType2.ordinal()];
        switch (n) {
            case 2: {
                this.getCtx().fillRect(x, y, width, height);
                unit = Unit.INSTANCE;
                break;
            }
            case 1: {
                this.getCtx().strokeRect(x, y, width, height);
                unit = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        paintType2 = unit;
        boolean $i$f$exhaustive = false;
    }

    public final void paintPolygon(@NotNull PaintType paintType, @NotNull List<Point> points) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)paintType, (String)"paintType");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.ensureClip();
        this.ensureTransform();
        this.ensurePaint(paintType);
        this.ensureComposite();
        Context2d context2d2 = this.getCtx();
        boolean bl = false;
        boolean bl2 = false;
        Context2d $this$paintPolygon_u24lambda_u2d28 = context2d2;
        boolean bl3 = false;
        $this$paintPolygon_u24lambda_u2d28.beginPath();
        $this$paintPolygon_u24lambda_u2d28.moveByPoints(points);
        Do do_ = Do.INSTANCE;
        PaintType paintType2 = paintType;
        int n = WhenMappings.$EnumSwitchMapping$0[paintType2.ordinal()];
        switch (n) {
            case 2: {
                $this$paintPolygon_u24lambda_u2d28.fill(Context2d.FillRule.EVENODD);
                unit = Unit.INSTANCE;
                break;
            }
            case 1: {
                $this$paintPolygon_u24lambda_u2d28.stroke();
                unit = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        paintType2 = unit;
        boolean $i$f$exhaustive = false;
    }

    public final void drawPolyline(@NotNull List<Point> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.ensureClip();
        this.ensureTransform();
        this.ensureStrokeStyle();
        this.ensureStroke();
        this.ensureComposite();
        Iterable $this$forEach$iv = CollectionsKt.windowed$default((Iterable)points, (int)2, (int)0, (boolean)false, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List $dstr$p1$p2 = (List)element$iv;
            boolean bl = false;
            List list = $dstr$p1$p2;
            boolean bl2 = false;
            Point p1 = (Point)list.get(0);
            List list2 = $dstr$p1$p2;
            boolean bl3 = false;
            Point p2 = (Point)list2.get(1);
            this.drawLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        }
    }

    public final void setClip(@Nullable CommonShape identitySpaceClip) {
        this.requestedState.setIdentitySpaceClip(identitySpaceClip);
    }

    public final void setTransform(@NotNull List<Double> tx) {
        Intrinsics.checkNotNullParameter(tx, (String)"tx");
        this.requestedState.setTransform(tx);
    }

    public final void setFont(@Nullable Short fontId, int fontSize, boolean ligaturesOn) {
        String string;
        if (fontId == null) {
            Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)setFont.font.1.INSTANCE, (int)1, null);
            string = fontSize + "px Arial";
        } else {
            string = fontSize + "px " + Extensions.INSTANCE.toFontFaceName(fontId);
        }
        String font2 = string;
        this.requestedState.setFont(font2);
        this.renderingSurface.getCanvas().setFontVariantLigatures(this.toLigatureVariant(ligaturesOn));
        this.renderingSurface.getCanvas();
    }

    private final String toLigatureVariant(boolean $this$toLigatureVariant) {
        return $this$toLigatureVariant ? "normal" : "none";
    }

    public final void drawImage(@NotNull Canvas.ImageSource image, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image.isEmpty()) {
            return;
        }
        this.ensureClip();
        this.ensureTransform();
        this.ensureComposite();
        this.getCtx().drawImage(image, x, y);
    }

    public final void drawImage(@NotNull Canvas.ImageSource image, double x, double y, double width, double height) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image.isEmpty()) {
            return;
        }
        this.ensureClip();
        this.ensureTransform();
        this.ensureComposite();
        this.getCtx().drawImage(image, x, y, width, height);
    }

    public final void drawImage(@NotNull Canvas.ImageSource image, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image.isEmpty()) {
            return;
        }
        this.ensureClip();
        this.ensureTransform();
        this.ensureComposite();
        this.getCtx().drawImage(image, sx, sy, sw, sh, dx, dy, dw, dh);
    }

    public final void drawImage(@NotNull Canvas.ImageSource image, @NotNull List<Double> tx) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(tx, (String)"tx");
        if (image.isEmpty()) {
            return;
        }
        this.ensureClip();
        this.ensureTransform();
        this.ensureComposite();
        Context2d context2d2 = this.getCtx();
        boolean bl = false;
        boolean bl2 = false;
        Context2d $this$drawImage_u24lambda_u2d30 = context2d2;
        boolean bl3 = false;
        $this$drawImage_u24lambda_u2d30.save();
        $this$drawImage_u24lambda_u2d30.transform(((Number)tx.get(0)).doubleValue(), ((Number)tx.get(1)).doubleValue(), ((Number)tx.get(2)).doubleValue(), ((Number)tx.get(3)).doubleValue(), ((Number)tx.get(4)).doubleValue(), ((Number)tx.get(5)).doubleValue());
        this.getCtx().drawImage(image, 0.0, 0.0);
        $this$drawImage_u24lambda_u2d30.restore();
    }

    public final void drawImageRaw(@NotNull Canvas.ImageSource image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image.isEmpty()) {
            return;
        }
        this.getCtx().restore();
        this.getCtx().drawImage(image, 0.0, 0.0);
        this.canvasState.reset();
    }

    public final void setStroke(@NotNull StrokeData strokeData) {
        Intrinsics.checkNotNullParameter((Object)strokeData, (String)"strokeData");
        this.requestedState.setStrokeData(strokeData);
    }

    public final void paintOval(@NotNull PaintType paintType, double x, double y, double width, double height) {
        Intrinsics.checkNotNullParameter((Object)paintType, (String)"paintType");
        this.ensureClip();
        this.ensureTransform();
        this.ensurePaint(paintType);
        this.ensureComposite();
        Context2d context2d2 = this.getCtx();
        boolean bl = false;
        boolean bl2 = false;
        Context2d $this$paintOval_u24lambda_u2d31 = context2d2;
        boolean bl3 = false;
        $this$paintOval_u24lambda_u2d31.beginPath();
        Context2dStateOperations.DefaultImpls.ellipse$default($this$paintOval_u24lambda_u2d31, x + width / (double)2, y + height / (double)2, width / (double)2, height / (double)2, 0.0, 0.0, Math.PI * 2, false, 128, null);
        PaintType paintType2 = paintType;
        int n = WhenMappings.$EnumSwitchMapping$0[paintType2.ordinal()];
        switch (n) {
            case 1: {
                $this$paintOval_u24lambda_u2d31.stroke();
                break;
            }
            case 2: {
                Context2dDrawOperations.DefaultImpls.fill$default($this$paintOval_u24lambda_u2d31, null, 1, null);
            }
        }
    }

    public final void copyArea(double x, double y, double width, double height, double dx, double dy) {
        this.ensureClip();
        this.ensureTransform();
        this.ensureComposite();
        Context2d context2d2 = this.getCtx();
        boolean bl = false;
        boolean bl2 = false;
        Context2d $this$copyArea_u24lambda_u2d34 = context2d2;
        boolean bl3 = false;
        $this$copyArea_u24lambda_u2d34.save();
        $this$copyArea_u24lambda_u2d34.beginPath();
        $this$copyArea_u24lambda_u2d34.rect(x + dx, y + dy, width, height);
        Context2dStateOperations.DefaultImpls.clip$default($this$copyArea_u24lambda_u2d34, null, 1, null);
        Context2d.Matrix matrix = $this$copyArea_u24lambda_u2d34.getTransform();
        boolean bl4 = false;
        boolean bl5 = false;
        Context2d.Matrix $this$copyArea_u24lambda_u2d34_u24lambda_u2d32 = matrix;
        boolean bl6 = false;
        $this$copyArea_u24lambda_u2d34.setTransform($this$copyArea_u24lambda_u2d34_u24lambda_u2d32.getA(), $this$copyArea_u24lambda_u2d34_u24lambda_u2d32.getB(), $this$copyArea_u24lambda_u2d34_u24lambda_u2d32.getC(), $this$copyArea_u24lambda_u2d34_u24lambda_u2d32.getD(), 0.0, 0.0);
        $this$copyArea_u24lambda_u2d34.translate(dx, dy);
        matrix = $this$copyArea_u24lambda_u2d34.getTransform();
        bl4 = false;
        bl5 = false;
        Context2d.Matrix $this$copyArea_u24lambda_u2d34_u24lambda_u2d33 = matrix;
        boolean bl7 = false;
        $this$copyArea_u24lambda_u2d34.setTransform(1.0, 0.0, 0.0, 1.0, $this$copyArea_u24lambda_u2d34_u24lambda_u2d33.getE(), $this$copyArea_u24lambda_u2d34_u24lambda_u2d33.getF());
        $this$copyArea_u24lambda_u2d34.drawImage(this.renderingSurface.getCanvas().getImageSource(), 0.0, 0.0);
        $this$copyArea_u24lambda_u2d34.restore();
    }

    private static final void ensureFillStyle$realEnsureFillStyle(Renderer this$0) {
        PaintColor paintColor = this$0.requestedState.getPaint();
        if (paintColor != null) {
            PaintColor paintColor2 = paintColor;
            boolean bl = false;
            boolean bl2 = false;
            PaintColor requestedPaint = paintColor2;
            boolean bl3 = false;
            PaintColor paintColor3 = this$0.canvasState.getFillStyle();
            boolean bl4 = false;
            boolean bl5 = false;
            PaintColor currentPaint = paintColor3;
            boolean bl6 = false;
            if (!Intrinsics.areEqual((Object)currentPaint, (Object)requestedPaint)) {
                this$0.applyFillStyle(requestedPaint);
            }
        }
    }

    private static final void ensureStrokeStyle$realEnsureStrokeStyle(Renderer this$0) {
        PaintColor paintColor = this$0.requestedState.getPaint();
        if (paintColor != null) {
            PaintColor paintColor2 = paintColor;
            boolean bl = false;
            boolean bl2 = false;
            PaintColor requestedPaint = paintColor2;
            boolean bl3 = false;
            PaintColor paintColor3 = this$0.canvasState.getStrokeStyle();
            boolean bl4 = false;
            boolean bl5 = false;
            PaintColor currentPaint = paintColor3;
            boolean bl6 = false;
            if (!Intrinsics.areEqual((Object)currentPaint, (Object)requestedPaint)) {
                this$0.applyStrokeStyle(requestedPaint);
            }
        }
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(Renderer.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\n\u0010\u0007\u001a\u00020\u0006*\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/projector/client/common/Renderer$Companion;", "", "()V", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "createNextRandomColor", "Lorg/jetbrains/projector/client/common/canvas/PaintColor;", "toColor", "", "CanvasRenderingState", "RequestedRenderingState", "projector-client-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PaintColor toColor(int $this$toColor) {
            return new PaintColor.SolidColor($this$toColor);
        }

        private final PaintColor createNextRandomColor() {
            return new PaintColor.SolidColor(0x7F000000 + Random.Default.nextInt(0x1000000));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000 A2\u00020\u0001:\u0001ABa\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0011J\u000b\u00100\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u00102\u001a\u00020\bH\u00c6\u0003J\t\u00103\u001a\u00020\nH\u00c6\u0003J\t\u00104\u001a\u00020\fH\u00c6\u0003J\t\u00105\u001a\u00020\u0006H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\u000b\u00107\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003Je\u00108\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00062\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u00c6\u0001J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010<\u001a\u00020=H\u00d6\u0001J\u0006\u0010>\u001a\u00020?J\t\u0010@\u001a\u00020\nH\u00d6\u0001R\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0017\"\u0004\b+\u0010\u0019R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006B"}, d2={"Lorg/jetbrains/projector/client/common/Renderer$Companion$CanvasRenderingState;", "", "identitySpaceClip", "Lorg/jetbrains/projector/common/protocol/data/CommonShape;", "transform", "", "", "strokeData", "Lorg/jetbrains/projector/common/protocol/data/StrokeData;", "font", "", "rule", "Lorg/jetbrains/projector/common/protocol/data/AlphaCompositeRule;", "alpha", "fillStyle", "Lorg/jetbrains/projector/client/common/canvas/PaintColor;", "strokeStyle", "(Lorg/jetbrains/projector/common/protocol/data/CommonShape;Ljava/util/List;Lorg/jetbrains/projector/common/protocol/data/StrokeData;Ljava/lang/String;Lorg/jetbrains/projector/common/protocol/data/AlphaCompositeRule;DLorg/jetbrains/projector/client/common/canvas/PaintColor;Lorg/jetbrains/projector/client/common/canvas/PaintColor;)V", "getAlpha", "()D", "setAlpha", "(D)V", "getFillStyle", "()Lorg/jetbrains/projector/client/common/canvas/PaintColor;", "setFillStyle", "(Lorg/jetbrains/projector/client/common/canvas/PaintColor;)V", "getFont", "()Ljava/lang/String;", "setFont", "(Ljava/lang/String;)V", "getIdentitySpaceClip", "()Lorg/jetbrains/projector/common/protocol/data/CommonShape;", "setIdentitySpaceClip", "(Lorg/jetbrains/projector/common/protocol/data/CommonShape;)V", "getRule", "()Lorg/jetbrains/projector/common/protocol/data/AlphaCompositeRule;", "setRule", "(Lorg/jetbrains/projector/common/protocol/data/AlphaCompositeRule;)V", "getStrokeData", "()Lorg/jetbrains/projector/common/protocol/data/StrokeData;", "setStrokeData", "(Lorg/jetbrains/projector/common/protocol/data/StrokeData;)V", "getStrokeStyle", "setStrokeStyle", "getTransform", "()Ljava/util/List;", "setTransform", "(Ljava/util/List;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "reset", "", "toString", "Companion", "projector-client-common"})
        private static final class CanvasRenderingState {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @Nullable
            private CommonShape identitySpaceClip;
            @NotNull
            private List<Double> transform;
            @NotNull
            private StrokeData strokeData;
            @NotNull
            private String font;
            @NotNull
            private AlphaCompositeRule rule;
            private double alpha;
            @Nullable
            private PaintColor fillStyle;
            @Nullable
            private PaintColor strokeStyle;
            @Nullable
            private static final CommonShape DEFAULT_IDENTITY_SPACE_CLIP;
            @NotNull
            private static final List<Double> DEFAULT_TRANSFORM;
            @NotNull
            private static final StrokeData DEFAULT_STROKE_DATA;
            @NotNull
            private static String DEFAULT_FONT;
            @NotNull
            private static final AlphaCompositeRule DEFAULT_RULE;
            private static final double DEFAULT_ALPHA = 1.0;
            @Nullable
            private static final PaintColor DEFAULT_FILL_STYLE;
            @Nullable
            private static final PaintColor DEFAULT_STROKE_STYLE;

            public CanvasRenderingState(@Nullable CommonShape identitySpaceClip, @NotNull List<Double> transform, @NotNull StrokeData strokeData, @NotNull String font2, @NotNull AlphaCompositeRule rule, double alpha, @Nullable PaintColor fillStyle, @Nullable PaintColor strokeStyle) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                Intrinsics.checkNotNullParameter((Object)strokeData, (String)"strokeData");
                Intrinsics.checkNotNullParameter((Object)font2, (String)"font");
                Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
                this.identitySpaceClip = identitySpaceClip;
                this.transform = transform;
                this.strokeData = strokeData;
                this.font = font2;
                this.rule = rule;
                this.alpha = alpha;
                this.fillStyle = fillStyle;
                this.strokeStyle = strokeStyle;
            }

            public /* synthetic */ CanvasRenderingState(CommonShape commonShape, List list, StrokeData strokeData, String string, AlphaCompositeRule alphaCompositeRule, double d, PaintColor paintColor, PaintColor paintColor2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    commonShape = DEFAULT_IDENTITY_SPACE_CLIP;
                }
                if ((n & 2) != 0) {
                    list = DEFAULT_TRANSFORM;
                }
                if ((n & 4) != 0) {
                    strokeData = DEFAULT_STROKE_DATA;
                }
                if ((n & 8) != 0) {
                    string = DEFAULT_FONT;
                }
                if ((n & 0x10) != 0) {
                    alphaCompositeRule = DEFAULT_RULE;
                }
                if ((n & 0x20) != 0) {
                    d = 1.0;
                }
                if ((n & 0x40) != 0) {
                    paintColor = DEFAULT_FILL_STYLE;
                }
                if ((n & 0x80) != 0) {
                    paintColor2 = DEFAULT_STROKE_STYLE;
                }
                this(commonShape, list, strokeData, string, alphaCompositeRule, d, paintColor, paintColor2);
            }

            @Nullable
            public final CommonShape getIdentitySpaceClip() {
                return this.identitySpaceClip;
            }

            public final void setIdentitySpaceClip(@Nullable CommonShape commonShape) {
                this.identitySpaceClip = commonShape;
            }

            @NotNull
            public final List<Double> getTransform() {
                return this.transform;
            }

            public final void setTransform(@NotNull List<Double> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.transform = list;
            }

            @NotNull
            public final StrokeData getStrokeData() {
                return this.strokeData;
            }

            public final void setStrokeData(@NotNull StrokeData strokeData) {
                Intrinsics.checkNotNullParameter((Object)strokeData, (String)"<set-?>");
                this.strokeData = strokeData;
            }

            @NotNull
            public final String getFont() {
                return this.font;
            }

            public final void setFont(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.font = string;
            }

            @NotNull
            public final AlphaCompositeRule getRule() {
                return this.rule;
            }

            public final void setRule(@NotNull AlphaCompositeRule alphaCompositeRule) {
                Intrinsics.checkNotNullParameter((Object)alphaCompositeRule, (String)"<set-?>");
                this.rule = alphaCompositeRule;
            }

            public final double getAlpha() {
                return this.alpha;
            }

            public final void setAlpha(double d) {
                this.alpha = d;
            }

            @Nullable
            public final PaintColor getFillStyle() {
                return this.fillStyle;
            }

            public final void setFillStyle(@Nullable PaintColor paintColor) {
                this.fillStyle = paintColor;
            }

            @Nullable
            public final PaintColor getStrokeStyle() {
                return this.strokeStyle;
            }

            public final void setStrokeStyle(@Nullable PaintColor paintColor) {
                this.strokeStyle = paintColor;
            }

            public final void reset() {
                this.identitySpaceClip = DEFAULT_IDENTITY_SPACE_CLIP;
                this.transform = DEFAULT_TRANSFORM;
                this.strokeData = DEFAULT_STROKE_DATA;
                this.font = DEFAULT_FONT;
                this.rule = DEFAULT_RULE;
                this.alpha = 1.0;
                this.fillStyle = DEFAULT_FILL_STYLE;
                this.strokeStyle = DEFAULT_STROKE_STYLE;
            }

            @Nullable
            public final CommonShape component1() {
                return this.identitySpaceClip;
            }

            @NotNull
            public final List<Double> component2() {
                return this.transform;
            }

            @NotNull
            public final StrokeData component3() {
                return this.strokeData;
            }

            @NotNull
            public final String component4() {
                return this.font;
            }

            @NotNull
            public final AlphaCompositeRule component5() {
                return this.rule;
            }

            public final double component6() {
                return this.alpha;
            }

            @Nullable
            public final PaintColor component7() {
                return this.fillStyle;
            }

            @Nullable
            public final PaintColor component8() {
                return this.strokeStyle;
            }

            @NotNull
            public final CanvasRenderingState copy(@Nullable CommonShape identitySpaceClip, @NotNull List<Double> transform, @NotNull StrokeData strokeData, @NotNull String font2, @NotNull AlphaCompositeRule rule, double alpha, @Nullable PaintColor fillStyle, @Nullable PaintColor strokeStyle) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                Intrinsics.checkNotNullParameter((Object)strokeData, (String)"strokeData");
                Intrinsics.checkNotNullParameter((Object)font2, (String)"font");
                Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
                return new CanvasRenderingState(identitySpaceClip, transform, strokeData, font2, rule, alpha, fillStyle, strokeStyle);
            }

            public static /* synthetic */ CanvasRenderingState copy$default(CanvasRenderingState canvasRenderingState, CommonShape commonShape, List list, StrokeData strokeData, String string, AlphaCompositeRule alphaCompositeRule, double d, PaintColor paintColor, PaintColor paintColor2, int n, Object object) {
                if ((n & 1) != 0) {
                    commonShape = canvasRenderingState.identitySpaceClip;
                }
                if ((n & 2) != 0) {
                    list = canvasRenderingState.transform;
                }
                if ((n & 4) != 0) {
                    strokeData = canvasRenderingState.strokeData;
                }
                if ((n & 8) != 0) {
                    string = canvasRenderingState.font;
                }
                if ((n & 0x10) != 0) {
                    alphaCompositeRule = canvasRenderingState.rule;
                }
                if ((n & 0x20) != 0) {
                    d = canvasRenderingState.alpha;
                }
                if ((n & 0x40) != 0) {
                    paintColor = canvasRenderingState.fillStyle;
                }
                if ((n & 0x80) != 0) {
                    paintColor2 = canvasRenderingState.strokeStyle;
                }
                return canvasRenderingState.copy(commonShape, list, strokeData, string, alphaCompositeRule, d, paintColor, paintColor2);
            }

            @NotNull
            public String toString() {
                return "CanvasRenderingState(identitySpaceClip=" + this.identitySpaceClip + ", transform=" + this.transform + ", strokeData=" + this.strokeData + ", font=" + this.font + ", rule=" + this.rule + ", alpha=" + this.alpha + ", fillStyle=" + this.fillStyle + ", strokeStyle=" + this.strokeStyle + ")";
            }

            public int hashCode() {
                int result = this.identitySpaceClip == null ? 0 : this.identitySpaceClip.hashCode();
                result = result * 31 + ((Object)this.transform).hashCode();
                result = result * 31 + this.strokeData.hashCode();
                result = result * 31 + this.font.hashCode();
                result = result * 31 + this.rule.hashCode();
                result = result * 31 + Double.hashCode(this.alpha);
                result = result * 31 + (this.fillStyle == null ? 0 : this.fillStyle.hashCode());
                result = result * 31 + (this.strokeStyle == null ? 0 : this.strokeStyle.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CanvasRenderingState)) {
                    return false;
                }
                CanvasRenderingState canvasRenderingState = (CanvasRenderingState)other;
                if (!Intrinsics.areEqual((Object)this.identitySpaceClip, (Object)canvasRenderingState.identitySpaceClip)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.transform, canvasRenderingState.transform)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.strokeData, (Object)canvasRenderingState.strokeData)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.font, (Object)canvasRenderingState.font)) {
                    return false;
                }
                if (this.rule != canvasRenderingState.rule) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.alpha, (Object)canvasRenderingState.alpha)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.fillStyle, (Object)canvasRenderingState.fillStyle)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.strokeStyle, (Object)canvasRenderingState.strokeStyle);
            }

            public CanvasRenderingState() {
                this(null, null, null, null, null, 0.0, null, null, 255, null);
            }

            static {
                DEFAULT_TRANSFORM = Context2d.Matrix.Companion.getIDENTITY_LIST();
                DEFAULT_STROKE_DATA = (StrokeData)Defaults.INSTANCE.getSTROKE();
                DEFAULT_FONT = "12px Arial";
                DEFAULT_RULE = AlphaCompositeRule.SRC_OVER;
            }

            @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/projector/client/common/Renderer$Companion$CanvasRenderingState$Companion;", "", "()V", "DEFAULT_ALPHA", "", "DEFAULT_FILL_STYLE", "Lorg/jetbrains/projector/client/common/canvas/PaintColor;", "DEFAULT_FONT", "", "DEFAULT_IDENTITY_SPACE_CLIP", "Lorg/jetbrains/projector/common/protocol/data/CommonShape;", "DEFAULT_RULE", "Lorg/jetbrains/projector/common/protocol/data/AlphaCompositeRule;", "DEFAULT_STROKE_DATA", "Lorg/jetbrains/projector/common/protocol/data/StrokeData;", "DEFAULT_STROKE_STYLE", "DEFAULT_TRANSFORM", "", "projector-client-common"})
            public static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BU\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010-\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010/\u001a\u00020\bH\u00c6\u0003J\t\u00100\u001a\u00020\nH\u00c6\u0003J\t\u00101\u001a\u00020\fH\u00c6\u0003J\t\u00102\u001a\u00020\u0006H\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003JY\u00104\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00062\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00c6\u0001J\u0013\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00108\u001a\u000209H\u00d6\u0001J\u000e\u0010:\u001a\u00020;2\u0006\u00107\u001a\u00020\u0000J\t\u0010<\u001a\u00020\nH\u00d6\u0001R\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006="}, d2={"Lorg/jetbrains/projector/client/common/Renderer$Companion$RequestedRenderingState;", "", "identitySpaceClip", "Lorg/jetbrains/projector/common/protocol/data/CommonShape;", "transform", "", "", "strokeData", "Lorg/jetbrains/projector/common/protocol/data/StrokeData;", "font", "", "rule", "Lorg/jetbrains/projector/common/protocol/data/AlphaCompositeRule;", "alpha", "paint", "Lorg/jetbrains/projector/client/common/canvas/PaintColor;", "(Lorg/jetbrains/projector/common/protocol/data/CommonShape;Ljava/util/List;Lorg/jetbrains/projector/common/protocol/data/StrokeData;Ljava/lang/String;Lorg/jetbrains/projector/common/protocol/data/AlphaCompositeRule;DLorg/jetbrains/projector/client/common/canvas/PaintColor;)V", "getAlpha", "()D", "setAlpha", "(D)V", "getFont", "()Ljava/lang/String;", "setFont", "(Ljava/lang/String;)V", "getIdentitySpaceClip", "()Lorg/jetbrains/projector/common/protocol/data/CommonShape;", "setIdentitySpaceClip", "(Lorg/jetbrains/projector/common/protocol/data/CommonShape;)V", "getPaint", "()Lorg/jetbrains/projector/client/common/canvas/PaintColor;", "setPaint", "(Lorg/jetbrains/projector/client/common/canvas/PaintColor;)V", "getRule", "()Lorg/jetbrains/projector/common/protocol/data/AlphaCompositeRule;", "setRule", "(Lorg/jetbrains/projector/common/protocol/data/AlphaCompositeRule;)V", "getStrokeData", "()Lorg/jetbrains/projector/common/protocol/data/StrokeData;", "setStrokeData", "(Lorg/jetbrains/projector/common/protocol/data/StrokeData;)V", "getTransform", "()Ljava/util/List;", "setTransform", "(Ljava/util/List;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "setTo", "", "toString", "projector-client-common"})
        public static final class RequestedRenderingState {
            @Nullable
            private CommonShape identitySpaceClip;
            @NotNull
            private List<Double> transform;
            @NotNull
            private StrokeData strokeData;
            @NotNull
            private String font;
            @NotNull
            private AlphaCompositeRule rule;
            private double alpha;
            @Nullable
            private PaintColor paint;

            public RequestedRenderingState(@Nullable CommonShape identitySpaceClip, @NotNull List<Double> transform, @NotNull StrokeData strokeData, @NotNull String font2, @NotNull AlphaCompositeRule rule, double alpha, @Nullable PaintColor paint) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                Intrinsics.checkNotNullParameter((Object)strokeData, (String)"strokeData");
                Intrinsics.checkNotNullParameter((Object)font2, (String)"font");
                Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
                this.identitySpaceClip = identitySpaceClip;
                this.transform = transform;
                this.strokeData = strokeData;
                this.font = font2;
                this.rule = rule;
                this.alpha = alpha;
                this.paint = paint;
            }

            public /* synthetic */ RequestedRenderingState(CommonShape commonShape, List list, StrokeData strokeData, String string, AlphaCompositeRule alphaCompositeRule, double d, PaintColor paintColor, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    commonShape = null;
                }
                if ((n & 2) != 0) {
                    list = Context2d.Matrix.Companion.getIDENTITY_LIST();
                }
                if ((n & 4) != 0) {
                    strokeData = (StrokeData)Defaults.INSTANCE.getSTROKE();
                }
                if ((n & 8) != 0) {
                    string = "12px Arial";
                }
                if ((n & 0x10) != 0) {
                    alphaCompositeRule = AlphaCompositeRule.SRC_OVER;
                }
                if ((n & 0x20) != 0) {
                    d = 1.0;
                }
                if ((n & 0x40) != 0) {
                    paintColor = new PaintColor.SolidColor(-16777216);
                }
                this(commonShape, list, strokeData, string, alphaCompositeRule, d, paintColor);
            }

            @Nullable
            public final CommonShape getIdentitySpaceClip() {
                return this.identitySpaceClip;
            }

            public final void setIdentitySpaceClip(@Nullable CommonShape commonShape) {
                this.identitySpaceClip = commonShape;
            }

            @NotNull
            public final List<Double> getTransform() {
                return this.transform;
            }

            public final void setTransform(@NotNull List<Double> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.transform = list;
            }

            @NotNull
            public final StrokeData getStrokeData() {
                return this.strokeData;
            }

            public final void setStrokeData(@NotNull StrokeData strokeData) {
                Intrinsics.checkNotNullParameter((Object)strokeData, (String)"<set-?>");
                this.strokeData = strokeData;
            }

            @NotNull
            public final String getFont() {
                return this.font;
            }

            public final void setFont(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.font = string;
            }

            @NotNull
            public final AlphaCompositeRule getRule() {
                return this.rule;
            }

            public final void setRule(@NotNull AlphaCompositeRule alphaCompositeRule) {
                Intrinsics.checkNotNullParameter((Object)alphaCompositeRule, (String)"<set-?>");
                this.rule = alphaCompositeRule;
            }

            public final double getAlpha() {
                return this.alpha;
            }

            public final void setAlpha(double d) {
                this.alpha = d;
            }

            @Nullable
            public final PaintColor getPaint() {
                return this.paint;
            }

            public final void setPaint(@Nullable PaintColor paintColor) {
                this.paint = paintColor;
            }

            public final void setTo(@NotNull RequestedRenderingState other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                this.identitySpaceClip = other.identitySpaceClip;
                this.transform = other.transform;
                this.strokeData = other.strokeData;
                this.font = other.font;
                this.rule = other.rule;
                this.alpha = other.alpha;
                this.paint = other.paint;
            }

            @Nullable
            public final CommonShape component1() {
                return this.identitySpaceClip;
            }

            @NotNull
            public final List<Double> component2() {
                return this.transform;
            }

            @NotNull
            public final StrokeData component3() {
                return this.strokeData;
            }

            @NotNull
            public final String component4() {
                return this.font;
            }

            @NotNull
            public final AlphaCompositeRule component5() {
                return this.rule;
            }

            public final double component6() {
                return this.alpha;
            }

            @Nullable
            public final PaintColor component7() {
                return this.paint;
            }

            @NotNull
            public final RequestedRenderingState copy(@Nullable CommonShape identitySpaceClip, @NotNull List<Double> transform, @NotNull StrokeData strokeData, @NotNull String font2, @NotNull AlphaCompositeRule rule, double alpha, @Nullable PaintColor paint) {
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                Intrinsics.checkNotNullParameter((Object)strokeData, (String)"strokeData");
                Intrinsics.checkNotNullParameter((Object)font2, (String)"font");
                Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
                return new RequestedRenderingState(identitySpaceClip, transform, strokeData, font2, rule, alpha, paint);
            }

            public static /* synthetic */ RequestedRenderingState copy$default(RequestedRenderingState requestedRenderingState, CommonShape commonShape, List list, StrokeData strokeData, String string, AlphaCompositeRule alphaCompositeRule, double d, PaintColor paintColor, int n, Object object) {
                if ((n & 1) != 0) {
                    commonShape = requestedRenderingState.identitySpaceClip;
                }
                if ((n & 2) != 0) {
                    list = requestedRenderingState.transform;
                }
                if ((n & 4) != 0) {
                    strokeData = requestedRenderingState.strokeData;
                }
                if ((n & 8) != 0) {
                    string = requestedRenderingState.font;
                }
                if ((n & 0x10) != 0) {
                    alphaCompositeRule = requestedRenderingState.rule;
                }
                if ((n & 0x20) != 0) {
                    d = requestedRenderingState.alpha;
                }
                if ((n & 0x40) != 0) {
                    paintColor = requestedRenderingState.paint;
                }
                return requestedRenderingState.copy(commonShape, list, strokeData, string, alphaCompositeRule, d, paintColor);
            }

            @NotNull
            public String toString() {
                return "RequestedRenderingState(identitySpaceClip=" + this.identitySpaceClip + ", transform=" + this.transform + ", strokeData=" + this.strokeData + ", font=" + this.font + ", rule=" + this.rule + ", alpha=" + this.alpha + ", paint=" + this.paint + ")";
            }

            public int hashCode() {
                int result = this.identitySpaceClip == null ? 0 : this.identitySpaceClip.hashCode();
                result = result * 31 + ((Object)this.transform).hashCode();
                result = result * 31 + this.strokeData.hashCode();
                result = result * 31 + this.font.hashCode();
                result = result * 31 + this.rule.hashCode();
                result = result * 31 + Double.hashCode(this.alpha);
                result = result * 31 + (this.paint == null ? 0 : this.paint.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RequestedRenderingState)) {
                    return false;
                }
                RequestedRenderingState requestedRenderingState = (RequestedRenderingState)other;
                if (!Intrinsics.areEqual((Object)this.identitySpaceClip, (Object)requestedRenderingState.identitySpaceClip)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.transform, requestedRenderingState.transform)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.strokeData, (Object)requestedRenderingState.strokeData)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.font, (Object)requestedRenderingState.font)) {
                    return false;
                }
                if (this.rule != requestedRenderingState.rule) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.alpha, (Object)requestedRenderingState.alpha)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.paint, (Object)requestedRenderingState.paint);
            }

            public RequestedRenderingState() {
                this(null, null, null, null, null, 0.0, null, 127, null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaintType.values().length];
            nArray[PaintType.DRAW.ordinal()] = 1;
            nArray[PaintType.FILL.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

