/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "()V", "listeners", "Ljava/util/HashSet;", "Lcom/intellij/codeInsight/hints/presentation/PresentationListener;", "Lkotlin/collections/HashSet;", "addListener", "", "listener", "fireContentChanged", "area", "Ljava/awt/Rectangle;", "fireSizeChanged", "previous", "Ljava/awt/Dimension;", "current", "removeListener", "intellij.platform.lang"})
public abstract class BasePresentation
implements InlayPresentation {
    private final HashSet<PresentationListener> listeners;

    @Override
    public void fireSizeChanged(@NotNull Dimension previous, @NotNull Dimension current) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        for (PresentationListener listener : this.listeners) {
            listener.sizeChanged(previous, current);
        }
    }

    @Override
    public void fireContentChanged(@NotNull Rectangle area) {
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        for (PresentationListener listener : this.listeners) {
            listener.contentChanged(area);
        }
    }

    @Override
    public void addListener(@NotNull PresentationListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull PresentationListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    public BasePresentation() {
        boolean bl = false;
        this.listeners = new HashSet();
    }

    @Override
    public boolean updateState(@NotNull InlayPresentation previousPresentation) {
        Intrinsics.checkNotNullParameter((Object)previousPresentation, (String)"previousPresentation");
        return InlayPresentation.DefaultImpls.updateState(this, previousPresentation);
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        InlayPresentation.DefaultImpls.mouseClicked(this, event, translated);
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        InlayPresentation.DefaultImpls.mouseMoved(this, event, translated);
    }

    @Override
    public void mouseExited() {
        InlayPresentation.DefaultImpls.mouseExited(this);
    }
}

