/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.serialization.SerializationException;
import com.intellij.util.ResourceUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.annotations.Property;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Property(assertIfNoBindings=false)
public abstract class InspectionProfileEntry
implements BatchSuppressableTool {
    private static final Logger LOG = Logger.getInstance(InspectionProfileEntry.class);
    private static Set<String> ourBlackList;
    private static final Object BLACK_LIST_LOCK;
    private Boolean myUseNewSerializer;
    protected volatile DefaultNameProvider myNameProvider;

    @NonNls
    @Nullable
    public String getAlternativeID() {
        return null;
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element) {
        Set<InspectionSuppressor> suppressors;
        if (element == null) {
            InspectionProfileEntry.$$$reportNull$$$0(0);
        }
        return !(suppressors = InspectionProfileEntry.getSuppressors(element)).isEmpty() && this.isSuppressedFor(element, suppressors);
    }

    private boolean isSuppressedFor(@NotNull PsiElement element, Set<? extends InspectionSuppressor> suppressors) {
        if (element == null) {
            InspectionProfileEntry.$$$reportNull$$$0(1);
        }
        String toolId = this.getSuppressId();
        for (InspectionSuppressor inspectionSuppressor : suppressors) {
            if (!this.isSuppressed(toolId, inspectionSuppressor, element)) continue;
            return true;
        }
        InspectionElementsMerger merger = InspectionElementsMerger.getMerger(this.getShortName());
        return merger != null && InspectionProfileEntry.isSuppressedForMerger(element, suppressors, merger);
    }

    private static boolean isSuppressedForMerger(PsiElement element, Set<? extends InspectionSuppressor> suppressors, InspectionElementsMerger merger) {
        String[] sourceToolIds;
        String[] suppressIds = merger.getSuppressIds();
        for (String sourceToolId : sourceToolIds = suppressIds.length != 0 ? suppressIds : merger.getSourceToolNames()) {
            for (InspectionSuppressor inspectionSuppressor : suppressors) {
                if (!inspectionSuppressor.isSuppressedFor(element, sourceToolId)) continue;
                return true;
            }
        }
        return false;
    }

    @NonNls
    @NotNull
    protected String getSuppressId() {
        String string = this.getShortName();
        if (string == null) {
            InspectionProfileEntry.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        if (element == null) {
            if (SuppressQuickFix.EMPTY_ARRAY == null) {
                InspectionProfileEntry.$$$reportNull$$$0(3);
            }
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        Set fixes = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)new HashingStrategy<SuppressQuickFix>(){

            public int hashCode(@Nullable SuppressQuickFix object) {
                if (object == null) {
                    return 0;
                }
                int result = object instanceof InjectionAwareSuppressQuickFix ? ((InjectionAwareSuppressQuickFix)object).isShouldBeAppliedToInjectionHost().hashCode() : 0;
                return 31 * result + object.getName().hashCode();
            }

            public boolean equals(SuppressQuickFix o1, SuppressQuickFix o2) {
                if (o1 == o2) {
                    return true;
                }
                if (o1 == null || o2 == null) {
                    return false;
                }
                if (o1 instanceof InjectionAwareSuppressQuickFix && o2 instanceof InjectionAwareSuppressQuickFix && ((InjectionAwareSuppressQuickFix)o1).isShouldBeAppliedToInjectionHost() != ((InjectionAwareSuppressQuickFix)o2).isShouldBeAppliedToInjectionHost()) {
                    return false;
                }
                return o1.getName().equals(o2.getName());
            }
        });
        Set<InspectionSuppressor> suppressors = InspectionProfileEntry.getSuppressors(element);
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance(element.getProject()).getInjectionHost(element);
        if (injectionHost != null) {
            Set<InspectionSuppressor> injectionHostSuppressors = InspectionProfileEntry.getSuppressors(injectionHost);
            for (InspectionSuppressor suppressor : injectionHostSuppressors) {
                InspectionProfileEntry.addAllSuppressActions(fixes, injectionHost, suppressor, ThreeState.YES, this.getSuppressId());
            }
        }
        for (InspectionSuppressor suppressor : suppressors) {
            InspectionProfileEntry.addAllSuppressActions(fixes, element, suppressor, injectionHost != null ? ThreeState.NO : ThreeState.UNSURE, this.getSuppressId());
        }
        SuppressQuickFix[] suppressQuickFixArray = fixes.toArray(SuppressQuickFix.EMPTY_ARRAY);
        if (suppressQuickFixArray == null) {
            InspectionProfileEntry.$$$reportNull$$$0(4);
        }
        return suppressQuickFixArray;
    }

    private static void addAllSuppressActions(@NotNull Collection<? super SuppressQuickFix> fixes, @NotNull PsiElement element, @NotNull InspectionSuppressor suppressor, @NotNull ThreeState appliedToInjectionHost, @NotNull String toolId) {
        SuppressQuickFix[] actions;
        if (fixes == null) {
            InspectionProfileEntry.$$$reportNull$$$0(5);
        }
        if (element == null) {
            InspectionProfileEntry.$$$reportNull$$$0(6);
        }
        if (suppressor == null) {
            InspectionProfileEntry.$$$reportNull$$$0(7);
        }
        if (appliedToInjectionHost == null) {
            InspectionProfileEntry.$$$reportNull$$$0(8);
        }
        if (toolId == null) {
            InspectionProfileEntry.$$$reportNull$$$0(9);
        }
        for (SuppressQuickFix action : actions = suppressor.getSuppressActions(element, toolId)) {
            if (action instanceof InjectionAwareSuppressQuickFix) {
                ((InjectionAwareSuppressQuickFix)action).setShouldBeAppliedToInjectionHost(appliedToInjectionHost);
            }
            fixes.add(action);
        }
    }

    private boolean isSuppressed(@NotNull String toolId, @NotNull InspectionSuppressor suppressor, @NotNull PsiElement element) {
        if (toolId == null) {
            InspectionProfileEntry.$$$reportNull$$$0(10);
        }
        if (suppressor == null) {
            InspectionProfileEntry.$$$reportNull$$$0(11);
        }
        if (element == null) {
            InspectionProfileEntry.$$$reportNull$$$0(12);
        }
        if (suppressor.isSuppressedFor(element, toolId)) {
            return true;
        }
        String alternativeId = this.getAlternativeID();
        return alternativeId != null && !alternativeId.equals(toolId) && suppressor.isSuppressedFor(element, alternativeId);
    }

    @NotNull
    public static Set<InspectionSuppressor> getSuppressors(@NotNull PsiElement element) {
        if (element == null) {
            InspectionProfileEntry.$$$reportNull$$$0(13);
        }
        PsiUtilCore.ensureValid(element);
        FileViewProvider viewProvider = element.getContainingFile().getViewProvider();
        List elementLanguageSuppressor = LanguageInspectionSuppressors.INSTANCE.allForLanguage(element.getLanguage());
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            LinkedHashSet<InspectionSuppressor> suppressors = new LinkedHashSet<InspectionSuppressor>();
            ContainerUtil.addAllNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.allForLanguage(viewProvider.getBaseLanguage()));
            for (Language language : viewProvider.getLanguages()) {
                ContainerUtil.addAllNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.allForLanguage(language));
            }
            ContainerUtil.addAllNotNull(suppressors, elementLanguageSuppressor);
            LinkedHashSet<InspectionSuppressor> linkedHashSet = suppressors;
            if (linkedHashSet == null) {
                InspectionProfileEntry.$$$reportNull$$$0(14);
            }
            return linkedHashSet;
        }
        if (!element.getLanguage().isKindOf(viewProvider.getBaseLanguage())) {
            LinkedHashSet<InspectionSuppressor> suppressors = new LinkedHashSet<InspectionSuppressor>();
            ContainerUtil.addAllNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.allForLanguage(viewProvider.getBaseLanguage()));
            ContainerUtil.addAllNotNull(suppressors, elementLanguageSuppressor);
            LinkedHashSet<InspectionSuppressor> linkedHashSet = suppressors;
            if (linkedHashSet == null) {
                InspectionProfileEntry.$$$reportNull$$$0(15);
            }
            return linkedHashSet;
        }
        int size = elementLanguageSuppressor.size();
        switch (size) {
            case 0: {
                Set<InspectionSuppressor> set = Collections.emptySet();
                if (set == null) {
                    InspectionProfileEntry.$$$reportNull$$$0(16);
                }
                return set;
            }
            case 1: {
                Set<InspectionSuppressor> set = Collections.singleton((InspectionSuppressor)elementLanguageSuppressor.get(0));
                if (set == null) {
                    InspectionProfileEntry.$$$reportNull$$$0(17);
                }
                return set;
            }
        }
        return new HashSet<InspectionSuppressor>(elementLanguageSuppressor);
    }

    public void cleanup(@NotNull Project project) {
        if (project == null) {
            InspectionProfileEntry.$$$reportNull$$$0(18);
        }
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            InspectionProfileEntry.$$$reportNull$$$0(19);
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getGroupDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultGroupDisplayName()) != null) {
            String string = name;
            if (string == null) {
                InspectionProfileEntry.$$$reportNull$$$0(20);
            }
            return string;
        }
        PluginException.logPluginError(LOG, this.getClass() + ": group display name should be overridden or configured via XML ", null, this.getClass());
        return "";
    }

    @NonNls
    @Nullable
    public String getGroupKey() {
        if (this.myNameProvider != null) {
            return this.myNameProvider.getGroupKey();
        }
        return null;
    }

    public @Nls(capitalization=Nls.Capitalization.Sentence) String @NotNull [] getGroupPath() {
        String groupDisplayName = this.getGroupDisplayName();
        if (groupDisplayName.isEmpty()) {
            groupDisplayName = InspectionProfileEntry.getGeneralGroupName();
        }
        String[] stringArray = new String[]{groupDisplayName};
        if (stringArray == null) {
            InspectionProfileEntry.$$$reportNull$$$0(21);
        }
        return stringArray;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultDisplayName()) != null) {
            String string = name;
            if (string == null) {
                InspectionProfileEntry.$$$reportNull$$$0(22);
            }
            return string;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            PluginException.logPluginError(LOG, this.getClass() + ": display name should be overridden or configured via XML ", null, this.getClass());
        }
        return "";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultShortName()) != null) {
            String string = name;
            if (string == null) {
                InspectionProfileEntry.$$$reportNull$$$0(23);
            }
            return string;
        }
        return InspectionProfileEntry.getShortName(this.getClass().getSimpleName());
    }

    @NotNull
    public static String getShortName(@NotNull String className) {
        if (className == null) {
            InspectionProfileEntry.$$$reportNull$$$0(24);
        }
        String string = StringUtil.trimEnd((String)StringUtil.trimEnd((String)className, (String)"Inspection"), (String)"InspectionBase");
        if (string == null) {
            InspectionProfileEntry.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            InspectionProfileEntry.$$$reportNull$$$0(26);
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return null;
    }

    public boolean showDefaultConfigurationOptions() {
        return true;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            InspectionProfileEntry.$$$reportNull$$$0(27);
        }
        if (this.useNewSerializer()) {
            try {
                XmlSerializer.deserializeInto(node, this);
            }
            catch (SerializationException e) {
                throw new InvalidDataException((Throwable)e);
            }
        } else {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)node);
        }
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            InspectionProfileEntry.$$$reportNull$$$0(28);
        }
        if (this.useNewSerializer()) {
            XmlSerializer.serializeObjectInto(this, node, this.getSerializationFilter());
        } else {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)node);
        }
    }

    private synchronized boolean useNewSerializer() {
        if (this.myUseNewSerializer == null) {
            this.myUseNewSerializer = !InspectionProfileEntry.getBlackList().contains(this.getClass().getName());
        }
        return this.myUseNewSerializer;
    }

    private static void loadBlackList() {
        ourBlackList = new HashSet<String>();
        URL url = InspectionProfileEntry.class.getResource("inspection-black-list.txt");
        if (url == null) {
            LOG.error("Resource not found");
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                ourBlackList.add(line);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load resource: " + url, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static Collection<String> getBlackList() {
        Object object = BLACK_LIST_LOCK;
        // MONITORENTER : object
        if (ourBlackList == null) {
            InspectionProfileEntry.loadBlackList();
        }
        Set<String> set = ourBlackList;
        // MONITOREXIT : object
        if (set != null) return set;
        InspectionProfileEntry.$$$reportNull$$$0(29);
        return set;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    protected SerializationFilter getSerializationFilter() {
        return XmlSerializer.getJdomSerializer().getDefaultSerializationFilter();
    }

    @Nullable
    @Nls
    public String getStaticDescription() {
        return null;
    }

    @Nullable
    public String getDescriptionFileName() {
        return null;
    }

    @NotNull
    protected Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        Class<?> clazz = this.getClass();
        if (clazz == null) {
            InspectionProfileEntry.$$$reportNull$$$0(30);
        }
        return clazz;
    }

    public boolean isInitialized() {
        return true;
    }

    @NonNls
    @Nullable
    public String getMainToolId() {
        return null;
    }

    @Nullable
    @Nls
    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            InputStream descriptionStream = null;
            String fileName = this.getDescriptionFileName();
            if (fileName != null) {
                descriptionStream = ResourceUtil.getResourceAsStream((ClassLoader)this.getDescriptionContextClass().getClassLoader(), (String)"inspectionDescriptions", (String)fileName);
            }
            return descriptionStream != null ? ResourceUtil.loadText(descriptionStream) : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nls
    public static String getGeneralGroupName() {
        return InspectionsBundle.message("inspection.general.tools.group.name", new Object[0]);
    }

    static {
        BLACK_LIST_LOCK = new Object();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionProfileEntry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedToInjectionHost";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionProfileEntry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressId";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressors";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlackList";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionContextClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAllSuppressActions";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressors";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface DefaultNameProvider {
        @NonNls
        @Nullable
        public String getDefaultShortName();

        @NonNls
        @Nullable
        public String getGroupKey();

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @Nullable
        public String getDefaultDisplayName();

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @Nullable
        public String getDefaultGroupDisplayName();
    }
}

