/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.lang.LangCoreBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public enum ShortenCommandLine {
    NONE("shorten.command.line.method.none", "java [options] className [args]"),
    MANIFEST("shorten.command.line.method.jar.manifest", "java -cp classpath.jar className [args]"),
    CLASSPATH_FILE("shorten.command.line.method.classpath.file", "java WrapperClass classpathFile className [args]"){

        @Override
        public boolean isApplicable(String jreRoot) {
            return jreRoot == null || !JdkUtil.isModularRuntime(jreRoot);
        }
    }
    ,
    ARGS_FILE("shorten.command.line.method.argfile", "java @argfile className [args]"){

        @Override
        public boolean isApplicable(String jreRoot) {
            return jreRoot == null || JdkUtil.isModularRuntime(jreRoot);
        }
    };

    @PropertyKey(resourceBundle="messages.LangCoreBundle")
    private final @PropertyKey(resourceBundle="messages.LangCoreBundle") String myNameKey;
    @NlsSafe
    private final String myDescription;

    private ShortenCommandLine(String nameKey, String description) {
        this.myNameKey = nameKey;
        this.myDescription = description;
    }

    public boolean isApplicable(String jreRoot) {
        return true;
    }

    @NlsContexts.Label
    public String getDescription() {
        return this.myDescription;
    }

    @NlsContexts.Label
    public String getPresentableName() {
        return LangCoreBundle.message(this.myNameKey, new Object[0]);
    }

    @NotNull
    public static ShortenCommandLine getDefaultMethod(@Nullable Project project, String rootPath) {
        if (!JdkUtil.useDynamicClasspath(project)) {
            ShortenCommandLine shortenCommandLine = NONE;
            if (shortenCommandLine == null) {
                ShortenCommandLine.$$$reportNull$$$0(0);
            }
            return shortenCommandLine;
        }
        return ShortenCommandLine.getDefaultMethodForJdkLevel(rootPath);
    }

    @NotNull
    public static ShortenCommandLine getDefaultMethodForJdkLevel(@Nullable String rootPath) {
        if (rootPath != null && JdkUtil.isModularRuntime(rootPath)) {
            ShortenCommandLine shortenCommandLine = ARGS_FILE;
            if (shortenCommandLine == null) {
                ShortenCommandLine.$$$reportNull$$$0(1);
            }
            return shortenCommandLine;
        }
        if (JdkUtil.useClasspathJar()) {
            ShortenCommandLine shortenCommandLine = MANIFEST;
            if (shortenCommandLine == null) {
                ShortenCommandLine.$$$reportNull$$$0(2);
            }
            return shortenCommandLine;
        }
        ShortenCommandLine shortenCommandLine = CLASSPATH_FILE;
        if (shortenCommandLine == null) {
            ShortenCommandLine.$$$reportNull$$$0(3);
        }
        return shortenCommandLine;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static ShortenCommandLine readShortenClasspathMethod(@NotNull Element element) {
        Element mode;
        if (element == null) {
            ShortenCommandLine.$$$reportNull$$$0(4);
        }
        return (mode = element.getChild("shortenClasspath")) != null ? ShortenCommandLine.valueOf(mode.getAttributeValue("name")) : null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void writeShortenClasspathMethod(@NotNull Element element, ShortenCommandLine shortenCommandLine) {
        if (element == null) {
            ShortenCommandLine.$$$reportNull$$$0(5);
        }
        if (shortenCommandLine != null) {
            element.addContent(new Element("shortenClasspath").setAttribute("name", shortenCommandLine.name()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ShortenCommandLine";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMethodForJdkLevel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ShortenCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readShortenClasspathMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeShortenClasspathMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

