/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.util.PathMappingTable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathMappingsComponent
extends LabeledComponent<TextFieldWithBrowseButton>
implements UserActivityProviderComponent {
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private PathMappingSettings myMappingSettings = new PathMappingSettings();

    public PathMappingsComponent() {
        TextFieldWithBrowseButton pathTextField = new TextFieldWithBrowseButton();
        pathTextField.setEditable(false);
        this.setComponent(pathTextField);
        this.setText(ExecutionBundle.message("label.path.mappings", new Object[0]));
        ((TextFieldWithBrowseButton)this.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathMappingsComponent.this.showConfigureMappingsDialog();
            }
        });
    }

    private void showConfigureMappingsDialog() {
        new MyPathMappingsDialog(this).show();
    }

    @NotNull
    public PathMappingSettings getMappingSettings() {
        PathMappingSettings pathMappingSettings = this.myMappingSettings;
        if (pathMappingSettings == null) {
            PathMappingsComponent.$$$reportNull$$$0(0);
        }
        return pathMappingSettings;
    }

    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myMappingSettings = mappingSettings == null ? new PathMappingSettings() : mappingSettings;
        this.setTextRepresentation(this.myMappingSettings);
        this.fireStateChanged();
    }

    private void setTextRepresentation(@NotNull PathMappingSettings mappingSettings) {
        if (mappingSettings == null) {
            PathMappingsComponent.$$$reportNull$$$0(1);
        }
        @NlsSafe StringBuilder sb = new StringBuilder();
        for (PathMappingSettings.PathMapping mapping : mappingSettings.getPathMappings()) {
            sb.append(mapping.getLocalRoot()).append("=").append(mapping.getRemoteRoot()).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        ((TextFieldWithBrowseButton)this.getComponent()).setText(sb.toString());
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            PathMappingsComponent.$$$reportNull$$$0(2);
        }
        this.myListeners.add(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            PathMappingsComponent.$$$reportNull$$$0(3);
        }
        this.myListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        for (ChangeListener listener : this.myListeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/util/PathMappingsComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/util/PathMappingsComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTextRepresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyPathMappingsDialog
    extends DialogWrapper {
        private final PathMappingTable myPathMappingTable;
        private final JPanel myWholePanel = new JPanel(new BorderLayout());
        private final PathMappingsComponent myMappingsComponent;

        protected MyPathMappingsDialog(PathMappingsComponent mappingsComponent) {
            super(mappingsComponent, true);
            this.myMappingsComponent = mappingsComponent;
            this.myPathMappingTable = new PathMappingTable();
            this.myPathMappingTable.setValues(mappingsComponent.getMappingSettings().getPathMappings());
            this.myWholePanel.add((Component)this.myPathMappingTable.getComponent(), "Center");
            this.setTitle(ExecutionBundle.message("dialog.title.edit.path.mappings", new Object[0]));
            this.init();
        }

        @Override
        @Nullable
        protected JComponent createCenterPanel() {
            return this.myWholePanel;
        }

        @Override
        protected void doOKAction() {
            this.myPathMappingTable.stopEditing();
            this.myMappingsComponent.setMappingSettings(this.myPathMappingTable.getPathMappingSettings());
            super.doOKAction();
        }
    }
}

