/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.platform.ProjectTemplate;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardContext
extends UserDataHolderBase {
    @Nullable
    private final Project myProject;
    private final Disposable myDisposable;
    private Path myProjectFileDirectory;
    private String myProjectName;
    private String myCompilerOutputDirectory;
    private Sdk myProjectJdk;
    private ProjectBuilder myProjectBuilder;
    private ProjectBuilder myOriginalBuilder;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private StorageScheme myProjectStorageFormat = StorageScheme.DIRECTORY_BASED;
    private ModulesProvider myModulesProvider;
    private boolean myProjectFileDirectorySetExplicitly;
    private String myDefaultModuleName = "untitled";

    public void setProjectStorageFormat(StorageScheme format) {
        this.myProjectStorageFormat = format;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean isNewWizard() {
        return true;
    }

    public ModulesProvider getModulesProvider() {
        return this.myModulesProvider;
    }

    public void setModulesProvider(ModulesProvider modulesProvider) {
        this.myModulesProvider = modulesProvider;
    }

    public Disposable getDisposable() {
        return this.myDisposable;
    }

    public void setDefaultModuleName(String defaultModuleName) {
        this.myDefaultModuleName = defaultModuleName;
    }

    public String getDefaultModuleName() {
        return this.myDefaultModuleName;
    }

    public WizardContext(@Nullable Project project, Disposable parentDisposable) {
        this.myProject = project;
        this.myDisposable = parentDisposable;
        if (this.myProject != null) {
            this.myProjectJdk = ProjectRootManager.getInstance(this.myProject).getProjectSdk();
        }
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getProjectFileDirectory() {
        String string = this.getProjectDirectory().toString();
        if (string == null) {
            WizardContext.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Path getProjectDirectory() {
        if (this.myProjectFileDirectory != null) {
            Path path2 = this.myProjectFileDirectory;
            if (path2 == null) {
                WizardContext.$$$reportNull$$$0(1);
            }
            return path2;
        }
        Path path3 = Paths.get(RecentProjectsManager.getInstance().suggestNewProjectLocation(), new String[0]);
        if (path3 == null) {
            WizardContext.$$$reportNull$$$0(2);
        }
        return path3;
    }

    public boolean isProjectFileDirectorySet() {
        return this.myProjectFileDirectory != null;
    }

    public boolean isProjectFileDirectorySetExplicitly() {
        return this.myProjectFileDirectorySetExplicitly;
    }

    public void setProjectFileDirectory(@Nullable String value2) {
        this.setProjectFileDirectory(value2 == null ? null : Paths.get(value2, new String[0]), false);
    }

    public void setProjectFileDirectory(@Nullable Path projectFileDirectory, boolean explicitly) {
        this.myProjectFileDirectorySetExplicitly = explicitly;
        this.myProjectFileDirectory = projectFileDirectory == null ? null : projectFileDirectory.normalize();
    }

    public String getCompilerOutputDirectory() {
        return this.myCompilerOutputDirectory;
    }

    public void setCompilerOutputDirectory(String compilerOutputDirectory) {
        this.myCompilerOutputDirectory = compilerOutputDirectory;
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public void setProjectName(String projectName) {
        this.myProjectName = projectName;
    }

    public boolean isCreatingNewProject() {
        return this.myProject == null;
    }

    @Nullable
    public Icon getStepIcon() {
        return null;
    }

    public void requestWizardButtonsUpdate() {
        for (Listener listener : this.myListeners) {
            listener.buttonsUpdateRequested();
        }
    }

    public void requestNextStep() {
        for (Listener listener : this.myListeners) {
            listener.nextStepRequested();
        }
    }

    public void requestSwitchTo(@NotNull String placeId) {
        if (placeId == null) {
            WizardContext.$$$reportNull$$$0(3);
        }
        for (Listener listener : this.myListeners) {
            listener.switchToRequested(placeId);
        }
    }

    public void addContextListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void setProjectJdk(Sdk jdk) {
        this.myProjectJdk = jdk;
    }

    public Sdk getProjectJdk() {
        return this.myProjectJdk;
    }

    @Nullable
    public ProjectBuilder getProjectBuilder() {
        return this.myProjectBuilder;
    }

    public void setProjectBuilder(@Nullable ProjectBuilder projectBuilder) {
        this.myOriginalBuilder = this.myProjectBuilder = projectBuilder;
    }

    public void setProjectTemplate(@Nullable ProjectTemplate projectTemplate) {
        this.myProjectBuilder = projectTemplate != null ? projectTemplate.createModuleBuilder() : this.myOriginalBuilder;
    }

    public String getPresentationName() {
        return IdeCoreBundle.message(this.myProject == null ? "project.new.wizard.project.identification" : "project.new.wizard.module.identification", new Object[0]);
    }

    public StorageScheme getProjectStorageFormat() {
        return this.myProjectStorageFormat;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/WizardContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFileDirectory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/WizardContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "requestSwitchTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener {
        default public void buttonsUpdateRequested() {
        }

        default public void nextStepRequested() {
        }

        default public void switchToRequested(@NotNull String placeId) {
            if (placeId == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeId", "com/intellij/ide/util/projectWizard/WizardContext$Listener", "switchToRequested"));
        }
    }
}

