/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionInGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultActionGroup
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance(DefaultActionGroup.class);
    private final List<AnAction> mySortedChildren;
    private final List<Pair<AnAction, Constraints>> myPairs;
    private int myModificationStamp;

    public DefaultActionGroup() {
        this(Presentation.NULL_STRING, false);
    }

    public DefaultActionGroup(AnAction ... actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(actions));
    }

    public DefaultActionGroup(@NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(1);
        }
        this(Presentation.NULL_STRING, actions);
    }

    public DefaultActionGroup(@NotNull Supplier<@NlsActions.ActionText String> name, @NotNull List<? extends AnAction> actions) {
        if (name == null) {
            DefaultActionGroup.$$$reportNull$$$0(2);
        }
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(3);
        }
        this(name, false);
        this.addActions(actions);
    }

    public DefaultActionGroup(@Nullable @NlsActions.ActionText String name, @NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(4);
        }
        this(() -> name, actions);
    }

    public DefaultActionGroup(@Nullable @NlsActions.ActionText String shortName, boolean popup) {
        this(() -> shortName, popup);
    }

    protected DefaultActionGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName, boolean popup) {
        if (shortName == null) {
            DefaultActionGroup.$$$reportNull$$$0(5);
        }
        super(shortName, popup);
        this.mySortedChildren = new ArrayList<AnAction>();
        this.myPairs = new ArrayList<Pair<AnAction, Constraints>>();
    }

    public static DefaultActionGroup createPopupGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName) {
        if (shortName == null) {
            DefaultActionGroup.$$$reportNull$$$0(6);
        }
        return new DefaultActionGroup(shortName, true);
    }

    public static DefaultActionGroup createFlatGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName) {
        if (shortName == null) {
            DefaultActionGroup.$$$reportNull$$$0(7);
        }
        return new DefaultActionGroup(shortName, false);
    }

    public static DefaultActionGroup createPopupGroupWithEmptyText() {
        return DefaultActionGroup.createPopupGroup(() -> "");
    }

    private void incrementModificationStamp() {
        ++this.myModificationStamp;
    }

    public int getModificationStamp() {
        return this.myModificationStamp;
    }

    private synchronized void addActions(@NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(8);
        }
        HashSet<AnAction> actionSet = new HashSet<AnAction>(actions.size());
        ArrayList<AnAction> uniqueActions = new ArrayList<AnAction>(actions.size());
        for (AnAction anAction : actions) {
            if (anAction == this) {
                throw this.newThisGroupToItselfAddedException();
            }
            if (anAction instanceof Separator || actionSet.add(anAction)) {
                uniqueActions.add(anAction);
                continue;
            }
            LOG.error((Throwable)DefaultActionGroup.newDuplicateActionAddedException(anAction));
        }
        this.mySortedChildren.addAll(uniqueActions);
        this.incrementModificationStamp();
    }

    private IllegalArgumentException newThisGroupToItselfAddedException() {
        return new IllegalArgumentException("Cannot add a group to itself: " + this + " (" + this.getTemplateText() + ")");
    }

    private static IllegalArgumentException newDuplicateActionAddedException(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(9);
        }
        return new IllegalArgumentException("Cannot add an action twice: " + action + " (" + (action instanceof ActionStub ? ((ActionStub)action).getClassName() : action.getClass().getName()) + ")");
    }

    public final void add(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(10);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(11);
        }
        this.add(action, Constraints.LAST, actionManager);
    }

    public final void add(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(12);
        }
        this.addAction(action, Constraints.LAST);
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(13);
        }
        return this.addAction(action, Constraints.LAST);
    }

    public final void addSeparator() {
        this.add(Separator.create());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(14);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(15);
        }
        this.addAction(action, constraint, ActionManager.getInstance());
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(16);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(17);
        }
        return this.addAction(action, constraint, ActionManager.getInstance());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(18);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(19);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(20);
        }
        this.addAction(action, constraint, actionManager);
    }

    @NotNull
    public final synchronized ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(21);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(22);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(23);
        }
        if (action == this) {
            throw this.newThisGroupToItselfAddedException();
        }
        if (!(action instanceof Separator) && this.containsAction(action)) {
            LOG.error((Throwable)DefaultActionGroup.newDuplicateActionAddedException(action));
            this.remove(action, actionManager.getId(action));
        }
        constraint = (Constraints)constraint.clone();
        if (constraint.myAnchor == Anchor.FIRST) {
            this.mySortedChildren.add(0, action);
        } else if (constraint.myAnchor == Anchor.LAST) {
            this.mySortedChildren.add(action);
        } else {
            this.myPairs.add((Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)constraint));
        }
        this.addAllToSortedList(actionManager);
        this.incrementModificationStamp();
        return new ActionInGroup(this, action);
    }

    public synchronized boolean containsAction(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(24);
        }
        if (this.mySortedChildren.contains(action)) {
            return true;
        }
        for (Pair<AnAction, Constraints> pair : this.myPairs) {
            if (!action.equals(pair.first)) continue;
            return true;
        }
        return false;
    }

    private void addAllToSortedList(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(25);
        }
        block0: while (!this.myPairs.isEmpty()) {
            for (int i2 = 0; i2 < this.myPairs.size(); ++i2) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i2);
                if (!this.addToSortedList((AnAction)pair.first, (Constraints)pair.second, actionManager)) continue;
                this.myPairs.remove(i2);
                continue block0;
            }
        }
    }

    private boolean addToSortedList(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        int index;
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(26);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(27);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(28);
        }
        if ((index = DefaultActionGroup.findIndex(constraint.myRelativeToActionId, this.mySortedChildren, actionManager)) == -1) {
            return false;
        }
        if (constraint.myAnchor == Anchor.BEFORE) {
            this.mySortedChildren.add(index, action);
        } else {
            this.mySortedChildren.add(index + 1, action);
        }
        return true;
    }

    private static int findIndex(String actionId, @NotNull List<? extends AnAction> actions, @NotNull ActionManager actionManager) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(29);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(30);
        }
        for (int i2 = 0; i2 < actions.size(); ++i2) {
            String id;
            AnAction action = actions.get(i2);
            if (!(action instanceof ActionStub ? ((ActionStub)action).getId().equals(actionId) : (id = actionManager.getId(action)) != null && id.equals(actionId))) continue;
            return i2;
        }
        return -1;
    }

    public final void remove(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(31);
        }
        this.remove(action, ActionManager.getInstance());
    }

    public final void remove(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(32);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(33);
        }
        this.remove(action, actionManager.getId(action));
    }

    public final synchronized void remove(@NotNull AnAction action, @Nullable String id) {
        boolean removed;
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(34);
        }
        removed = (removed = this.mySortedChildren.remove(action)) || this.mySortedChildren.removeIf(o -> o instanceof ActionStubBase && ((ActionStubBase)((Object)o)).getId().equals(id));
        boolean bl = removed = removed || this.myPairs.removeIf(o -> ((AnAction)o.first).equals(action) || o.first instanceof ActionStubBase && ((ActionStubBase)o.first).getId().equals(id));
        if (removed) {
            this.incrementModificationStamp();
        }
    }

    public final synchronized void removeAll() {
        this.mySortedChildren.clear();
        this.myPairs.clear();
        this.incrementModificationStamp();
    }

    public synchronized boolean replaceAction(@NotNull AnAction oldAction, @NotNull AnAction newAction) {
        int index;
        if (oldAction == null) {
            DefaultActionGroup.$$$reportNull$$$0(35);
        }
        if (newAction == null) {
            DefaultActionGroup.$$$reportNull$$$0(36);
        }
        if ((index = this.mySortedChildren.indexOf(oldAction)) >= 0) {
            this.mySortedChildren.set(index, newAction);
            this.incrementModificationStamp();
            return true;
        }
        for (int i2 = 0; i2 < this.myPairs.size(); ++i2) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i2);
            if (!((AnAction)pair.first).equals(newAction)) continue;
            this.myPairs.set(i2, (Pair<AnAction, Constraints>)Pair.create((Object)newAction, (Object)((Constraints)pair.second)));
            this.incrementModificationStamp();
            return true;
        }
        return false;
    }

    public synchronized void copyFromGroup(@NotNull DefaultActionGroup other) {
        if (other == null) {
            DefaultActionGroup.$$$reportNull$$$0(37);
        }
        this.copyFrom(other);
        this.setPopup(other.isPopup());
        this.mySortedChildren.clear();
        this.mySortedChildren.addAll(other.mySortedChildren);
        this.myPairs.clear();
        this.myPairs.addAll(other.myPairs);
        this.incrementModificationStamp();
    }

    @Override
    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        return this.getChildren(e, e != null ? e.getActionManager() : ActionManager.getInstance());
    }

    @Override
    public final synchronized AnAction @NotNull [] getChildren(@Nullable AnActionEvent e, @NotNull ActionManager actionManager) {
        int i2;
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(38);
        }
        boolean hasNulls = false;
        int sortedSize = this.mySortedChildren.size();
        Object[] children2 = new AnAction[sortedSize + this.myPairs.size()];
        for (i2 = 0; i2 < sortedSize; ++i2) {
            AnAction action = this.mySortedChildren.get(i2);
            if (action == null) {
                LOG.error("Empty sorted child: " + this + ", " + this.getClass() + "; index=" + i2);
            }
            if (action instanceof ActionStubBase) {
                if ((action = this.unStub(actionManager, (ActionStubBase)((Object)action))) == null) {
                    LOG.error("Can't unstub " + this.mySortedChildren.get(i2));
                } else {
                    this.mySortedChildren.set(i2, action);
                }
            }
            hasNulls |= action == null;
            children2[i2] = action;
        }
        for (i2 = 0; i2 < this.myPairs.size(); ++i2) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i2);
            AnAction action = (AnAction)pair.first;
            if (action == null) {
                LOG.error("Empty pair child: " + this + ", " + this.getClass() + "; index=" + i2);
            } else if (action instanceof ActionStubBase) {
                if ((action = this.unStub(actionManager, (ActionStubBase)((Object)action))) == null) {
                    LOG.error("Can't unstub " + pair);
                } else {
                    this.myPairs.set(i2, (Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)((Constraints)pair.second)));
                }
            }
            hasNulls |= action == null;
            children2[i2 + sortedSize] = action;
        }
        if (hasNulls) {
            AnAction[] anActionArray = (AnAction[])ContainerUtil.mapNotNull((Object[])children2, (Function)FunctionUtil.id(), (Object[])AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                DefaultActionGroup.$$$reportNull$$$0(39);
            }
            return anActionArray;
        }
        if (children2 == null) {
            DefaultActionGroup.$$$reportNull$$$0(40);
        }
        return children2;
    }

    @Nullable
    private AnAction unStub(@NotNull ActionManager actionManager, @NotNull ActionStubBase stub) {
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(41);
        }
        if (stub == null) {
            DefaultActionGroup.$$$reportNull$$$0(42);
        }
        try {
            AnAction action = actionManager.getAction(stub.getId());
            if (action == null) {
                LOG.error("Null child action in group " + this + " of class " + this.getClass() + ", id=" + stub.getId());
                return null;
            }
            this.replace((AnAction)((Object)stub), action);
            return action;
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Throwable e1) {
            LOG.error(e1);
            return null;
        }
    }

    public final synchronized int getChildrenCount() {
        return this.mySortedChildren.size() + this.myPairs.size();
    }

    public final synchronized AnAction @NotNull [] getChildActionsOrStubs() {
        int i2;
        int sortedSize = this.mySortedChildren.size();
        AnAction[] children2 = new AnAction[sortedSize + this.myPairs.size()];
        for (i2 = 0; i2 < sortedSize; ++i2) {
            children2[i2] = this.mySortedChildren.get(i2);
        }
        for (i2 = 0; i2 < this.myPairs.size(); ++i2) {
            children2[i2 + sortedSize] = (AnAction)this.myPairs.get((int)i2).first;
        }
        if (children2 == null) {
            DefaultActionGroup.$$$reportNull$$$0(43);
        }
        return children2;
    }

    public final void addAll(@NotNull ActionGroup group) {
        if (group == null) {
            DefaultActionGroup.$$$reportNull$$$0(44);
        }
        this.addAll(group.getChildren(null));
    }

    public final void addAll(@NotNull Collection<? extends AnAction> actionList) {
        if (actionList == null) {
            DefaultActionGroup.$$$reportNull$$$0(45);
        }
        this.addAll(actionList, ActionManager.getInstance());
    }

    public final void addAll(@NotNull Collection<? extends AnAction> actionList, @NotNull ActionManager actionManager) {
        if (actionList == null) {
            DefaultActionGroup.$$$reportNull$$$0(46);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(47);
        }
        if (actionList.isEmpty()) {
            return;
        }
        for (AnAction anAction : actionList) {
            this.addAction(anAction, Constraints.LAST, actionManager);
        }
    }

    public final void addAll(AnAction ... actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(48);
        }
        if (actions.length == 0) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction action : actions) {
            this.addAction(action, Constraints.LAST, actionManager);
        }
    }

    public void addSeparator(@Nullable @NlsContexts.Separator String separatorText) {
        this.add(Separator.create(separatorText));
    }

    public static DefaultActionGroup createUserDataAwareGroup(final @NlsActions.ActionText String templateText) {
        return new DefaultActionGroup(){

            @Override
            @Nullable
            public String getTemplateText() {
                return templateText;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 39: 
            case 40: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 39: 
            case 40: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 33: 
            case 38: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldAction";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAction";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 39: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/DefaultActionGroup";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/DefaultActionGroup";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildActionsOrStubs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopupGroup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFlatGroup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newDuplicateActionAddedException";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "containsAction";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addAllToSortedList";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addToSortedList";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findIndex";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "replaceAction";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "copyFromGroup";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 39: 
            case 40: 
            case 43: {
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "unStub";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 39: 
            case 40: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

