/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class CheckboxAction
extends ToggleAction
implements CustomComponentAction {
    protected CheckboxAction() {
    }

    protected CheckboxAction(@NlsContexts.Checkbox String text2) {
        super(text2);
    }

    protected CheckboxAction(@NotNull Supplier<String> dynamicText) {
        if (dynamicText == null) {
            CheckboxAction.$$$reportNull$$$0(0);
        }
        super(dynamicText);
    }

    protected CheckboxAction(@NlsContexts.Checkbox String text2, @NlsContexts.Tooltip String description, Icon icon2) {
        super(text2, description, icon2);
    }

    protected CheckboxAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon2) {
        if (dynamicText == null) {
            CheckboxAction.$$$reportNull$$$0(1);
        }
        if (dynamicDescription == null) {
            CheckboxAction.$$$reportNull$$$0(2);
        }
        super(dynamicText, dynamicDescription, icon2);
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            CheckboxAction.$$$reportNull$$$0(3);
        }
        if (place == null) {
            CheckboxAction.$$$reportNull$$$0(4);
        }
        JBCheckBox checkBox = new JBCheckBox();
        checkBox.setFocusable(false);
        return CheckboxAction.createCheckboxComponent(checkBox, this, place);
    }

    @Override
    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        if (component == null) {
            CheckboxAction.$$$reportNull$$$0(5);
        }
        if (presentation == null) {
            CheckboxAction.$$$reportNull$$$0(6);
        }
        if (component instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)component;
            this.updateCustomComponent(checkBox, presentation);
        }
    }

    protected void updateCustomComponent(JCheckBox checkBox, Presentation presentation) {
        CheckboxAction.updateCheckboxPresentation(checkBox, presentation);
        checkBox.setSelected(Toggleable.isSelected(presentation));
    }

    static void updateCheckboxPresentation(JCheckBox checkBox, Presentation presentation) {
        checkBox.setText(presentation.getText(true));
        checkBox.setToolTipText(presentation.getDescription());
        checkBox.setMnemonic(presentation.getMnemonic());
        checkBox.setDisplayedMnemonicIndex(presentation.getDisplayedMnemonicIndex());
        checkBox.setEnabled(presentation.isEnabled());
        checkBox.setVisible(presentation.isVisible());
    }

    @NotNull
    static JComponent createCheckboxComponent(@NotNull JCheckBox checkBox, final @NotNull AnAction action, final @NotNull String place) {
        if (checkBox == null) {
            CheckboxAction.$$$reportNull$$$0(7);
        }
        if (action == null) {
            CheckboxAction.$$$reportNull$$$0(8);
        }
        if (place == null) {
            CheckboxAction.$$$reportNull$$$0(9);
        }
        checkBox.setOpaque(false);
        checkBox.setBorder((Border)JBUI.Borders.emptyRight((int)9));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                DataContext dataContext = ActionToolbar.getDataContextFor(checkBox);
                KeyEvent inputEvent = new KeyEvent(checkBox, 401, System.currentTimeMillis(), 0, 32, ' ');
                AnActionEvent event = AnActionEvent.createFromAnAction(action, inputEvent, place, dataContext);
                ActionUtil.performActionDumbAwareWithCallbacks(action, event);
            }
        });
        JCheckBox jCheckBox = checkBox;
        if (jCheckBox == null) {
            CheckboxAction.$$$reportNull$$$0(10);
        }
        return jCheckBox;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/CheckboxAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/CheckboxAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckboxComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateCustomComponent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCheckboxComponent";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

