/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CaretModel {
    default public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        this.getCurrentCaret().moveCaretRelatively(columnShift, lineShift, withSelection, scrollToCaret);
    }

    default public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            CaretModel.$$$reportNull$$$0(0);
        }
        this.getCurrentCaret().moveToLogicalPosition(pos);
    }

    default public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModel.$$$reportNull$$$0(1);
        }
        this.getCurrentCaret().moveToVisualPosition(pos);
    }

    default public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    default public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.getCurrentCaret().moveToOffset(offset, locateBeforeSoftWrap);
    }

    default public boolean isUpToDate() {
        return this.getCurrentCaret().isUpToDate();
    }

    @NotNull
    default public LogicalPosition getLogicalPosition() {
        LogicalPosition logicalPosition = this.getCurrentCaret().getLogicalPosition();
        if (logicalPosition == null) {
            CaretModel.$$$reportNull$$$0(2);
        }
        return logicalPosition;
    }

    @NotNull
    default public VisualPosition getVisualPosition() {
        VisualPosition visualPosition = this.getCurrentCaret().getVisualPosition();
        if (visualPosition == null) {
            CaretModel.$$$reportNull$$$0(3);
        }
        return visualPosition;
    }

    default public int getOffset() {
        return this.getCurrentCaret().getOffset();
    }

    public void addCaretListener(@NotNull CaretListener var1);

    default public void addCaretListener(@NotNull CaretListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            CaretModel.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            CaretModel.$$$reportNull$$$0(5);
        }
        this.addCaretListener(listener);
        Disposer.register((Disposable)parentDisposable, () -> this.removeCaretListener(listener));
    }

    public void removeCaretListener(@NotNull CaretListener var1);

    default public int getVisualLineStart() {
        return this.getCurrentCaret().getVisualLineStart();
    }

    default public int getVisualLineEnd() {
        return this.getCurrentCaret().getVisualLineEnd();
    }

    public TextAttributes getTextAttributes();

    public boolean supportsMultipleCarets();

    public int getMaxCaretCount();

    @NotNull
    public Caret getCurrentCaret();

    @NotNull
    public Caret getPrimaryCaret();

    public int getCaretCount();

    @NotNull
    public List<Caret> getAllCarets();

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition var1);

    @Nullable
    default public Caret addCaret(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModel.$$$reportNull$$$0(6);
        }
        return this.addCaret(pos, true);
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition var1, boolean var2);

    @Nullable
    public Caret addCaret(@NotNull LogicalPosition var1, boolean var2);

    public boolean removeCaret(@NotNull Caret var1);

    public void removeSecondaryCarets();

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> var1);

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> var1, boolean var2);

    @NotNull
    public List<CaretState> getCaretsAndSelections();

    public void runForEachCaret(@NotNull CaretAction var1);

    public void runForEachCaret(@NotNull CaretAction var1, boolean var2);

    public void addCaretActionListener(@NotNull CaretActionListener var1, @NotNull Disposable var2);

    public void runBatchCaretOperation(@NotNull Runnable var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/CaretModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/CaretModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCaretListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

