/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.util;

import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTextCommentCellAppearance
implements CellAppearanceEx {
    private SimpleTextAttributes myCommentAttributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
    private SimpleTextAttributes myTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;

    protected abstract Icon getIcon();

    @Nls
    protected abstract String getSecondaryText();

    @Nls
    protected abstract String getPrimaryText();

    @Override
    public void customize(@NotNull SimpleColoredComponent component) {
        if (component == null) {
            BaseTextCommentCellAppearance.$$$reportNull$$$0(0);
        }
        component.setIcon(this.getIcon());
        component.append(this.getPrimaryText(), this.myTextAttributes);
        String secondaryText = this.getSecondaryText();
        if (!StringUtil.isEmptyOrSpaces((String)secondaryText)) {
            component.append(" (" + secondaryText + ")", this.myCommentAttributes);
        }
    }

    @Override
    @NotNull
    public String getText() {
        String secondaryText = this.getSecondaryText();
        if (secondaryText != null && secondaryText.length() > 0) {
            String string = this.getPrimaryText() + " (" + secondaryText + ")";
            if (string == null) {
                BaseTextCommentCellAppearance.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.getPrimaryText();
        if (string == null) {
            BaseTextCommentCellAppearance.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setCommentAttributes(SimpleTextAttributes commentAttributes) {
        this.myCommentAttributes = commentAttributes;
    }

    public void setTextAttributes(SimpleTextAttributes textAttributes) {
        this.myTextAttributes = textAttributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/util/BaseTextCommentCellAppearance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/util/BaseTextCommentCellAppearance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

