/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.psi.codeStyle.arrangement.ArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class StdArrangementExtendableSettings
extends StdArrangementSettings
implements ArrangementExtendableSettings {
    @NotNull
    private final Set<StdArrangementRuleAliasToken> myRulesAliases;
    @NotNull
    private final List<ArrangementSectionRule> myExtendedSectionRules;

    public StdArrangementExtendableSettings() {
        this.myRulesAliases = new HashSet<StdArrangementRuleAliasToken>();
        this.myExtendedSectionRules = Collections.synchronizedList(new ArrayList());
    }

    public StdArrangementExtendableSettings(@NotNull List<? extends ArrangementGroupingRule> groupingRules, @NotNull List<ArrangementSectionRule> sectionRules, @NotNull Collection<? extends StdArrangementRuleAliasToken> rulesAliases) {
        if (groupingRules == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(0);
        }
        if (sectionRules == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(1);
        }
        if (rulesAliases == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(2);
        }
        super(groupingRules, sectionRules);
        this.myRulesAliases = new HashSet<StdArrangementRuleAliasToken>();
        this.myExtendedSectionRules = Collections.synchronizedList(new ArrayList());
        this.myRulesAliases.addAll(rulesAliases);
    }

    public static StdArrangementExtendableSettings createByMatchRules(@NotNull List<? extends ArrangementGroupingRule> groupingRules, @NotNull List<? extends StdArrangementMatchRule> matchRules, @NotNull Collection<? extends StdArrangementRuleAliasToken> rulesAliases) {
        if (groupingRules == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(3);
        }
        if (matchRules == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(4);
        }
        if (rulesAliases == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(5);
        }
        ArrayList<ArrangementSectionRule> sectionRules = new ArrayList<ArrangementSectionRule>();
        for (StdArrangementMatchRule stdArrangementMatchRule : matchRules) {
            sectionRules.add(ArrangementSectionRule.create(stdArrangementMatchRule));
        }
        return new StdArrangementExtendableSettings(groupingRules, sectionRules, rulesAliases);
    }

    @Override
    public Set<StdArrangementRuleAliasToken> getRuleAliases() {
        return this.myRulesAliases;
    }

    private Set<StdArrangementRuleAliasToken> cloneTokenDefinitions() {
        HashSet<StdArrangementRuleAliasToken> definitions = new HashSet<StdArrangementRuleAliasToken>();
        for (StdArrangementRuleAliasToken definition : this.myRulesAliases) {
            definitions.add(definition.clone());
        }
        return definitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArrangementSectionRule> getExtendedSectionRules() {
        List<ArrangementSectionRule> list = this.myExtendedSectionRules;
        synchronized (list) {
            if (this.myExtendedSectionRules.isEmpty()) {
                HashMap<String, StdArrangementRuleAliasToken> tokenIdToDefinition = new HashMap<String, StdArrangementRuleAliasToken>(this.myRulesAliases.size());
                for (StdArrangementRuleAliasToken alias : this.myRulesAliases) {
                    String id = alias.getId();
                    tokenIdToDefinition.put(id, alias);
                }
                List<ArrangementSectionRule> sections = this.getSections();
                for (ArrangementSectionRule section : sections) {
                    ArrayList extendedRules = new ArrayList();
                    for (StdArrangementMatchRule rule : section.getMatchRules()) {
                        this.appendExpandedRules(rule, extendedRules, tokenIdToDefinition);
                    }
                    this.myExtendedSectionRules.add(ArrangementSectionRule.create(section.getStartComment(), section.getEndComment(), extendedRules));
                }
            }
        }
        return this.myExtendedSectionRules;
    }

    public void appendExpandedRules(@NotNull StdArrangementMatchRule rule, @NotNull List<? super StdArrangementMatchRule> rules, @NotNull Map<String, StdArrangementRuleAliasToken> tokenIdToDefinition) {
        List<StdArrangementMatchRule> sequence;
        if (rule == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(6);
        }
        if (rules == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(7);
        }
        if (tokenIdToDefinition == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(8);
        }
        if ((sequence = this.getRuleSequence(rule, tokenIdToDefinition)).isEmpty()) {
            rules.add(rule);
            return;
        }
        ArrangementCompositeMatchCondition ruleTemplate = StdArrangementExtendableSettings.removeAliasRuleToken(rule.getMatcher().getCondition());
        for (StdArrangementMatchRule matchRule : sequence) {
            ArrangementCompositeMatchCondition extendedRule = ruleTemplate.clone();
            extendedRule.addOperand(matchRule.getMatcher().getCondition());
            rules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher(extendedRule), rule.getOrderType()));
        }
    }

    @NotNull
    private List<StdArrangementMatchRule> getRuleSequence(@NotNull StdArrangementMatchRule rule, final @NotNull Map<String, StdArrangementRuleAliasToken> tokenIdToDefinition) {
        if (rule == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(9);
        }
        if (tokenIdToDefinition == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(10);
        }
        SmartList seqRule = new SmartList();
        rule.getMatcher().getCondition().invite(new ArrangementMatchConditionVisitor((List)seqRule){
            final /* synthetic */ List val$seqRule;
            {
                this.val$seqRule = list;
            }

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                StdArrangementRuleAliasToken token;
                if (condition == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((token = (StdArrangementRuleAliasToken)tokenIdToDefinition.get(condition.getType().getId())) != null && !token.getDefinitionRules().isEmpty()) {
                    this.val$seqRule.addAll(token.getDefinitionRules());
                }
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (ArrangementMatchCondition operand : condition.getOperands()) {
                    if (!this.val$seqRule.isEmpty()) {
                        return;
                    }
                    operand.invite(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings$1", "visit"));
            }
        });
        SmartList smartList = seqRule;
        if (smartList == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    @NotNull
    private static ArrangementCompositeMatchCondition removeAliasRuleToken(ArrangementMatchCondition original) {
        final ArrangementCompositeMatchCondition composite = new ArrangementCompositeMatchCondition();
        original.invite(new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                if (condition == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!ArrangementUtil.isAliasedCondition(condition)) {
                    composite.addOperand(condition);
                }
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings$2", "visit"));
            }
        });
        ArrangementCompositeMatchCondition arrangementCompositeMatchCondition = composite;
        if (arrangementCompositeMatchCondition == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(12);
        }
        return arrangementCompositeMatchCondition;
    }

    @Override
    public void addRule(@NotNull StdArrangementMatchRule rule) {
        if (rule == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(13);
        }
        this.addSectionRule(rule);
        this.myRulesByPriority.clear();
        this.myExtendedSectionRules.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<? extends ArrangementMatchRule> getRulesSortedByPriority() {
        List<ArrangementSectionRule> list = this.myExtendedSectionRules;
        synchronized (list) {
            if (this.myRulesByPriority.isEmpty()) {
                for (ArrangementSectionRule rule : this.getExtendedSectionRules()) {
                    this.myRulesByPriority.addAll(rule.getMatchRules());
                }
                ContainerUtil.sort((List)this.myRulesByPriority);
            }
        }
        List list2 = this.myRulesByPriority;
        if (list2 == null) {
            StdArrangementExtendableSettings.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @Override
    @NotNull
    public StdArrangementExtendableSettings clone() {
        return new StdArrangementExtendableSettings(this.cloneGroupings(), this.cloneSectionRules(), this.cloneTokenDefinitions());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementExtendableSettings settings = (StdArrangementExtendableSettings)o;
        if (!super.equals(settings)) {
            return false;
        }
        return this.myRulesAliases.equals(settings.myRulesAliases);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupingRules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionRules";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rulesAliases";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchRules";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenIdToDefinition";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuleSequence";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAliasRuleToken";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesSortedByPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createByMatchRules";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendExpandedRules";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRuleSequence";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

