/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimatedIcon
implements Icon {
    private static final Logger LOG = Logger.getInstance(AnimatedIcon.class);
    public static final Key<Boolean> ANIMATION_IN_RENDERER_ALLOWED = Key.create((String)"ANIMATION_IN_RENDERER_ALLOWED");
    @ApiStatus.Experimental
    public static final Key<Runnable> REFRESH_DELEGATE = Key.create((String)"REFRESH_DELEGATE");
    private final Frame[] frames;
    private final Set<Component> requested;
    private long time;
    private int index;

    public AnimatedIcon(int delay, Icon ... icons) {
        if (icons == null) {
            AnimatedIcon.$$$reportNull$$$0(0);
        }
        this(AnimatedIcon.getFrames(delay, icons));
    }

    public AnimatedIcon(Frame ... frames) {
        if (frames == null) {
            AnimatedIcon.$$$reportNull$$$0(1);
        }
        this.requested = Collections.newSetFromMap(new IdentityHashMap());
        this.frames = frames;
        assert (frames.length > 0) : "empty array";
        for (Frame frame : frames) {
            assert (frame != null) : "null animation frame";
        }
        this.time = System.currentTimeMillis();
    }

    private static Frame[] getFrames(final int delay, Icon ... icons) {
        if (icons == null) {
            AnimatedIcon.$$$reportNull$$$0(2);
        }
        int length = icons.length;
        assert (length > 0) : "empty array";
        Frame[] frames = new Frame[length];
        for (int i2 = 0; i2 < length; ++i2) {
            final Icon icon2 = icons[i2];
            assert (icon2 != null) : "null icon";
            frames[i2] = new Frame(){

                @Override
                @NotNull
                public Icon getIcon() {
                    Icon icon22 = icon2;
                    if (icon22 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon22;
                }

                @Override
                public int getDelay() {
                    return delay;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AnimatedIcon$1", "getIcon"));
                }
            };
        }
        return frames;
    }

    private void updateFrameAt(long current) {
        int next = this.index + 1;
        this.index = next < this.frames.length ? next : 0;
        this.time = current;
    }

    @NotNull
    private Icon getUpdatedIcon() {
        int index = this.getCurrentIndex();
        Icon icon2 = this.frames[index].getIcon();
        if (icon2 == null) {
            AnimatedIcon.$$$reportNull$$$0(3);
        }
        return icon2;
    }

    private int getCurrentIndex() {
        long current = System.currentTimeMillis();
        Frame frame = this.frames[this.index];
        if ((long)frame.getDelay() <= current - this.time) {
            this.updateFrameAt(current);
        }
        return this.index;
    }

    private void requestRefresh(@Nullable Component c) {
        if (c == null || this.requested.contains(c) || !this.canRefresh(c)) {
            return;
        }
        Frame frame = this.frames[this.index];
        int delay = frame.getDelay();
        if (delay > 0) {
            this.requested.add(c);
            EdtScheduledExecutorService.getInstance().schedule(() -> {
                this.requested.remove(c);
                if (this.canRefresh(c)) {
                    this.doRefresh(c);
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        } else {
            this.doRefresh(c);
        }
    }

    @Override
    public final void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon2 = this.getUpdatedIcon();
        if (EventQueue.isDispatchThread()) {
            CellRendererPane pane = (CellRendererPane)ComponentUtil.getParentOfType(CellRendererPane.class, (Component)c);
            this.requestRefresh(pane == null ? c : this.getRendererOwner(pane.getParent()));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Throwable)new IllegalStateException("Unexpected thread " + Thread.currentThread().getName()));
        }
        icon2.paintIcon(c, g, x, y);
    }

    @Override
    public final int getIconWidth() {
        return this.getUpdatedIcon().getIconWidth();
    }

    @Override
    public final int getIconHeight() {
        return this.getUpdatedIcon().getIconHeight();
    }

    protected boolean canRefresh(@NotNull Component component) {
        if (component == null) {
            AnimatedIcon.$$$reportNull$$$0(4);
        }
        return component.isShowing();
    }

    protected void doRefresh(@NotNull Component component) {
        Runnable delegate;
        if (component == null) {
            AnimatedIcon.$$$reportNull$$$0(5);
        }
        Runnable runnable = delegate = component instanceof JComponent ? (Runnable)((JComponent)component).getClientProperty(REFRESH_DELEGATE) : null;
        if (delegate == null) {
            component.repaint();
        } else {
            delegate.run();
        }
    }

    @Nullable
    protected Component getRendererOwner(@Nullable Component component) {
        return UIUtil.isClientPropertyTrue((Object)component, ANIMATION_IN_RENDERER_ALLOWED) ? component : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/AnimatedIcon";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/AnimatedIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFrames";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canRefresh";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doRefresh";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class Fading
    extends AnimatedIcon {
        public Fading(@NotNull Icon icon2) {
            if (icon2 == null) {
                Fading.$$$reportNull$$$0(0);
            }
            this(1000, icon2);
        }

        public Fading(final int period, final @NotNull Icon icon2) {
            if (icon2 == null) {
                Fading.$$$reportNull$$$0(1);
            }
            super(50, new Icon(){
                private final long time = System.currentTimeMillis();

                @Override
                public int getIconWidth() {
                    return icon2.getIconWidth();
                }

                @Override
                public int getIconHeight() {
                    return icon2.getIconHeight();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    assert (period > 0) : "unexpected";
                    long time = (System.currentTimeMillis() - this.time) % (long)period;
                    float alpha = (float)((Math.cos(Math.PI * 2 * (double)time / (double)period) + 1.0) / 2.0);
                    if (alpha > 0.0f) {
                        if (alpha < 1.0f && g instanceof Graphics2D) {
                            Graphics2D g2d = (Graphics2D)g.create();
                            try {
                                g2d.setComposite(AlphaComposite.SrcAtop.derive(alpha));
                                icon2.paintIcon(c, g2d, x, y);
                            }
                            finally {
                                g2d.dispose();
                            }
                        } else {
                            icon2.paintIcon(c, g, x, y);
                        }
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/AnimatedIcon$Fading", "<init>"));
        }
    }

    @ApiStatus.Internal
    public static final class Blinking
    extends AnimatedIcon {
        public Blinking(@NotNull Icon icon2) {
            if (icon2 == null) {
                Blinking.$$$reportNull$$$0(0);
            }
            this(1000, icon2);
        }

        public Blinking(int delay, @NotNull Icon icon2) {
            if (icon2 == null) {
                Blinking.$$$reportNull$$$0(1);
            }
            super(delay, icon2, IconLoader.getDisabledIcon((Icon)icon2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/AnimatedIcon$Blinking", "<init>"));
        }
    }

    @ApiStatus.Internal
    public static final class FS
    extends AnimatedIcon {
        public static final int DELAY = 50;
        public static final List<Icon> ICONS = List.of(AllIcons.Process.FS.Step_1, AllIcons.Process.FS.Step_2, AllIcons.Process.FS.Step_3, AllIcons.Process.FS.Step_4, AllIcons.Process.FS.Step_5, AllIcons.Process.FS.Step_6, AllIcons.Process.FS.Step_7, AllIcons.Process.FS.Step_8, AllIcons.Process.FS.Step_9, AllIcons.Process.FS.Step_10, AllIcons.Process.FS.Step_11, AllIcons.Process.FS.Step_12, AllIcons.Process.FS.Step_13, AllIcons.Process.FS.Step_14, AllIcons.Process.FS.Step_15, AllIcons.Process.FS.Step_16, AllIcons.Process.FS.Step_17, AllIcons.Process.FS.Step_18);

        public FS() {
            super(50, ICONS.toArray(new Icon[0]));
        }
    }

    public static final class Recording
    extends AnimatedIcon {
        public static final int DELAY = 250;
        public static final List<Icon> ICONS = List.of(AllIcons.Ide.Macro.Recording_1, AllIcons.Ide.Macro.Recording_2, AllIcons.Ide.Macro.Recording_3, AllIcons.Ide.Macro.Recording_4);

        public Recording() {
            super(250, ICONS.toArray(new Icon[0]));
        }
    }

    public static class Big
    extends AnimatedIcon {
        public static final int DELAY = 130;
        public static final List<Icon> ICONS = List.of(AllIcons.Process.Big.Step_1, AllIcons.Process.Big.Step_2, AllIcons.Process.Big.Step_3, AllIcons.Process.Big.Step_4, AllIcons.Process.Big.Step_5, AllIcons.Process.Big.Step_6, AllIcons.Process.Big.Step_7, AllIcons.Process.Big.Step_8);
        public static final AnimatedIcon INSTANCE = new Big();

        public Big() {
            super(130, ICONS.toArray(new Icon[0]));
        }
    }

    public static class Default
    extends AnimatedIcon {
        public static final int DELAY = 130;
        public static final List<Icon> ICONS = List.of(AllIcons.Process.Step_1, AllIcons.Process.Step_2, AllIcons.Process.Step_3, AllIcons.Process.Step_4, AllIcons.Process.Step_5, AllIcons.Process.Step_6, AllIcons.Process.Step_7, AllIcons.Process.Step_8);
        public static final AnimatedIcon INSTANCE = new Default();

        public Default() {
            super(130, ICONS.toArray(new Icon[0]));
        }
    }

    public static interface Frame {
        @NotNull
        public Icon getIcon();

        public int getDelay();
    }
}

