/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExperimentalUI {
    public static boolean isNewUI() {
        return Registry.is((String)"ide.experimental.ui");
    }

    public static boolean isNewToolWindowsStripes() {
        return ExperimentalUI.isEnabled("ide.experimental.ui.toolwindow.stripes");
    }

    public static boolean isNewEditorTabs() {
        return ExperimentalUI.isEnabled("ide.experimental.ui.editor.tabs");
    }

    public static boolean isNewVcsBranchPopup() {
        return ExperimentalUI.isEnabled("ide.experimental.ui.vcs.branch.popup");
    }

    public static boolean isNewToolbar() {
        return false;
    }

    private static boolean isEnabled(@NonNls @NotNull String key) {
        if (key == null) {
            ExperimentalUI.$$$reportNull$$$0(0);
        }
        return ApplicationManager.getApplication().isEAP() && (ExperimentalUI.isNewUI() || Registry.is((String)key));
    }

    private static void init() {
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        final RegistryValue value2 = Registry.get((String)"ide.experimental.ui");
        ExperimentalUI.patchUIDefaults(value2);
        final IconPathPatcher iconPathPatcher = ExperimentalUI.createPathPatcher();
        if (value2.asBoolean()) {
            IconLoader.installPathPatcher((IconPathPatcher)iconPathPatcher);
        }
        value2.addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExperimentalUI.patchUIDefaults(value2);
                if (value2.asBoolean()) {
                    int tabPlacement = UISettings.getInstance().getEditorTabPlacement();
                    if (tabPlacement == 2 || tabPlacement == 4 || tabPlacement == 3) {
                        UISettings.getInstance().setEditorTabPlacement(1);
                    }
                    IconLoader.installPathPatcher((IconPathPatcher)iconPathPatcher);
                } else {
                    IconLoader.removePathPatcher((IconPathPatcher)iconPathPatcher);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ui/ExperimentalUI$1", "afterValueChanged"));
            }
        }, (Disposable)app);
        app.getMessageBus().connect((Disposable)app).subscribe(LafManagerListener.TOPIC, (Object)new LafManagerListener(){

            @Override
            public void lookAndFeelChanged(@NotNull LafManager source) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                ExperimentalUI.patchUIDefaults(value2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ui/ExperimentalUI$2", "lookAndFeelChanged"));
            }
        });
    }

    private static IconPathPatcher createPathPatcher() {
        final HashMap<String, String> paths = new HashMap<String, String>();
        paths.put("/toolwindows/toolWindowAnt.svg", "/expui/toolwindow/ant.svg");
        paths.put("/toolwindows/toolWindowBookmarks.svg", "/expui/toolwindow/bookmarks.svg");
        paths.put("/toolwindows/toolWindowBuild.svg", "/expui/toolwindow/build.svg");
        paths.put("/toolwindows/toolWindowCommit.svg", "/expui/toolwindow/commit.svg");
        paths.put("/icons/toolWindowDatabase.svg", "/expui/toolwindow/database.svg");
        paths.put("/toolwindows/toolWindowDebugger.svg", "/expui/toolwindow/debug.svg");
        paths.put("/toolwindows/documentation.svg", "/expui/toolwindow/documentation.svg");
        paths.put("/icons/toolWindowGradle.svg", "/expui/toolwindow/gradle.svg");
        paths.put("/toolwindows/toolWindowHierarchy.svg", "/expui/toolwindow/hierarchy.svg");
        paths.put("/images/toolWindowMaven.svg", "/expui/toolwindow/maven.svg");
        paths.put("/toolwindows/toolWindowProblems.svg", "/expui/toolwindow/problems.svg");
        paths.put("/toolwindows/toolWindowProfiler.svg", "/expui/toolwindow/profiler.svg");
        paths.put("/toolwindows/toolWindowProject.svg", "/expui/toolwindow/project.svg");
        paths.put("/toolwindows/toolWindowRun.svg", "/expui/toolwindow/run.svg");
        paths.put("/toolwindows/toolWindowStructure.svg", "/expui/toolwindow/structure.svg");
        paths.put("/icons/OpenTerminal_13x13.svg", "/expui/toolwindow/terminal.svg");
        paths.put("/toolwindows/toolWindowTodo.svg", "/expui/toolwindow/todo.svg");
        paths.put("/toolwindows/toolWindowChanges.svg", "/expui/toolwindow/vcs.svg");
        paths.put("/toolwindows/webToolWindow.svg", "/expui/toolwindow/web.svg");
        return new IconPathPatcher(){

            @Nullable
            public String patchPath(@NotNull String path2, @Nullable ClassLoader classLoader) {
                if (path2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (String)paths.get(path2.replace("_dark.svg", ".svg"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ui/ExperimentalUI$3", "patchPath"));
            }
        };
    }

    private static void patchUIDefaults(RegistryValue value2) {
        if (!value2.asBoolean()) {
            return;
        }
        UIDefaults defaults = UIManager.getDefaults();
        ExperimentalUI.setUIProperty("EditorTabs.underlineArc", 4, defaults);
        EditorColorsScheme editorColorScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color tabsHover = ColorUtil.mix((Color)JBColor.PanelBackground, (Color)editorColorScheme.getDefaultBackground(), (double)0.5);
        ExperimentalUI.setUIProperty("EditorTabs.hoverInactiveBackground", tabsHover, defaults);
        if (Registry.is((String)"ide.experimental.ui.inter.font") && SystemInfo.isJetBrainsJvm) {
            ExperimentalUI.installInterFont();
        }
    }

    private static void setUIProperty(String key, Object value2, UIDefaults defaults) {
        defaults.remove(key);
        defaults.put(key, value2);
    }

    private static void installInterFont() {
        UIDefaults defaults = UIManager.getDefaults();
        List<String> keysToPatch = Arrays.asList("CheckBoxMenuItem.acceleratorFont", "CheckBoxMenuItem.font", "Menu.acceleratorFont", "Menu.font", "MenuItem.acceleratorFont", "MenuItem.font", "PopupMenu.font", "RadioButtonMenuItem.acceleratorFont", "RadioButtonMenuItem.font");
        for (String key : keysToPatch) {
            Font font = UIManager.getFont(key);
            FontUIResource inter = new FontUIResource("Inter", font.getStyle(), font.getSize());
            defaults.put(key, inter);
        }
        if (JBColor.isBright()) {
            ColorUIResource menuBg = new ColorUIResource(2369843);
            ColorUIResource menuFg = new ColorUIResource(0xFFFFFF);
            ExperimentalUI.setUIProperty("PopupMenu.background", menuBg, defaults);
            ExperimentalUI.setUIProperty("MenuItem.background", menuBg, defaults);
            ExperimentalUI.setUIProperty("MenuItem.foreground", menuFg, defaults);
            ExperimentalUI.setUIProperty("Menu.background", menuBg, defaults);
            ExperimentalUI.setUIProperty("Menu.foreground", menuFg, defaults);
            ExperimentalUI.setUIProperty("CheckBoxMenuItem.acceleratorForeground", menuFg, defaults);
            ExperimentalUI.setUIProperty("Menu.acceleratorForeground", menuFg, defaults);
            ExperimentalUI.setUIProperty("MenuItem.acceleratorForeground", menuFg, defaults);
            ExperimentalUI.setUIProperty("RadioButtonMenuItem.acceleratorForeground", menuFg, defaults);
        }
    }

    static {
        ExperimentalUI.init();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ui/ExperimentalUI", "isEnabled"));
    }
}

