/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ListUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PopupHandler
extends MouseAdapter {
    private static final Logger LOG = Logger.getInstance(PopupHandler.class);
    private static final PopupHandler EMPTY_HANDLER = new PopupHandler(){

        @Override
        public void invokePopup(Component comp, int x, int y) {
        }
    };

    public abstract void invokePopup(Component var1, int var2, int var3);

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static void installPopupHandler(@NotNull JComponent component, @NotNull String groupId, @NotNull String place) {
        if (component == null) {
            PopupHandler.$$$reportNull$$$0(0);
        }
        if (groupId == null) {
            PopupHandler.$$$reportNull$$$0(1);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(2);
        }
        PopupHandler.installPopupMenu(component, groupId, place);
    }

    @NotNull
    public static PopupHandler installPopupMenu(@NotNull JComponent component, @NotNull String groupId, @NotNull String place) {
        if (component == null) {
            PopupHandler.$$$reportNull$$$0(3);
        }
        if (groupId == null) {
            PopupHandler.$$$reportNull$$$0(4);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(5);
        }
        return PopupHandler.installPopupMenu(component, am -> {
            AnAction action = am.getAction(groupId);
            if (action instanceof ActionGroup) {
                return (ActionGroup)action;
            }
            LOG.warn("'" + groupId + "' invoked at '" + place + "' is " + (action == null ? "null" : "not an action group"));
            return null;
        }, place, null, null);
    }

    @Deprecated
    @NotNull
    public static MouseListener installPopupHandler(@NotNull JComponent component, @NotNull ActionGroup group, @NotNull String place) {
        if (component == null) {
            PopupHandler.$$$reportNull$$$0(6);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(7);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(8);
        }
        return PopupHandler.installPopupMenu(component, __ -> group, place, null, null);
    }

    @NotNull
    public static PopupHandler installPopupMenu(@NotNull JComponent component, @NotNull ActionGroup group, @NotNull String place) {
        if (component == null) {
            PopupHandler.$$$reportNull$$$0(9);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(10);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(11);
        }
        return PopupHandler.installPopupMenu(component, __ -> group, place, null, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @NotNull
    public static MouseListener installPopupHandler(@NotNull JComponent component, @NotNull ActionGroup group, @NotNull String place, @Nullable ActionManager actionManager) {
        if (component == null) {
            PopupHandler.$$$reportNull$$$0(12);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(13);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(14);
        }
        return PopupHandler.installPopupMenu(component, __ -> group, place, actionManager, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    @NotNull
    public static MouseListener installPopupHandler(@NotNull JComponent component, @NotNull ActionGroup group, @NotNull String place, @Nullable ActionManager actionManager, @Nullable PopupMenuListener menuListener) {
        if (component == null) {
            PopupHandler.$$$reportNull$$$0(15);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(17);
        }
        return PopupHandler.installPopupMenu(component, __ -> group, place, actionManager, menuListener);
    }

    @NotNull
    private static PopupHandler installPopupMenu(final @NotNull JComponent component, final @NotNull Function<ActionManager, ActionGroup> group, final @NotNull String place, final @Nullable ActionManager actionManager, final @Nullable PopupMenuListener menuListener) {
        if (component == null) {
            PopupHandler.$$$reportNull$$$0(18);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(19);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(20);
        }
        if (ApplicationManager.getApplication() == null) {
            PopupHandler popupHandler = EMPTY_HANDLER;
            if (popupHandler == null) {
                PopupHandler.$$$reportNull$$$0(21);
            }
            return popupHandler;
        }
        PopupHandler popupHandler = new PopupHandler(){

            @Override
            public void invokePopup(Component comp, int x, int y) {
                ActionManager manager = actionManager == null ? ActionManager.getInstance() : actionManager;
                ActionGroup actionGroup = (ActionGroup)group.apply(manager);
                if (actionGroup == null) {
                    return;
                }
                ActionPopupMenu popupMenu = manager.createActionPopupMenu(place, actionGroup);
                popupMenu.setTargetComponent(component);
                JPopupMenu menu = popupMenu.getComponent();
                if (menuListener != null) {
                    menu.addPopupMenuListener(menuListener);
                }
                menu.show(comp, x, y);
            }
        };
        component.addMouseListener(popupHandler);
        PopupHandler popupHandler2 = popupHandler;
        if (popupHandler2 == null) {
            PopupHandler.$$$reportNull$$$0(22);
        }
        return popupHandler2;
    }

    @NotNull
    public static PopupHandler installFollowingSelectionTreePopup(@NotNull JTree tree, @NotNull ActionGroup group, @NotNull String place) {
        if (tree == null) {
            PopupHandler.$$$reportNull$$$0(23);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(24);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(25);
        }
        return (PopupHandler)PopupHandler.installFollowingSelectionTreePopup(tree, group, place, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static MouseListener installFollowingSelectionTreePopup(@NotNull JTree tree, @NotNull ActionGroup group, @NotNull String place, @Nullable ActionManager actionManager) {
        if (tree == null) {
            PopupHandler.$$$reportNull$$$0(26);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(27);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(28);
        }
        return PopupHandler.installConditionalPopup(tree, group, place, actionManager, (comp, x, y) -> tree.getPathForLocation(x, y) != null && Arrays.binarySearch(Objects.requireNonNull(tree.getSelectionRows()), tree.getRowForLocation(x, y)) > -1);
    }

    @NotNull
    public static PopupHandler installRowSelectionTablePopup(@NotNull JTable table, @NotNull ActionGroup group, @NotNull String place) {
        if (table == null) {
            PopupHandler.$$$reportNull$$$0(29);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(30);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(31);
        }
        return PopupHandler.installConditionalPopup(table, group, place, null, (comp, x, y) -> Arrays.binarySearch(table.getSelectedRows(), table.rowAtPoint(new Point(x, y))) > -1);
    }

    @NotNull
    public static PopupHandler installSelectionListPopup(@NotNull JList<?> list, @NotNull ActionGroup group, @NotNull String place) {
        if (list == null) {
            PopupHandler.$$$reportNull$$$0(32);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(33);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(34);
        }
        return PopupHandler.installConditionalPopup(list, group, place, null, (comp, x, y) -> ListUtil.isPointOnSelection(list, x, y));
    }

    @NotNull
    private static PopupHandler installConditionalPopup(@NotNull JComponent component, final @NotNull ActionGroup group, final @NotNull String place, final @Nullable ActionManager actionManager, final @NotNull ShowPopupPredicate condition) {
        if (component == null) {
            PopupHandler.$$$reportNull$$$0(35);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(36);
        }
        if (place == null) {
            PopupHandler.$$$reportNull$$$0(37);
        }
        if (condition == null) {
            PopupHandler.$$$reportNull$$$0(38);
        }
        if (ApplicationManager.getApplication() == null) {
            PopupHandler popupHandler = EMPTY_HANDLER;
            if (popupHandler == null) {
                PopupHandler.$$$reportNull$$$0(39);
            }
            return popupHandler;
        }
        PopupHandler handler = new PopupHandler(){

            @Override
            public void invokePopup(Component comp, int x, int y) {
                if (condition.shouldShowPopup(comp, x, y)) {
                    ActionManager manager = actionManager == null ? ActionManager.getInstance() : actionManager;
                    ActionPopupMenu popupMenu = manager.createActionPopupMenu(place, group);
                    popupMenu.getComponent().show(comp, x, y);
                }
            }
        };
        component.addMouseListener(handler);
        PopupHandler popupHandler = handler;
        if (popupHandler == null) {
            PopupHandler.$$$reportNull$$$0(40);
        }
        return popupHandler;
    }

    @Deprecated
    public static MouseListener installUnknownPopupHandler(JComponent component, ActionGroup group, ActionManager actionManager) {
        return PopupHandler.installPopupMenu(component, __ -> group, "unknown", actionManager, null);
    }

    @Deprecated
    public static MouseListener installUnknownPopupHandler(JComponent component, ActionGroup group) {
        return PopupHandler.installPopupMenu(component, __ -> group, "unknown", null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 21: 
            case 22: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/PopupHandler";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/PopupHandler";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "installPopupMenu";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "installConditionalPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "installPopupMenu";
                break;
            }
            case 21: 
            case 22: 
            case 39: 
            case 40: {
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "installFollowingSelectionTreePopup";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "installRowSelectionTablePopup";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "installSelectionListPopup";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "installConditionalPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface ShowPopupPredicate {
        public boolean shouldShowPopup(Component var1, int var2, int var3);
    }
}

