/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RootPaneContainer;

final class ScrollSettings {
    ScrollSettings() {
    }

    static boolean isEligibleFor(Component component) {
        if (component == null || !component.isShowing()) {
            return false;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return false;
        }
        if (PowerSaveMode.isEnabled()) {
            return false;
        }
        if (RemoteDesktopService.isRemoteSession()) {
            return false;
        }
        UISettings settings = UISettings.getInstanceOrNull();
        return settings != null && settings.getSmoothScrolling();
    }

    static boolean isHighPrecisionEnabled() {
        return Registry.is((String)"idea.true.smooth.scrolling.high.precision", (boolean)true);
    }

    static boolean isPixelPerfectEnabled() {
        return Registry.is((String)"idea.true.smooth.scrolling.pixel.perfect", (boolean)true);
    }

    static boolean isDebugEnabled() {
        return Registry.is((String)"idea.true.smooth.scrolling.debug", (boolean)false);
    }

    static boolean isBackgroundFromView() {
        return Registry.is((String)"ide.scroll.background.auto", (boolean)true);
    }

    static boolean isHeaderOverCorner(JViewport viewport) {
        Component view = viewport == null ? null : viewport.getView();
        return !ScrollSettings.isNotSupportedYet(view) && Registry.is((String)"ide.scroll.layout.header.over.corner", (boolean)true);
    }

    static boolean isNotSupportedYet(Component view) {
        return view instanceof JTable;
    }

    static boolean isGapNeededForAnyComponent() {
        return Registry.is((String)"ide.scroll.align.component", (boolean)true);
    }

    static boolean isHorizontalGapNeededOnMac() {
        return Registry.is((String)"mac.scroll.horizontal.gap", (boolean)false);
    }

    static boolean isThumbSmallIfOpaque() {
        return Registry.is((String)"ide.scroll.thumb.small.if.opaque", (boolean)false);
    }

    static boolean isInterpolationEligibleFor(JScrollBar scrollbar) {
        String name;
        Component[] subComponents;
        Window window = (Window)scrollbar.getTopLevelAncestor();
        if (window instanceof JDialog && "Commit Changes".equals(((JDialog)window).getTitle())) {
            return false;
        }
        if (!(window instanceof RootPaneContainer)) {
            return true;
        }
        Component[] components = ((RootPaneContainer)((Object)window)).getContentPane().getComponents();
        if (components.length == 1 && components[0].getClass().getName().contains("DiffWindow")) {
            return false;
        }
        return components.length != 2 || !(components[0] instanceof Container) || (subComponents = ((Container)components[0]).getComponents()).length != 1 || !(name = subComponents[0].getClass().getName()).contains("DiffWindow") && !name.contains("MergeWindow");
    }
}

