/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.editors;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import org.jetbrains.annotations.NotNull;

public class JBComboBoxTableCellEditorComponent
extends JBLabel {
    private JTable myTable;
    private int myRow = 0;
    private int myColumn = 0;
    private final JBList myList = new JBList();
    private Object[] myOptions = new Object[0];
    private Object myValue;
    public boolean myWide = false;
    private Function<Object, @NlsContexts.ListItem String> myToString = Object::toString;
    private final List<ActionListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private ListCellRenderer myRenderer = new DefaultListCellRenderer(){
        private boolean myChecked;
        public Icon myEmptyIcon;

        @Override
        public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, JBComboBoxTableCellEditorComponent.this.myToString.fun(value2), index, isSelected, cellHasFocus);
            boolean bl = this.myChecked = value2 == JBComboBoxTableCellEditorComponent.this.myValue;
            if (this.myChecked) {
                label.setIcon(this.getIcon(isSelected));
            } else {
                label.setIcon(this.getEmptyIcon());
            }
            GraphicsUtil.setAntialiasingType((JComponent)label, (Object)AntialiasingType.getAAHintForSwingComponent());
            return label;
        }

        private Icon getEmptyIcon() {
            if (this.myEmptyIcon == null) {
                this.myEmptyIcon = EmptyIcon.create((int)this.getIcon(true).getIconWidth());
            }
            return this.myEmptyIcon;
        }

        private Icon getIcon(boolean selected) {
            boolean small = "small".equals(JBComboBoxTableCellEditorComponent.this.getClientProperty("JComponent.sizeVariant"));
            return small ? (selected ? PlatformIcons.CHECK_ICON_SMALL_SELECTED : PlatformIcons.CHECK_ICON_SMALL) : (selected ? PlatformIcons.CHECK_ICON_SELECTED : PlatformIcons.CHECK_ICON);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleRenderer();
            }
            return this.accessibleContext;
        }

        class AccessibleRenderer
        extends JLabel.AccessibleJLabel {
            AccessibleRenderer() {
                super(this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.CHECK_BOX;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet set = super.getAccessibleStateSet();
                if (myChecked) {
                    set.add(AccessibleState.CHECKED);
                }
                return set;
            }
        }
    };

    public JBComboBoxTableCellEditorComponent() {
    }

    public JBComboBoxTableCellEditorComponent(JTable table) {
        this.myTable = table;
    }

    public void setCell(JTable table, int row, int column) {
        this.setTable(table);
        this.setRow(row);
        this.setColumn(column);
    }

    public void setTable(JTable table) {
        this.myTable = table;
    }

    public void setRow(int row) {
        this.myRow = row;
    }

    public void setColumn(int column) {
        this.myColumn = column;
    }

    public Object[] getOptions() {
        return this.myOptions;
    }

    public void setOptions(Object ... options) {
        this.myOptions = options;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initAndShowPopup();
    }

    private void initAndShowPopup() {
        this.myList.removeAll();
        this.myList.setModel(JBList.createDefaultListModel(this.myOptions));
        if (this.myRenderer != null) {
            this.myList.setCellRenderer(this.myRenderer);
        }
        Rectangle rect = this.myTable.getCellRect(this.myRow, this.myColumn, true);
        Point point = new Point(rect.x, rect.y);
        final boolean surrendersFocusOnKeystrokeOldValue = this.myTable instanceof JBTable ? ((JBTable)this.myTable).surrendersFocusOnKeyStroke() : this.myTable.getSurrendersFocusOnKeystroke();
        JBPopup popup = ((PopupChooserBuilder)((PopupChooserBuilder)((PopupChooserBuilder)JBPopupFactory.getInstance().createListPopupBuilder(this.myList).setItemChoosenCallback(() -> {
            this.myValue = this.myList.getSelectedValue();
            ActionEvent event = new ActionEvent(this.myList, 1001, "elementChosen");
            for (ActionListener listener : this.myListeners) {
                listener.actionPerformed(event);
            }
            TableUtil.stopEditing((JTable)this.myTable);
            this.myTable.setValueAt(this.myValue, this.myRow, this.myColumn);
            this.myTable.tableChanged(new TableModelEvent(this.myTable.getModel(), this.myRow));
        }).setCancelCallback(() -> {
            TableUtil.stopEditing((JTable)this.myTable);
            return true;
        })).addListener(new JBPopupListener(){

            @Override
            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                JBComboBoxTableCellEditorComponent.this.myTable.setSurrendersFocusOnKeystroke(false);
            }

            @Override
            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                JBComboBoxTableCellEditorComponent.this.myTable.setSurrendersFocusOnKeystroke(surrendersFocusOnKeystrokeOldValue);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ui/components/editors/JBComboBoxTableCellEditorComponent$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })).setMinSize(this.myWide ? new Dimension((int)rect.getSize().getWidth(), -1) : null)).createPopup();
        popup.show(new RelativePoint((Component)this.myTable, point));
    }

    public void setWide(boolean wide) {
        this.myWide = wide;
    }

    public Object getEditorValue() {
        return this.myValue;
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.myRenderer = renderer;
    }

    public void setDefaultValue(Object value2) {
        this.myValue = value2;
    }

    public void setToString(Function<Object, String> toString2) {
        this.myToString = toString2;
    }

    public void addActionListener(ActionListener listener) {
        this.myListeners.add(listener);
    }

    public Function<Object, String> getToString() {
        return this.myToString;
    }
}

