/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.ui.jcef.JBCefFpsMeter;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ui.JBFont;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import sun.awt.AWTAccessor;

class JBCefFpsMeterImpl
extends JBCefFpsMeter {
    @NotNull
    private final AtomicInteger myFps;
    @NotNull
    private final AtomicInteger myFrameCount;
    @NotNull
    private final AtomicLong myStartMeasureTime;
    @NotNull
    private final AtomicLong myMeasureDuration;
    @NotNull
    private final AtomicBoolean myIsActive;
    @NotNull
    private final AtomicReference<Rectangle> myFpsBarBounds;
    @NotNull
    private final AtomicReference<Font> myFont;
    @NotNull
    private final AtomicReference<WeakReference<Component>> myComp;
    @NotNull
    private final AtomicReference<Timer> myTimer;
    private static final int TICK_DELAY_MS = 1000;
    private static final int FPS_STR_OFFSET = 10;
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    LazyInitializer.LazyValue<@NotNull Component> DEFAULT_COMPONENT = LazyInitializer.create(() -> {
        JPanel comp = new JPanel();
        try {
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            AWTAccessor.getComponentAccessor().setGraphicsConfiguration(comp, gc);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return comp;
    });

    JBCefFpsMeterImpl(@NotNull String id) {
        if (id == null) {
            JBCefFpsMeterImpl.$$$reportNull$$$0(0);
        }
        this.myFps = new AtomicInteger();
        this.myFrameCount = new AtomicInteger();
        this.myStartMeasureTime = new AtomicLong();
        this.myMeasureDuration = new AtomicLong();
        this.myIsActive = new AtomicBoolean();
        this.myFpsBarBounds = new AtomicReference<Rectangle>(new Rectangle());
        this.myFont = new AtomicReference();
        this.myComp = new AtomicReference<Object>(null);
        this.myTimer = new AtomicReference();
    }

    @Override
    public void paintFrameStarted() {
    }

    @Override
    public void paintFrameFinished(@NotNull Graphics g) {
        if (g == null) {
            JBCefFpsMeterImpl.$$$reportNull$$$0(1);
        }
        if (this.isActive()) {
            this.myFrameCount.incrementAndGet();
            this.drawFps(g);
        }
    }

    private void tick() {
        if (this.myStartMeasureTime.get() > 0L) {
            this.myMeasureDuration.set(System.nanoTime() - this.myStartMeasureTime.get());
            this.myFps.set((int)((float)this.myFrameCount.get() / ((float)this.myMeasureDuration.get() / 1.0E9f)));
        }
        this.myFrameCount.set(0);
        this.myStartMeasureTime.set(System.nanoTime());
        this.requestFpsBarRepaint();
    }

    @Override
    public int getFps() {
        return Math.min(this.myFps.get(), 99);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawFps(@NotNull Graphics g) {
        if (g == null) {
            JBCefFpsMeterImpl.$$$reportNull$$$0(2);
        }
        Graphics gr = g.create();
        try {
            gr.setColor(Color.blue);
            Rectangle r = this.myFpsBarBounds.get();
            gr.fillRect(r.x, r.y, r.width, r.height);
            gr.setColor(Color.green);
            gr.setFont(this.myFont.get());
            int fps = this.getFps();
            gr.drawString((Serializable)(fps == 0 ? "__" : Integer.valueOf(fps)) + " fps", 10, 10 + this.myFont.get().getSize());
        }
        finally {
            gr.dispose();
        }
    }

    @Override
    public void setActive(boolean active) {
        boolean wasActive = this.myIsActive.getAndSet(active);
        if (active && !wasActive) {
            this.myTimer.set(new Timer(1000, actionEvent -> this.tick()));
            this.myTimer.get().setRepeats(true);
            this.myTimer.get().start();
            this.reset();
        } else if (!active && wasActive) {
            this.myTimer.get().stop();
            this.myTimer.set(null);
            this.requestFpsBarRepaint();
        }
    }

    @Override
    public boolean isActive() {
        return this.myIsActive.get();
    }

    @Override
    public void registerComponent(@NotNull Component component) {
        if (component == null) {
            JBCefFpsMeterImpl.$$$reportNull$$$0(3);
        }
        this.myComp.set(new WeakReference<Component>(component));
    }

    private void requestFpsBarRepaint() {
        Rectangle r = this.myFpsBarBounds.get();
        this.getComponent().repaint(r.x, r.y, r.width, r.height);
    }

    @NotNull
    private Component getComponent() {
        Component comp = null;
        WeakReference<Component> compRef = this.myComp.get();
        if (compRef != null) {
            comp = (Component)compRef.get();
        }
        Component component = comp != null ? comp : (Component)DEFAULT_COMPONENT.get();
        if (component == null) {
            JBCefFpsMeterImpl.$$$reportNull$$$0(4);
        }
        return component;
    }

    private void reset() {
        this.myFps.set(0);
        this.myFrameCount.set(0);
        this.myStartMeasureTime.set(0L);
        this.myMeasureDuration.set(0L);
        Component comp = this.getComponent();
        this.myFont.set((Font)JBFont.create((Font)new Font("Sans", 1, 16)));
        comp.getFontMetrics(this.myFont.get());
        Rectangle strBounds = this.myFont.get().getStringBounds("00 fps", comp.getFontMetrics(this.myFont.get()).getFontRenderContext()).getBounds();
        this.myFpsBarBounds.get().setBounds(0, 0, strBounds.width + 20, strBounds.height + 20);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefFpsMeterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefFpsMeterImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "paintFrameFinished";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "drawFps";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerComponent";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

