/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.screenmenu;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.screenmenu.MenuItem;
import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Menu
extends MenuItem {
    private static final boolean USE_STUB = Boolean.getBoolean("jbScreenMenuBar.useStubItem");
    private static final int CLOSE_DELAY = Integer.getInteger("jbScreenMenuBar.closeDelay", 500);
    private static Boolean IS_ENABLED = null;
    private final List<MenuItem> myItems = new ArrayList<MenuItem>();
    private final List<MenuItem> myBuffer = new ArrayList<MenuItem>();
    private Runnable myOnOpen;
    private Runnable myOnClose;
    private Component myComponent;
    private boolean myIsOpened = false;
    long[] myCachedPeers;

    public Menu(String title) {
        this.setTitle(title);
    }

    public void setOnOpen(Runnable fillMenuProcedure, Component component) {
        this.myOnOpen = fillMenuProcedure;
        this.myComponent = component;
    }

    public void setOnClose(Runnable onClose, Component component) {
        this.myOnClose = onClose;
        this.myComponent = component;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        @NonNls String propertyName = e.getPropertyName();
        if ("text".equals(propertyName) || "description".equals(propertyName)) {
            this.setTitle(this.presentation.getText());
        }
    }

    public void setTitle(String label) {
        this.ensureNativePeer();
        this.nativeSetTitle(this.nativePeer, label, this.isInHierarchy);
    }

    void disposeChildren(int delayMs) {
        if (delayMs <= 0) {
            for (MenuItem item : this.myItems) {
                item.dispose();
            }
        } else {
            ArrayList<MenuItem> copy = new ArrayList<MenuItem>(this.myItems);
            SimpleTimer.getInstance().setUp(() -> {
                for (MenuItem item : copy) {
                    item.dispose();
                }
            }, delayMs);
        }
        this.myItems.clear();
    }

    @Override
    public synchronized void dispose() {
        this.disposeChildren(0);
        this.myCachedPeers = null;
        super.dispose();
    }

    public void beginFill() {
        for (MenuItem item : this.myBuffer) {
            if (item == null) continue;
            item.dispose();
        }
        this.myBuffer.clear();
    }

    @Nullable
    public MenuItem add(@Nullable MenuItem item) {
        this.myBuffer.add(item);
        return item;
    }

    public synchronized void endFill(boolean onAppKit) {
        this.disposeChildren(0);
        if (this.myBuffer.isEmpty()) {
            return;
        }
        this.myCachedPeers = new long[this.myBuffer.size()];
        for (int c = 0; c < this.myBuffer.size(); ++c) {
            MenuItem menuItem = this.myBuffer.get(c);
            if (menuItem != null) {
                menuItem.ensureNativePeer();
                this.myCachedPeers[c] = menuItem.nativePeer;
                this.myItems.add(menuItem);
                menuItem.isInHierarchy = true;
                continue;
            }
            this.myCachedPeers[c] = 0L;
        }
        this.myBuffer.clear();
        this.refillImpl(onAppKit);
    }

    synchronized void refillImpl(boolean onAppKit) {
        this.ensureNativePeer();
        if (this.myCachedPeers != null) {
            this.nativeRefill(this.nativePeer, this.myCachedPeers, onAppKit);
        }
    }

    public synchronized void endFill() {
        this.endFill(true);
    }

    @Override
    synchronized void ensureNativePeer() {
        if (this.nativePeer == 0L) {
            this.nativePeer = this.nativeCreateMenu();
        }
    }

    public void invokeOpenLater() {
        this.myIsOpened = true;
        if (this.myOnOpen != null) {
            if (USE_STUB) {
                MenuItem stub = new MenuItem();
                this.myItems.add(stub);
                stub.isInHierarchy = true;
                this.ensureNativePeer();
                stub.ensureNativePeer();
                this.nativeAddItem(this.nativePeer, stub.nativePeer, false);
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myOnOpen.run();
                    this.endFill(true);
                });
            } else {
                Menu.invokeWithLWCToolkit(this.myOnOpen, () -> this.endFill(false), this.myComponent);
            }
        }
    }

    public void invokeMenuClosing() {
        this.myIsOpened = false;
        this.disposeChildren(CLOSE_DELAY);
        SimpleTimer.getInstance().setUp(() -> {
            if (this.myIsOpened) {
                return;
            }
            Menu menu = this;
            synchronized (menu) {
                if (this.nativePeer != 0L) {
                    this.nativeRefill(this.nativePeer, null, true);
                }
            }
        }, CLOSE_DELAY);
        if (this.myOnClose != null) {
            Menu.invokeWithLWCToolkit(this.myOnClose, null, this.myComponent);
        }
    }

    private native long nativeCreateMenu();

    private native void nativeSetTitle(long var1, String var3, boolean var4);

    private native void nativeAddItem(long var1, long var3, boolean var5);

    native void nativeRefill(long var1, long[] var3, boolean var4);

    private static native void nativeInitClass();

    public static boolean isJbScreenMenuEnabled() {
        if (IS_ENABLED != null) {
            return IS_ENABLED;
        }
        IS_ENABLED = false;
        if (!SystemInfo.isMac) {
            return false;
        }
        if (!Boolean.getBoolean("jbScreenMenuBar.enabled")) {
            return false;
        }
        if (Boolean.getBoolean("apple.laf.useScreenMenuBar")) {
            Logger.getInstance(Menu.class).info("apple.laf.useScreenMenuBar==true, default screen menu implementation will be used");
            return false;
        }
        Path lib = PathManager.findBinFile((String)"libmacscreenmenu64.dylib");
        try {
            System.load(lib.toFile().getAbsolutePath());
            Menu.nativeInitClass();
            Menu test = new Menu("test");
            test.ensureNativePeer();
            test.dispose();
            IS_ENABLED = true;
            Logger.getInstance(Menu.class).info("use new ScreenMenuBar implementation");
        }
        catch (Throwable e) {
            Logger.getInstance(Menu.class).warn("can't load menu library: " + lib.toFile().getAbsolutePath() + ", exception: " + e.getMessage());
        }
        return IS_ENABLED;
    }

    private static void invokeWithLWCToolkit(Runnable r, Runnable after, Component invoker) {
        block6: {
            try {
                Class<?> toolkitClass = Class.forName("sun.lwawt.macosx.LWCToolkit");
                Method invokeMethod = ReflectionUtil.getDeclaredMethod(toolkitClass, (String)"invokeAndWait", (Class[])new Class[]{Runnable.class, Component.class});
                if (invokeMethod != null) {
                    try {
                        invokeMethod.invoke(toolkitClass, r, invoker);
                    }
                    catch (Exception e) {
                        Logger.getInstance(Menu.class).debug("invokeWithLWCToolkit.invokeAndWait: " + e);
                    }
                    if (after != null) {
                        after.run();
                    }
                    break block6;
                }
                Logger.getInstance(Menu.class).warn("can't find sun.lwawt.macosx.LWCToolkit.invokeAndWait, screen menu won't be filled");
            }
            catch (ClassNotFoundException e) {
                Logger.getInstance(Menu.class).warn("can't find sun.lwawt.macosx.LWCToolkit, screen menu won't be filled");
            }
        }
    }
}

