/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.themes;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010-\u001a\u0002H,2\u0006\u0010.\u001a\u0002H,\u00a2\u0006\u0002\u0010/R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006R\u0014\u0010!\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001cR\u0016\u0010#\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0006R\u0014\u0010%\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0006R\u0016\u0010'\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0006R\u0014\u0010)\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0006\u00a8\u00060"}, d2={"Lcom/intellij/ui/tabs/impl/themes/EditorTabTheme;", "Lcom/intellij/ui/tabs/impl/themes/TabTheme;", "()V", "background", "Ljava/awt/Color;", "getBackground", "()Ljava/awt/Color;", "borderColor", "getBorderColor", "globalScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getGlobalScheme", "()Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "hoverBackground", "getHoverBackground", "hoverInactiveBackground", "getHoverInactiveBackground", "hoverSelectedBackground", "getHoverSelectedBackground", "hoverSelectedInactiveBackground", "getHoverSelectedInactiveBackground", "inactiveColoredTabBackground", "getInactiveColoredTabBackground", "inactiveUnderlineColor", "getInactiveUnderlineColor", "topBorderThickness", "", "getTopBorderThickness", "()I", "underlineArc", "getUnderlineArc", "underlineColor", "getUnderlineColor", "underlineHeight", "getUnderlineHeight", "underlinedTabBackground", "getUnderlinedTabBackground", "underlinedTabForeground", "getUnderlinedTabForeground", "underlinedTabInactiveBackground", "getUnderlinedTabInactiveBackground", "underlinedTabInactiveForeground", "getUnderlinedTabInactiveForeground", "newUIAware", "T", "newUI", "oldUI", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "intellij.platform.ide"})
public final class EditorTabTheme
implements TabTheme {
    @Override
    public int getTopBorderThickness() {
        return ((Number)this.newUIAware(1, TabTheme.DefaultImpls.getTopBorderThickness(this))).intValue();
    }

    @NotNull
    public final EditorColorsScheme getGlobalScheme() {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        return editorColorsScheme;
    }

    @Override
    @NotNull
    public Color getBackground() {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        Color color = editorColorsScheme.getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"EditorColorsManager.getI\u2026lScheme.defaultBackground");
        Color color2 = JBUI.CurrentTheme.EditorTabs.background();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"JBUI.CurrentTheme.EditorTabs.background()");
        return this.newUIAware(color, color2);
    }

    @Override
    @NotNull
    public Color getBorderColor() {
        Color color = JBUI.CurrentTheme.EditorTabs.borderColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBUI.CurrentTheme.EditorTabs.borderColor()");
        return color;
    }

    @Override
    @NotNull
    public Color getUnderlineColor() {
        Color color = this.getGlobalScheme().getColor(EditorColors.TAB_UNDERLINE);
        if (color == null) {
            Color color2 = JBUI.CurrentTheme.EditorTabs.underlineColor();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"JBUI.CurrentTheme.EditorTabs.underlineColor()");
        }
        return color;
    }

    @Override
    @NotNull
    public Color getInactiveUnderlineColor() {
        Color color = this.getGlobalScheme().getColor(EditorColors.TAB_UNDERLINE_INACTIVE);
        if (color == null) {
            Color color2 = JBUI.CurrentTheme.EditorTabs.inactiveUnderlineColor();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"JBUI.CurrentTheme.Editor\u2026.inactiveUnderlineColor()");
        }
        return color;
    }

    @Override
    @Nullable
    public Color getUnderlinedTabBackground() {
        Color color = this.getGlobalScheme().getDefaultBackground();
        TextAttributes textAttributes = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"globalScheme.getAttribut\u2026ditorColors.TAB_SELECTED)");
        Color color2 = textAttributes.getBackgroundColor();
        if (color2 == null) {
            color2 = JBUI.CurrentTheme.EditorTabs.underlinedTabBackground();
        }
        return this.newUIAware(color, color2);
    }

    @Override
    @NotNull
    public Color getUnderlinedTabForeground() {
        TextAttributes textAttributes = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"globalScheme.getAttribut\u2026ditorColors.TAB_SELECTED)");
        Color color = textAttributes.getForegroundColor();
        if (color == null) {
            Color color2 = JBUI.CurrentTheme.EditorTabs.underlinedTabForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"JBUI.CurrentTheme.Editor\u2026underlinedTabForeground()");
        }
        return color;
    }

    @Override
    public int getUnderlineHeight() {
        return JBUI.CurrentTheme.EditorTabs.underlineHeight();
    }

    @Override
    public int getUnderlineArc() {
        return JBUI.CurrentTheme.EditorTabs.underlineArc();
    }

    @Override
    @NotNull
    public Color getHoverBackground() {
        Color color = JBUI.CurrentTheme.EditorTabs.hoverBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBUI.CurrentTheme.EditorTabs.hoverBackground()");
        return color;
    }

    @Override
    @NotNull
    public Color getHoverInactiveBackground() {
        Color color = JBUI.CurrentTheme.EditorTabs.hoverBackground((boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBUI.CurrentTheme.Editor\u2026rBackground(false, false)");
        return color;
    }

    @Override
    @NotNull
    public Color getHoverSelectedBackground() {
        Color color = JBUI.CurrentTheme.EditorTabs.hoverBackground((boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBUI.CurrentTheme.Editor\u2026verBackground(true, true)");
        return color;
    }

    @Override
    @NotNull
    public Color getHoverSelectedInactiveBackground() {
        Color color = JBUI.CurrentTheme.EditorTabs.hoverBackground((boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBUI.CurrentTheme.Editor\u2026erBackground(true, false)");
        return color;
    }

    @Override
    @Nullable
    public Color getUnderlinedTabInactiveBackground() {
        TextAttributes textAttributes = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED_INACTIVE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"globalScheme.getAttribut\u2026rs.TAB_SELECTED_INACTIVE)");
        Color color = textAttributes.getBackgroundColor();
        if (color == null) {
            color = this.getUnderlinedTabBackground();
        }
        return color;
    }

    @Override
    @NotNull
    public Color getUnderlinedTabInactiveForeground() {
        TextAttributes textAttributes = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED_INACTIVE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"globalScheme.getAttribut\u2026rs.TAB_SELECTED_INACTIVE)");
        Color color = textAttributes.getForegroundColor();
        if (color == null) {
            color = this.getUnderlinedTabForeground();
        }
        return color;
    }

    @Override
    @NotNull
    public Color getInactiveColoredTabBackground() {
        Color color = JBColor.PanelBackground;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBColor.PanelBackground");
        Color color2 = JBUI.CurrentTheme.EditorTabs.inactiveColoredFileBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"JBUI.CurrentTheme.Editor\u2026veColoredFileBackground()");
        return this.newUIAware(color, color2);
    }

    public final <T> T newUIAware(T newUI, T oldUI) {
        return ExperimentalUI.isNewEditorTabs() ? newUI : oldUI;
    }
}

