/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.usages.UsageNodePresentation;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class Node
extends DefaultMutableTreeNode {
    private int myCachedTextHash;
    private byte myCachedFlags;
    private static final byte CACHED_INVALID_MASK = 1;
    private static final byte CACHED_READ_ONLY_MASK = 2;
    private static final byte READ_ONLY_COMPUTED_MASK = 4;
    static final byte EXCLUDED_MASK = 8;
    private static final byte UPDATED_MASK = 16;
    private static final byte FORCE_UPDATE_REQUESTED_MASK = 32;

    private synchronized boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet((byte)this.myCachedFlags, (byte)mask);
    }

    private synchronized void setFlag(@FlagConstant byte mask, boolean value2) {
        this.myCachedFlags = BitUtil.set((byte)this.myCachedFlags, (byte)mask, (boolean)value2);
    }

    Node() {
    }

    protected abstract boolean isDataValid();

    protected abstract boolean isDataReadOnly();

    protected abstract boolean isDataExcluded();

    @Nullable
    public UsageNodePresentation getCachedPresentation() {
        return null;
    }

    protected void updateCachedPresentation() {
    }

    @NotNull
    protected abstract String getNodeText();

    final boolean isValid() {
        return !this.isFlagSet((byte)1);
    }

    final boolean isReadOnly() {
        boolean result;
        boolean computed = this.isFlagSet((byte)4);
        if (computed) {
            result = this.isFlagSet((byte)2);
        } else {
            result = this.isDataReadOnly();
            this.setFlag((byte)4, true);
            this.setFlag((byte)2, result);
        }
        return result;
    }

    final boolean isExcluded() {
        return this.isFlagSet((byte)8);
    }

    final void update(@NotNull Consumer<? super Node> edtFireTreeNodesChangedQueue) {
        if (edtFireTreeNodesChangedQueue == null) {
            Node.$$$reportNull$$$0(0);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        boolean isDataValid = this.isDataValid();
        boolean isReadOnly = this.isDataReadOnly();
        String text2 = this.getNodeText();
        this.updateCachedPresentation();
        this.doUpdate(isDataValid, isReadOnly, text2, edtFireTreeNodesChangedQueue);
    }

    private synchronized void doUpdate(boolean isDataValid, boolean isReadOnly, @NotNull String text2, @NotNull Consumer<? super Node> edtFireTreeNodesChangedQueue) {
        if (text2 == null) {
            Node.$$$reportNull$$$0(1);
        }
        if (edtFireTreeNodesChangedQueue == null) {
            Node.$$$reportNull$$$0(2);
        }
        boolean cachedValid = this.isValid();
        boolean cachedReadOnly = this.isFlagSet((byte)2);
        if (isDataValid != cachedValid || isReadOnly != cachedReadOnly || this.myCachedTextHash != text2.hashCode() || this.isFlagSet((byte)32)) {
            this.setFlag((byte)1, !isDataValid);
            this.setFlag((byte)2, isReadOnly);
            this.setFlag((byte)32, false);
            this.myCachedTextHash = text2.hashCode();
            this.updateNotify();
            edtFireTreeNodesChangedQueue.consume((Object)this);
        }
        this.setFlag((byte)16, true);
    }

    void markNeedUpdate() {
        this.setFlag((byte)16, false);
    }

    boolean needsUpdate() {
        return !this.isFlagSet((byte)16);
    }

    void forceUpdate() {
        this.setFlag((byte)32, true);
    }

    protected void updateNotify() {
    }

    void insertNewNode(@NotNull Node newChild, int childIndex) {
        if (newChild == null) {
            Node.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    void setExcluded(boolean excluded, @NotNull Consumer<? super Node> edtFireTreeNodesChangedQueue) {
        if (edtFireTreeNodesChangedQueue == null) {
            Node.$$$reportNull$$$0(4);
        }
        this.setFlag((byte)8, excluded);
        edtFireTreeNodesChangedQueue.consume((Object)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtFireTreeNodesChangedQueue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
        }
        objectArray2[1] = "com/intellij/usages/impl/Node";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "insertNewNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setExcluded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static @interface FlagConstant {
    }
}

