/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.text.DateTimeFormatterBean;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DateTimeFormatter", storages={@Storage(value="ui-datetime.xml")}, category=SettingsCategory.SYSTEM)
public final class DateTimeFormatManager
implements PersistentStateComponent<Element> {
    public static final String DEFAULT_DATE_FORMAT = "dd MMM yyyy";
    private boolean myPrettyFormattingAllowed = true;
    private String myPattern = "dd MMM yyyy";
    private boolean myOverrideSystemDateFormat = false;
    private boolean myUse24HourTime = true;

    @Override
    @Nullable
    public Element getState() {
        return XmlSerializer.serialize(this);
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            DateTimeFormatManager.$$$reportNull$$$0(0);
        }
        DateTimeFormatManager loaded = XmlSerializer.deserialize(state, DateTimeFormatManager.class);
        XmlSerializerUtil.copyBean((Object)loaded, (Object)this);
    }

    public boolean isOverrideSystemDateFormat() {
        return this.myOverrideSystemDateFormat;
    }

    public void setOverrideSystemDateFormat(boolean overrideSystemDateFormat) {
        this.myOverrideSystemDateFormat = overrideSystemDateFormat;
    }

    public boolean isUse24HourTime() {
        return this.myUse24HourTime;
    }

    public void setUse24HourTime(boolean use24HourTime) {
        this.myUse24HourTime = use24HourTime;
    }

    public void setPrettyFormattingAllowed(boolean prettyFormattingAllowed) {
        this.myPrettyFormattingAllowed = prettyFormattingAllowed;
    }

    @Nullable
    public DateFormat getDateFormat() {
        try {
            return new SimpleDateFormat(this.myPattern);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set<String> getIds() {
        return DateTimeFormatterBean.EP_NAME.getExtensionList().stream().map(bean -> bean.id).collect(Collectors.toSet());
    }

    @NotNull
    public String getDateFormatPattern() {
        String string = this.myPattern;
        if (string == null) {
            DateTimeFormatManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setDateFormatPattern(@NotNull String pattern) {
        if (pattern == null) {
            DateTimeFormatManager.$$$reportNull$$$0(2);
        }
        try {
            new SimpleDateFormat(pattern);
            this.myPattern = pattern;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isPrettyFormattingAllowed() {
        return this.myPrettyFormattingAllowed;
    }

    public static DateTimeFormatManager getInstance() {
        return (DateTimeFormatManager)ApplicationManager.getApplication().getService(DateTimeFormatManager.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/DateTimeFormatManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/DateTimeFormatManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateFormatPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDateFormatPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

