/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.data.AwtImageInfo;
import org.jetbrains.projector.awt.data.AwtPaintType;
import org.jetbrains.projector.awt.font.PFontManager;
import org.jetbrains.projector.awt.image.AffineTransformUrilKt;
import org.jetbrains.projector.awt.image.PGraphics2D;
import org.jetbrains.projector.awt.image.PVolatileImage;
import org.jetbrains.projector.awt.image.ShapeUtilKt;
import org.jetbrains.projector.awt.service.Defaults;
import org.jetbrains.projector.awt.service.DrawEventQueue;
import org.jetbrains.projector.awt.service.ImageCacher;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;
import sun.font.FontDesignMetrics;
import sun.java2d.NullSurfaceData;
import sun.java2d.SunGraphics2D;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b%\u0018\u0000 \u00c1\u00012\u00020\u0001:\u0002\u00c1\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bBG\b\u0012\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016Ba\b\u0002\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u001fJ0\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020/H\u0002J\u0018\u00103\u001a\u00020+2\u000e\u0010\u0019\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000304H\u0016J(\u00105\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u000206H\u0016J\u0012\u00107\u001a\u00020+2\b\u00108\u001a\u0004\u0018\u00010\u001cH\u0016J(\u00109\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u0010:\u001a\u0002062\u0006\u0010;\u001a\u000206H\u0016J8\u0010<\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u0002062\u0006\u0010=\u001a\u0002062\u0006\u0010>\u001a\u000206H\u0016J\b\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020+H\u0016J\u0010\u0010B\u001a\u00020+2\u0006\u00108\u001a\u00020\u001cH\u0016J8\u0010C\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u0002062\u0006\u0010D\u001a\u0002062\u0006\u0010E\u001a\u000206H\u0016J \u0010F\u001a\u00020+2\u0006\u0010G\u001a\u00020H2\u0006\u0010.\u001a\u00020I2\u0006\u00100\u001a\u00020IH\u0016J$\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010N\u001a\u00020\f2\b\u0010O\u001a\u0004\u0018\u00010PH\u0016J6\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\b\u0010Q\u001a\u0004\u0018\u00010\u000e2\b\u0010R\u001a\u0004\u0018\u00010PH\u0016J,\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\b\u0010R\u001a\u0004\u0018\u00010PH\u0016JF\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u0002062\b\u0010Q\u001a\u0004\u0018\u00010\u000e2\b\u0010R\u001a\u0004\u0018\u00010PH\u0016J<\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u0002062\b\u0010R\u001a\u0004\u0018\u00010PH\u0016Jf\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010S\u001a\u0002062\u0006\u0010T\u001a\u0002062\u0006\u0010U\u001a\u0002062\u0006\u0010V\u001a\u0002062\u0006\u0010W\u001a\u0002062\u0006\u0010X\u001a\u0002062\u0006\u0010Y\u001a\u0002062\u0006\u0010Z\u001a\u0002062\b\u0010Q\u001a\u0004\u0018\u00010\u000e2\b\u0010R\u001a\u0004\u0018\u00010PH\u0016J\\\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010S\u001a\u0002062\u0006\u0010T\u001a\u0002062\u0006\u0010U\u001a\u0002062\u0006\u0010V\u001a\u0002062\u0006\u0010W\u001a\u0002062\u0006\u0010X\u001a\u0002062\u0006\u0010Y\u001a\u0002062\u0006\u0010Z\u001a\u0002062\b\u0010R\u001a\u0004\u0018\u00010PH\u0016J*\u0010J\u001a\u00020+2\b\u0010L\u001a\u0004\u0018\u00010[2\u0006\u0010\\\u001a\u00020]2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u000206H\u0016J(\u0010^\u001a\u00020+2\u0006\u0010_\u001a\u0002062\u0006\u0010`\u001a\u0002062\u0006\u0010a\u001a\u0002062\u0006\u0010b\u001a\u000206H\u0016J(\u0010c\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u000206H\u0016J \u0010d\u001a\u00020+2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020f2\u0006\u0010h\u001a\u000206H\u0016J \u0010i\u001a\u00020+2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020f2\u0006\u0010h\u001a\u000206H\u0016J\u0018\u0010j\u001a\u00020+2\u0006\u0010L\u001a\u00020k2\u0006\u0010N\u001a\u00020\fH\u0016J\u001a\u0010l\u001a\u00020+2\u0006\u0010L\u001a\u00020m2\b\u0010N\u001a\u0004\u0018\u00010\fH\u0016J8\u0010n\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u0002062\u0006\u0010o\u001a\u0002062\u0006\u0010p\u001a\u000206H\u0016J \u0010q\u001a\u00020+2\u0006\u0010r\u001a\u00020s2\u0006\u0010.\u001a\u00020I2\u0006\u00100\u001a\u00020IH\u0016J \u0010q\u001a\u00020+2\u0006\u0010r\u001a\u00020s2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u000206H\u0016J \u0010q\u001a\u00020+2\u0006\u0010t\u001a\u00020u2\u0006\u0010.\u001a\u00020I2\u0006\u00100\u001a\u00020IH\u0016J \u0010q\u001a\u00020+2\u0006\u0010t\u001a\u00020u2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u000206H\u0016J\"\u0010v\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020uH\u0002J\u0010\u0010z\u001a\u00020+2\u0006\u00108\u001a\u00020\u001cH\u0016J8\u0010{\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u0002062\u0006\u0010D\u001a\u0002062\u0006\u0010E\u001a\u000206H\u0016J(\u0010|\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u000206H\u0016J \u0010}\u001a\u00020+2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020f2\u0006\u0010h\u001a\u000206H\u0016J(\u0010~\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u000206H\u0016J8\u0010\u007f\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u0002062\u0006\u0010o\u001a\u0002062\u0006\u0010p\u001a\u000206H\u0016J\t\u0010\u0080\u0001\u001a\u00020\u000eH\u0016J\u000b\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u001cH\u0016J\f\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0083\u0001H\u0016J\t\u0010\u0084\u0001\u001a\u00020\u000eH\u0016J\t\u0010\u0085\u0001\u001a\u00020\u0018H\u0016J\n\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0016J\t\u0010\u0088\u0001\u001a\u00020\u0013H\u0016J\n\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0016J\u0013\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0007\u0010\u008b\u0001\u001a\u00020\u0013H\u0016J\t\u0010\u008c\u0001\u001a\u00020!H\u0016J\t\u0010\u008d\u0001\u001a\u00020\u0010H\u0016J\u0016\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0016J\t\u0010\u0092\u0001\u001a\u00020\u001aH\u0016J\t\u0010\u0093\u0001\u001a\u00020\u001eH\u0016J\t\u0010\u0094\u0001\u001a\u00020\fH\u0016J$\u0010\u0095\u0001\u001a\u00020K2\b\u0010\u0096\u0001\u001a\u00030\u0083\u00012\u0006\u00108\u001a\u00020\u001c2\u0007\u0010\u0097\u0001\u001a\u00020KH\u0016JA\u0010\u0098\u0001\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u0002062\u0006\u0010D\u001a\u0002062\u0006\u0010E\u001a\u000206H\u0002J)\u0010\u0099\u0001\u001a\u00020+2\u001d\b\u0004\u0010\u009a\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u009c\u0001\u0012\u0004\u0012\u00020+0\u009b\u0001\u00a2\u0006\u0003\b\u009d\u0001H\u0082\bJ1\u0010\u009e\u0001\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u000206H\u0002J)\u0010\u009f\u0001\u001a\u00020+2\u001d\b\u0004\u0010\u009a\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u009c\u0001\u0012\u0004\u0012\u00020+0\u009b\u0001\u00a2\u0006\u0003\b\u009d\u0001H\u0082\bJ)\u0010\u00a0\u0001\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020f2\u0006\u0010h\u001a\u000206H\u0002JA\u0010\u00a1\u0001\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u00101\u001a\u0002062\u0006\u00102\u001a\u0002062\u0006\u0010o\u001a\u0002062\u0006\u0010p\u001a\u000206H\u0002J\u001a\u0010\u00a2\u0001\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0007\u0010\u00a3\u0001\u001a\u00020\u001cH\u0002J)\u0010\u00a2\u0001\u001a\u00020+2\u001d\b\u0004\u0010\u009a\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u009c\u0001\u0012\u0004\u0012\u00020+0\u009b\u0001\u00a2\u0006\u0003\b\u009d\u0001H\u0082\bJ!\u0010\u00a4\u0001\u001a\u00020+2\u0006\u0010t\u001a\u00020u2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0002J\u0012\u0010\u00a5\u0001\u001a\u00020+2\u0007\u0010\u00a6\u0001\u001a\u00020/H\u0016J\"\u0010\u00a5\u0001\u001a\u00020+2\u0007\u0010\u00a7\u0001\u001a\u00020/2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0016J\u001b\u0010\u00a8\u0001\u001a\u00020+2\u0007\u0010\u00a9\u0001\u001a\u00020/2\u0007\u0010\u00aa\u0001\u001a\u00020/H\u0016J\u0014\u0010\u00ab\u0001\u001a\u00020+2\t\u0010\u00ac\u0001\u001a\u0004\u0018\u00010\u000eH\u0016J\u0013\u0010\u00ad\u0001\u001a\u00020+2\b\u00108\u001a\u0004\u0018\u00010\u001cH\u0016J)\u0010\u00ad\u0001\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u0002062\u0006\u0010:\u001a\u0002062\u0006\u0010;\u001a\u000206H\u0016J\u0014\u0010\u00ae\u0001\u001a\u00020+2\t\u0010\u00ac\u0001\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u00af\u0001\u001a\u00020+2\u0007\u0010\u00b0\u0001\u001a\u00020\u0018H\u0016J\u0013\u0010\u00b1\u0001\u001a\u00020+2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0013\u0010\u00b2\u0001\u001a\u00020+2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\t\u0010\u00b3\u0001\u001a\u00020+H\u0016J!\u0010\u00b4\u0001\u001a\u00020+2\n\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u00012\n\u0010\u00b5\u0001\u001a\u0005\u0018\u00010\u008f\u0001H\u0016J\u0019\u0010\u00b6\u0001\u001a\u00020+2\u000e\u0010\u0019\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000304H\u0016J\u0011\u0010\u00b7\u0001\u001a\u00020+2\u0006\u00108\u001a\u00020\u001eH\u0016J\u0012\u0010\u00b8\u0001\u001a\u00020+2\u0007\u0010\u00b9\u0001\u001a\u00020\fH\u0016J\u0012\u0010\u00ba\u0001\u001a\u00020+2\u0007\u0010\u00ac\u0001\u001a\u00020\u000eH\u0016J\u001b\u0010\u00bb\u0001\u001a\u00020+2\u0007\u0010\u00bc\u0001\u001a\u00020/2\u0007\u0010\u00bd\u0001\u001a\u00020/H\u0016J\u0011\u0010\u000b\u001a\u00020+2\u0007\u0010\u00be\u0001\u001a\u00020\fH\u0016J\u0019\u0010\u00bf\u0001\u001a\u00020+2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0016J\u0019\u0010\u00bf\u0001\u001a\u00020+2\u0006\u0010.\u001a\u0002062\u0006\u00100\u001a\u000206H\u0016J\r\u0010\u00c0\u0001\u001a\u00020\u001c*\u00020\u001cH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\u00020!8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00c2\u0001"}, d2={"Lorg/jetbrains/projector/awt/image/PGraphics2D;", "Ljava/awt/Graphics2D;", "target", "Lorg/jetbrains/projector/awt/image/PVolatileImage$Descriptor;", "(Lorg/jetbrains/projector/awt/image/PVolatileImage$Descriptor;)V", "component", "Ljava/awt/Component;", "Lorg/jetbrains/projector/awt/PWindow$Descriptor;", "(Ljava/awt/Component;Lorg/jetbrains/projector/awt/PWindow$Descriptor;)V", "drawEventQueue", "Lorg/jetbrains/projector/awt/service/DrawEventQueue;", "transform", "Ljava/awt/geom/AffineTransform;", "backgroundColor", "Ljava/awt/Color;", "paint", "Ljava/awt/Paint;", "foregroundColor", "font", "Ljava/awt/Font;", "device", "Ljava/awt/GraphicsDevice;", "(Lorg/jetbrains/projector/awt/service/DrawEventQueue;Ljava/awt/geom/AffineTransform;Ljava/awt/Color;Ljava/awt/Paint;Ljava/awt/Color;Ljava/awt/Font;Ljava/awt/GraphicsDevice;)V", "backingComposite", "Ljava/awt/Composite;", "hints", "Ljava/awt/RenderingHints;", "identitySpaceClip", "Ljava/awt/Shape;", "stroke", "Ljava/awt/Stroke;", "(Lorg/jetbrains/projector/awt/service/DrawEventQueue;Ljava/awt/Composite;Ljava/awt/RenderingHints;Ljava/awt/Shape;Ljava/awt/geom/AffineTransform;Ljava/awt/Color;Ljava/awt/Paint;Ljava/awt/Color;Ljava/awt/Stroke;Ljava/awt/Font;Ljava/awt/GraphicsDevice;)V", "backingFontRenderContext", "Ljava/awt/font/FontRenderContext;", "getBackingFontRenderContext", "()Ljava/awt/font/FontRenderContext;", "getDevice", "()Ljava/awt/GraphicsDevice;", "setDevice", "(Ljava/awt/GraphicsDevice;)V", "getDrawEventQueue", "()Lorg/jetbrains/projector/awt/service/DrawEventQueue;", "addPaintRectCommand", "", "paintType", "Lorg/jetbrains/projector/awt/data/AwtPaintType;", "x", "", "y", "width", "height", "addRenderingHints", "", "clearRect", "", "clip", "s", "clipRect", "w", "h", "copyArea", "dx", "dy", "create", "Ljava/awt/Graphics;", "dispose", "draw", "drawArc", "startAngle", "arcAngle", "drawGlyphVector", "g", "Ljava/awt/font/GlyphVector;", "", "drawImage", "", "img", "Ljava/awt/Image;", "xform", "obs", "Ljava/awt/image/ImageObserver;", "bgcolor", "observer", "dx1", "dy1", "dx2", "dy2", "sx1", "sy1", "sx2", "sy2", "Ljava/awt/image/BufferedImage;", "op", "Ljava/awt/image/BufferedImageOp;", "drawLine", "x1", "y1", "x2", "y2", "drawOval", "drawPolygon", "xPoints", "", "yPoints", "nPoints", "drawPolyline", "drawRenderableImage", "Ljava/awt/image/renderable/RenderableImage;", "drawRenderedImage", "Ljava/awt/image/RenderedImage;", "drawRoundRect", "arcWidth", "arcHeight", "drawString", "iterator", "Ljava/text/AttributedCharacterIterator;", "str", "", "extractImage", "awtImageInfo", "Lorg/jetbrains/projector/awt/data/AwtImageInfo;", "methodName", "fill", "fillArc", "fillOval", "fillPolygon", "fillRect", "fillRoundRect", "getBackground", "getClip", "getClipBounds", "Ljava/awt/Rectangle;", "getColor", "getComposite", "getDeviceConfiguration", "Ljava/awt/GraphicsConfiguration;", "getFont", "getFontMetrics", "Ljava/awt/FontMetrics;", "newFont", "getFontRenderContext", "getPaint", "getRenderingHint", "", "hintKey", "Ljava/awt/RenderingHints$Key;", "getRenderingHints", "getStroke", "getTransform", "hit", "rect", "onStroke", "paintArc", "paintArea", "command", "Lkotlin/Function1;", "Lorg/jetbrains/projector/awt/service/DrawEventQueue$CommandBuilder;", "Lkotlin/ExtensionFunctionType;", "paintOval", "paintPlain", "paintPolygon", "paintRoundRect", "paintShape", "shape", "paintString", "rotate", "radians", "theta", "scale", "sx", "sy", "setBackground", "color", "setClip", "setColor", "setComposite", "comp", "setFont", "setPaint", "setPaintMode", "setRenderingHint", "hintValue", "setRenderingHints", "setStroke", "setTransform", "tx", "setXORMode", "shear", "shx", "shy", "Tx", "translate", "untransformShape", "Companion", "projector-awt"})
public final class PGraphics2D
extends Graphics2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DrawEventQueue drawEventQueue;
    @NotNull
    private Composite backingComposite;
    @NotNull
    private final RenderingHints hints;
    @Nullable
    private Shape identitySpaceClip;
    @NotNull
    private final AffineTransform transform;
    @NotNull
    private Color backgroundColor;
    @NotNull
    private Paint paint;
    @NotNull
    private Color foregroundColor;
    @NotNull
    private Stroke stroke;
    @NotNull
    private Font font;
    @NotNull
    private GraphicsDevice device;
    @NotNull
    private FontRenderContext backingFontRenderContext;
    @NotNull
    private static final Logger logger;
    private static final RenderingHints defaultRenderingHints;
    @Nullable
    private static final Object defaultAa;

    private PGraphics2D(DrawEventQueue drawEventQueue, Composite backingComposite, RenderingHints hints, Shape identitySpaceClip, AffineTransform transform, Color backgroundColor, Paint paint, Color foregroundColor, Stroke stroke, Font font, GraphicsDevice device) {
        this.drawEventQueue = drawEventQueue;
        this.backingComposite = backingComposite;
        this.hints = hints;
        this.identitySpaceClip = identitySpaceClip;
        this.transform = transform;
        this.backgroundColor = backgroundColor;
        this.paint = paint;
        this.foregroundColor = foregroundColor;
        this.stroke = stroke;
        this.font = font;
        this.device = device;
        this.backingFontRenderContext = new FontRenderContext(PGraphics2D.Companion.getWithoutTranslation(this.transform), PGraphics2D.Companion.extractTextAntiAliasingHint(this.hints), PGraphics2D.Companion.extractFractionalMetricsHint(this.hints));
    }

    @NotNull
    public final DrawEventQueue getDrawEventQueue() {
        return this.drawEventQueue;
    }

    @NotNull
    public final GraphicsDevice getDevice() {
        return this.device;
    }

    public final void setDevice(@NotNull GraphicsDevice graphicsDevice) {
        Intrinsics.checkNotNullParameter((Object)graphicsDevice, (String)"<set-?>");
        this.device = graphicsDevice;
    }

    private final FontRenderContext getBackingFontRenderContext() {
        AffineTransform currentTransform = PGraphics2D.Companion.getWithoutTranslation(this.transform);
        Object currentAa = PGraphics2D.Companion.extractTextAntiAliasingHint(this.hints);
        Object currentFm = PGraphics2D.Companion.extractFractionalMetricsHint(this.hints);
        if (!(Intrinsics.areEqual((Object)this.backingFontRenderContext.getTransform(), (Object)currentTransform) && Intrinsics.areEqual((Object)this.backingFontRenderContext.getAntiAliasingHint(), (Object)currentAa) && Intrinsics.areEqual((Object)this.backingFontRenderContext.getFractionalMetricsHint(), (Object)currentFm))) {
            this.backingFontRenderContext = new FontRenderContext(currentTransform, currentAa, currentFm);
        }
        return this.backingFontRenderContext;
    }

    private final void paintPlain(Function1<? super DrawEventQueue.CommandBuilder, Unit> command) {
        boolean $i$f$paintPlain = false;
        command.invoke((Object)this.getDrawEventQueue().buildCommand());
    }

    private final void paintShape(Function1<? super DrawEventQueue.CommandBuilder, Unit> command) {
        boolean $i$f$paintShape = false;
        command.invoke((Object)this.getDrawEventQueue().buildCommand().setClip(this.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this.transform)).setStroke(this.stroke).setPaint(this.paint).setComposite(this.backingComposite));
    }

    private final void paintArea(Function1<? super DrawEventQueue.CommandBuilder, Unit> command) {
        boolean $i$f$paintArea = false;
        command.invoke((Object)this.getDrawEventQueue().buildCommand().setClip(this.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this.transform)).setComposite(this.backingComposite));
    }

    private final void paintString(String str, double x, double y) {
        if (StringsKt.isBlank((CharSequence)str)) {
            return;
        }
        FontDesignMetrics metrics = FontDesignMetrics.getMetrics(this.font, this.getBackingFontRenderContext());
        int desiredWidth = metrics.stringWidth(str);
        this.drawEventQueue.buildCommand().setClip(this.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this.transform)).setFont(this.font).setPaint(this.paint).setComposite(this.backingComposite).drawString(str, x, y, desiredWidth);
    }

    public PGraphics2D(@NotNull PVolatileImage.Descriptor target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        DrawEventQueue drawEventQueue = (DrawEventQueue)DrawEventQueue.Companion.getCreateOffScreen().invoke((Object)target);
        AffineTransform affineTransform = new AffineTransform();
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsDevice, (String)"getLocalGraphicsEnvironment().defaultScreenDevice");
        this(drawEventQueue, affineTransform, null, null, null, null, graphicsDevice);
    }

    public PGraphics2D(@NotNull Component component, @NotNull PWindow.Descriptor target) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        DrawEventQueue drawEventQueue = (DrawEventQueue)DrawEventQueue.Companion.getCreateOnScreen().invoke((Object)target);
        Object object = component.getGraphicsConfiguration().getDefaultTransform();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component.graphicsConfiguration.defaultTransform");
        AffineTransform affineTransform = object;
        Color color = component.getBackground();
        Paint paint = component.getForeground();
        Color color2 = component.getForeground();
        Font font = component.getFont();
        object = component.getGraphicsConfiguration().getDevice();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component.graphicsConfiguration.device");
        this(drawEventQueue, affineTransform, color, paint, color2, font, (GraphicsDevice)object);
    }

    private PGraphics2D(DrawEventQueue drawEventQueue, AffineTransform transform, Color backgroundColor, Paint paint, Color foregroundColor, Font font, GraphicsDevice device) {
        Object object = AlphaComposite.SrcOver;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SrcOver");
        Composite composite = (Composite)object;
        object = backgroundColor;
        Object object2 = object == null ? Defaults.INSTANCE.getBACKGROUND_COLOR_ARGB() : object;
        object = paint;
        Object object3 = object == null ? (Paint)Defaults.INSTANCE.getFOREGROUND_COLOR_ARGB() : object;
        object = foregroundColor;
        Object object4 = object == null ? Defaults.INSTANCE.getFOREGROUND_COLOR_ARGB() : object;
        object = font;
        this(drawEventQueue, composite, PGraphics2D.Companion.makeHints(null), null, transform, (Color)object2, (Paint)object3, (Color)object4, Defaults.INSTANCE.getSTROKE(), (Font)(object == null ? (Font)ArraysKt.first((Object[])PFontManager.INSTANCE.getAllInstalledFonts()) : object), device);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Graphics create() {
        void $this$create_u24lambda_u2d0;
        Object object = PGraphics2D.Companion.makeHints(null);
        boolean bl = false;
        boolean bl2 = false;
        RenderingHints renderingHints = object;
        Composite composite = this.backingComposite;
        DrawEventQueue drawEventQueue = this.drawEventQueue;
        boolean bl3 = false;
        $this$create_u24lambda_u2d0.add(this.hints);
        Unit unit = Unit.INSTANCE;
        RenderingHints renderingHints2 = object;
        object = this.identitySpaceClip;
        GraphicsDevice graphicsDevice = this.device;
        Font font = this.font;
        Stroke stroke = this.stroke;
        Color color = this.foregroundColor;
        Paint paint = this.paint;
        Color color2 = this.backgroundColor;
        AffineTransform affineTransform = new AffineTransform(this.transform);
        Shape shape = object == null ? null : ShapeUtilKt.copy((Shape)object);
        RenderingHints renderingHints3 = renderingHints2;
        Composite composite2 = composite;
        DrawEventQueue drawEventQueue2 = drawEventQueue;
        return new PGraphics2D(drawEventQueue2, composite2, renderingHints3, shape, affineTransform, color2, paint, color, stroke, font, graphicsDevice);
    }

    @Override
    public void draw(@NotNull Shape s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.paintShape(AwtPaintType.DRAW, s);
    }

    @Override
    public void drawRenderedImage(@NotNull RenderedImage img, @Nullable AffineTransform xform) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        Object object = xform;
        AffineTransform xFormOrDefault = object == null ? new AffineTransform() : object;
        object = img;
        if (object instanceof BufferedImage) {
            AwtImageInfo.Transformation info = new AwtImageInfo.Transformation(AffineTransformUrilKt.toList(xFormOrDefault));
            this.extractImage((Image)((Object)img), info, "drawRenderedImage(img, xform)");
        } else {
            PGraphics2D this_$iv = this;
            boolean $i$f$paintPlain = false;
            DrawEventQueue.CommandBuilder $this$drawRenderedImage_u24lambda_u2d1 = this_$iv.getDrawEventQueue().buildCommand();
            boolean bl = false;
            $this$drawRenderedImage_u24lambda_u2d1.drawRenderedImage();
        }
    }

    @Override
    public void drawRenderableImage(@NotNull RenderableImage img, @NotNull AffineTransform xform) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        Intrinsics.checkNotNullParameter((Object)xform, (String)"xform");
        PGraphics2D this_$iv = this;
        boolean $i$f$paintPlain = false;
        DrawEventQueue.CommandBuilder $this$drawRenderableImage_u24lambda_u2d2 = this_$iv.getDrawEventQueue().buildCommand();
        boolean bl = false;
        $this$drawRenderableImage_u24lambda_u2d2.drawRenderableImage();
    }

    @Override
    public void drawString(@NotNull String str, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.paintString(str, x, y);
    }

    @Override
    public void drawString(@NotNull String str, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.paintString(str, x, y);
    }

    @Override
    public void drawString(@NotNull AttributedCharacterIterator iterator, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(@NotNull AttributedCharacterIterator iterator, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        if (iterator.getBeginIndex() != iterator.getEndIndex()) {
            TextLayout tl = new TextLayout(iterator, this.getBackingFontRenderContext());
            tl.draw(this, x, y);
        }
    }

    @Override
    public void drawGlyphVector(@NotNull GlyphVector g, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Shape shape = g.getOutline(x, y);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"shape");
        this.fill(shape);
    }

    private final void paintShape(AwtPaintType paintType, Shape shape) {
        Shape shape2 = shape;
        if (shape2 instanceof Rectangle2D) {
            this.addPaintRectCommand(paintType, ((Rectangle2D)shape).getX(), ((Rectangle2D)shape).getY(), ((Rectangle2D)shape).getWidth(), ((Rectangle2D)shape).getHeight());
        } else {
            PGraphics2D this_$iv = this;
            boolean $i$f$paintShape = false;
            DrawEventQueue.CommandBuilder $this$paintShape_u24lambda_u2d3 = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
            boolean bl = false;
            $this$paintShape_u24lambda_u2d3.paintPath(paintType, shape);
        }
    }

    @Override
    public void fill(@NotNull Shape s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.paintShape(AwtPaintType.FILL, s);
    }

    @Override
    public boolean hit(@NotNull Rectangle rect, @NotNull Shape s, boolean onStroke) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return false;
    }

    @Override
    @NotNull
    public GraphicsConfiguration getDeviceConfiguration() {
        GraphicsConfiguration graphicsConfiguration = this.device.getDefaultConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"device.defaultConfiguration");
        return graphicsConfiguration;
    }

    @Override
    public void setComposite(@NotNull Composite comp) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        this.backingComposite = comp;
    }

    @Override
    public void setPaint(@Nullable Paint paint) {
        if (paint == null) {
            return;
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        } else {
            this.paint = paint;
        }
    }

    @Override
    public void setStroke(@NotNull Stroke s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.stroke = s;
    }

    @Override
    public void setRenderingHint(@Nullable RenderingHints.Key hintKey, @Nullable Object hintValue) {
        if (hintKey == null || hintValue == null) {
            return;
        }
        Map map = this.hints;
        boolean bl = false;
        map.put(hintKey, hintValue);
    }

    @Override
    @Nullable
    public Object getRenderingHint(@NotNull RenderingHints.Key hintKey) {
        Intrinsics.checkNotNullParameter((Object)hintKey, (String)"hintKey");
        return this.hints.get(hintKey);
    }

    @Override
    public void setRenderingHints(@NotNull Map<?, ?> hints) {
        Intrinsics.checkNotNullParameter(hints, (String)"hints");
        RenderingHints renderingHints = this.hints;
        boolean bl = false;
        boolean bl2 = false;
        RenderingHints $this$setRenderingHints_u24lambda_u2d4 = renderingHints;
        boolean bl3 = false;
        $this$setRenderingHints_u24lambda_u2d4.clear();
        $this$setRenderingHints_u24lambda_u2d4.putAll(hints);
    }

    @Override
    public void addRenderingHints(@NotNull Map<?, ?> hints) {
        Intrinsics.checkNotNullParameter(hints, (String)"hints");
        this.hints.putAll(hints);
    }

    @Override
    @NotNull
    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.hints.clone();
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void translate(double x, double y) {
        this.transform.translate(x, y);
    }

    @Override
    public void rotate(double radians) {
        this.transform.rotate(radians);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
    }

    @Override
    public void transform(@NotNull AffineTransform Tx) {
        Intrinsics.checkNotNullParameter((Object)Tx, (String)"Tx");
        this.transform.concatenate(Tx);
    }

    @Override
    public void setTransform(@NotNull AffineTransform tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        this.transform.setTransform(tx);
    }

    @Override
    @NotNull
    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    @Override
    @NotNull
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    @NotNull
    public Composite getComposite() {
        return this.backingComposite;
    }

    @Override
    public void setBackground(@Nullable Color color) {
        Color color2 = color;
        if (color2 == null) {
            return;
        }
        this.backgroundColor = color;
    }

    @Override
    @NotNull
    public Color getBackground() {
        return this.backgroundColor;
    }

    @Override
    @NotNull
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    @NotNull
    public FontRenderContext getFontRenderContext() {
        return this.getBackingFontRenderContext();
    }

    @Override
    @NotNull
    public Color getColor() {
        return this.foregroundColor;
    }

    @Override
    public void setColor(@Nullable Color color) {
        if (color == null) {
            return;
        }
        this.paint = color;
        this.foregroundColor = color;
    }

    @Override
    public void setPaintMode() {
        AlphaComposite alphaComposite = AlphaComposite.SrcOver;
        Intrinsics.checkNotNullExpressionValue((Object)alphaComposite, (String)"SrcOver");
        this.setComposite(alphaComposite);
    }

    @Override
    public void setXORMode(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
    }

    @Override
    @NotNull
    public Font getFont() {
        Font font = this.getFontMetrics().getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"fontMetrics.font");
        return font;
    }

    @Override
    public void setFont(@Nullable Font font) {
        if (font == null) {
            return;
        }
        this.font = font;
    }

    @Override
    @NotNull
    public FontMetrics getFontMetrics() {
        FontDesignMetrics fontDesignMetrics = FontDesignMetrics.getMetrics(this.font, this.getBackingFontRenderContext());
        Intrinsics.checkNotNullExpressionValue((Object)fontDesignMetrics, (String)"getMetrics(font, backingFontRenderContext)");
        return fontDesignMetrics;
    }

    @Override
    @NotNull
    public FontMetrics getFontMetrics(@NotNull Font newFont) {
        Intrinsics.checkNotNullParameter((Object)newFont, (String)"newFont");
        if (Intrinsics.areEqual((Object)newFont, (Object)this.font)) {
            return this.getFontMetrics();
        }
        FontDesignMetrics fontDesignMetrics = FontDesignMetrics.getMetrics(newFont, this.getBackingFontRenderContext());
        Intrinsics.checkNotNullExpressionValue((Object)fontDesignMetrics, (String)"getMetrics(newFont, backingFontRenderContext)");
        return fontDesignMetrics;
    }

    @Override
    @Nullable
    public Rectangle getClipBounds() {
        Rectangle rectangle;
        Shape shape = this.identitySpaceClip;
        if (shape == null) {
            rectangle = null;
        } else {
            Shape shape2 = this.untransformShape(shape);
            rectangle = shape2.getBounds();
        }
        return rectangle;
    }

    @Override
    public void clipRect(int x, int y, int w, int h) {
        this.clip(new Rectangle(x, y, w, h));
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.setClip(new Rectangle(x, y, w, h));
    }

    private final Shape untransformShape(Shape $this$untransformShape) {
        AffineTransform affineTransform = this.transform.createInverse();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"transform.createInverse()");
        return AffineTransformUrilKt.transformShape($this$untransformShape, affineTransform);
    }

    @Override
    @Nullable
    public Shape getClip() {
        try {
            Shape shape = this.identitySpaceClip;
            return shape == null ? null : this.untransformShape(shape);
        }
        catch (NoninvertibleTransformException e) {
            logger.error((Throwable)e, (Function0)getClip.1.INSTANCE);
            return null;
        }
    }

    @Override
    public void clip(@Nullable Shape s) {
        Shape shape;
        if (s == null) {
            this.identitySpaceClip = null;
            return;
        }
        Shape identitySpaceShape = null;
        identitySpaceShape = AffineTransformUrilKt.transformShape(s, this.transform);
        if (Intrinsics.areEqual((Object)identitySpaceShape, (Object)this.identitySpaceClip)) {
            return;
        }
        if (identitySpaceShape.getBounds().isEmpty()) {
            // empty if block
        }
        if ((shape = this.identitySpaceClip) != null) {
            Shape shape2 = shape;
            boolean bl = false;
            boolean bl2 = false;
            Shape it = shape2;
            boolean bl3 = false;
            Shape intersection = ShapeUtilKt.intersectShapes(it, identitySpaceShape, true, true);
            if (intersection.getBounds().isEmpty()) {
                // empty if block
            }
            identitySpaceShape = intersection;
        }
        this.identitySpaceClip = identitySpaceShape;
    }

    @Override
    public void setClip(@Nullable Shape s) {
        Shape identitySpaceShape;
        Shape shape = s;
        Shape shape2 = identitySpaceShape = shape == null ? null : AffineTransformUrilKt.transformShape(shape, this.transform);
        if (Intrinsics.areEqual((Object)identitySpaceShape, (Object)this.identitySpaceClip)) {
            return;
        }
        this.identitySpaceClip = identitySpaceShape;
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        PGraphics2D this_$iv = this;
        boolean $i$f$paintArea = false;
        DrawEventQueue.CommandBuilder $this$copyArea_u24lambda_u2d6 = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$copyArea_u24lambda_u2d6.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$drawLine_u24lambda_u2d7 = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$drawLine_u24lambda_u2d7.drawLine(x1, y1, x2, y2);
    }

    private final void addPaintRectCommand(AwtPaintType paintType, double x, double y, double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$addPaintRectCommand_u24lambda_u2d8 = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$addPaintRectCommand_u24lambda_u2d8.paintRect(paintType, x, y, width, height);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.addPaintRectCommand(AwtPaintType.FILL, x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Composite c = this.getComposite();
        Paint p = this.getPaint();
        AlphaComposite alphaComposite = AlphaComposite.Src;
        Intrinsics.checkNotNullExpressionValue((Object)alphaComposite, (String)"Src");
        this.setComposite(alphaComposite);
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(p);
        this.setComposite(c);
    }

    private final void paintRoundRect(AwtPaintType paintType, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (width <= 0 || height <= 0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$paintRoundRect_u24lambda_u2d9 = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintRoundRect_u24lambda_u2d9.paintRoundRect(paintType, x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.paintRoundRect(AwtPaintType.DRAW, x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.paintRoundRect(AwtPaintType.FILL, x, y, width, height, arcWidth, arcHeight);
    }

    private final void paintOval(AwtPaintType paintType, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$paintOval_u24lambda_u2d10 = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintOval_u24lambda_u2d10.paintOval(paintType, x, y, width, height);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.paintOval(AwtPaintType.DRAW, x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.paintOval(AwtPaintType.FILL, x, y, width, height);
    }

    private final void paintArc(AwtPaintType paintType, int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (width <= 0 || height <= 0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$paintArc_u24lambda_u2d11 = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintArc_u24lambda_u2d11.paintArc(paintType, x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.paintArc(AwtPaintType.DRAW, x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.paintArc(AwtPaintType.FILL, x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkNotNullParameter((Object)xPoints, (String)"xPoints");
        Intrinsics.checkNotNullParameter((Object)yPoints, (String)"yPoints");
        if (nPoints <= 0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$drawPolyline_u24lambda_u2d12 = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$drawPolyline_u24lambda_u2d12.drawPolyline(CollectionsKt.zip((Iterable)ArraysKt.take((int[])xPoints, (int)nPoints), (Iterable)ArraysKt.take((int[])yPoints, (int)nPoints)));
    }

    private final void paintPolygon(AwtPaintType paintType, int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints <= 0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$paintPolygon_u24lambda_u2d13 = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintPolygon_u24lambda_u2d13.paintPolygon(paintType, CollectionsKt.zip((Iterable)ArraysKt.take((int[])xPoints, (int)nPoints), (Iterable)ArraysKt.take((int[])yPoints, (int)nPoints)));
    }

    @Override
    public void drawPolygon(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkNotNullParameter((Object)xPoints, (String)"xPoints");
        Intrinsics.checkNotNullParameter((Object)yPoints, (String)"yPoints");
        this.paintPolygon(AwtPaintType.DRAW, xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkNotNullParameter((Object)xPoints, (String)"xPoints");
        Intrinsics.checkNotNullParameter((Object)yPoints, (String)"yPoints");
        this.paintPolygon(AwtPaintType.FILL, xPoints, yPoints, nPoints);
    }

    @Override
    public boolean drawImage(@Nullable Image img, @NotNull AffineTransform xform, @Nullable ImageObserver obs) {
        Intrinsics.checkNotNullParameter((Object)xform, (String)"xform");
        AwtImageInfo.Transformation info = new AwtImageInfo.Transformation(AffineTransformUrilKt.toList(xform));
        return this.extractImage(img, info, "drawImage(img, xform, obs)");
    }

    @Override
    public void drawImage(@Nullable BufferedImage img, @NotNull BufferedImageOp op, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (img == null) {
            return;
        }
        this.drawImage(op.filter(img, null), new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)x, (double)y), null);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, @Nullable ImageObserver observer) {
        return this.drawImage(img, x, y, null, observer);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, @Nullable Color bgcolor, @Nullable ImageObserver observer) {
        Color color = bgcolor;
        AwtImageInfo.Point info = new AwtImageInfo.Point(x, y, color == null ? null : Integer.valueOf(color.getRGB()));
        return this.extractImage(img, info, "drawImage(img, x, y, bgcolor, observer)");
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, int width, int height, @Nullable ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, null, observer);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, int width, int height, @Nullable Color bgcolor, @Nullable ImageObserver observer) {
        Color color = bgcolor;
        AwtImageInfo.Rectangle info = new AwtImageInfo.Rectangle(x, y, width, height, color == null ? null : Integer.valueOf(color.getRGB()));
        return this.extractImage(img, info, "drawImage(img, x, y, w, h, bgcolor, observer)");
    }

    @Override
    public boolean drawImage(@Nullable Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @Nullable ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @Nullable Color bgcolor, @Nullable ImageObserver observer) {
        Color color = bgcolor;
        AwtImageInfo.Area info = new AwtImageInfo.Area(dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, color == null ? null : Integer.valueOf(color.getRGB()));
        return this.extractImage(img, info, "drawImage(img, d..., s..., bgcolor, observer)");
    }

    private final boolean extractImage(Image img, AwtImageInfo awtImageInfo, String methodName) {
        if (img == null) {
            return true;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintArea = false;
        DrawEventQueue.CommandBuilder $this$extractImage_u24lambda_u2d14 = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$extractImage_u24lambda_u2d14.drawImage(ImageCacher.Companion.getInstance().getImageId(img, methodName), awtImageInfo);
        return true;
    }

    @Override
    public void dispose() {
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(PGraphics2D.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
        RenderingHints renderingHints = defaultRenderingHints = new SunGraphics2D(NullSurfaceData.theInstance, Color.BLACK, Color.WHITE, (Font)ArraysKt.first((Object[])PFontManager.INSTANCE.getAllInstalledFonts())).getRenderingHints();
        Intrinsics.checkNotNullExpressionValue((Object)renderingHints, (String)"defaultRenderingHints");
        defaultAa = PGraphics2D.Companion.extractTextAntiAliasingHint(renderingHints);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\n \b*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\n \b*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u001c\u0010\u0012\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/projector/awt/image/PGraphics2D$Companion;", "", "()V", "defaultAa", "getDefaultAa", "()Ljava/lang/Object;", "defaultRenderingHints", "Ljava/awt/RenderingHints;", "kotlin.jvm.PlatformType", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "withoutTranslation", "Ljava/awt/geom/AffineTransform;", "getWithoutTranslation", "(Ljava/awt/geom/AffineTransform;)Ljava/awt/geom/AffineTransform;", "extractFractionalMetricsHint", "hints", "extractTextAntiAliasingHint", "makeHints", "", "Ljava/awt/RenderingHints$Key;", "projector-awt"})
    public static final class Companion {
        private Companion() {
        }

        private final Object extractTextAntiAliasingHint(RenderingHints hints) {
            Object object;
            Object object2 = hints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            return object2 == null ? ((object = UIManager.getDefaults().get(RenderingHints.KEY_TEXT_ANTIALIASING)) == null ? RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT : object) : object2;
        }

        private final Object extractFractionalMetricsHint(RenderingHints hints) {
            Object object;
            Object object2 = hints.get(RenderingHints.KEY_FRACTIONALMETRICS);
            return object2 == null ? ((object = UIManager.getDefaults().get(RenderingHints.KEY_FRACTIONALMETRICS)) == null ? RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT : object) : object2;
        }

        private final AffineTransform getWithoutTranslation(AffineTransform $this$withoutTranslation) {
            AffineTransform affineTransform = new AffineTransform($this$withoutTranslation);
            boolean bl = false;
            boolean bl2 = false;
            AffineTransform $this$_get_withoutTranslation__u24lambda_u2d0 = affineTransform;
            boolean bl3 = false;
            $this$_get_withoutTranslation__u24lambda_u2d0.setTransform($this$_get_withoutTranslation__u24lambda_u2d0.getScaleX(), $this$_get_withoutTranslation__u24lambda_u2d0.getShearY(), $this$_get_withoutTranslation__u24lambda_u2d0.getShearX(), $this$_get_withoutTranslation__u24lambda_u2d0.getScaleY(), 0.0, 0.0);
            return affineTransform;
        }

        @Nullable
        public final Object getDefaultAa() {
            return defaultAa;
        }

        private final RenderingHints makeHints(Map<RenderingHints.Key, ?> hints) {
            RenderingHints renderingHints = new RenderingHints(null);
            boolean bl = false;
            boolean bl2 = false;
            RenderingHints $this$makeHints_u24lambda_u2d2 = renderingHints;
            boolean bl3 = false;
            $this$makeHints_u24lambda_u2d2.add(defaultRenderingHints);
            Map<RenderingHints.Key, ?> map = hints;
            if (map != null) {
                Map<RenderingHints.Key, ?> map2 = map;
                boolean bl4 = false;
                boolean bl5 = false;
                Map<RenderingHints.Key, ?> it = map2;
                boolean bl6 = false;
                $this$makeHints_u24lambda_u2d2.putAll(it);
            }
            return renderingHints;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

