/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.SharedIndexAuthHolder;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.impl.SharedIndexesFusCollector;
import com.intellij.indexing.shared.util.DownloadUtilKt;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.diagnostic.SharedIndexDiagnostic;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a$\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "toSpeedKBytesPerSecond", "", "size", "durationNano", "tryExtractMetadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "targetFile", "Ljava/nio/file/Path;", "downloadChunk", "", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared"})
public final class SharedIndexLookupResultKt {
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final boolean downloadChunk(@NotNull SharedIndexLookupResult $this$downloadChunk, @NotNull Path targetFile, @Nullable Project project, @NotNull ProgressIndicator indicator) {
        SharedIndexMetadata metadata;
        SharedIndexLookupResult downloadResult;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$downloadChunk, (String)"$this$downloadChunk");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String string = SharedIndexesBundle.message("downloading.shared.indexes", $this$downloadChunk.getRequest().getPresentableChunkName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SharedIndexesBundle.mess\u2026est.presentableChunkName)");
        String message = string;
        if (indicator instanceof SubTaskProgressIndicator) {
            ((SubTaskProgressIndicator)indicator).setText(message);
        } else {
            indicator.setText(message);
            indicator.setText2((String)null);
        }
        SharedIndexesFusCollector.INSTANCE.reportIndexDownloadStarted(project, $this$downloadChunk.getRequest().getKind(), $this$downloadChunk.getChunkUniqueId());
        boolean $i$f$service = false;
        Class<SharedIndexAuthHolder> serviceClass$iv = SharedIndexAuthHolder.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        Map<String, String> headers = ((SharedIndexAuthHolder)object2).resolveHeaders($this$downloadChunk.getUrl(), $this$downloadChunk.getRequest(), indicator);
        AtomicLong downloadTime = new AtomicLong(System.nanoTime());
        SharedIndexLookupResult sharedIndexLookupResult = $this$downloadChunk;
        boolean bl = false;
        try {
            Object object3;
            object = Result.Companion;
            SharedIndexLookupResult $this$runCatching = sharedIndexLookupResult;
            boolean bl2 = false;
            try {
                Long l;
                block29: {
                    void request$iv;
                    void LOG$iv;
                    object3 = LOG;
                    SharedIndexLookupRequest sharedIndexLookupRequest = $this$runCatching.getRequest();
                    String url$iv = $this$runCatching.getUrl();
                    boolean $i$f$handleHttpDownloadExceptions = false;
                    try {
                        boolean bl3 = false;
                        l = DownloadUtilKt.downloadUrlWithValidation($this$runCatching.getUrl(), targetFile, $this$runCatching.getSize(), $this$runCatching.getSha256(), headers, $this$runCatching.getCompression(), indicator);
                        break block29;
                    }
                    catch (ConnectException e$iv) {
                        LOG$iv.debug("Cannot connect to the host for " + url$iv + " for " + request$iv + ". " + e$iv.getMessage(), (Throwable)e$iv);
                    }
                    catch (UnknownHostException e$iv) {
                        LOG$iv.debug("Cannot resolve host for " + url$iv + " for " + request$iv + ". " + e$iv.getMessage(), (Throwable)e$iv);
                    }
                    catch (SocketTimeoutException e$iv) {
                        if (LOG$iv.isDebugEnabled()) {
                            LOG$iv.warn("Connection expired by timeout at " + url$iv + " for " + request$iv + ". Error: " + e$iv.getMessage() + '.', (Throwable)e$iv);
                        } else {
                            LOG$iv.warn("Connection expired by timeout at " + url$iv + " for " + request$iv + ". Error: " + e$iv.getMessage() + '.');
                        }
                    }
                    catch (HttpRequests.HttpStatusException e$iv) {
                        if (e$iv.getStatusCode() < 500) {
                            LOG$iv.debug("No data available for " + url$iv + " for " + request$iv + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                        } else {
                            LOG$iv.info("No data available for " + url$iv + " for " + request$iv + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                        }
                    }
                    catch (IOException e$iv) {
                        if (LOG$iv.isDebugEnabled()) {
                            StringBuilder stringBuilder = new StringBuilder().append("Failed to download ").append(url$iv).append(" for ").append(request$iv).append(". Error: ");
                            String string2 = e$iv.getMessage();
                            if (string2 == null) {
                                Throwable throwable = e$iv.getCause();
                                string2 = throwable != null ? throwable.getMessage() : null;
                            }
                            LOG$iv.warn(stringBuilder.append(string2 != null ? (Serializable)((Object)string2) : (Serializable)e$iv.getClass()).toString(), (Throwable)e$iv);
                        } else {
                            StringBuilder stringBuilder = new StringBuilder().append("Failed to download ").append(url$iv).append(" for ").append(request$iv).append(". Error: ");
                            String string3 = e$iv.getMessage();
                            if (string3 == null) {
                                Throwable throwable = e$iv.getCause();
                                string3 = throwable != null ? throwable.getMessage() : null;
                            }
                            LOG$iv.warn(stringBuilder.append(string3 != null ? (Serializable)((Object)string3) : (Serializable)e$iv.getClass()).toString());
                        }
                    }
                    catch (Throwable t$iv) {
                        if (t$iv instanceof ControlFlowException) {
                            throw t$iv;
                        }
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to download ").append(url$iv).append(" due ").append(t$iv.getClass()).append(" for ").append(request$iv).append(". Error: ");
                        String string4 = t$iv.getMessage();
                        if (string4 == null) {
                            Throwable throwable = t$iv.getCause();
                            string4 = throwable != null ? throwable.getMessage() : null;
                        }
                        LOG$iv.warn(stringBuilder.append(string4 != null ? (Serializable)((Object)string4) : (Serializable)t$iv.getClass()).toString());
                    }
                    l = null;
                }
                object3 = l;
            }
            finally {
                downloadTime.set(System.nanoTime() - downloadTime.get());
            }
            $this$runCatching = object3;
            bl2 = false;
            object = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        sharedIndexLookupResult = object;
        bl = false;
        boolean bl5 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)sharedIndexLookupResult);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean $this$runCatching = false;
            boolean bl2 = false;
            Throwable throwable3 = throwable2;
            boolean bl6 = false;
            Throwable it = throwable3;
            boolean bl7 = false;
            if (it instanceof ControlFlowException) {
                LOG.info("Shared index download interrupted because of " + it.getClass().getName());
                throw it;
            }
            LOG.error(it);
        }
        SharedIndexLookupResult sharedIndexLookupResult2 = downloadResult = sharedIndexLookupResult;
        boolean bl8 = false;
        Long sharedIndexSize = (Long)((Object)(Result.isFailure-impl((Object)sharedIndexLookupResult2) ? null : sharedIndexLookupResult2));
        SharedIndexesFusCollector.FinishType finishType2 = Result.isFailure-impl((Object)downloadResult) && Result.exceptionOrNull-impl((Object)downloadResult) instanceof ControlFlowException ? SharedIndexesFusCollector.FinishType.CANCELLED : (Result.isFailure-impl((Object)downloadResult) ? SharedIndexesFusCollector.FinishType.ERROR : (sharedIndexSize == null || sharedIndexSize <= 0L ? SharedIndexesFusCollector.FinishType.ERROR : SharedIndexesFusCollector.FinishType.SUCCESS));
        Long l = sharedIndexSize;
        SharedIndexesFusCollector.INSTANCE.reportIndexDownloadFinished(project, finishType2, $this$downloadChunk.getRequest().getKind(), $this$downloadChunk.getChunkUniqueId(), TimeUnit.NANOSECONDS.toMillis(downloadTime.get()), $this$downloadChunk.getSize(), l != null ? l : 0L, SharedIndexLookupResultKt.toSpeedKBytesPerSecond($this$downloadChunk.getSize(), downloadTime.get()));
        SharedIndexMetadata sharedIndexMetadata = metadata = SharedIndexLookupResultKt.tryExtractMetadata(targetFile);
        ZonedDateTime generationStamp = sharedIndexMetadata != null ? sharedIndexMetadata.getGenerationTime() : null;
        Object object4 = metadata;
        if (object4 == null || (object4 = ((SharedIndexMetadata)object4).getIndexKind()) == null) {
            object4 = $this$downloadChunk.getRequest().getKind();
        }
        Object kind2 = object4;
        String string5 = $this$downloadChunk.getChunkUniqueId();
        String string6 = finishType2.name();
        boolean bl9 = false;
        String string7 = string6;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
        Long l2 = sharedIndexSize;
        SharedIndexDiagnostic.INSTANCE.onIndexDownloaded(project, (String)kind2, string5, string8, downloadTime.get(), $this$downloadChunk.getSize(), l2 != null ? l2 : 0L, generationStamp);
        return finishType2 == SharedIndexesFusCollector.FinishType.SUCCESS && sharedIndexSize != null && sharedIndexSize > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SharedIndexMetadata tryExtractMetadata(Path targetFile) {
        Object object;
        boolean bl = false;
        try {
            SharedIndexMetadata sharedIndexMetadata;
            object = Result.Companion;
            boolean bl2 = false;
            Closeable closeable = UncompressedZipFileSystem.create(targetFile);
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                UncompressedZipFileSystem it = (UncompressedZipFileSystem)closeable;
                boolean bl5 = false;
                UncompressedZipFileSystem uncompressedZipFileSystem = it;
                Intrinsics.checkNotNullExpressionValue((Object)uncompressedZipFileSystem, (String)"it");
                Path path = uncompressedZipFileSystem.getRootDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.rootDirectory");
                sharedIndexMetadata = SharedIndexMetadata.Companion.readSharedIndexMetadata(path);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            SharedIndexMetadata sharedIndexMetadata2 = sharedIndexMetadata;
            boolean bl6 = false;
            object = Result.constructor-impl((Object)sharedIndexMetadata2);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl7 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Result.Companion companion = object;
        boolean bl8 = false;
        return (SharedIndexMetadata)(Result.isFailure-impl((Object)companion) ? null : companion);
    }

    private static final long toSpeedKBytesPerSecond(long size, long durationNano) {
        long millis = TimeUnit.NANOSECONDS.toMillis(durationNano);
        if (millis == 0L) {
            return 0L;
        }
        double kbPerMs = (double)(size / (long)1024) / (double)millis;
        return (long)(kbPerMs * (double)1000);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexLookupResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

