/*
 * Decompiled with CFR 0.152.
 */
package org.toml.ide.annotator;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.toml.ide.annotator.AnnotatorBase;
import org.toml.ide.colors.TomlColor;
import org.toml.lang.psi.TomlElementTypes;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/toml/ide/annotator/TomlHighlightingAnnotator;", "Lorg/toml/ide/annotator/AnnotatorBase;", "()V", "annotateInternal", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.toml.core"})
public final class TomlHighlightingAnnotator
extends AnnotatorBase {
    @Override
    protected void annotateInternal(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        TomlColor tomlColor;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder.isBatchMode()) {
            return;
        }
        ASTNode aSTNode = element.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
        IElementType iElementType = aSTNode.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)TomlElementTypes.NUMBER)) {
            tomlColor = TomlColor.NUMBER;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)TomlElementTypes.DATE_TIME)) {
            tomlColor = TomlColor.DATE;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)TomlElementTypes.BARE_KEY)) {
            tomlColor = TomlColor.KEY;
        } else {
            return;
        }
        TomlColor color = tomlColor;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        HighlightSeverity severity = application.isUnitTestMode() ? color.getTestSeverity() : HighlightSeverity.INFORMATION;
        holder.newSilentAnnotation(severity).textAttributes(color.getTextAttributesKey()).create();
    }
}

