/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessService;
import com.intellij.execution.process.ProcessTreeKiller;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessTerminator;
import com.intellij.execution.process.WinRunnerMediator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillableProcessHandler
extends OSProcessHandler
implements KillableProcess {
    private static final Logger LOG = Logger.getInstance(KillableProcessHandler.class);
    private boolean myShouldKillProcessSoftly;
    private final boolean myMediatedProcess;
    private boolean myShouldKillProcessSoftlyWithWinP;

    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(0);
        }
        super(commandLine);
        this.myShouldKillProcessSoftly = true;
        this.myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is("use.winp.for.graceful.process.termination");
        this.myMediatedProcess = WinRunnerMediator.isRunnerCommandInjected(commandLine);
    }

    protected KillableProcessHandler(@NotNull Process process2, @NotNull GeneralCommandLine commandLine) {
        if (process2 == null) {
            KillableProcessHandler.$$$reportNull$$$0(1);
        }
        if (commandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(2);
        }
        super(process2, commandLine.getCommandLineString(), commandLine.getCharset());
        this.myShouldKillProcessSoftly = true;
        this.myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is("use.winp.for.graceful.process.termination");
        this.myMediatedProcess = WinRunnerMediator.isRunnerCommandInjected(commandLine);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
        if (commandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(3);
        }
        this(KillableProcessHandler.mediate(commandLine, withMediator, false));
    }

    public KillableProcessHandler(@NotNull Process process2, String commandLine) {
        if (process2 == null) {
            KillableProcessHandler.$$$reportNull$$$0(4);
        }
        super(process2, commandLine);
        this.myShouldKillProcessSoftly = true;
        this.myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is("use.winp.for.graceful.process.termination");
        this.myMediatedProcess = false;
    }

    public KillableProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset) {
        if (process2 == null) {
            KillableProcessHandler.$$$reportNull$$$0(5);
        }
        if (charset == null) {
            KillableProcessHandler.$$$reportNull$$$0(6);
        }
        this(process2, commandLine, charset, null);
    }

    public KillableProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset, @Nullable Set<File> filesToDelete) {
        if (process2 == null) {
            KillableProcessHandler.$$$reportNull$$$0(7);
        }
        if (charset == null) {
            KillableProcessHandler.$$$reportNull$$$0(8);
        }
        super(process2, commandLine, charset, filesToDelete);
        this.myShouldKillProcessSoftly = true;
        this.myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is("use.winp.for.graceful.process.termination");
        this.myMediatedProcess = false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @NotNull
    protected static GeneralCommandLine mediate(@NotNull GeneralCommandLine commandLine, boolean withMediator, boolean showConsole) {
        if (commandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(9);
        }
        if (withMediator && SystemInfo.isWindows) {
            WinRunnerMediator.injectRunnerCommand(commandLine, showConsole);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(10);
        }
        return generalCommandLine;
    }

    public boolean shouldKillProcessSoftly() {
        return this.myShouldKillProcessSoftly;
    }

    public void setShouldKillProcessSoftly(boolean shouldKillProcessSoftly) {
        this.myShouldKillProcessSoftly = shouldKillProcessSoftly;
    }

    private boolean canDestroyProcessGracefully() {
        if (KillableProcessHandler.processCanBeKilledByOS(this.myProcess)) {
            if (SystemInfo.isWindows) {
                return this.hasPty() || this.myMediatedProcess || this.canTerminateGracefullyWithWinP();
            }
            if (SystemInfo.isUnix) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void destroyProcessImpl() {
        try {
            this.myProcess.getOutputStream().flush();
        }
        catch (IOException e) {
            LOG.warn(e);
        }
        finally {
            this.doDestroyProcess();
        }
    }

    @Override
    protected void notifyProcessTerminated(int exitCode) {
        try {
            super.closeStreams();
        }
        finally {
            super.notifyProcessTerminated(exitCode);
        }
    }

    @Override
    protected void doDestroyProcess() {
        boolean gracefulTerminationAttempted;
        boolean bl = gracefulTerminationAttempted = this.shouldKillProcessSoftly() && this.canDestroyProcessGracefully() && this.destroyProcessGracefully();
        if (!gracefulTerminationAttempted) {
            super.doDestroyProcess();
        }
    }

    @Deprecated
    @ApiStatus.Experimental
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public void setShouldKillProcessSoftlyWithWinP(boolean shouldKillProcessSoftlyWithWinP) {
        this.myShouldKillProcessSoftlyWithWinP = shouldKillProcessSoftlyWithWinP;
    }

    private boolean canTerminateGracefullyWithWinP() {
        return this.myShouldKillProcessSoftlyWithWinP && SystemInfo.isWin10OrNewer && !this.isWslProcess();
    }

    private boolean isWslProcess() {
        boolean wsl;
        List<String> command = KillableProcessHandler.getProcessService().getCommand(this.myProcess);
        String executable = ContainerUtil.getFirstItem(command);
        boolean bl = wsl = executable != null && PathUtil.getFileName((String)executable).equals("wsl.exe");
        if (wsl) {
            LOG.info("WinP graceful termination does not work for WSL process: " + command);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("[graceful termination with WinP] WSL process: " + wsl + ", process: " + this.myProcess.getClass() + ", command: " + command);
        }
        return wsl;
    }

    protected boolean destroyProcessGracefully() {
        if (this.hasPty() && this.sendInterruptToPtyProcess()) {
            return true;
        }
        if (SystemInfo.isWindows) {
            if (this.myMediatedProcess) {
                return WinRunnerMediator.destroyProcess(this.myProcess, true);
            }
            if (this.canTerminateGracefullyWithWinP() && !Registry.is("disable.winp")) {
                try {
                    if (!this.myProcess.isAlive()) {
                        OSProcessUtil.logSkippedActionWithTerminatedProcess(this.myProcess, "destroy", this.getCommandLine());
                        return true;
                    }
                    return WinProcessTerminator.terminateWinProcessGracefully(this, KillableProcessHandler.getProcessService());
                }
                catch (Throwable e) {
                    if (!this.myProcess.isAlive()) {
                        OSProcessUtil.logSkippedActionWithTerminatedProcess(this.myProcess, "destroy", this.getCommandLine());
                        return true;
                    }
                    String message = e.getMessage();
                    if (message != null && message.contains(".exe terminated with exit code 6,")) {
                        String msg = "Cannot send Ctrl+C to process without a console (fallback to default termination)";
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(msg + " " + this.getCommandLine());
                        }
                        LOG.info(msg);
                    }
                    LOG.error("Cannot send Ctrl+C (fallback to default termination) " + this.getCommandLine(), e);
                }
            }
        } else if (SystemInfo.isUnix) {
            if (this.shouldDestroyProcessRecursively()) {
                return UnixProcessManager.sendSigIntToProcessTree(this.myProcess);
            }
            return UnixProcessManager.sendSignal(UnixProcessManager.getProcessId(this.myProcess), 2) == 0;
        }
        return false;
    }

    @NotNull
    private static ProcessService getProcessService() {
        ProcessService processService = (ProcessService)ProgressManager.getInstance().computeInNonCancelableSection(() -> ProcessService.getInstance());
        if (processService == null) {
            KillableProcessHandler.$$$reportNull$$$0(11);
        }
        return processService;
    }

    private boolean sendInterruptToPtyProcess() {
        if (!KillableProcessHandler.getProcessService().hasControllingTerminal(this.myProcess)) {
            return false;
        }
        OutputStream outputStream = this.myProcess.getOutputStream();
        if (outputStream != null) {
            try {
                outputStream.write(3);
                outputStream.flush();
                return true;
            }
            catch (IOException e) {
                LOG.info("Failed to send Ctrl+C to PTY process. Fallback to default graceful termination.", e);
            }
        }
        return false;
    }

    @Override
    public boolean canKillProcess() {
        return KillableProcessHandler.processCanBeKilledByOS(this.getProcess()) || this.getProcess() instanceof ProcessTreeKiller;
    }

    @Override
    public void killProcess() {
        if (KillableProcessHandler.processCanBeKilledByOS(this.getProcess())) {
            this.killProcessTree((Process)this.getProcess());
        } else if (this.getProcess() instanceof ProcessTreeKiller) {
            ((ProcessTreeKiller)this.getProcess()).killProcessTree();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/KillableProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/KillableProcessHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "mediate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mediate";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

