/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessService;
import com.intellij.execution.process.WinProcessTerminator;
import com.intellij.openapi.util.Key;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a(\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0001\u00a8\u0006\t"}, d2={"isCmdBatchFile", "", "processHandler", "Lcom/intellij/execution/process/KillableProcessHandler;", "processService", "Lcom/intellij/execution/process/ProcessService;", "terminateWinProcessGracefully", "terminateGracefully", "Lkotlin/Function0;", "intellij.platform.ide.util.io"})
@JvmName(name="WinProcessTerminator")
public final class WinProcessTerminator {
    @JvmOverloads
    public static final boolean terminateWinProcessGracefully(@NotNull KillableProcessHandler processHandler, @NotNull ProcessService processService, @NotNull Function0<Boolean> terminateGracefully) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)processService, (String)"processService");
        Intrinsics.checkNotNullParameter(terminateGracefully, (String)"terminateGracefully");
        CompletableFuture stdoutMatched = new CompletableFuture();
        ProcessAdapter processListener2 = new ProcessAdapter(processHandler, stdoutMatched){
            final /* synthetic */ KillableProcessHandler $processHandler;
            final /* synthetic */ CompletableFuture $stdoutMatched;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (ProcessOutputType.isStdout(outputType)) {
                    String string2 = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.text");
                    if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"?", (boolean)false, (int)2, null)) {
                        this.$processHandler.removeProcessListener(this);
                        this.$stdoutMatched.complete(null);
                    }
                }
            }
            {
                this.$processHandler = $captured_local_variable$0;
                this.$stdoutMatched = $captured_local_variable$1;
            }
        };
        processHandler.addProcessListener(processListener2);
        Object object = terminateGracefully.invoke();
        boolean bl = false;
        boolean bl2 = false;
        boolean it = (Boolean)object;
        boolean bl3 = false;
        if (it) {
            stdoutMatched.whenComplete(new BiConsumer(stdoutMatched, processHandler, processService, processListener2){
                final /* synthetic */ CompletableFuture $stdoutMatched$inlined;
                final /* synthetic */ KillableProcessHandler $processHandler$inlined;
                final /* synthetic */ ProcessService $processService$inlined;
                final /* synthetic */ terminateWinProcessGracefully.processListener.1 $processListener$inlined;
                {
                    this.$stdoutMatched$inlined = completableFuture;
                    this.$processHandler$inlined = killableProcessHandler;
                    this.$processService$inlined = processService;
                    this.$processListener$inlined = var4_4;
                }

                public final void accept(Void $noName_0, Throwable $noName_1) {
                    if (WinProcessTerminator.access$isCmdBatchFile(this.$processHandler$inlined, this.$processService$inlined)) {
                        T t = this.$processHandler$inlined.getProcess();
                        Intrinsics.checkNotNullExpressionValue(t, (String)"processHandler.process");
                        if (((Process)t).isAlive()) {
                            ((Process)this.$processHandler$inlined.getProcess()).destroy();
                        }
                    }
                }
            });
        } else {
            processHandler.removeProcessListener(processListener2);
        }
        return (Boolean)object;
    }

    public static /* synthetic */ boolean terminateWinProcessGracefully$default(KillableProcessHandler killableProcessHandler, ProcessService processService, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = (Function0)new Function0<Boolean>(processService, killableProcessHandler){
                final /* synthetic */ ProcessService $processService;
                final /* synthetic */ KillableProcessHandler $processHandler;

                public final boolean invoke() {
                    return this.$processService.sendWinProcessCtrlC((Process)this.$processHandler.getProcess());
                }
                {
                    this.$processService = processService;
                    this.$processHandler = killableProcessHandler;
                    super(0);
                }
            };
        }
        return WinProcessTerminator.terminateWinProcessGracefully(killableProcessHandler, processService, (Function0<Boolean>)function0);
    }

    @JvmOverloads
    public static final boolean terminateWinProcessGracefully(@NotNull KillableProcessHandler processHandler, @NotNull ProcessService processService) {
        return WinProcessTerminator.terminateWinProcessGracefully$default(processHandler, processService, null, 4, null);
    }

    private static final boolean isCmdBatchFile(KillableProcessHandler processHandler, ProcessService processService) {
        List<String> list = processService.getCommand((Process)processHandler.getProcess());
        Intrinsics.checkNotNullExpressionValue(list, (String)"processService.getCommand(processHandler.process)");
        Object object = CollectionsKt.firstOrNull(list);
        boolean bl = false;
        boolean bl2 = false;
        String it = (String)object;
        boolean bl3 = false;
        return it != null && (StringsKt.endsWith$default((String)it, (String)".bat", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)".cmd", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"\\cmd.exe", (boolean)false, (int)2, null));
    }

    public static final /* synthetic */ boolean access$isCmdBatchFile(KillableProcessHandler processHandler, ProcessService processService) {
        return WinProcessTerminator.isCmdBatchFile(processHandler, processService);
    }
}

