/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class UiInterceptors {
    private static final Queue<UiInterceptor<?>> ourInterceptors = new ConcurrentLinkedQueue();
    private static final Set<PersistentUiInterceptor<?>> ourPersistentInterceptors = ConcurrentHashMap.newKeySet();

    public static boolean tryIntercept(@NotNull Object uiComponent) {
        if (uiComponent == null) {
            UiInterceptors.$$$reportNull$$$0(0);
        }
        return UiInterceptors.tryIntercept(uiComponent, null);
    }

    public static boolean tryIntercept(@NotNull Object uiComponent, @Nullable RelativePoint relativePoint) {
        UiInterceptor<?> interceptor;
        if (uiComponent == null) {
            UiInterceptors.$$$reportNull$$$0(1);
        }
        if ((interceptor = ourInterceptors.poll()) != null) {
            interceptor.intercept(uiComponent);
            return true;
        }
        PersistentUiInterceptor persistentUiInterceptor = (PersistentUiInterceptor)((Object)ContainerUtil.find(ourPersistentInterceptors, s -> s.isApplicable(uiComponent, relativePoint)));
        if (persistentUiInterceptor != null) {
            persistentUiInterceptor.intercept(uiComponent, relativePoint);
            return true;
        }
        return false;
    }

    @TestOnly
    public static void register(@NotNull UiInterceptor<?> interceptor) {
        if (interceptor == null) {
            UiInterceptors.$$$reportNull$$$0(2);
        }
        ourInterceptors.offer(interceptor);
    }

    public static void registerPersistent(@NotNull Disposable parent, @NotNull PersistentUiInterceptor<?> interceptor) {
        if (parent == null) {
            UiInterceptors.$$$reportNull$$$0(3);
        }
        if (interceptor == null) {
            UiInterceptors.$$$reportNull$$$0(4);
        }
        ContainerUtil.add(interceptor, ourPersistentInterceptors, parent);
    }

    @TestOnly
    public static void clear() {
        ArrayList interceptors = new ArrayList(ourInterceptors);
        ourInterceptors.clear();
        if (!interceptors.isEmpty()) {
            throw new IllegalStateException("Expected UI was not shown: " + interceptors);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiComponent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interceptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/UiInterceptors";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryIntercept";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerPersistent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class PersistentUiInterceptor<T>
    extends UiInterceptor<T> {
        protected PersistentUiInterceptor(@NotNull Class<T> componentClass) {
            if (componentClass == null) {
                PersistentUiInterceptor.$$$reportNull$$$0(0);
            }
            super(componentClass);
        }

        public final boolean isApplicable(@NotNull Object component) {
            if (component == null) {
                PersistentUiInterceptor.$$$reportNull$$$0(1);
            }
            return this.isApplicable(component, null);
        }

        public final boolean isApplicable(@NotNull Object component, @Nullable RelativePoint relativePoint) {
            if (component == null) {
                PersistentUiInterceptor.$$$reportNull$$$0(2);
            }
            if (!this.myClass.isInstance(component)) {
                return false;
            }
            return this.shouldIntercept(component, relativePoint);
        }

        public final void intercept(@NotNull Object component, @Nullable RelativePoint relativePoint) {
            if (component == null) {
                PersistentUiInterceptor.$$$reportNull$$$0(3);
            }
            if (!this.isApplicable(component)) {
                return;
            }
            this.doIntercept(this.myClass.cast(component), relativePoint);
        }

        @Override
        public final void doIntercept(@NotNull T component) {
            if (component == null) {
                PersistentUiInterceptor.$$$reportNull$$$0(4);
            }
            this.intercept(component, null);
        }

        protected abstract void doIntercept(@NotNull T var1, @Nullable RelativePoint var2);

        public abstract boolean shouldIntercept(@NotNull T var1);

        public boolean shouldIntercept(@NotNull T component, @Nullable RelativePoint relativePoint) {
            if (component == null) {
                PersistentUiInterceptor.$$$reportNull$$$0(5);
            }
            return this.shouldIntercept(component);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentClass";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/UiInterceptors$PersistentUiInterceptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "intercept";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doIntercept";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldIntercept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class UiInterceptor<T> {
        @NotNull
        protected final Class<T> myClass;

        protected UiInterceptor(@NotNull Class<T> componentClass) {
            if (componentClass == null) {
                UiInterceptor.$$$reportNull$$$0(0);
            }
            this.myClass = componentClass;
        }

        public final void intercept(@NotNull Object component) {
            if (component == null) {
                UiInterceptor.$$$reportNull$$$0(1);
            }
            if (!this.myClass.isInstance(component)) {
                throw new IllegalStateException("Unexpected UI component appears: wanted " + this.myClass.getName() + "; got: " + component.getClass().getName() + " (" + component + ")");
            }
            this.doIntercept(this.myClass.cast(component));
        }

        protected abstract void doIntercept(@NotNull T var1);

        public String toString() {
            return this.myClass.getName() + " (interceptor: " + this.getClass().getName() + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/UiInterceptors$UiInterceptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "intercept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

