/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.svg.SvgTranscoder;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a@\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u001a\r\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0002\u001a(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"identityTransform", "Ljava/awt/geom/AffineTransform;", "supportedFeatures", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "computeTransform", "document", "Lorg/apache/batik/anim/dom/SVGOMDocument;", "gvtRoot", "Lorg/apache/batik/gvt/GraphicsNode;", "context", "Lorg/apache/batik/bridge/BridgeContext;", "docWidth", "", "docHeight", "width", "height", "getStandardBolderFontWeight", "f", "getStandardLighterFontWeight", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "render", "Ljava/awt/image/BufferedImage;", "offScreenWidth", "", "offScreenHeight", "usr2dev", "intellij.platform.util.ui"})
public final class SvgTranscoderKt {
    private static final AffineTransform identityTransform = new AffineTransform();
    private static final HashSet<String> supportedFeatures = new HashSet();

    private static final Logger logger() {
        Logger logger = Logger.getInstance(SvgTranscoder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(SvgTranscoder::class.java)");
        return logger;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final AffineTransform computeTransform(SVGOMDocument document, GraphicsNode gvtRoot, BridgeContext context, float docWidth, float docHeight, float width, float height) {
        preserveAspectRatioMatrix = null;
        root = document.getRootElement();
        viewBox = root.getAttributeNS(null, "viewBox");
        if (viewBox == null) ** GOTO lbl-1000
        var10_10 = viewBox;
        var11_13 = false;
        if (var10_10.length() > 0) {
            aspectRatio = root.getAttributeNS(null, "preserveAspectRatio");
            v0 = ViewBox.getPreserveAspectRatioTransform((Element)((Element)root), (String)viewBox, (String)aspectRatio, (float)width, (float)height, (BridgeContext)context);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ViewBox.getPreserveAspec\u2026, width, height, context)");
            preserveAspectRatioMatrix = v0;
        } else lbl-1000:
        // 2 sources

        {
            var11_14 = width / docWidth;
            var12_15 = height / docHeight;
            var13_16 = false;
            scale = Math.min(var11_14, var12_15);
            v1 = AffineTransform.getScaleInstance(scale, scale);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"AffineTransform.getScale\u2026uble(), scale.toDouble())");
            preserveAspectRatioMatrix = v1;
        }
        if (!((v2 = gvtRoot) instanceof CompositeGraphicsNode)) {
            v2 = null;
        }
        if (!(((v3 /* !! */  = (CompositeGraphicsNode)v2) != null && (v3 /* !! */  = v3 /* !! */ .getChildren()) != null ? CollectionsKt.firstOrNull((List)v3 /* !! */ ) : (v4 = null)) instanceof CanvasGraphicsNode)) {
            v4 = null;
        }
        if ((cgn = (CanvasGraphicsNode)v4) == null) {
            return preserveAspectRatioMatrix;
        }
        cgn.setViewingTransform(preserveAspectRatioMatrix);
        return new AffineTransform();
    }

    private static final BufferedImage render(int offScreenWidth, int offScreenHeight, AffineTransform usr2dev, GraphicsNode gvtRoot) {
        BufferedImage image = new BufferedImage(offScreenWidth, offScreenHeight, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, new WeakReference<BufferedImage>(image));
        Graphics2D graphics2D = g;
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"g");
        graphics2D.setTransform(identityTransform);
        g.setClip(0, 0, offScreenWidth, offScreenHeight);
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, offScreenWidth, offScreenHeight);
        g.setComposite(AlphaComposite.SrcOver);
        g.transform(usr2dev);
        gvtRoot.paint(g);
        g.dispose();
        return image;
    }

    private static final float getStandardLighterFontWeight(float f) {
        float f2;
        switch ((int)((f + (float)50) / (float)100) * 100) {
            case 100: 
            case 200: {
                f2 = 100.0f;
                break;
            }
            case 300: {
                f2 = 200.0f;
                break;
            }
            case 400: {
                f2 = 300.0f;
                break;
            }
            case 500: 
            case 600: 
            case 700: 
            case 800: 
            case 900: {
                f2 = 400.0f;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Bad Font Weight: " + f);
            }
        }
        return f2;
    }

    private static final float getStandardBolderFontWeight(float f) {
        float f2;
        switch ((int)((f + (float)50) / (float)100) * 100) {
            case 100: 
            case 200: 
            case 300: 
            case 400: 
            case 500: {
                f2 = 600.0f;
                break;
            }
            case 600: {
                f2 = 700.0f;
                break;
            }
            case 700: {
                f2 = 800.0f;
                break;
            }
            case 800: {
                f2 = 900.0f;
                break;
            }
            case 900: {
                f2 = 900.0f;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Bad Font Weight: " + f);
            }
        }
        return f2;
    }

    public static final /* synthetic */ Logger access$logger() {
        return SvgTranscoderKt.logger();
    }

    public static final /* synthetic */ float access$getStandardLighterFontWeight(float f) {
        return SvgTranscoderKt.getStandardLighterFontWeight(f);
    }

    public static final /* synthetic */ float access$getStandardBolderFontWeight(float f) {
        return SvgTranscoderKt.getStandardBolderFontWeight(f);
    }

    public static final /* synthetic */ HashSet access$getSupportedFeatures$p() {
        return supportedFeatures;
    }

    public static final /* synthetic */ AffineTransform access$computeTransform(SVGOMDocument document, GraphicsNode gvtRoot, BridgeContext context, float docWidth, float docHeight, float width, float height) {
        return SvgTranscoderKt.computeTransform(document, gvtRoot, context, docWidth, docHeight, width, height);
    }

    public static final /* synthetic */ BufferedImage access$render(int offScreenWidth, int offScreenHeight, AffineTransform usr2dev, GraphicsNode gvtRoot) {
        return SvgTranscoderKt.render(offScreenWidth, offScreenHeight, usr2dev, gvtRoot);
    }
}

