/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.Activity;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(EnvironmentUtil.class);
    private static final long DEFAULT_SHELL_ENV_READING_TIMEOUT_MILLIS = 20000L;
    private static final String LANG = "LANG";
    private static final String LC_ALL = "LC_ALL";
    private static final String LC_CTYPE = "LC_CTYPE";
    private static final String DESKTOP_STARTUP_ID = "DESKTOP_STARTUP_ID";
    public static final String BASH_EXECUTABLE_NAME = "bash";
    public static final String SHELL_VARIABLE_NAME = "SHELL";
    private static final String SHELL_INTERACTIVE_ARGUMENT = "-i";
    public static final String SHELL_LOGIN_ARGUMENT = "-l";
    public static final String SHELL_COMMAND_ARGUMENT = "-c";
    public static final String SHELL_SOURCE_COMMAND = "source";
    private static final String SHLVL = "SHLVL";
    private static final AtomicReference<CompletableFuture<Map<String, String>>> ourEnvGetter = new AtomicReference();
    public static final String DISABLE_OMZ_AUTO_UPDATE = "DISABLE_AUTO_UPDATE";
    private static final String INTELLIJ_ENVIRONMENT_READER = "INTELLIJ_ENVIRONMENT_READER";

    private EnvironmentUtil() {
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        Map<String, String> map2;
        CompletableFuture<Map<String, String>> getter = ourEnvGetter.get();
        if (getter == null && !ourEnvGetter.compareAndSet(null, getter = CompletableFuture.completedFuture(EnvironmentUtil.getSystemEnv()))) {
            getter = ourEnvGetter.get();
        }
        try {
            map2 = getter.join();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
        if (map2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(0);
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Nullable
    public static Boolean loadEnvironment(@NotNull Activity activity) {
        if (activity == null) {
            EnvironmentUtil.$$$reportNull$$$0(1);
        }
        if (!EnvironmentUtil.shouldLoadShellEnv()) {
            ourEnvGetter.set(CompletableFuture.completedFuture(EnvironmentUtil.getSystemEnv()));
            return null;
        }
        CompletableFuture<Map<String, String>> envFuture = new CompletableFuture<Map<String, String>>();
        ourEnvGetter.set(envFuture);
        Boolean result = Boolean.TRUE;
        try {
            Map<String, String> env = EnvironmentUtil.getShellEnv();
            EnvironmentUtil.setCharsetVar(env);
            envFuture.complete(Collections.unmodifiableMap(env));
        }
        catch (Throwable t) {
            result = Boolean.FALSE;
            LOG.warn("can't get shell environment", t);
        }
        finally {
            activity.end();
        }
        if (result == Boolean.FALSE) {
            envFuture.complete(EnvironmentUtil.getSystemEnv());
        }
        return result;
    }

    private static boolean shouldLoadShellEnv() {
        if (!SystemInfoRt.isMac) {
            return false;
        }
        if (!Boolean.parseBoolean(System.getProperty("ij.load.shell.env", "true"))) {
            LOG.info("loading shell env is turned off");
            return false;
        }
        String shLvl = System.getenv(SHLVL);
        try {
            if (shLvl != null && Integer.parseInt(shLvl) > 0) {
                LOG.info("loading shell env is skipped: IDE has been launched from a terminal (SHLVL=" + shLvl + ')');
                return false;
            }
        }
        catch (NumberFormatException e) {
            LOG.info("loading shell env is skipped: IDE has been launched with malformed SHLVL=" + shLvl);
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, String> getSystemEnv() {
        if (SystemInfoRt.isWindows) {
            Map<String, String> map2 = Collections.unmodifiableMap(CollectionFactory.createCaseInsensitiveStringMap(System.getenv()));
            if (map2 == null) {
                EnvironmentUtil.$$$reportNull$$$0(2);
            }
            return map2;
        }
        if (SystemInfoRt.isXWindow) {
            Map<String, String> env = System.getenv();
            if (env.containsKey(DESKTOP_STARTUP_ID)) {
                env = new HashMap<String, String>(env);
                env.remove(DESKTOP_STARTUP_ID);
                env = Collections.unmodifiableMap(env);
            }
            Map<String, String> map3 = env;
            if (map3 == null) {
                EnvironmentUtil.$$$reportNull$$$0(3);
            }
            return map3;
        }
        Map<String, String> map4 = System.getenv();
        if (map4 == null) {
            EnvironmentUtil.$$$reportNull$$$0(4);
        }
        return map4;
    }

    @Nullable
    public static String getValue(@NotNull String name) {
        if (name == null) {
            EnvironmentUtil.$$$reportNull$$$0(5);
        }
        return EnvironmentUtil.getEnvironmentMap().get(name);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidName(@Nullable String name) {
        return name != null && !name.isEmpty() && name.indexOf(0) == -1 && name.indexOf(61, SystemInfoRt.isWindows ? 1 : 0) == -1;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidValue(@Nullable String value) {
        return value != null && value.indexOf(0) == -1;
    }

    @NotNull
    private static Map<String, String> getShellEnv() throws IOException {
        Map<String, String> map2 = new ShellEnvReader().readShellEnv(null, null);
        if (map2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @ApiStatus.Experimental
    @NotNull
    public static List<String> buildShellProcessCommand(@NotNull String shellScript, boolean isLogin, boolean isInteractive, boolean isCommand) {
        if (shellScript == null) {
            EnvironmentUtil.$$$reportNull$$$0(7);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(shellScript);
        if (isLogin && !shellScript.endsWith("/tcsh") && !shellScript.endsWith("/csh")) {
            commands.add(SHELL_LOGIN_ARGUMENT);
        }
        if (isInteractive && !shellScript.endsWith("/fish")) {
            commands.add(SHELL_INTERACTIVE_ARGUMENT);
        }
        if (isCommand) {
            commands.add(SHELL_COMMAND_ARGUMENT);
        }
        ArrayList<String> arrayList = commands;
        if (arrayList == null) {
            EnvironmentUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public static Map<String, String> parseEnv(String @NotNull [] lines) {
        if (lines == null) {
            EnvironmentUtil.$$$reportNull$$$0(9);
        }
        HashSet<String> toIgnore = new HashSet<String>(Arrays.asList("_", "PWD", SHLVL, DISABLE_OMZ_AUTO_UPDATE, INTELLIJ_ENVIRONMENT_READER));
        Map<String, String> env = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>();
        for (String line : lines) {
            int pos = line.indexOf(61);
            if (pos <= 0) {
                throw new RuntimeException("malformed:" + line);
            }
            String name = line.substring(0, pos);
            if (!toIgnore.contains(name)) {
                newEnv.put(name, line.substring(pos + 1));
                continue;
            }
            if (!env.containsKey(name)) continue;
            newEnv.put(name, env.get(name));
        }
        LOG.info("shell environment loaded (" + newEnv.size() + " vars)");
        HashMap<String, String> hashMap = newEnv;
        if (hashMap == null) {
            EnvironmentUtil.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, String> parseEnv(@NotNull String text) {
        if (text == null) {
            EnvironmentUtil.$$$reportNull$$$0(11);
        }
        return EnvironmentUtil.parseEnv(text.split("\u0000"));
    }

    private static int waitAndTerminateAfter(@NotNull Process process2, long timeoutMillis) {
        Integer exitCode;
        if (process2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(12);
        }
        if ((exitCode = EnvironmentUtil.waitFor(process2, timeoutMillis)) != null) {
            return exitCode;
        }
        LOG.warn("shell env loader is timed out");
        if (!SystemInfoRt.isWindows) {
            UnixProcessManager.sendSigIntToProcessTree(process2);
            exitCode = EnvironmentUtil.waitFor(process2, 1000L);
            if (exitCode != null) {
                return exitCode;
            }
            LOG.warn("failed to terminate shell env loader process gracefully, terminating forcibly");
        }
        if (SystemInfoRt.isWindows) {
            WinProcessManager.kill(process2, true);
        } else {
            UnixProcessManager.sendSigKillToProcessTree(process2);
        }
        exitCode = EnvironmentUtil.waitFor(process2, 1000L);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("failed to kill shell env loader");
        return -1;
    }

    @Nullable
    private static Integer waitFor(@NotNull Process process2, long timeoutMillis) {
        if (process2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(13);
        }
        try {
            if (process2.waitFor(timeoutMillis, TimeUnit.MILLISECONDS)) {
                return process2.exitValue();
            }
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for process", e);
        }
        return null;
    }

    private static void setCharsetVar(@NotNull Map<String, String> env) {
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(14);
        }
        if (!EnvironmentUtil.isCharsetVarDefined(env)) {
            String value = EnvironmentUtil.setLocaleEnv(env, Charset.defaultCharset());
            LOG.info("LC_CTYPE=" + value);
        }
    }

    private static boolean checkIfLocaleAvailable(String candidateLanguageTerritory) {
        Locale[] available;
        for (Locale l : available = Locale.getAvailableLocales()) {
            if (!Objects.equals(l.toString(), candidateLanguageTerritory)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String setLocaleEnv(@NotNull Map<String, String> env, @NotNull Charset charset) {
        String languageTerritoryFromLocale;
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(15);
        }
        if (charset == null) {
            EnvironmentUtil.$$$reportNull$$$0(16);
        }
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String languageTerritory = "en_US";
        if (!language.isEmpty() && !country.isEmpty() && EnvironmentUtil.checkIfLocaleAvailable(languageTerritoryFromLocale = language + '_' + country)) {
            languageTerritory = languageTerritoryFromLocale;
        }
        String result = languageTerritory + '.' + charset.name();
        env.put(LC_CTYPE, result);
        String string2 = result;
        if (string2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(17);
        }
        return string2;
    }

    private static boolean isCharsetVarDefined(@NotNull Map<String, String> env) {
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(18);
        }
        return !env.isEmpty() && (env.containsKey(LANG) || env.containsKey(LC_ALL) || env.containsKey(LC_CTYPE));
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentUtil.$$$reportNull$$$0(19);
        }
        EnvironmentUtil.inlineParentOccurrences(envs, EnvironmentUtil.getEnvironmentMap());
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs, @NotNull Map<String, String> parentEnv) {
        if (envs == null) {
            EnvironmentUtil.$$$reportNull$$$0(20);
        }
        if (parentEnv == null) {
            EnvironmentUtil.$$$reportNull$$$0(21);
        }
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String parentVal;
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null || (parentVal = parentEnv.get(key)) == null || !EnvironmentUtil.containsEnvKeySubstitution(key, value)) continue;
            envs.put(key, value.replace("$" + key + "$", parentVal));
        }
    }

    public static boolean containsEnvKeySubstitution(String envKey, String val) {
        return ArrayUtil.find(val.split(File.pathSeparator), "$" + envKey + "$") != -1;
    }

    @TestOnly
    static Map<String, String> testLoader() throws IOException {
        return EnvironmentUtil.getShellEnv();
    }

    @TestOnly
    static Map<String, String> testParser(@NotNull String lines) {
        if (lines == null) {
            EnvironmentUtil.$$$reportNull$$$0(22);
        }
        try {
            return EnvironmentUtil.parseEnv(lines);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/EnvironmentUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellScript";
                break;
            }
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentMap";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/EnvironmentUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemEnv";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellEnv";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildShellProcessCommand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEnv";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocaleEnv";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildShellProcessCommand";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseEnv";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "waitAndTerminateAfter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setCharsetVar";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setLocaleEnv";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCharsetVarDefined";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "inlineParentOccurrences";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "testParser";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class StreamGobbler
    extends BaseOutputReader {
        private static final BaseOutputReader.Options OPTIONS = new BaseOutputReader.Options(){

            @Override
            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            @Override
            public boolean splitToLines() {
                return false;
            }
        };
        private final StringBuffer myBuffer;

        StreamGobbler(@NotNull InputStream stream) {
            if (stream == null) {
                StreamGobbler.$$$reportNull$$$0(0);
            }
            super(stream, Charset.defaultCharset(), OPTIONS);
            this.myBuffer = new StringBuffer();
            this.startWithoutChangingThreadName();
        }

        @Override
        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                StreamGobbler.$$$reportNull$$$0(1);
            }
            Future future = ForkJoinPool.commonPool().submit(runnable);
            if (future == null) {
                StreamGobbler.$$$reportNull$$$0(2);
            }
            return future;
        }

        @Override
        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                StreamGobbler.$$$reportNull$$$0(3);
            }
            this.myBuffer.append(text);
        }

        @NotNull
        public String getText() {
            String string2 = this.myBuffer.toString();
            if (string2 == null) {
                StreamGobbler.$$$reportNull$$$0(4);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/EnvironmentUtil$StreamGobbler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/EnvironmentUtil$StreamGobbler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ShellEnvReader {
        private final long myTimeoutMillis;

        public ShellEnvReader() {
            this(20000L);
        }

        public ShellEnvReader(long timeoutMillis) {
            this.myTimeoutMillis = timeoutMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Map<String, String> readShellEnv(@Nullable Path file2, @Nullable Map<String, String> additionalEnvironment) throws IOException {
            String loader = SystemInfoRt.isMac ? "printenv" : "printenv.py";
            Path reader = PathManager.findBinFileWithException(loader);
            Path envFile = Files.createTempFile("intellij-shell-env.", ".tmp", new FileAttribute[0]);
            StringBuilder readerCmd = new StringBuilder();
            if (file2 != null) {
                if (!Files.exists(file2, new LinkOption[0])) {
                    throw new NoSuchFileException(file2.toString());
                }
                readerCmd.append(EnvironmentUtil.SHELL_SOURCE_COMMAND).append(" \"").append(file2).append("\" && ");
            }
            readerCmd.append("'").append(reader.toAbsolutePath()).append("' '").append(envFile.toAbsolutePath()).append("'");
            List<String> command = this.getShellProcessCommand();
            int idx = command.indexOf(EnvironmentUtil.SHELL_COMMAND_ARGUMENT);
            if (idx >= 0) {
                command.set(idx + 1, command.get(idx + 1) + ';' + readerCmd);
            } else {
                command.add(EnvironmentUtil.SHELL_COMMAND_ARGUMENT);
                command.add(readerCmd.toString());
            }
            LOG.info("loading shell env: " + String.join((CharSequence)" ", command));
            Map<String, String> map2 = this.runProcessAndReadOutputAndEnvs(command, null, additionalEnvironment, envFile).getValue();
            Map<String, String> map3 = map2;
            if (map3 == null) {
                ShellEnvReader.$$$reportNull$$$0(0);
            }
            return map3;
            finally {
                try {
                    Files.delete(envFile);
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException e) {
                    LOG.warn("Cannot delete temporary file", e);
                }
            }
        }

        @NotNull
        protected final Map.Entry<String, Map<String, String>> runProcessAndReadOutputAndEnvs(@NotNull List<String> command, @Nullable Path workingDir, @NotNull Path envFile) throws IOException {
            if (command == null) {
                ShellEnvReader.$$$reportNull$$$0(1);
            }
            if (envFile == null) {
                ShellEnvReader.$$$reportNull$$$0(2);
            }
            return this.runProcessAndReadOutputAndEnvs(command, workingDir, Collections.emptyMap(), envFile);
        }

        @NotNull
        protected final Map.Entry<String, Map<String, String>> runProcessAndReadOutputAndEnvs(@NotNull List<String> command, @Nullable Path workingDir, @Nullable Map<String, String> scriptEnvironment, @NotNull Path envFile) throws IOException {
            if (command == null) {
                ShellEnvReader.$$$reportNull$$$0(3);
            }
            if (envFile == null) {
                ShellEnvReader.$$$reportNull$$$0(4);
            }
            return this.runProcessAndReadOutputAndEnvs(command, workingDir, (Map<String, String> it) -> {
                if (scriptEnvironment != null) {
                    it.putAll(scriptEnvironment);
                }
            }, envFile);
        }

        @NotNull
        protected final Map.Entry<String, Map<String, String>> runProcessAndReadOutputAndEnvs(@NotNull List<String> command, @Nullable Path workingDir, @NotNull @NotNull Consumer<@NotNull Map<String, String>> scriptEnvironmentProcessor, @NotNull Path envFile) throws IOException {
            if (command == null) {
                ShellEnvReader.$$$reportNull$$$0(5);
            }
            if (scriptEnvironmentProcessor == null) {
                ShellEnvReader.$$$reportNull$$$0(6);
            }
            if (envFile == null) {
                ShellEnvReader.$$$reportNull$$$0(7);
            }
            ProcessBuilder builder = new ProcessBuilder(command).redirectErrorStream(true);
            scriptEnvironmentProcessor.accept(builder.environment());
            if (workingDir != null) {
                builder.directory(workingDir.toFile());
            }
            builder.environment().put(EnvironmentUtil.DISABLE_OMZ_AUTO_UPDATE, "true");
            builder.environment().put(EnvironmentUtil.INTELLIJ_ENVIRONMENT_READER, "true");
            Process process2 = builder.start();
            StreamGobbler gobbler = new StreamGobbler(process2.getInputStream());
            int exitCode = EnvironmentUtil.waitAndTerminateAfter(process2, this.myTimeoutMillis);
            gobbler.stop();
            String lines = new String(Files.readAllBytes(envFile), StandardCharsets.UTF_8);
            if (exitCode != 0 || lines.isEmpty()) {
                throw new IOException("command " + command + "\n\texit code:" + exitCode + " text:" + lines.length() + " out:" + gobbler.getText().trim());
            }
            return new AbstractMap.SimpleImmutableEntry<String, Map<String, String>>(gobbler.getText(), EnvironmentUtil.parseEnv(lines));
        }

        @NotNull
        protected List<String> getShellProcessCommand() {
            String shellScript = this.getShell();
            if (shellScript == null || shellScript.isEmpty()) {
                throw new RuntimeException("empty $SHELL");
            }
            if (!Files.isExecutable(Paths.get(shellScript, new String[0]))) {
                throw new RuntimeException("$SHELL points to a missing or non-executable file: " + shellScript);
            }
            List<String> list = EnvironmentUtil.buildShellProcessCommand(shellScript, true, true, false);
            if (list == null) {
                ShellEnvReader.$$$reportNull$$$0(8);
            }
            return list;
        }

        @Nullable
        protected String getShell() {
            return System.getenv(EnvironmentUtil.SHELL_VARIABLE_NAME);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/EnvironmentUtil$ShellEnvReader";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envFile";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptEnvironmentProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readShellEnv";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/EnvironmentUtil$ShellEnvReader";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShellProcessCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "runProcessAndReadOutputAndEnvs";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

