/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
public final class ChannelRegistrar
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = Logger.getInstance(ChannelRegistrar.class);
    private final AtomicReference<ServerChannel> serverChannel = new AtomicReference();
    private final Set<Channel> clientChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean isEventLoopGroupOwner;

    public boolean isEmpty() {
        return this.serverChannel.get() == null && this.clientChannels.isEmpty();
    }

    public void setServerChannel(@NotNull Channel channel, boolean isOwnEventLoopGroup) {
        if (channel == null) {
            ChannelRegistrar.$$$reportNull$$$0(0);
        }
        boolean isSet = this.serverChannel.compareAndSet(null, (ServerChannel)channel);
        LOG.assertTrue(isSet);
        this.isEventLoopGroupOwner = isOwnEventLoopGroup;
    }

    public void channelActive(@NotNull ChannelHandlerContext context) throws Exception {
        if (context == null) {
            ChannelRegistrar.$$$reportNull$$$0(1);
        }
        this.clientChannels.add(context.channel());
        super.channelActive(context);
    }

    public void channelInactive(@NotNull ChannelHandlerContext context) throws Exception {
        if (context == null) {
            ChannelRegistrar.$$$reportNull$$$0(2);
        }
        this.clientChannels.remove(context.channel());
        super.channelInactive(context);
    }

    public void close() {
        this.close(this.isEventLoopGroupOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean shutdownEventLoopGroup) {
        ServerChannel serverChannel = this.serverChannel.get();
        if (serverChannel == null) {
            LOG.assertTrue(this.clientChannels.isEmpty());
            return;
        }
        if (!this.serverChannel.compareAndSet(serverChannel, null)) {
            return;
        }
        EventLoopGroup eventLoopGroup = shutdownEventLoopGroup ? serverChannel.eventLoop().parent() : null;
        try {
            long start = System.currentTimeMillis();
            Object[] clientChannels = this.clientChannels.toArray(new Channel[0]);
            this.clientChannels.clear();
            final CountDownLatch countDown = new CountDownLatch(clientChannels.length + 1);
            GenericFutureListener<ChannelFuture> listener2 = new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(@NotNull ChannelFuture future) {
                    if (future == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        Throwable cause = future.cause();
                        if (cause != null) {
                            LOG.warn(cause);
                        }
                    }
                    finally {
                        countDown.countDown();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "org/jetbrains/io/ChannelRegistrar$1", "operationComplete"));
                }
            };
            ChannelRegistrar.addCloseListener((Channel)serverChannel, countDown, listener2);
            for (Channel channel : clientChannels) {
                ChannelRegistrar.addCloseListener(channel, countDown, listener2);
            }
            try {
                countDown.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("Cannot close all channels for 10 seconds, channels: " + Arrays.toString(clientChannels));
            }
            long duration = System.currentTimeMillis() - start;
            if (duration > 1000L) {
                LOG.info("Close all channels took " + duration + " ms: " + duration / 60000L + " min " + duration % 60000L / 1000L + "sec");
            }
        }
        finally {
            if (eventLoopGroup != null) {
                eventLoopGroup.shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
            }
        }
    }

    private static void addCloseListener(@NotNull Channel serverChannel, @NotNull CountDownLatch countDown, @NotNull GenericFutureListener<ChannelFuture> listener2) {
        ChannelFuture close2;
        if (serverChannel == null) {
            ChannelRegistrar.$$$reportNull$$$0(3);
        }
        if (countDown == null) {
            ChannelRegistrar.$$$reportNull$$$0(4);
        }
        if (listener2 == null) {
            ChannelRegistrar.$$$reportNull$$$0(5);
        }
        if ((close2 = serverChannel.close()).isDone()) {
            countDown.countDown();
        } else {
            close2.addListener(listener2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverChannel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "countDown";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/io/ChannelRegistrar";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setServerChannel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "channelActive";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "channelInactive";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addCloseListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

