/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.httpclient.util.URIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ*\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/GHPathUtil;", "", "()V", "getFileURL", "", "project", "Lcom/intellij/openapi/project/Project;", "repositoryRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "virtualFile", "editor", "Lcom/intellij/openapi/editor/Editor;", "makeUrlToOpen", "relativePath", "branch", "intellij.vcs.github"})
public final class GHPathUtil {
    @NotNull
    public static final GHPathUtil INSTANCE;

    @Nullable
    public final String getFileURL(@NotNull Project project, @NotNull VirtualFile repositoryRoot, @NotNull GHRepositoryCoordinates path, @NotNull VirtualFile virtualFile, @Nullable Editor editor) {
        String hash;
        GitRepository repository;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repositoryRoot, (String)"repositoryRoot");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)repositoryRoot);
        if (relativePath == null) {
            return null;
        }
        GitRepository gitRepository = repository = GitBranchUtil.getCurrentRepository((Project)project);
        String string = hash = gitRepository != null ? gitRepository.getCurrentRevision() : null;
        if (hash == null) {
            return null;
        }
        return this.makeUrlToOpen(editor, relativePath, hash, path);
    }

    @Nullable
    public final String makeUrlToOpen(@Nullable Editor editor, @NotNull String relativePath, @NotNull String branch, @NotNull GHRepositoryCoordinates path) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        StringBuilder builder = new StringBuilder();
        if (StringUtil.isEmptyOrSpaces((String)relativePath)) {
            builder.append(path.toUrl()).append("/tree/").append(branch);
        } else {
            builder.append(path.toUrl()).append("/blob/").append(branch).append('/').append(URIUtil.encodePath((String)relativePath));
        }
        if (editor != null) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            if (document.getLineCount() >= 1) {
                SelectionModel selectionModel = editor.getSelectionModel();
                Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
                SelectionModel selectionModel2 = selectionModel;
                int begin = editor.getDocument().getLineNumber(selectionModel2.getSelectionStart()) + 1;
                int selectionEnd = selectionModel2.getSelectionEnd();
                int end = editor.getDocument().getLineNumber(selectionEnd) + 1;
                if (editor.getDocument().getLineStartOffset(end - 1) == selectionEnd) {
                    --end;
                }
                builder.append("#L").append(begin);
                if (begin != end) {
                    builder.append("-L").append(end);
                }
            }
        }
        return builder.toString();
    }

    private GHPathUtil() {
    }

    static {
        GHPathUtil gHPathUtil;
        INSTANCE = gHPathUtil = new GHPathUtil();
    }
}

