/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.dvcs.hosting.RepositoryListLoader;
import com.intellij.dvcs.hosting.RepositoryListLoadingException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.exceptions.GithubMissingTokenException;
import org.jetbrains.plugins.github.extensions.GHRepositoryHostingServiceKt;
import org.jetbrains.plugins.github.extensions.GHRepositoryListLoader;
import org.jetbrains.plugins.github.util.GithubGitHelper;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/extensions/GHRepositoryListLoader;", "Lcom/intellij/dvcs/hosting/RepositoryListLoader;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "getAuthenticationManager", "()Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "executorManager", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutorManager;", "getExecutorManager", "()Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutorManager;", "executors", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "gitHelper", "Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "getGitHelper", "()Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "enable", "", "parentComponent", "Ljava/awt/Component;", "getAvailableRepositoriesFromMultipleSources", "Lcom/intellij/dvcs/hosting/RepositoryListLoader$Result;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isEnabled", "intellij.vcs.github"})
final class GHRepositoryListLoader
implements RepositoryListLoader {
    private final Map<GithubAccount, GithubApiRequestExecutor> executors;
    private final Project project;

    private final GithubAuthenticationManager getAuthenticationManager() {
        return GithubAuthenticationManager.Companion.getInstance();
    }

    private final GithubApiRequestExecutorManager getExecutorManager() {
        return GithubApiRequestExecutorManager.Companion.getInstance();
    }

    private final GithubGitHelper getGitHelper() {
        return GithubGitHelper.Companion.getInstance();
    }

    public boolean isEnabled() {
        Iterable $this$forEach$iv = this.getAuthenticationManager().getAccounts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GithubAccount account = (GithubAccount)((Object)element$iv);
            boolean bl = false;
            try {
                this.executors.put(account, this.getExecutorManager().getExecutor(account));
            }
            catch (GithubMissingTokenException githubMissingTokenException) {
            }
        }
        Map<GithubAccount, GithubApiRequestExecutor> map2 = this.executors;
        boolean bl = false;
        return !map2.isEmpty();
    }

    public boolean enable(@Nullable Component parentComponent) {
        if (!this.getAuthenticationManager().ensureHasAccounts(this.project, parentComponent)) {
            return false;
        }
        boolean atLeastOneHasToken = false;
        for (GithubAccount account : this.getAuthenticationManager().getAccounts()) {
            GithubApiRequestExecutor.WithTokenAuth executor;
            if (this.getExecutorManager().getExecutor(account, this.project) == null) {
                continue;
            }
            this.executors.put(account, executor);
            atLeastOneHasToken = true;
        }
        return atLeastOneHasToken;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public RepositoryListLoader.Result getAvailableRepositoriesFromMultipleSources(@NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        boolean bl = false;
        List urls = new ArrayList();
        boolean bl2 = false;
        List exceptions = new ArrayList();
        Map<GithubAccount, GithubApiRequestExecutor> $this$forEach$iv = this.executors;
        boolean $i$f$forEach = false;
        Map<GithubAccount, GithubApiRequestExecutor> map2 = $this$forEach$iv;
        boolean bl3 = false;
        Iterator<Map.Entry<GithubAccount, GithubApiRequestExecutor>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<GithubAccount, GithubApiRequestExecutor> element$iv;
            Map.Entry<GithubAccount, GithubApiRequestExecutor> $dstr$account$executor = element$iv = iterator.next();
            boolean bl4 = false;
            Map.Entry<GithubAccount, GithubApiRequestExecutor> entry = $dstr$account$executor;
            boolean bl5 = false;
            GithubAccount githubAccount = entry.getKey();
            entry = $dstr$account$executor;
            bl5 = false;
            GithubApiRequestExecutor executor = entry.getValue();
            try {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void account;
                List associatedRepos = GHRepositoryHostingServiceKt.access$loadAssociatedRepos((GithubAccount)account, executor, progressIndicator);
                List watchedRepos = GHRepositoryHostingServiceKt.access$loadWatchedReposSkipErrors((GithubAccount)account, executor, progressIndicator);
                Iterable iterable = CollectionsKt.sortedWith((Iterable)CollectionsKt.plus((Collection)associatedRepos, (Iterable)watchedRepos), (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{getAvailableRepositoriesFromMultipleSources.1.1.INSTANCE, getAvailableRepositoriesFromMultipleSources.1.2.INSTANCE}));
                List list2 = urls;
                boolean $i$f$map = false;
                void var19_23 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void repo;
                    GithubRepo githubRepo = (GithubRepo)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl6 = false;
                    GithubGitHelper githubGitHelper = this.getGitHelper();
                    GithubServerPath githubServerPath = account.getServer();
                    String string = repo.getUserName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repo.userName");
                    String string2 = repo.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"repo.name");
                    String string3 = githubGitHelper.getRemoteUrl(githubServerPath, string, string2);
                    collection.add(string3);
                }
                collection = (List)destination$iv$iv;
                list2.addAll((Collection)collection);
            }
            catch (Exception e) {
                exceptions.add(new RepositoryListLoadingException("Cannot load repositories from GitHub", (Throwable)e));
            }
        }
        return new RepositoryListLoader.Result(urls, exceptions);
    }

    public GHRepositoryListLoader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean bl = false;
        this.executors = new LinkedHashMap();
    }
}

