/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.util.ProgressIndicatorsProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.util.CachingGHUserAvatarLoader;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005Rn\u0010\u0003\u001ab\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\b \u0006*\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00070\u0007 \u0006*0\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\b \u0006*\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader;", "Lcom/intellij/openapi/Disposable;", "()V", "avatarCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/Image;", "indicatorProvider", "Lcom/intellij/collaboration/util/ProgressIndicatorsProvider;", "dispose", "", "loadAndDownscale", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "url", "maximumSize", "", "requestAvatar", "Companion", "intellij.vcs.github"})
public final class CachingGHUserAvatarLoader
implements Disposable {
    private final ProgressIndicatorsProvider indicatorProvider;
    private final Cache<String, CompletableFuture<Image>> avatarCache;
    private static final Logger LOG;
    private static final int MAXIMUM_ICON_SIZE = 40;
    private static final int STORED_IMAGE_SIZE = 240;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final CompletableFuture<Image> requestAvatar(@NotNull GithubApiRequestExecutor requestExecutor, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = this.avatarCache.get((Object)url, new Function(this, requestExecutor, url){
            final /* synthetic */ CachingGHUserAvatarLoader this$0;
            final /* synthetic */ GithubApiRequestExecutor $requestExecutor;
            final /* synthetic */ String $url;

            public final CompletableFuture<Image> apply(String it) {
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                return CompletableFutureUtil.INSTANCE.submitIOTask(progressManager, CachingGHUserAvatarLoader.access$getIndicatorProvider$p(this.this$0), (Function1)new Function1<ProgressIndicator, Image>(this){
                    final /* synthetic */ requestAvatar.1 this$0;

                    @Nullable
                    public final Image invoke(@NotNull ProgressIndicator it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return CachingGHUserAvatarLoader.access$loadAndDownscale(this.this$0.this$0, this.this$0.$requestExecutor, it, this.this$0.$url, 240);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = cachingGHUserAvatarLoader;
                this.$requestExecutor = githubApiRequestExecutor;
                this.$url = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"avatarCache.get(url) {\n \u2026 STORED_IMAGE_SIZE) }\n  }");
        return (CompletableFuture)object;
    }

    private final Image loadAndDownscale(GithubApiRequestExecutor requestExecutor, ProgressIndicator indicator, String url, int maximumSize) {
        try {
            Image image = requestExecutor.execute(indicator, GithubApiRequests.CurrentUser.getAvatar(url));
            return image.getWidth(null) <= maximumSize && image.getHeight(null) <= maximumSize ? image : ImageLoader.scaleImage((Image)image, (int)maximumSize);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Exception e) {
            LOG.debug("Error loading image from " + url, (Throwable)e);
            return null;
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    public CachingGHUserAvatarLoader() {
        void it;
        ProgressIndicatorsProvider progressIndicatorsProvider = new ProgressIndicatorsProvider();
        boolean bl = false;
        boolean bl2 = false;
        ProgressIndicatorsProvider progressIndicatorsProvider2 = progressIndicatorsProvider;
        CachingGHUserAvatarLoader cachingGHUserAvatarLoader = this;
        boolean bl3 = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        Unit unit = Unit.INSTANCE;
        cachingGHUserAvatarLoader.indicatorProvider = progressIndicatorsProvider;
        this.avatarCache = Caffeine.newBuilder().expireAfterAccess(Duration.of(5L, ChronoUnit.MINUTES)).build();
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public final void run() {
                avatarCache.invalidateAll();
            }
        }, (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CachingGHUserAvatarLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ ProgressIndicatorsProvider access$getIndicatorProvider$p(CachingGHUserAvatarLoader $this) {
        return $this.indicatorProvider;
    }

    public static final /* synthetic */ Image access$loadAndDownscale(CachingGHUserAvatarLoader $this, GithubApiRequestExecutor requestExecutor, ProgressIndicator indicator, String url, int maximumSize) {
        return $this.loadAndDownscale(requestExecutor, indicator, url, maximumSize);
    }

    @JvmStatic
    @NotNull
    public static final CachingGHUserAvatarLoader getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAXIMUM_ICON_SIZE", "", "STORED_IMAGE_SIZE", "getInstance", "Lorg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final CachingGHUserAvatarLoader getInstance() {
            boolean $i$f$service = false;
            Class<CachingGHUserAvatarLoader> serviceClass$iv = CachingGHUserAvatarLoader.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (CachingGHUserAvatarLoader)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

