/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.i18n.GitBundle;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.util.GithubUtil;

public final class GithubNotifications {
    private static final Logger LOG = GithubUtil.LOG;

    private static boolean isOperationCanceled(@NotNull Throwable e) {
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(0);
        }
        return e instanceof GithubOperationCanceledException || e instanceof ProcessCanceledException;
    }

    public static void showInfo(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(1);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(2);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(3);
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(displayId, title, message);
    }

    public static void showWarning(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(4);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(5);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(6);
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(displayId, title, message);
    }

    public static void showError(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(7);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(8);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(9);
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyError(displayId, title, message);
    }

    public static void showError(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @NotNull String logDetails) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(10);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(11);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(12);
        }
        if (logDetails == null) {
            GithubNotifications.$$$reportNull$$$0(13);
        }
        LOG.warn(title + "; " + message + "; " + logDetails);
        VcsNotifier.getInstance((Project)project).notifyError(displayId, title, message);
    }

    public static void showError(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NotNull Throwable e) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(14);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(15);
        }
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(16);
        }
        LOG.warn(title + "; ", e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        VcsNotifier.getInstance((Project)project).notifyError(displayId, title, GithubUtil.getErrorTextFromException(e));
    }

    public static void showInfoURL(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @NotNull String url) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(17);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(18);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(19);
        }
        if (url == null) {
            GithubNotifications.$$$reportNull$$$0(20);
        }
        LOG.info(title + "; " + message + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(displayId, title, HtmlChunk.link((String)url, (String)message).toString(), NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showWarningURL(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(21);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(22);
        }
        if (prefix == null) {
            GithubNotifications.$$$reportNull$$$0(23);
        }
        if (highlight == null) {
            GithubNotifications.$$$reportNull$$$0(24);
        }
        if (postfix == null) {
            GithubNotifications.$$$reportNull$$$0(25);
        }
        if (url == null) {
            GithubNotifications.$$$reportNull$$$0(26);
        }
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(displayId, title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showErrorURL(@NotNull Project project, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(27);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(28);
        }
        if (prefix == null) {
            GithubNotifications.$$$reportNull$$$0(29);
        }
        if (highlight == null) {
            GithubNotifications.$$$reportNull$$$0(30);
        }
        if (postfix == null) {
            GithubNotifications.$$$reportNull$$$0(31);
        }
        if (url == null) {
            GithubNotifications.$$$reportNull$$$0(32);
        }
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyError(displayId, title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showWarningDialog(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(33);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(34);
        }
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Project)project, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(35);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(36);
        }
        LOG.info(title + "; " + message);
        Messages.showErrorDialog((Project)project, (String)message, (String)title);
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(37);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(38);
        }
        return MessageDialogBuilder.yesNo((String)title, (String)message).ask(project);
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @NotNull DoNotAskOption doNotAskOption) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(39);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(40);
        }
        if (doNotAskOption == null) {
            GithubNotifications.$$$reportNull$$$0(41);
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).icon(Messages.getQuestionIcon())).doNotAsk(doNotAskOption)).ask(project);
    }

    @NotNull
    public static AnAction getConfigureAction(@NotNull Project project) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(42);
        }
        NotificationAction notificationAction = NotificationAction.createSimple((Supplier)GitBundle.messagePointer((String)"action.NotificationAction.GithubNotifications.text.configure", (Object[])new Object[0]), () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, "GitHub"));
        if (notificationAction == null) {
            GithubNotifications.$$$reportNull$$$0(43);
        }
        return notificationAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 27: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 18: 
            case 22: 
            case 28: 
            case 33: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 19: 
            case 34: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logDetails";
                break;
            }
            case 20: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlight";
                break;
            }
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfix";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doNotAskOption";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/util/GithubNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/util/GithubNotifications";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOperationCanceled";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showWarning";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showInfoURL";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "showWarningURL";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "showErrorURL";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "showWarningDialog";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoDialog";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getConfigureAction";
                break;
            }
            case 43: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

