/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonCodeStyleService;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.imports.ImportLocationHelper;
import com.jetbrains.python.codeInsight.imports.PyRelativeImportData;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddImportHelper {
    private static final Logger LOG = Logger.getInstance(AddImportHelper.class);
    private static final Comparator<PyImportStatementBase> IMPORT_TYPE_COMPARATOR = (import1, import2) -> {
        int firstIsFromImport = import1 instanceof PyFromImportStatement ? 1 : 0;
        int secondIsFromImport = import2 instanceof PyFromImportStatement ? 1 : 0;
        return firstIsFromImport - secondIsFromImport;
    };
    private static final ImportPriority UNRESOLVED_SYMBOL_PRIORITY = ImportPriority.THIRD_PARTY;

    @NotNull
    private static Comparator<PyImportStatementBase> getImportStatementComparator(@NotNull PsiFile settingsAnchor) {
        if (settingsAnchor == null) {
            AddImportHelper.$$$reportNull$$$0(0);
        }
        Comparator comparator = (import1, import2) -> {
            Comparator<String> stringComparator = AddImportHelper.getImportTextComparator(settingsAnchor);
            return ContainerUtil.compareLexicographically(AddImportHelper.getSortNames(import1), AddImportHelper.getSortNames(import2), Comparator.nullsFirst(stringComparator));
        };
        if (comparator == null) {
            AddImportHelper.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    @NotNull
    public static Comparator<String> getImportTextComparator(@NotNull PsiFile settingsAnchor) {
        if (settingsAnchor == null) {
            AddImportHelper.$$$reportNull$$$0(2);
        }
        Comparator<String> comparator = PythonCodeStyleService.getInstance().isOptimizeImportsCaseSensitiveOrder(settingsAnchor) ? String.CASE_INSENSITIVE_ORDER : Comparator.naturalOrder();
        if (comparator == null) {
            AddImportHelper.$$$reportNull$$$0(3);
        }
        return comparator;
    }

    @NotNull
    private static List<String> getSortNames(@NotNull PyImportStatementBase importStatement) {
        if (importStatement == null) {
            AddImportHelper.$$$reportNull$$$0(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        PyFromImportStatement fromImport = PyUtil.as(importStatement, PyFromImportStatement.class);
        if (fromImport != null) {
            result.add(StringUtil.repeatSymbol((char)'.', (int)fromImport.getRelativeLevel()));
            QualifiedName source = fromImport.getImportSourceQName();
            result.add(Objects.toString(source, ""));
            if (fromImport.isStarImport()) {
                result.add("*");
            }
        } else {
            result.add("");
        }
        for (PyImportElement importElement : importStatement.getImportElements()) {
            QualifiedName qualifiedName = importElement.getImportedQName();
            result.add(Objects.toString(qualifiedName, ""));
            result.add(StringUtil.notNullize((String)importElement.getAsName()));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            AddImportHelper.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static Comparator<PyImportStatementBase> getSameGroupImportsComparator(@NotNull PsiFile settingsAnchor) {
        if (settingsAnchor == null) {
            AddImportHelper.$$$reportNull$$$0(6);
        }
        if (PythonCodeStyleService.getInstance().isOptimizeImportsSortedByTypeFirst(settingsAnchor)) {
            Comparator<PyImportStatementBase> comparator = IMPORT_TYPE_COMPARATOR.thenComparing(AddImportHelper.getImportStatementComparator(settingsAnchor));
            if (comparator == null) {
                AddImportHelper.$$$reportNull$$$0(7);
            }
            return comparator;
        }
        Comparator<PyImportStatementBase> comparator = AddImportHelper.getImportStatementComparator(settingsAnchor).thenComparing(IMPORT_TYPE_COMPARATOR);
        if (comparator == null) {
            AddImportHelper.$$$reportNull$$$0(8);
        }
        return comparator;
    }

    private AddImportHelper() {
    }

    public static void addLocalImportStatement(@NotNull PsiElement element, @NotNull String name, @Nullable String asName) {
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(9);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(10);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(element.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(element);
        PsiElement anchor = AddImportHelper.getLocalInsertPosition(element);
        PsiElement parentElement = PyUtil.sure(anchor).getParent();
        if (parentElement != null) {
            parentElement.addBefore((PsiElement)generator.createImportStatement(languageLevel, name, asName), anchor);
        }
    }

    public static void addLocalFromImportStatement(@NotNull PsiElement element, @NotNull String qualifier, @NotNull String name, @Nullable String asName) {
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(11);
        }
        if (qualifier == null) {
            AddImportHelper.$$$reportNull$$$0(12);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(13);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(element.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(element);
        PsiElement anchor = AddImportHelper.getLocalInsertPosition(element);
        PsiElement parentElement = PyUtil.sure(anchor).getParent();
        if (parentElement != null) {
            parentElement.addBefore((PsiElement)generator.createFromImportStatement(languageLevel, qualifier, name, asName), anchor);
        }
    }

    @Nullable
    public static PsiElement getLocalInsertPosition(@NotNull PsiElement anchor) {
        if (anchor == null) {
            AddImportHelper.$$$reportNull$$$0(14);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)anchor, PyStatement.class, (boolean)false);
    }

    @Nullable
    public static PsiElement getFileInsertPosition(PsiFile file) {
        return AddImportHelper.getInsertPosition((PsiElement)file, null, null, null);
    }

    @Nullable
    private static PsiElement getInsertPosition(@NotNull PsiElement insertParent, @Nullable PsiElement anchor, @Nullable PyImportStatementBase newImport, @Nullable ImportPriority priority) {
        ImportPriority priorityBelow;
        PsiElement feeler;
        if (insertParent == null) {
            AddImportHelper.$$$reportNull$$$0(15);
        }
        if ((feeler = ImportLocationHelper.getInstance().getSearchStartPosition(anchor, insertParent)) == null) {
            return null;
        }
        boolean skippedOverStatements = false;
        boolean skippedOverDoc = false;
        PsiElement seeker = feeler;
        boolean isInjected = InjectedLanguageManager.getInstance((Project)feeler.getProject()).isInjectedFragment(feeler.getContainingFile());
        PyImportStatementBase importAbove = null;
        PyImportStatementBase importBelow = null;
        do {
            PyStringLiteralExpression docElem;
            if (feeler instanceof PyImportStatementBase && !isInjected) {
                PyImportStatementBase existingImport = (PyImportStatementBase)feeler;
                if (priority != null && newImport != null) {
                    if (AddImportHelper.shouldInsertBefore(newImport, existingImport, priority)) {
                        importBelow = existingImport;
                        break;
                    }
                    importAbove = existingImport;
                }
                seeker = feeler;
                feeler = feeler.getNextSibling();
                skippedOverStatements = true;
                continue;
            }
            if (PsiTreeUtil.instanceOf((Object)feeler, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) {
                seeker = feeler;
                feeler = feeler.getNextSibling();
                continue;
            }
            if (PsiTreeUtil.instanceOf((Object)feeler, (Class[])new Class[]{OuterLanguageElement.class})) {
                if (skippedOverStatements) break;
                seeker = feeler = feeler.getNextSibling();
                continue;
            }
            if (AddImportHelper.isAssignmentToModuleLevelDunderName(feeler)) {
                if (priority == ImportPriority.FUTURE) {
                    seeker = feeler;
                    break;
                }
                seeker = feeler = feeler.getNextSibling();
                skippedOverStatements = true;
                continue;
            }
            if (skippedOverStatements || skippedOverDoc || !(insertParent instanceof PyFile) || (docElem = DocStringUtil.findDocStringExpression((PyElement)insertParent)) == null || docElem.getParent() != feeler) break;
            seeker = feeler = feeler.getNextSibling();
            skippedOverDoc = true;
        } while (feeler != null);
        ImportPriority priorityAbove = importAbove != null ? AddImportHelper.getImportPriority(importAbove) : null;
        ImportPriority importPriority = priorityBelow = importBelow != null ? AddImportHelper.getImportPriority(importBelow) : null;
        if (newImport != null && (priorityAbove == null || priorityAbove.compareTo(priority) < 0)) {
            newImport.putCopyableUserData(PythonCodeStyleService.IMPORT_GROUP_BEGIN, true);
        }
        if (priorityBelow != null) {
            if (priorityBelow.compareTo(priority) > 0) {
                importBelow.putCopyableUserData(PythonCodeStyleService.IMPORT_GROUP_BEGIN, true);
            } else if (priorityBelow == priority) {
                importBelow.putCopyableUserData(PythonCodeStyleService.IMPORT_GROUP_BEGIN, null);
            }
        }
        return seeker;
    }

    private static boolean shouldInsertBefore(@Nullable PyImportStatementBase newImport, @NotNull PyImportStatementBase existingImport, @NotNull ImportPriority priority) {
        ImportPriority existingImportPriority;
        int byPriority;
        if (existingImport == null) {
            AddImportHelper.$$$reportNull$$$0(16);
        }
        if (priority == null) {
            AddImportHelper.$$$reportNull$$$0(17);
        }
        if ((byPriority = priority.compareTo(existingImportPriority = AddImportHelper.getImportPriority(existingImport))) != 0) {
            return byPriority < 0;
        }
        if (newImport == null) {
            return false;
        }
        return AddImportHelper.getSameGroupImportsComparator(existingImport.getContainingFile()).compare(newImport, existingImport) < 0;
    }

    @NotNull
    public static ImportPriority getImportPriority(@NotNull PsiElement importLocation, @NotNull PsiFileSystemItem toImport) {
        if (importLocation == null) {
            AddImportHelper.$$$reportNull$$$0(18);
        }
        if (toImport == null) {
            AddImportHelper.$$$reportNull$$$0(19);
        }
        ImportPriorityChoice choice = AddImportHelper.getImportPriorityWithReason(importLocation, toImport);
        LOG.debug(String.format("Import group for %s at %s is %s: %s", new Object[]{toImport, importLocation.getContainingFile(), choice.myPriority, choice.myDescription}));
        ImportPriority importPriority = choice.myPriority;
        if (importPriority == null) {
            AddImportHelper.$$$reportNull$$$0(20);
        }
        return importPriority;
    }

    @NotNull
    public static ImportPriority getImportPriority(@NotNull PyImportStatementBase importStatement) {
        if (importStatement == null) {
            AddImportHelper.$$$reportNull$$$0(21);
        }
        ImportPriorityChoice choice = AddImportHelper.getImportPriorityWithReason(importStatement);
        LOG.debug(String.format("Import group for '%s' is %s: %s", new Object[]{importStatement.getText(), choice.myPriority, choice.myDescription}));
        ImportPriority importPriority = choice.myPriority;
        if (importPriority == null) {
            AddImportHelper.$$$reportNull$$$0(22);
        }
        return importPriority;
    }

    @NotNull
    static ImportPriorityChoice getImportPriorityWithReason(@NotNull PyImportStatementBase importStatement) {
        PsiElement resolved;
        PyElement resolveAnchor;
        if (importStatement == null) {
            AddImportHelper.$$$reportNull$$$0(23);
        }
        if (importStatement instanceof PyFromImportStatement) {
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)importStatement;
            if (fromImportStatement.isFromFuture()) {
                return new ImportPriorityChoice(ImportPriority.FUTURE, "import from __future__");
            }
            if (fromImportStatement.getRelativeLevel() > 0) {
                return new ImportPriorityChoice(ImportPriority.PROJECT, "explicit relative import");
            }
            resolveAnchor = ((PyFromImportStatement)importStatement).getImportSource();
            resolved = fromImportStatement.resolveImportSource();
        } else {
            PyImportElement firstImportElement = (PyImportElement)ArrayUtil.getFirstElement((Object[])importStatement.getImportElements());
            if (firstImportElement == null) {
                return new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, "incomplete import statement");
            }
            resolveAnchor = firstImportElement;
            resolved = firstImportElement.resolve();
        }
        if (resolved == null) {
            return new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, (String)(resolveAnchor == null ? "incomplete import statement" : resolveAnchor.getText() + " is unresolved"));
        }
        Object resolvedFileOrDir = resolved instanceof PsiDirectory ? (PsiFileSystemItem)resolved : (resolved instanceof PsiDirectoryContainer ? (PsiFileSystemItem)ArrayUtil.getFirstElement((Object[])((PsiDirectoryContainer)resolved).getDirectories()) : resolved.getContainingFile());
        if (resolvedFileOrDir instanceof PyiFile) {
            PsiElement original = PyiUtil.getOriginalElement((PyiFile)resolvedFileOrDir);
            resolvedFileOrDir = (PsiFileSystemItem)ObjectUtils.notNull((Object)PyUtil.as(original, PsiFileSystemItem.class), (Object)resolvedFileOrDir);
        }
        if (resolvedFileOrDir == null) {
            return new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, resolved + " is not a file or directory");
        }
        return AddImportHelper.getImportPriorityWithReason((PsiElement)importStatement, resolvedFileOrDir);
    }

    @NotNull
    static ImportPriorityChoice getImportPriorityWithReason(@NotNull PsiElement importLocation, @NotNull PsiFileSystemItem toImport) {
        Sdk pythonSdk2;
        VirtualFile vFile;
        if (importLocation == null) {
            AddImportHelper.$$$reportNull$$$0(24);
        }
        if (toImport == null) {
            AddImportHelper.$$$reportNull$$$0(25);
        }
        if ((vFile = toImport.getVirtualFile()) == null) {
            return new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, toImport + " doesn't have an associated virtual file");
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)toImport.getProject());
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        if (fileIndex.isInContent(vFile) && !fileIndex.isInLibraryClasses(vFile)) {
            return new ImportPriorityChoice(ImportPriority.PROJECT, vFile + " belongs to the project and not under interpreter paths");
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)importLocation);
        Sdk sdk = pythonSdk2 = module != null ? PythonSdkUtil.findPythonSdk(module) : projectRootManager.getProjectSdk();
        if (PythonSdkUtil.isStdLib(vFile, pythonSdk2)) {
            return new ImportPriorityChoice(ImportPriority.BUILTIN, vFile + " is either in lib but not under site-packages, or belongs to the root of skeletons, or is a .pyi stub definition for stdlib module");
        }
        return new ImportPriorityChoice(ImportPriority.THIRD_PARTY, pythonSdk2 == null ? "SDK for " + vFile + " isn't found" : "Fall back value for " + vFile);
    }

    public static boolean addImportStatement(@NotNull PsiFile file, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(26);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(27);
        }
        return AddImportHelper.addImportStatement(file, name, asName, priority, anchor, null);
    }

    public static boolean addImportStatement(@NotNull PsiFile file, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor, @Nullable PsiElement insertBefore) {
        PyImportStatementBase importStatement;
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(28);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(29);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        List<PyImportElement> existingImports = ((PyFile)file).getImportTargets();
        List<PyImportStatementBase> importsAllowedToReuse = AddImportHelper.getImportsAllowedToReuse(insertBefore);
        for (PyImportElement existingImport : existingImports) {
            String existingName;
            if (importsAllowedToReuse != null && !importsAllowedToReuse.contains(existingImport.getContainingImportStatement()) || !name.equals(existingName = Objects.toString(existingImport.getImportedQName(), "")) || !Objects.equals(asName, existingImport.getAsName())) continue;
            return false;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(file.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        PyImportStatement importNodeToInsert = generator.createImportStatement(languageLevel, name, asName);
        Object insertParent = insertBefore == null || insertBefore.getParent() == null ? ((importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyImportStatementBase.class, (boolean)false)) != null && importStatement.getContainingFile() == file ? importStatement.getParent() : file) : insertBefore.getParent();
        try {
            if (anchor instanceof PyImportStatementBase) {
                insertParent.addAfter((PsiElement)importNodeToInsert, anchor);
            } else {
                PsiElement position = insertBefore == null ? AddImportHelper.getInsertPosition(insertParent, anchor, importNodeToInsert, priority) : insertBefore;
                insertParent.addBefore((PsiElement)importNodeToInsert, position);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    public static void addFromImportStatement(@NotNull PsiFile file, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(30);
        }
        if (from == null) {
            AddImportHelper.$$$reportNull$$$0(31);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(32);
        }
        AddImportHelper.addFromImportStatement(file, from, name, asName, priority, anchor, null);
    }

    public static void addFromImportStatement(@NotNull PsiFile file, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor, @Nullable PsiElement insertBefore) {
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(33);
        }
        if (from == null) {
            AddImportHelper.$$$reportNull$$$0(34);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(35);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(file.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        PyFromImportStatement newImport = generator.createFromImportStatement(languageLevel, from, name, asName);
        AddImportHelper.addFromImportStatement(file, newImport, priority, anchor, insertBefore);
    }

    public static void addFromImportStatement(@NotNull PsiFile file, @NotNull PyFromImportStatement newImport, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(36);
        }
        if (newImport == null) {
            AddImportHelper.$$$reportNull$$$0(37);
        }
        AddImportHelper.addFromImportStatement(file, newImport, priority, anchor, null);
    }

    public static void addFromImportStatement(@NotNull PsiFile file, @NotNull PyFromImportStatement newImport, @Nullable ImportPriority priority, @Nullable PsiElement anchor, @Nullable PsiElement insertBefore) {
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(38);
        }
        if (newImport == null) {
            AddImportHelper.$$$reportNull$$$0(39);
        }
        try {
            boolean insideDoctest;
            PyImportStatementBase parentImport = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyImportStatementBase.class, (boolean)false);
            InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)file.getProject());
            PsiLanguageInjectionHost injectionHost = manager.getInjectionHost((PsiElement)file);
            boolean bl = insideDoctest = file instanceof PyDocstringFile && injectionHost != null && DocStringUtil.getParentDefinitionDocString((PsiElement)injectionHost) == injectionHost;
            Object insertParent = insertBefore != null && insertBefore.getParent() != null ? insertBefore.getParent() : (parentImport != null && parentImport.getContainingFile() == file ? parentImport.getParent() : (injectionHost != null && !insideDoctest ? manager.getTopLevelFile((PsiElement)file) : file));
            if (insideDoctest) {
                PsiElement element = insertParent.addBefore((PsiElement)newImport, AddImportHelper.getInsertPosition(insertParent, anchor, newImport, priority));
                PsiElement whitespace = element.getNextSibling();
                if (!(whitespace instanceof PsiWhiteSpace)) {
                    whitespace = PsiParserFacade.SERVICE.getInstance((Project)file.getProject()).createWhiteSpaceFromText("  >>> ");
                }
                insertParent.addBefore(whitespace, element);
            } else if (anchor instanceof PyImportStatementBase) {
                insertParent.addAfter((PsiElement)newImport, anchor);
            } else {
                PsiElement position = insertBefore == null ? AddImportHelper.getInsertPosition(insertParent, anchor, newImport, priority) : insertBefore;
                insertParent.addBefore((PsiElement)newImport, position);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static boolean addOrUpdateFromImportStatement(@NotNull PsiFile file, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(40);
        }
        if (from == null) {
            AddImportHelper.$$$reportNull$$$0(41);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(42);
        }
        return AddImportHelper.addOrUpdateFromImportStatement(file, from, name, asName, priority, anchor, null);
    }

    public static boolean addOrUpdateFromImportStatement(@NotNull PsiFile file, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor, @Nullable PsiElement insertBefore) {
        int maxAllowedDepth;
        int maxRelativeLevelInFile;
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(43);
        }
        if (from == null) {
            AddImportHelper.$$$reportNull$$$0(44);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(45);
        }
        PyFile pyFile = (PyFile)file;
        List<PyFromImportStatement> existingImports = pyFile.getFromImports();
        int relativeLevel = 0;
        PyRelativeImportData importData = null;
        if (priority == ImportPriority.PROJECT && (importData = PyRelativeImportData.fromString(from, pyFile)) != null) {
            relativeLevel = importData.getRelativeLevel();
        }
        List<PyImportStatementBase> importsAllowedToReuse = AddImportHelper.getImportsAllowedToReuse(insertBefore);
        if (!PythonCodeStyleService.getInstance().isOptimizeImportsAlwaysSplitFromImports(file)) {
            for (PyFromImportStatement existingImport : existingImports) {
                if (importsAllowedToReuse != null && !importsAllowedToReuse.contains(existingImport) || existingImport.isStarImport()) continue;
                String existingSource = Objects.toString(existingImport.getImportSourceQName(), "");
                boolean updateExisting = false;
                int currentRelativeLevel = existingImport.getRelativeLevel();
                if (currentRelativeLevel == 0) {
                    updateExisting = from.equals(existingSource);
                } else if (relativeLevel != 0) {
                    boolean bl = updateExisting = currentRelativeLevel == relativeLevel && existingSource.equals(importData.getRelativeLocation());
                }
                if (!updateExisting) continue;
                return AddImportHelper.addNameToFromImportStatement(existingImport, name, asName);
            }
        }
        if (!PyUtil.hasIfNameEqualsMain(pyFile) && (maxRelativeLevelInFile = StreamEx.of(pyFile.getFromImports()).mapToInt(PyFromImportStatement::getRelativeLevel).max().orElse(0)) > 0 && relativeLevel > 0 && (maxAllowedDepth = Math.max(maxRelativeLevelInFile, Registry.intValue((String)"python.relative.import.depth"))) >= relativeLevel) {
            from = importData.getLocationWithDots();
        }
        AddImportHelper.addFromImportStatement(file, from, name, asName, priority, anchor, insertBefore);
        return true;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private static List<PyImportStatementBase> getImportsAllowedToReuse(@Nullable PsiElement importBlockStart) {
        if (importBlockStart == null) {
            return null;
        }
        ArrayList<PyImportStatementBase> importsAllowedToReuse = new ArrayList<PyImportStatementBase>();
        PsiElement candidate = importBlockStart;
        while (candidate instanceof PyImportStatementBase) {
            importsAllowedToReuse.add((PyImportStatementBase)candidate);
            candidate = PyPsiUtils.getNextNonWhitespaceSibling(candidate);
        }
        return importsAllowedToReuse;
    }

    public static boolean addNameToFromImportStatement(@NotNull PyFromImportStatement fromImport, @NotNull String name, @Nullable String asName) {
        if (fromImport == null) {
            AddImportHelper.$$$reportNull$$$0(46);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(47);
        }
        PsiFile file = fromImport.getContainingFile();
        Comparator<String> nameComparator2 = AddImportHelper.getImportTextComparator(file);
        PythonCodeStyleService pyCodeStyle = PythonCodeStyleService.getInstance();
        boolean shouldSort = pyCodeStyle.isOptimizeImportsSortImports(file) && pyCodeStyle.isOptimizeImportsSortNamesInFromImports(file);
        PyImportElement followingNameElement = null;
        for (PyImportElement existingNameElement : fromImport.getImportElements()) {
            String existingName = Objects.toString(existingNameElement.getImportedQName(), "");
            if (name.equals(existingName) && Objects.equals(asName, existingNameElement.getAsName())) {
                return false;
            }
            if (!shouldSort || followingNameElement != null || nameComparator2.compare(existingName, name) <= 0) continue;
            followingNameElement = existingNameElement;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(fromImport.getProject());
        PyImportElement newNameElement = generator.createImportElement(LanguageLevel.forElement((PsiElement)fromImport), name, asName);
        fromImport.addBefore((PsiElement)newNameElement, (PsiElement)followingNameElement);
        CodeStyleManager.getInstance((Project)fromImport.getProject()).reformat((PsiElement)fromImport);
        return true;
    }

    public static void addImport(@NotNull PsiNamedElement target, @NotNull PsiFile file, @NotNull PyElement element) {
        if (target == null) {
            AddImportHelper.$$$reportNull$$$0(48);
        }
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(49);
        }
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(50);
        }
        if (target instanceof PsiFileSystemItem) {
            AddImportHelper.addFileSystemItemImport((PsiFileSystemItem)target, file, element);
            return;
        }
        String name = target.getName();
        if (name == null) {
            return;
        }
        PsiFile toImport = target.getContainingFile();
        if (toImport == null) {
            return;
        }
        QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)target, (PsiElement)element);
        if (importPath == null) {
            return;
        }
        String path = importPath.toString();
        ImportPriority priority = AddImportHelper.getImportPriority((PsiElement)file, (PsiFileSystemItem)toImport);
        if (!PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT) {
            AddImportHelper.addImportStatement(file, path, null, priority, (PsiElement)element);
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(file.getProject());
            element.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)target), path + "." + name));
        } else {
            AddImportHelper.addOrUpdateFromImportStatement(file, path, name, null, priority, (PsiElement)element);
        }
    }

    public static boolean isAssignmentToModuleLevelDunderName(@Nullable PsiElement element) {
        PyAssignmentStatement statement;
        PyExpression[] targets;
        if (element instanceof PyAssignmentStatement && PyUtil.isTopLevel(element) && (targets = (statement = (PyAssignmentStatement)element).getTargets()).length == 1) {
            String name = targets[0].getName();
            return name != null && PyUtil.isSpecialName(name);
        }
        return false;
    }

    private static void addFileSystemItemImport(@NotNull PsiFileSystemItem target, @NotNull PsiFile file, @NotNull PyElement element) {
        PsiFileSystemItem toImport;
        if (target == null) {
            AddImportHelper.$$$reportNull$$$0(51);
        }
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(52);
        }
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(53);
        }
        if ((toImport = target.getParent()) == null) {
            return;
        }
        QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)target, (PsiElement)element);
        if (importPath == null) {
            return;
        }
        ImportPriority priority = AddImportHelper.getImportPriority((PsiElement)file, toImport);
        if (importPath.getComponentCount() == 1 || !PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT) {
            String path = importPath.toString();
            AddImportHelper.addImportStatement(file, path, null, priority, (PsiElement)element);
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(file.getProject());
            element.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)target), path));
        } else {
            AddImportHelper.addOrUpdateFromImportStatement(file, importPath.removeLastComponent().toString(), target.getName(), null, priority, (PsiElement)element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AddImportHelper";
                break;
            }
            case 4: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 9: 
            case 11: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 13: 
            case 27: 
            case 29: 
            case 32: 
            case 35: 
            case 42: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertParent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingImport";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importLocation";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: 
            case 34: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newImport";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromImport";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AddImportHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatementComparator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportTextComparator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSameGroupImportsComparator";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImportStatementComparator";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 20: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImportTextComparator";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSortNames";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSameGroupImportsComparator";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addLocalImportStatement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addLocalFromImportStatement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLocalInsertPosition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInsertPosition";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertBefore";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getImportPriority";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getImportPriorityWithReason";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addImportStatement";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addFromImportStatement";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addOrUpdateFromImportStatement";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addNameToFromImportStatement";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addFileSystemItemImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ImportPriorityChoice {
        private final ImportPriority myPriority;
        private final String myDescription;

        ImportPriorityChoice(@NotNull ImportPriority priority, @NotNull String description) {
            if (priority == null) {
                ImportPriorityChoice.$$$reportNull$$$0(0);
            }
            if (description == null) {
                ImportPriorityChoice.$$$reportNull$$$0(1);
            }
            this.myPriority = priority;
            this.myDescription = description;
        }

        @NotNull
        public ImportPriority getPriority() {
            ImportPriority importPriority = this.myPriority;
            if (importPriority == null) {
                ImportPriorityChoice.$$$reportNull$$$0(2);
            }
            return importPriority;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                ImportPriorityChoice.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AddImportHelper$ImportPriorityChoice";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AddImportHelper$ImportPriorityChoice";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ImportPriority {
        FUTURE,
        BUILTIN,
        THIRD_PARTY,
        PROJECT;

    }
}

