/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PythonSdkDetailsDialog;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackagesNotificationPanel;
import com.jetbrains.python.packaging.ui.PyInstalledPackagesPanel;
import com.jetbrains.python.sdk.AddInterpreterActions;
import com.jetbrains.python.sdk.PyCustomSdkUiProvider;
import com.jetbrains.python.sdk.PyRenderedSdkType;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PySdkRenderingKt;
import com.jetbrains.python.sdk.PyTransferredSdkRootsKt;
import com.jetbrains.python.sdk.PythonSdkDetailsStep;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyActiveSdkConfigurable
implements UnnamedConfigurable {
    private static final Logger LOG = Logger.getInstance(PyActiveSdkConfigurable.class);
    @NotNull
    protected final Project myProject;
    @Nullable
    protected final Module myModule;
    @NotNull
    private final PyConfigurableInterpreterList myInterpreterList;
    @NotNull
    protected final ProjectSdksModel myProjectSdksModel;
    @NotNull
    private final JPanel myMainPanel;
    @NotNull
    private final ComboBox<Object> mySdkCombo;
    @NotNull
    private final PyInstalledPackagesPanel myPackagesPanel;
    @Nullable
    private final Disposable myDisposable;

    public PyActiveSdkConfigurable(@NotNull Project project) {
        if (project == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public PyActiveSdkConfigurable(@NotNull Module module) {
        if (module == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(1);
        }
        this(module.getProject(), module);
    }

    private PyActiveSdkConfigurable(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myModule = module;
        this.mySdkCombo = PyActiveSdkConfigurable.buildSdkComboBox(this::onShowAllSelected, this::onSdkSelected);
        PyPackagesNotificationPanel packagesNotificationPanel = new PyPackagesNotificationPanel();
        this.myPackagesPanel = new PyInstalledPackagesPanel(this.myProject, packagesNotificationPanel);
        this.myPackagesPanel.setShowGrid(false);
        PyCustomSdkUiProvider customUiProvider = PyCustomSdkUiProvider.getInstance();
        this.myDisposable = customUiProvider == null ? null : Disposer.newDisposable();
        Pair customizer = customUiProvider == null ? null : new Pair((Object)customUiProvider, (Object)this.myDisposable);
        JButton additionalAction = Experiments.getInstance().isFeatureEnabled("add.python.interpreter.dialog.on.targets") ? new DropDownLink((Object)PyBundle.message("active.sdk.dialog.link.add.interpreter.text", new Object[0]), link -> PyActiveSdkConfigurable.createAddInterpreterPopup(project, module, (Component)link, this::updateSdkListAndSelect)) : PyActiveSdkConfigurable.buildDetailsButton(this.mySdkCombo, this::onShowDetailsClicked);
        this.myMainPanel = PyActiveSdkConfigurable.buildPanel(project, this.mySdkCombo, additionalAction, this.myPackagesPanel, packagesNotificationPanel, (Pair<PyCustomSdkUiProvider, Disposable>)customizer);
        this.myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        this.myProjectSdksModel = this.myInterpreterList.getModel();
    }

    @NotNull
    private static ListPopup createAddInterpreterPopup(@NotNull Project project, @Nullable Module module, @NotNull Component dataContextComponent, @NotNull Consumer<Sdk> onSdkCreated) {
        if (project == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(3);
        }
        if (dataContextComponent == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(4);
        }
        if (onSdkCreated == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(5);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(dataContextComponent);
        List<AnAction> actions = AddInterpreterActions.collectAddInterpreterActions(project, module, onSdkCreated);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(actions), dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, -1, action -> false, null);
        if (listPopup == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(6);
        }
        return listPopup;
    }

    @NotNull
    private static ComboBox<Object> buildSdkComboBox(final @NotNull Runnable onShowAllSelected, @NotNull Runnable onSdkSelected) {
        if (onShowAllSelected == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(7);
        }
        if (onSdkSelected == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(8);
        }
        ComboBox<Object> result = new ComboBox<Object>(){

            public void setSelectedItem(Object item) {
                if (PyActiveSdkConfigurable.getShowAll().equals(item)) {
                    ApplicationManager.getApplication().invokeLater(onShowAllSelected);
                } else if (!"separator".equals(item)) {
                    super.setSelectedItem(item);
                }
            }
        };
        result.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                onSdkSelected.run();
            }
        });
        new ComboboxSpeedSearch((JComboBox)result);
        result.setPreferredSize(result.getPreferredSize());
        ComboBox<Object> comboBox = result;
        if (comboBox == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(9);
        }
        return comboBox;
    }

    @NotNull
    private static JButton buildDetailsButton(@NotNull ComboBox<?> sdkComboBox, @NotNull Consumer<JButton> onShowDetails) {
        if (sdkComboBox == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(10);
        }
        if (onShowDetails == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(11);
        }
        FixedSizeButton result = new FixedSizeButton(sdkComboBox.getPreferredSize().height);
        result.setIcon(AllIcons.General.GearPlain);
        result.addActionListener(e -> onShowDetails.accept((JButton)result));
        FixedSizeButton fixedSizeButton = result;
        if (fixedSizeButton == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(12);
        }
        return fixedSizeButton;
    }

    @NotNull
    private static JPanel buildPanel(@NotNull Project project, @NotNull ComboBox<?> sdkComboBox, @NotNull JComponent additionalAction, @NotNull PyInstalledPackagesPanel installedPackagesPanel, @NotNull PackagesNotificationPanel packagesNotificationPanel, @Nullable Pair<PyCustomSdkUiProvider, Disposable> customizer) {
        if (project == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(13);
        }
        if (sdkComboBox == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(14);
        }
        if (additionalAction == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(15);
        }
        if (installedPackagesPanel == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(16);
        }
        if (packagesNotificationPanel == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(17);
        }
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = JBUI.insets((int)2);
        c.gridx = 0;
        c.gridy = 0;
        JLabel label = new JLabel(PyBundle.message("active.sdk.dialog.project.interpreter", new Object[0]));
        label.setLabelFor((Component)sdkComboBox);
        result.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.1;
        result.add((Component)sdkComboBox, c);
        c.insets = JBUI.insets((int)2, (int)0, (int)2, (int)2);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)additionalAction, c);
        if (customizer != null) {
            ((PyCustomSdkUiProvider)customizer.first).customizeActiveSdkPanel(project, sdkComboBox, result, c, (Disposable)customizer.second);
        }
        c.insets = JBUI.insets((int)2, (int)2, (int)0, (int)2);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weightx = 0.0;
        result.add((Component)new JLabel("  "), c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridheight = -1;
        c.fill = 1;
        result.add((Component)((Object)installedPackagesPanel), c);
        c.gridheight = 0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        result.add((Component)packagesNotificationPanel.getComponent(), c);
        JPanel jPanel = result;
        if (jPanel == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    private void onShowAllSelected() {
        this.buildAllSdksDialog().show();
    }

    protected void onSdkSelected() {
        Sdk sdk = this.getOriginalSelectedSdk();
        this.refreshPackages(sdk);
    }

    protected void refreshPackages(@Nullable Sdk sdk) {
        PyPackageManagers packageManagers = PyPackageManagers.getInstance();
        this.myPackagesPanel.updatePackages(sdk != null ? packageManagers.getManagementService(this.myProject, sdk) : null);
        this.myPackagesPanel.updateNotifications(sdk);
    }

    private void onShowDetailsClicked(@NotNull JButton detailsButton) {
        if (detailsButton == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(19);
        }
        PythonSdkDetailsStep.show(this.myProject, this.myModule, this.myProjectSdksModel.getSdks(), this.buildAllSdksDialog(), this.myMainPanel, detailsButton.getLocationOnScreen(), new SdkAddedCallback());
    }

    @NotNull
    private PythonSdkDetailsDialog buildAllSdksDialog() {
        return new PythonSdkDetailsDialog(this.myProject, this.myModule, (NullableConsumer<? super Sdk>)((NullableConsumer)selectedSdk -> {
            if (selectedSdk != null) {
                this.updateSdkListAndSelect((Sdk)selectedSdk);
            } else {
                Sdk currentSelectedSdk = this.getEditableSelectedSdk();
                if (currentSelectedSdk != null && this.myProjectSdksModel.findSdk(currentSelectedSdk.getName()) != null) {
                    this.updateSdkListAndSelect(currentSelectedSdk);
                } else {
                    this.updateSdkListAndSelect(null);
                }
            }
        }), reset -> {
            if (reset.booleanValue()) {
                this.updateSdkListAndSelect(this.getEditableSelectedSdk());
            }
        });
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return !Comparing.equal((Object)this.getSdk(), (Object)this.getOriginalSelectedSdk());
    }

    @Nullable
    protected Sdk getOriginalSelectedSdk() {
        Sdk editableSdk = this.getEditableSelectedSdk();
        return editableSdk == null ? null : this.myProjectSdksModel.findSdk(editableSdk);
    }

    @Nullable
    protected Sdk getEditableSelectedSdk() {
        return (Sdk)this.mySdkCombo.getSelectedItem();
    }

    @Nullable
    protected Sdk getSdk() {
        if (this.myModule == null) {
            return ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
        return rootManager.getSdk();
    }

    public void apply() {
        Sdk selectedSdk = this.getOriginalSelectedSdk();
        if (selectedSdk != null) {
            ((PythonSdkType)selectedSdk.getSdkType()).setupSdkPaths(selectedSdk);
        }
        this.setSdk(selectedSdk);
    }

    protected void setSdk(@Nullable Sdk item) {
        Sdk currentSdk = this.getSdk();
        PyTransferredSdkRootsKt.removeTransferredRootsFromModulesWithInheritedSdk(this.myProject, currentSdk);
        PySdkExtKt.setPythonSdk(this.myProject, item);
        PyTransferredSdkRootsKt.transferRootsToModulesWithInheritedSdk(this.myProject, item);
        if (this.myModule != null) {
            PyTransferredSdkRootsKt.removeTransferredRoots(this.myModule, currentSdk);
            PySdkExtKt.setPythonSdk(this.myModule, item);
            PyTransferredSdkRootsKt.transferRoots(this.myModule, item);
        }
    }

    public void reset() {
        Sdk sdk = this.getSdk();
        this.updateSdkListAndSelect(sdk);
    }

    @NotNull
    protected List<Sdk> getAvailableSdks() {
        List<Sdk> list = this.myInterpreterList.getAllPythonSdks(this.myProject);
        if (list == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(20);
        }
        return list;
    }

    private void updateSdkListAndSelect(@Nullable Sdk selectedSdk) {
        List<Sdk> allPythonSdks = this.getAvailableSdks();
        ArrayList<String> items = new ArrayList<String>();
        items.add(null);
        Map<PyRenderedSdkType, List<Sdk>> moduleSdksByTypes2 = PySdkRenderingKt.groupModuleSdksByTypes(allPythonSdks, this.myModule, (Function1<? super Sdk, Boolean>)((Function1)PythonSdkUtil::isInvalid));
        PyRenderedSdkType[] renderedSdkTypes = PyRenderedSdkType.values();
        for (int i = 0; i < renderedSdkTypes.length; ++i) {
            PyRenderedSdkType currentSdkType = renderedSdkTypes[i];
            if (!moduleSdksByTypes2.containsKey((Object)currentSdkType)) continue;
            if (i != 0) {
                items.add("separator");
            }
            items.addAll((Collection)moduleSdksByTypes2.get((Object)currentSdkType));
        }
        items.add("separator");
        items.add(PyActiveSdkConfigurable.getShowAll());
        this.mySdkCombo.setRenderer((ListCellRenderer)((Object)new PySdkListCellRenderer()));
        Sdk selection = this.getEditableSdkUsingOriginal(selectedSdk);
        this.mySdkCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)selection));
        this.mySdkCombo.setSelectedItem((Object)selection);
        this.onSdkSelected();
    }

    @Nullable
    protected Sdk getEditableSdkUsingOriginal(@Nullable Sdk sdk) {
        return sdk == null ? null : this.myProjectSdksModel.findSdk(sdk.getName());
    }

    public void disposeUIResources() {
        this.myInterpreterList.disposeModel();
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    private static String getShowAll() {
        return PyBundle.message("active.sdk.dialog.show.all.item", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContextComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSdkCreated";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/configuration/PyActiveSdkConfigurable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onShowAllSelected";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSdkSelected";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkComboBox";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onShowDetails";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalAction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackagesPanel";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagesNotificationPanel";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/configuration/PyActiveSdkConfigurable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddInterpreterPopup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSdkComboBox";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDetailsButton";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPanel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAddInterpreterPopup";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 20: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkComboBox";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildDetailsButton";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildPanel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "onShowDetailsClicked";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SdkAddedCallback
    implements NullableConsumer<Sdk> {
        private SdkAddedCallback() {
        }

        public void consume(Sdk sdk) {
            if (sdk != null && PyActiveSdkConfigurable.this.myProjectSdksModel.findSdk(sdk.getName()) == null) {
                PyActiveSdkConfigurable.this.myProjectSdksModel.addSdk(sdk);
                try {
                    PyActiveSdkConfigurable.this.myProjectSdksModel.apply(null, true);
                }
                catch (ConfigurationException e) {
                    LOG.error((Throwable)e);
                }
                PyActiveSdkConfigurable.this.updateSdkListAndSelect(sdk);
            }
        }
    }
}

