/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.run.PythonProcessHandler;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class PyConsoleProcessHandler
extends PythonProcessHandler {
    private final PythonConsoleView myConsoleView;
    private final PydevConsoleCommunication myPydevConsoleCommunication;

    public PyConsoleProcessHandler(Process process2, @NotNull PythonConsoleView consoleView, @NotNull PydevConsoleCommunication pydevConsoleCommunication, @NotNull String commandLine, @NotNull Charset charset) {
        if (consoleView == null) {
            PyConsoleProcessHandler.$$$reportNull$$$0(0);
        }
        if (pydevConsoleCommunication == null) {
            PyConsoleProcessHandler.$$$reportNull$$$0(1);
        }
        if (commandLine == null) {
            PyConsoleProcessHandler.$$$reportNull$$$0(2);
        }
        if (charset == null) {
            PyConsoleProcessHandler.$$$reportNull$$$0(3);
        }
        super(process2, commandLine, charset);
        this.myConsoleView = consoleView;
        this.myPydevConsoleCommunication = pydevConsoleCommunication;
        Disposer.register((Disposable)consoleView, (Disposable)new Disposable(){

            public void dispose() {
                if (!PyConsoleProcessHandler.this.isProcessTerminated()) {
                    PyConsoleProcessHandler.this.destroyProcess();
                }
            }
        });
    }

    public void coloredTextAvailable(@NotNull String text2, @NotNull Key attributes) {
        if (text2 == null) {
            PyConsoleProcessHandler.$$$reportNull$$$0(4);
        }
        if (attributes == null) {
            PyConsoleProcessHandler.$$$reportNull$$$0(5);
        }
        String string = PyConsoleUtil.processPrompts((LanguageConsoleView)this.myConsoleView, text2);
        super.coloredTextAvailable(string, attributes);
    }

    protected void closeStreams() {
        this.doCloseCommunication();
        super.closeStreams();
    }

    public boolean isSilentlyDestroyOnClose() {
        return !this.myPydevConsoleCommunication.isExecuting();
    }

    public boolean shouldKillProcessSoftly() {
        return false;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
        if (options == null) {
            PyConsoleProcessHandler.$$$reportNull$$$0(6);
        }
        return options;
    }

    private void doCloseCommunication() {
        if (this.myPydevConsoleCommunication != null) {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                try {
                    this.myPydevConsoleCommunication.close();
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    @NotNull
    public PydevConsoleCommunication getPydevConsoleCommunication() {
        PydevConsoleCommunication pydevConsoleCommunication = this.myPydevConsoleCommunication;
        if (pydevConsoleCommunication == null) {
            PyConsoleProcessHandler.$$$reportNull$$$0(7);
        }
        return pydevConsoleCommunication;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pydevConsoleCommunication";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PyConsoleProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleProcessHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readerOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPydevConsoleCommunication";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "coloredTextAvailable";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

