/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev.dataviewer;

import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractFrameCommand;
import com.jetbrains.python.debugger.pydev.GetVariableCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandAction;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataViewerCommand
extends AbstractFrameCommand {
    @NotNull
    private final String myVariableName;
    @NotNull
    private final DataViewerCommandAction myAction;
    private final String @Nullable [] myArgs;
    @Nullable
    private DataViewerCommandResult myResult;

    public DataViewerCommand(@NotNull RemoteDebugger debugger, @NotNull String threadId, @NotNull String frameId, @NotNull PyDebugValue var, @NotNull DataViewerCommandAction action, String @Nullable [] args2) {
        if (debugger == null) {
            DataViewerCommand.$$$reportNull$$$0(0);
        }
        if (threadId == null) {
            DataViewerCommand.$$$reportNull$$$0(1);
        }
        if (frameId == null) {
            DataViewerCommand.$$$reportNull$$$0(2);
        }
        if (var == null) {
            DataViewerCommand.$$$reportNull$$$0(3);
        }
        if (action == null) {
            DataViewerCommand.$$$reportNull$$$0(4);
        }
        super(debugger, 210, threadId, frameId);
        this.myVariableName = GetVariableCommand.composeName(var);
        this.myAction = action;
        this.myArgs = args2;
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        super.buildPayload(payload);
        payload.add(this.myVariableName);
        payload.add(this.myAction.name());
        if (this.myArgs != null) {
            for (String arg : this.myArgs) {
                payload.add(arg);
            }
        }
    }

    @NotNull
    public DataViewerCommandResult getResult() {
        if (this.myResult == null) {
            DataViewerCommandResult dataViewerCommandResult = DataViewerCommandResult.makeErrorResult(DataViewerCommandResult.ResultType.UNHANDLED_ERROR, "No response received");
            if (dataViewerCommandResult == null) {
                DataViewerCommand.$$$reportNull$$$0(5);
            }
            return dataViewerCommandResult;
        }
        DataViewerCommandResult dataViewerCommandResult = this.myResult;
        if (dataViewerCommandResult == null) {
            DataViewerCommand.$$$reportNull$$$0(6);
        }
        return dataViewerCommandResult;
    }

    @Override
    protected void processResponse(@NotNull ProtocolFrame response) {
        if (response == null) {
            DataViewerCommand.$$$reportNull$$$0(7);
        }
        this.myResult = DataViewerCommand.isErrorCommand(response.getCommand()) ? DataViewerCommandResult.errorFromExportTraceback(response.getPayload()) : DataViewerCommandResult.makeSuccessResult(response.getPayload());
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/dataviewer/DataViewerCommand";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/dataviewer/DataViewerCommand";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processResponse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

