/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyTypedDictTypeProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddMethodQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassHasNoInitInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyClassHasNoInitInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyClassHasNoInitInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyClassHasNoInitInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context2) {
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context2);
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            PyClass outerClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            assert (node != null);
            if (outerClass != null && StringUtil.equalsIgnoreCase((CharSequence)"meta", (CharSequence)node.getName())) {
                return;
            }
            List types = node.getAncestorTypes(this.myTypeEvalContext);
            if (PyTypedDictTypeProvider.Companion.isTypingTypedDictInheritor(node, this.myTypeEvalContext)) {
                return;
            }
            for (PyClassLikeType type : types) {
                if (type == null) {
                    return;
                }
                String qName = type.getClassQName();
                if (qName != null && qName.contains("TestCase")) {
                    return;
                }
                if (type instanceof PyClassType) continue;
                return;
            }
            PyFunction init = node.findInitOrNew(true, this.myTypeEvalContext);
            if (init == null) {
                this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.class.has.no.init", new Object[0]), new AddMethodQuickFix("__init__", node.getName(), false));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyClassHasNoInitInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

