/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyTypeCheckerInspectionProblemRegistrar;
import com.jetbrains.python.inspections.quickfix.PyMakeFunctionReturnTypeQuickFix;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeCheckerInspection
extends PyInspection {
    private static final Logger LOG = Logger.getInstance((String)PyTypeCheckerInspection.class.getName());
    private static final Key<Long> TIME_KEY = Key.create((String)"PyTypeCheckerInspection.StartTime");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            session.putUserData(TIME_KEY, (Object)System.nanoTime());
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        Long startTime;
        if (session == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(2);
        }
        if (problemsHolder == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(3);
        }
        if (LOG.isDebugEnabled() && (startTime = (Long)session.getUserData(TIME_KEY)) != null) {
            LOG.debug(String.format("[%d] elapsed time: %d ms\n", Thread.currentThread().getId(), (System.nanoTime() - startTime) / 1000000L));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectionFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class AnalyzeArgumentResult {
        @NotNull
        private final PyExpression myArgument;
        @Nullable
        private final PyType myExpectedType;
        @Nullable
        private final PyType myExpectedTypeAfterSubstitution;
        @Nullable
        private final PyType myActualType;
        private final boolean myIsMatched;

        AnalyzeArgumentResult(@NotNull PyExpression argument, @Nullable PyType expectedType, @Nullable PyType expectedTypeAfterSubstitution, @Nullable PyType actualType, boolean isMatched) {
            if (argument == null) {
                AnalyzeArgumentResult.$$$reportNull$$$0(0);
            }
            this.myArgument = argument;
            this.myExpectedType = expectedType;
            this.myExpectedTypeAfterSubstitution = expectedTypeAfterSubstitution;
            this.myActualType = actualType;
            this.myIsMatched = isMatched;
        }

        @NotNull
        public PyExpression getArgument() {
            PyExpression pyExpression = this.myArgument;
            if (pyExpression == null) {
                AnalyzeArgumentResult.$$$reportNull$$$0(1);
            }
            return pyExpression;
        }

        @Nullable
        public PyType getExpectedType() {
            return this.myExpectedType;
        }

        @Nullable
        public PyType getExpectedTypeAfterSubstitution() {
            return this.myExpectedTypeAfterSubstitution;
        }

        @Nullable
        public PyType getActualType() {
            return this.myActualType;
        }

        public boolean isMatched() {
            return this.myIsMatched;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeArgumentResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeArgumentResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class AnalyzeCalleeResults {
        @NotNull
        private final PyCallableType myCallableType;
        @Nullable
        private final PyCallable myCallable;
        @NotNull
        private final List<AnalyzeArgumentResult> myResults;

        AnalyzeCalleeResults(@NotNull PyCallableType callableType, @Nullable PyCallable callable, @NotNull List<AnalyzeArgumentResult> results) {
            if (callableType == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(0);
            }
            if (results == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(1);
            }
            this.myCallableType = callableType;
            this.myCallable = callable;
            this.myResults = results;
        }

        @NotNull
        public PyCallableType getCallableType() {
            PyCallableType pyCallableType = this.myCallableType;
            if (pyCallableType == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(2);
            }
            return pyCallableType;
        }

        @Nullable
        public PyCallable getCallable() {
            return this.myCallable;
        }

        @NotNull
        public List<AnalyzeArgumentResult> getResults() {
            List<AnalyzeArgumentResult> list = this.myResults;
            if (list == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callableType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeCalleeResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeCalleeResults";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallableType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context2) {
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context2);
        }

        @Deprecated
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            this.checkCallSite(node);
        }

        @Override
        public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            this.checkCallSite(node);
        }

        @Override
        public void visitPySubscriptionExpression(@NotNull PySubscriptionExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (this.myTypeEvalContext.getType(node.getOperand()) instanceof PyTypedDictType) {
                return;
            }
            this.checkCallSite(node);
        }

        @Override
        public void visitPyForStatement(@NotNull PyForStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            this.checkIteratedValue(node.getForPart().getSource(), node.isAsync());
        }

        @Override
        public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
            ScopeOwner owner;
            if (node == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if ((owner = ScopeUtil.getScopeOwner((PsiElement)node)) instanceof PyFunction) {
                PyFunction function = (PyFunction)owner;
                PyAnnotation annotation = function.getAnnotation();
                String typeCommentAnnotation = function.getTypeCommentAnnotation();
                if (annotation != null || typeCommentAnnotation != null) {
                    PyNoneType actual;
                    PyExpression returnExpr = node.getExpression();
                    PyType expected = this.getExpectedReturnType(function);
                    PyType pyType = actual = returnExpr != null ? this.tryPromotingType(returnExpr, expected) : PyNoneType.INSTANCE;
                    if (!PyTypeChecker.match(expected, (PyType)actual, this.myTypeEvalContext)) {
                        String expectedName = PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext);
                        String actualName = PythonDocumentationProvider.getTypeName(actual, this.myTypeEvalContext);
                        PyMakeFunctionReturnTypeQuickFix localQuickFix = new PyMakeFunctionReturnTypeQuickFix(function, returnExpr, actual, this.myTypeEvalContext);
                        PyMakeFunctionReturnTypeQuickFix globalQuickFix = new PyMakeFunctionReturnTypeQuickFix(function, returnExpr, null, this.myTypeEvalContext);
                        this.registerProblem((PsiElement)(returnExpr != null ? returnExpr : node), PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", expectedName, actualName), localQuickFix, globalQuickFix);
                    }
                }
            }
        }

        @Nullable
        private PyType getExpectedReturnType(@NotNull PyFunction function) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            return Visitor.getExpectedReturnType(function, this.myTypeEvalContext);
        }

        @Nullable
        public static PyType getExpectedReturnType(@NotNull PyFunction function, @NotNull TypeEvalContext typeEvalContext) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            if (typeEvalContext == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            PyType returnType = typeEvalContext.getReturnType(function);
            if (function.isAsync() || function.isGenerator()) {
                return (PyType)Ref.deref(PyTypingTypeProvider.coroutineOrGeneratorElementType(returnType));
            }
            return returnType;
        }

        @Nullable
        public static PyType getActualReturnType(@NotNull PyFunction function, @Nullable PyExpression returnExpr, @NotNull TypeEvalContext context2) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(11);
            }
            PyType returnTypeExpected = Visitor.getExpectedReturnType(function, context2);
            return returnExpr != null ? Visitor.tryPromotingType(returnExpr, returnTypeExpected, context2) : PyNoneType.INSTANCE;
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            PyType actual;
            ScopeOwner owner;
            if (node == null) {
                Visitor.$$$reportNull$$$0(12);
            }
            if ((owner = ScopeUtil.getScopeOwner(node)) instanceof PyClass) {
                return;
            }
            PyExpression value = node.findAssignedValue();
            if (value == null) {
                return;
            }
            PyType expected = this.myTypeEvalContext.getType(node);
            if (!PyTypeChecker.match(expected, actual = this.tryPromotingType(value, expected), this.myTypeEvalContext)) {
                String expectedName = PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext);
                String actualName = PythonDocumentationProvider.getTypeName(actual, this.myTypeEvalContext);
                this.registerProblem((PsiElement)value, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", expectedName, actualName));
            }
        }

        @Nullable
        private PyType tryPromotingType(@NotNull PyExpression value, @Nullable PyType expected) {
            if (value == null) {
                Visitor.$$$reportNull$$$0(13);
            }
            return Visitor.tryPromotingType(value, expected, this.myTypeEvalContext);
        }

        @Nullable
        public static PyType tryPromotingType(@NotNull PyExpression value, @Nullable PyType expected, @NotNull TypeEvalContext context2) {
            PyType promotedToLiteral;
            if (value == null) {
                Visitor.$$$reportNull$$$0(14);
            }
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(15);
            }
            if ((promotedToLiteral = PyLiteralType.Companion.promoteToLiteral(value, expected, context2, null)) != null) {
                return promotedToLiteral;
            }
            return context2.getType(value);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(16);
            }
            PyAnnotation annotation = node.getAnnotation();
            String typeCommentAnnotation = node.getTypeCommentAnnotation();
            if (annotation != null || typeCommentAnnotation != null) {
                if (!PyUtil.isEmptyFunction(node)) {
                    ReturnVisitor visitor2 = new ReturnVisitor(node);
                    node.getStatementList().accept(visitor2);
                    if (!visitor2.myHasReturns) {
                        PyType expected = this.getExpectedReturnType(node);
                        String expectedName = PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext);
                        if (expected != null && !(expected instanceof PyNoneType)) {
                            this.registerProblem((PsiElement)(annotation != null ? annotation.getValue() : node.getTypeComment()), PyPsiBundle.message("INSP.type.checker.expected.to.return.type.got.no.return", expectedName));
                        }
                    }
                }
                if (PyUtil.isInitMethod(node) && !(this.getExpectedReturnType(node) instanceof PyNoneType)) {
                    this.registerProblem((PsiElement)(annotation != null ? annotation.getValue() : node.getTypeComment()), PyPsiBundle.message("INSP.type.checker.init.should.return.none", new Object[0]));
                }
            }
        }

        @Override
        public void visitPyComprehensionElement(@NotNull PyComprehensionElement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(17);
            }
            super.visitPyComprehensionElement(node);
            for (PyComprehensionForComponent forComponent : node.getForComponents()) {
                this.checkIteratedValue(forComponent.getIteratedList(), forComponent.isAsync());
            }
        }

        private void checkCallSite(@NotNull PyCallSiteExpression callSite) {
            List calleesResults;
            if (callSite == null) {
                Visitor.$$$reportNull$$$0(18);
            }
            if (!Visitor.matchedCalleeResultsExist(calleesResults = ((StreamEx)StreamEx.of(PyCallExpressionHelper.mapArguments(callSite, this.getResolveContext())).filter(mapping -> mapping.getUnmappedArguments().isEmpty() && mapping.getUnmappedParameters().isEmpty())).map(mapping -> this.analyzeCallee(callSite, (PyCallExpression.PyArgumentsMapping)mapping)).nonNull().toList())) {
                PyTypeCheckerInspectionProblemRegistrar.registerProblem(this, callSite, Visitor.getArgumentTypes(calleesResults), calleesResults, this.myTypeEvalContext);
            }
        }

        private void checkIteratedValue(@Nullable PyExpression iteratedValue, boolean isAsync) {
            if (iteratedValue != null) {
                String iterableClassName;
                PyType type = this.myTypeEvalContext.getType(iteratedValue);
                String string = iterableClassName = isAsync ? "AsyncIterable" : "Iterable";
                if (type != null && !PyTypeChecker.isUnknown(type, this.myTypeEvalContext) && !PyABCUtil.isSubtype(type, iterableClassName, this.myTypeEvalContext)) {
                    String typeName = PythonDocumentationProvider.getTypeName(type, this.myTypeEvalContext);
                    String qualifiedName = "collections." + iterableClassName;
                    this.registerProblem((PsiElement)iteratedValue, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", qualifiedName, typeName));
                }
            }
        }

        @Nullable
        private AnalyzeCalleeResults analyzeCallee(@NotNull PyCallSiteExpression callSite, @NotNull PyCallExpression.PyArgumentsMapping mapping) {
            PyCallableParameter keywordContainer;
            PyCallableParameter positionalContainer;
            PyCallableType callableType;
            if (callSite == null) {
                Visitor.$$$reportNull$$$0(19);
            }
            if (mapping == null) {
                Visitor.$$$reportNull$$$0(20);
            }
            if ((callableType = mapping.getCallableType()) == null) {
                return null;
            }
            ArrayList<AnalyzeArgumentResult> result = new ArrayList<AnalyzeArgumentResult>();
            PyExpression receiver = callSite.getReceiver(callableType.getCallable());
            PyTypeChecker.GenericSubstitutions substitutions = PyTypeChecker.unifyReceiverWithParamSpecs(receiver, this.myTypeEvalContext);
            Map<PyExpression, PyCallableParameter> mappedParameters = mapping.getMappedParameters();
            Map<PyExpression, PyCallableParameter> regularMappedParameters = PyCallExpressionHelper.getRegularMappedParameters(mappedParameters);
            for (Map.Entry<PyExpression, PyCallableParameter> entry : regularMappedParameters.entrySet()) {
                PyType actual;
                PyCallableParameter parameter;
                PyType expected;
                PyExpression argument = entry.getKey();
                PyType promotedToLiteral = PyLiteralType.Companion.promoteToLiteral(argument, expected = (parameter = entry.getValue()).getArgumentType(this.myTypeEvalContext), this.myTypeEvalContext, substitutions);
                PyType pyType = actual = promotedToLiteral != null ? promotedToLiteral : this.myTypeEvalContext.getType(argument);
                if (expected instanceof PyParamSpecType) {
                    List<PyExpression> allArguments = callSite.getArguments(callableType.getCallable());
                    this.analyzeParamSpec((PyParamSpecType)expected, allArguments, substitutions, result);
                    break;
                }
                if (expected instanceof PyConcatenateType) {
                    List<PyExpression> allArguments = callSite.getArguments(callableType.getCallable());
                    if (allArguments.isEmpty()) break;
                    PyConcatenateType concatenateType = (PyConcatenateType)expected;
                    List<PyType> firstExpectedTypes = concatenateType.getFirstTypes();
                    int argumentRightBound = Math.min(firstExpectedTypes.size(), allArguments.size());
                    List<PyExpression> firstArguments = allArguments.subList(0, argumentRightBound);
                    this.matchArgumentsAndTypes(firstArguments, firstExpectedTypes, substitutions, result);
                    if (argumentRightBound >= allArguments.size()) break;
                    PyParamSpecType paramSpec = concatenateType.getParamSpec();
                    List<PyExpression> restArguments = allArguments.subList(argumentRightBound, allArguments.size());
                    this.analyzeParamSpec(paramSpec, restArguments, substitutions, result);
                    break;
                }
                boolean matched = this.matchParameterAndArgument(expected, actual, substitutions);
                result.add(new AnalyzeArgumentResult(argument, expected, this.substituteGenerics(expected, substitutions), actual, matched));
            }
            if ((positionalContainer = PyCallExpressionHelper.getMappedPositionalContainer(mappedParameters)) != null) {
                result.addAll(this.analyzeContainerMapping(positionalContainer, PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(mappedParameters), substitutions));
            }
            if ((keywordContainer = PyCallExpressionHelper.getMappedKeywordContainer(mappedParameters)) != null) {
                result.addAll(this.analyzeContainerMapping(keywordContainer, PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(mappedParameters), substitutions));
            }
            return new AnalyzeCalleeResults(callableType, callableType.getCallable(), result);
        }

        private void analyzeParamSpec(@NotNull PyParamSpecType paramSpec, @NotNull List<PyExpression> arguments, @NotNull PyTypeChecker.GenericSubstitutions substitutions, @NotNull List<AnalyzeArgumentResult> result) {
            PyParamSpecType substParamSpec;
            List<PyCallableParameter> parameters;
            if (paramSpec == null) {
                Visitor.$$$reportNull$$$0(21);
            }
            if (arguments == null) {
                Visitor.$$$reportNull$$$0(22);
            }
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(23);
            }
            if (result == null) {
                Visitor.$$$reportNull$$$0(24);
            }
            if ((parameters = (paramSpec = (substParamSpec = substitutions.getParamSpecs().get(paramSpec)) == null ? paramSpec : substParamSpec).getParameters()) == null) {
                return;
            }
            List parametersTypes = ContainerUtil.map(parameters, it -> it.getType(this.myTypeEvalContext));
            this.matchArgumentsAndTypes(arguments, parametersTypes, substitutions, result);
        }

        private void matchArgumentsAndTypes(@NotNull List<PyExpression> arguments, @NotNull List<PyType> types, @NotNull PyTypeChecker.GenericSubstitutions substitutions, @NotNull List<AnalyzeArgumentResult> result) {
            if (arguments == null) {
                Visitor.$$$reportNull$$$0(25);
            }
            if (types == null) {
                Visitor.$$$reportNull$$$0(26);
            }
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(27);
            }
            if (result == null) {
                Visitor.$$$reportNull$$$0(28);
            }
            int size = Math.min(arguments.size(), types.size());
            for (int i = 0; i < size; ++i) {
                PyType expected = types.get(i);
                PyExpression argument = arguments.get(i);
                PyType actual = this.myTypeEvalContext.getType(argument);
                boolean matched = this.matchParameterAndArgument(expected, actual, substitutions);
                result.add(new AnalyzeArgumentResult(argument, expected, this.substituteGenerics(expected, substitutions), actual, matched));
            }
        }

        @NotNull
        private List<AnalyzeArgumentResult> analyzeContainerMapping(@NotNull PyCallableParameter container, @NotNull List<PyExpression> arguments, @NotNull PyTypeChecker.GenericSubstitutions substitutions) {
            if (container == null) {
                Visitor.$$$reportNull$$$0(29);
            }
            if (arguments == null) {
                Visitor.$$$reportNull$$$0(30);
            }
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(31);
            }
            PyType expected = container.getArgumentType(this.myTypeEvalContext);
            PyType expectedWithSubstitutions = this.substituteGenerics(expected, substitutions);
            if (PyTypeChecker.hasGenerics(expected, this.myTypeEvalContext)) {
                PyType actual = PyUnionType.union(ContainerUtil.map(arguments, this.myTypeEvalContext::getType));
                boolean matched = this.matchParameterAndArgument(expected, actual, substitutions);
                List list = ContainerUtil.map(arguments, argument -> new AnalyzeArgumentResult((PyExpression)argument, expected, expectedWithSubstitutions, actual, matched));
                if (list == null) {
                    Visitor.$$$reportNull$$$0(32);
                }
                return list;
            }
            List list = ContainerUtil.map(arguments, argument -> {
                PyType actual = this.myTypeEvalContext.getType((PyTypedElement)argument);
                boolean matched = this.matchParameterAndArgument(expected, actual, substitutions);
                return new AnalyzeArgumentResult((PyExpression)argument, expected, expectedWithSubstitutions, actual, matched);
            });
            if (list == null) {
                Visitor.$$$reportNull$$$0(33);
            }
            return list;
        }

        private boolean matchParameterAndArgument(@Nullable PyType parameterType, @Nullable PyType argumentType, @NotNull PyTypeChecker.GenericSubstitutions substitutions) {
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(34);
            }
            return PyTypeChecker.match(parameterType, argumentType, this.myTypeEvalContext, substitutions) && !PyProtocolsKt.matchingProtocolDefinitions(parameterType, argumentType, this.myTypeEvalContext);
        }

        @Nullable
        private PyType substituteGenerics(@Nullable PyType expectedArgumentType, @NotNull PyTypeChecker.GenericSubstitutions substitutions) {
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(35);
            }
            return PyTypeChecker.hasGenerics(expectedArgumentType, this.myTypeEvalContext) ? PyTypeChecker.substitute(expectedArgumentType, substitutions, this.myTypeEvalContext) : null;
        }

        private static boolean matchedCalleeResultsExist(@NotNull List<AnalyzeCalleeResults> calleesResults) {
            if (calleesResults == null) {
                Visitor.$$$reportNull$$$0(36);
            }
            return calleesResults.stream().anyMatch(calleeResults -> calleeResults.getResults().stream().allMatch(AnalyzeArgumentResult::isMatched));
        }

        @NotNull
        private static List<PyType> getArgumentTypes(@NotNull List<AnalyzeCalleeResults> calleesResults) {
            if (calleesResults == null) {
                Visitor.$$$reportNull$$$0(37);
            }
            List list = ContainerUtil.map((Collection)calleesResults.stream().map(AnalyzeCalleeResults::getResults).max(Comparator.comparingInt(List::size)).orElse(Collections.emptyList()), AnalyzeArgumentResult::getActualType);
            if (list == null) {
                Visitor.$$$reportNull$$$0(38);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 32: 
                case 33: 
                case 38: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 32: 
                case 33: 
                case 38: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeEvalContext";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callSite";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramSpec";
                    break;
                }
                case 22: 
                case 25: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 23: 
                case 27: 
                case 31: 
                case 34: 
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutions";
                    break;
                }
                case 24: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 32: 
                case 33: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor";
                    break;
                }
                case 36: 
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "calleesResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor";
                    break;
                }
                case 32: 
                case 33: {
                    objectArray = objectArray2;
                    objectArray2[1] = "analyzeContainerMapping";
                    break;
                }
                case 38: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgumentTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyBinaryExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPySubscriptionExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyForStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyReturnStatement";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpectedReturnType";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getActualReturnType";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyTargetExpression";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "tryPromotingType";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyFunction";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyComprehensionElement";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "checkCallSite";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeCallee";
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeParamSpec";
                    break;
                }
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "matchArgumentsAndTypes";
                    break;
                }
                case 29: 
                case 30: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeContainerMapping";
                    break;
                }
                case 32: 
                case 33: 
                case 38: {
                    break;
                }
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "matchParameterAndArgument";
                    break;
                }
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteGenerics";
                    break;
                }
                case 36: {
                    objectArray = objectArray;
                    objectArray[2] = "matchedCalleeResultsExist";
                    break;
                }
                case 37: {
                    objectArray = objectArray;
                    objectArray[2] = "getArgumentTypes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 32: 
                case 33: 
                case 38: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ReturnVisitor
        extends PyRecursiveElementVisitor {
            private final PyFunction myFunction;
            private boolean myHasReturns = false;

            ReturnVisitor(PyFunction function) {
                this.myFunction = function;
            }

            @Override
            public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
                if (node == null) {
                    ReturnVisitor.$$$reportNull$$$0(0);
                }
                if (ScopeUtil.getScopeOwner((PsiElement)node) == this.myFunction) {
                    this.myHasReturns = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor$ReturnVisitor", "visitPyReturnStatement"));
            }
        }
    }
}

