/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.unresolvedReference;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyCustomType;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.PySubstitutionChunkReference;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.OptimizeImportsQuickFix;
import com.jetbrains.python.documentation.docstrings.DocStringParameterReference;
import com.jetbrains.python.documentation.docstrings.DocStringTypeReference;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyInspectionsUtil;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.AddFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.AddMethodQuickFix;
import com.jetbrains.python.inspections.quickfix.CreateClassQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRenameUnresolvedRefQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefCreateFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefTrueFalseQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddParameterQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddSelfQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.references.PyFromImportNameReference;
import com.jetbrains.python.psi.impl.references.PyImportReference;
import com.jetbrains.python.psi.impl.references.PyOperatorReference;
import com.jetbrains.python.psi.impl.references.hasattr.PyHasAttrHelper;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassMembersProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyFunctionTypeImpl;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyUnresolvedReferencesVisitor
extends PyInspectionVisitor {
    private final Set<PyImportedNameDefiner> myAllImports;
    private final Set<PyImportedNameDefiner> myImportsInsideGuard;
    private final Set<PyImportedNameDefiner> myUsedImports;
    private final ImmutableSet<String> myIgnoredIdentifiers;
    private final PyInspection myInspection;
    private volatile Boolean myIsEnabled;

    protected PyUnresolvedReferencesVisitor(@Nullable ProblemsHolder holder, List<String> ignoredIdentifiers, @NotNull PyInspection inspection, @NotNull TypeEvalContext context2) {
        if (inspection == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(1);
        }
        super(holder, context2);
        this.myAllImports = Collections.synchronizedSet(new HashSet());
        this.myImportsInsideGuard = Collections.synchronizedSet(new HashSet());
        this.myUsedImports = Collections.synchronizedSet(new HashSet());
        this.myIsEnabled = null;
        this.myIgnoredIdentifiers = ImmutableSet.copyOf(ignoredIdentifiers);
        this.myInspection = inspection;
    }

    @Override
    public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(2);
        }
        this.checkSlotsAndProperties(node);
    }

    private void checkSlotsAndProperties(PyQualifiedExpression node) {
        PyType type;
        PyExpression qualifier = node.getQualifier();
        String attrName = node.getReferencedName();
        if (qualifier != null && attrName != null && (type = this.myTypeEvalContext.getType(qualifier)) instanceof PyClassType && !((PyClassType)type).isAttributeWritable(attrName, this.myTypeEvalContext)) {
            ASTNode nameNode = node.getNameElement();
            PyQualifiedExpression e = nameNode != null ? nameNode.getPsi() : node;
            this.registerProblem((PsiElement)e, PyPsiBundle.message("INSP.unresolved.refs.class.object.has.no.attribute", type.getName(), attrName));
        }
    }

    @Override
    public void visitPyImportElement(@NotNull PyImportElement node) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(3);
        }
        super.visitPyImportElement(node);
        PyFromImportStatement fromImport = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyFromImportStatement.class);
        if (this.isEnabled((PsiElement)node) && (fromImport == null || !fromImport.isFromFuture())) {
            this.myAllImports.add(node);
        }
    }

    @Override
    public void visitPyStarImportElement(@NotNull PyStarImportElement node) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(4);
        }
        super.visitPyStarImportElement(node);
        if (this.isEnabled((PsiElement)node)) {
            this.myAllImports.add(node);
        }
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(5);
        }
        super.visitComment(comment);
        if (comment instanceof PsiLanguageInjectionHost) {
            this.processInjection((PsiLanguageInjectionHost)comment);
        }
    }

    @Override
    public void visitPyElement(@NotNull PyElement node) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(6);
        }
        super.visitPyElement(node);
        PsiFile file = node.getContainingFile();
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)node.getProject());
        if (injectedLanguageManager.isInjectedFragment(file)) {
            PsiLanguageInjectionHost host = injectedLanguageManager.getInjectionHost((PsiElement)node);
            this.processInjection(host);
        }
        if (node instanceof PyReferenceOwner) {
            PyResolveContext resolveContext = PyResolveContext.defaultContext(this.myTypeEvalContext);
            this.processReference(node, (PsiReference)((PyReferenceOwner)node).getReference(resolveContext));
        } else {
            if (node instanceof PsiLanguageInjectionHost) {
                this.processInjection((PsiLanguageInjectionHost)node);
            }
            for (PsiReference reference : node.getReferences()) {
                this.processReference(node, reference);
            }
        }
    }

    private void processInjection(@Nullable PsiLanguageInjectionHost node) {
        if (node == null) {
            return;
        }
        List files = InjectedLanguageManager.getInstance((Project)node.getProject()).getInjectedPsiFiles((PsiElement)node);
        if (files != null) {
            for (Pair pair : files) {
                new PyRecursiveElementVisitor(){

                    @Override
                    public void visitPyElement(@NotNull PyElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.visitPyElement(element);
                        if (element instanceof PyReferenceOwner) {
                            PyResolveContext resolveContext = PyResolveContext.defaultContext(PyUnresolvedReferencesVisitor.this.myTypeEvalContext);
                            PsiPolyVariantReference reference = ((PyReferenceOwner)element).getReference(resolveContext);
                            PyUnresolvedReferencesVisitor.this.markTargetImportsAsUsed(reference);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesVisitor$1", "visitPyElement"));
                    }
                }.visitElement((PsiElement)pair.getFirst());
            }
        }
    }

    private void markTargetImportsAsUsed(@NotNull PsiPolyVariantReference reference) {
        ResolveResult[] resolveResults;
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(7);
        }
        for (ResolveResult resolveResult : resolveResults = reference.multiResolve(false)) {
            PyImportedNameDefiner definer;
            if (!(resolveResult instanceof ImportedResolveResult) || (definer = ((ImportedResolveResult)resolveResult).getDefiner()) == null) continue;
            this.myUsedImports.add(definer);
        }
    }

    private void processReference(@NotNull PyElement node, @Nullable PsiReference reference) {
        boolean unresolved;
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(8);
        }
        if (!this.isEnabled((PsiElement)node) || reference == null || reference.isSoft()) {
            return;
        }
        PyExceptPart guard = PyUnresolvedReferencesVisitor.getImportErrorGuard(node);
        if (guard != null) {
            this.processReferenceInImportGuard(node, guard);
            return;
        }
        if (node instanceof PyQualifiedExpression) {
            PyQualifiedExpression qExpr = (PyQualifiedExpression)node;
            PyExpression qualifier = qExpr.getQualifier();
            String name = node.getName();
            if (qualifier != null && name != null && PyHasAttrHelper.INSTANCE.getNamesFromHasAttrs((PsiElement)node, qualifier).contains(name)) {
                return;
            }
        }
        PsiElement target = null;
        if (reference instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference poly = (PsiPolyVariantReference)reference;
            ResolveResult[] resolveResults = poly.multiResolve(false);
            unresolved = resolveResults.length == 0;
            for (ResolveResult resolveResult : resolveResults) {
                PyImportedNameDefiner definer;
                if (target == null && resolveResult.isValidResult()) {
                    target = resolveResult.getElement();
                }
                if (!(resolveResult instanceof ImportedResolveResult) || (definer = ((ImportedResolveResult)resolveResult).getDefiner()) == null) continue;
                this.myUsedImports.add(definer);
            }
        } else {
            target = reference.resolve();
            boolean bl = unresolved = target == null;
        }
        if (unresolved) {
            boolean ignoreUnresolved = this.ignoreUnresolved(node, reference);
            if (!ignoreUnresolved) {
                HighlightSeverity severity;
                HighlightSeverity highlightSeverity = severity = reference instanceof PsiReferenceEx ? ((PsiReferenceEx)reference).getUnresolvedHighlightSeverity(this.myTypeEvalContext) : HighlightSeverity.ERROR;
                if (severity == null) {
                    return;
                }
                this.registerUnresolvedReferenceProblem(node, reference, severity);
            }
            if (node.getParent() instanceof PyImportElement) {
                this.myAllImports.remove(node.getParent());
            }
        } else if (reference instanceof PyImportReference && target == reference.getElement().getContainingFile() && !PyUnresolvedReferencesVisitor.isContainingFileImportAllowed(node, (PsiFile)target)) {
            this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.unresolved.refs.import.resolves.to.its.containing.file", new Object[0]));
        }
    }

    private void processReferenceInImportGuard(@NotNull PyElement node, @NotNull PyExceptPart guard) {
        PyImportElement importElement;
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(9);
        }
        if (guard == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(10);
        }
        if ((importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportElement.class)) != null) {
            List<PsiElement> allWrites;
            boolean hasWriteInsideGuard;
            String visibleName = importElement.getVisibleName();
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)importElement);
            if (visibleName != null && owner != null && !(hasWriteInsideGuard = (allWrites = ScopeUtil.getElementsOfAccessType(visibleName, owner, ReadWriteInstruction.ACCESS.WRITE)).stream().anyMatch(e -> PsiTreeUtil.isAncestor((PsiElement)guard, (PsiElement)e, (boolean)false))) && !PyUnresolvedReferencesVisitor.shouldSkipMissingWriteInsideGuard(guard, visibleName)) {
                this.myImportsInsideGuard.add(importElement);
            }
        }
    }

    private void registerUnresolvedReferenceProblem(@NotNull PyElement node, @NotNull PsiReference reference, @NotNull HighlightSeverity severity) {
        String refName;
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(11);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(12);
        }
        if (severity == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(13);
        }
        if (reference instanceof DocStringTypeReference) {
            return;
        }
        String description = null;
        PsiElement element = reference.getElement();
        String text2 = element.getText();
        TextRange rangeInElement = reference.getRangeInElement();
        String refText = text2;
        if (rangeInElement.getStartOffset() >= 0 && rangeInElement.getEndOffset() > 0) {
            refText = rangeInElement.substring(text2);
        }
        String string = refName = element instanceof PyQualifiedExpression ? ((PyQualifiedExpression)element).getReferencedName() : refText;
        if (StringUtil.isEmpty((String)refName)) {
            return;
        }
        List<QualifiedName> qualifiedNames = PyUnresolvedReferencesVisitor.getCanonicalNames(reference, this.myTypeEvalContext);
        for (QualifiedName name : qualifiedNames) {
            String canonicalName = name.toString();
            for (String ignored : this.myIgnoredIdentifiers) {
                String prefix;
                if (!(ignored.endsWith(".*") ? canonicalName.startsWith(prefix = ignored.substring(0, ignored.length() - ".*".length())) : canonicalName.equals(ignored))) continue;
                return;
            }
        }
        if (this.myIgnoredIdentifiers.contains((Object)refName)) {
            return;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (element instanceof PyReferenceExpression) {
            PyReferenceExpression expr = (PyReferenceExpression)element;
            if (PyNames.COMPARISON_OPERATORS.contains(refName)) {
                return;
            }
            if (!expr.isQualified()) {
                if (PyInspectionsUtil.hasAnyInterruptedControlFlowPaths((PsiElement)expr)) {
                    return;
                }
                ContainerUtil.addIfNotNull(fixes, (Object)this.getTrueFalseQuickFix(expr, refText));
                ContainerUtil.addAll(fixes, this.getAddSelfFixes(this.myTypeEvalContext, node, expr));
                ContainerUtil.addIfNotNull(fixes, (Object)this.getCreateFunctionQuickFix(expr));
                ContainerUtil.addIfNotNull(fixes, (Object)this.getAddParameterQuickFix(refName, expr));
                fixes.add(new PyRenameUnresolvedRefQuickFix());
            }
            if (PyModuleType.getPossibleInstanceMembers().contains(refName)) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportElement.class), (Class[])new Class[]{PyTryExceptStatement.class, PyIfStatement.class}) != null) {
                severity = HighlightSeverity.WEAK_WARNING;
                description = PyPsiBundle.message("INSP.unresolved.refs.module.not.found", refText);
            }
        }
        if (reference instanceof PsiReferenceEx && description == null) {
            description = ((PsiReferenceEx)reference).getUnresolvedDescription();
        }
        if (description == null) {
            PyType type;
            PyExpression qualifier;
            boolean markedQualified = false;
            if (element instanceof PyQualifiedExpression) {
                if ("__qualname__".equals(refText) && !LanguageLevel.forElement(element).isPython2()) {
                    return;
                }
                if (PyNames.COMPARISON_OPERATORS.contains(refName)) {
                    return;
                }
            }
            if ((qualifier = PyUnresolvedReferencesVisitor.getReferenceQualifier(reference)) != null && (type = this.myTypeEvalContext.getType(qualifier)) != null) {
                if (this.ignoreUnresolvedMemberForType(type, reference, refName) || this.isDeclaredInSlots(type, refName)) {
                    return;
                }
                ContainerUtil.addAll(fixes, this.getCreateMemberFromUsageFixes(type, reference, refText));
                if (type instanceof PyClassType) {
                    PyClassType classType = (PyClassType)type;
                    if (reference instanceof PyOperatorReference) {
                        PyClassLikeType metaClassType;
                        String className = type.getName();
                        if (classType.isDefinition() && (metaClassType = classType.getMetaClassType(this.myTypeEvalContext, true)) != null) {
                            className = metaClassType.getName();
                        }
                        description = PyPsiBundle.message("INSP.unresolved.refs.class.does.not.define.operator", className, refName, ((PyOperatorReference)reference).getReadableOperatorName());
                    } else {
                        description = PyPsiBundle.message("INSP.unresolved.refs.unresolved.attribute.for.class", refText, type.getName());
                    }
                } else {
                    description = PyPsiBundle.message("INSP.unresolved.refs.cannot.find.reference.in.type", refText, type.getName());
                }
                markedQualified = true;
            }
            if (!markedQualified) {
                description = PyPsiBundle.message("INSP.unresolved.refs.unresolved.reference", refText);
                ContainerUtil.addAll(fixes, this.getAutoImportFixes(node, reference, element));
                ContainerUtil.addIfNotNull(fixes, (Object)this.getCreateClassFix(refText, element));
            }
        }
        ProblemHighlightType hl_type = severity == HighlightSeverity.WARNING ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (severity == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        ContainerUtil.addAll(fixes, this.getImportStatementQuickFixes(element));
        ContainerUtil.addAll(fixes, this.getAddIgnoredIdentifierQuickFixes(qualifiedNames));
        ContainerUtil.addAll(fixes, this.getInstallPackageQuickFixes(node, reference, refName));
        if (reference instanceof PySubstitutionChunkReference) {
            return;
        }
        this.getPluginQuickFixes(fixes, reference);
        this.registerProblem((PsiElement)node, description, hl_type, null, rangeInElement, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private boolean isDeclaredInSlots(@NotNull PyType type, @NotNull String attrName) {
        if (type == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(14);
        }
        if (attrName == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(15);
        }
        return ((StreamEx)PyTypeUtil.toStream(type).select(PyClassType.class).map(PyClassType::getPyClass).flatMap(cls -> StreamEx.of((Object)cls).append(cls.getAncestorClasses(this.myTypeEvalContext))).nonNull().filter(c -> c.isNewStyleClass(this.myTypeEvalContext))).flatCollection(PyClass::getOwnSlots).anyMatch(attrName::equals);
    }

    private boolean ignoreUnresolvedMemberForType(@NotNull PyType type, PsiReference reference, String name) {
        PyCallable callable;
        Object module;
        if (type == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(16);
        }
        if (PyTypeChecker.isUnknown(type, this.myTypeEvalContext)) {
            return true;
        }
        if (type instanceof PyStructuralType && ((PyStructuralType)type).isInferredFromUsages()) {
            return true;
        }
        if (type instanceof PyImportedModuleType && ((PyImportedModule)(module = ((PyImportedModuleType)type).getImportedModule())).resolve() == null) {
            return true;
        }
        if (type instanceof PyCustomType) {
            module = ((PyCustomType)type).getTypesToMimic().iterator();
            while (module.hasNext()) {
                PyClassLikeType mimic = (PyClassLikeType)module.next();
                if (!(mimic instanceof PyClassType) || !PyUtil.hasUnresolvedAncestors(((PyClassType)mimic).getPyClass(), this.myTypeEvalContext)) continue;
                return true;
            }
        }
        if (type instanceof PyClassType) {
            PyClass cls = ((PyClassType)type).getPyClass();
            if (PyTypeChecker.overridesGetAttr(cls, this.myTypeEvalContext)) {
                return true;
            }
            if (cls.findProperty(name, true, this.myTypeEvalContext) != null) {
                return true;
            }
            if (PyUtil.hasUnresolvedAncestors(cls, this.myTypeEvalContext)) {
                return true;
            }
            if (this.isDecoratedAsDynamic(cls, true)) {
                return true;
            }
            if (PyUnresolvedReferencesVisitor.hasUnresolvedDynamicMember((PyClassType)type, reference, name, this.myTypeEvalContext)) {
                return true;
            }
            if (this.isAwaitOnGeneratorBasedCoroutine(name, reference, cls)) {
                return true;
            }
        }
        if (type instanceof PyFunctionTypeImpl && (callable = ((PyFunctionTypeImpl)type).getCallable()) instanceof PyFunction && PyKnownDecoratorUtil.hasUnknownOrUpdatingAttributesDecorator((PyFunction)callable, this.myTypeEvalContext)) {
            return true;
        }
        if (type instanceof PyUnionType) {
            return ContainerUtil.exists(((PyUnionType)type).getMembers(), member -> this.ignoreUnresolvedMemberForType((PyType)member, reference, name));
        }
        if (type instanceof PyModuleType && (module = ((PyModuleType)type).getModule()).getLanguageLevel().isAtLeast(LanguageLevel.PYTHON37)) {
            return PyTypeChecker.definesGetAttr((PyFile)module, this.myTypeEvalContext);
        }
        for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
            if (!extension.ignoreUnresolvedMember(type, name, this.myTypeEvalContext)) continue;
            return true;
        }
        return false;
    }

    private boolean isDecoratedAsDynamic(@NotNull PyClass cls, boolean inherited) {
        if (cls == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(17);
        }
        if (inherited) {
            if (this.isDecoratedAsDynamic(cls, false)) {
                return true;
            }
            for (PyClass base : cls.getAncestorClasses(this.myTypeEvalContext)) {
                if (base == null || !this.isDecoratedAsDynamic(base, false)) continue;
                return true;
            }
        } else {
            if (PyKnownDecoratorUtil.hasUnknownDecorator(cls, this.myTypeEvalContext)) {
                return true;
            }
            String docString = cls.getDocStringValue();
            if (docString != null && docString.contains("@DynamicAttrs")) {
                return true;
            }
        }
        return false;
    }

    private boolean isAwaitOnGeneratorBasedCoroutine(@NotNull String name, @NotNull PsiReference reference, @NotNull PyClass cls) {
        PyExpression receiver;
        if (name == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(18);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(19);
        }
        if (cls == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(20);
        }
        if ("__await__".equals(name) && reference instanceof PyOperatorReference && "typing.Generator".equals(cls.getQualifiedName()) && (receiver = ((PyOperatorReference)reference).getReceiver()) instanceof PyCallExpression) {
            return PyKnownDecoratorUtil.isResolvedToGeneratorBasedCoroutine((PyCallExpression)receiver, this.getResolveContext(), this.myTypeEvalContext);
        }
        return false;
    }

    private boolean isEnabled(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(21);
        }
        if (this.myIsEnabled == null) {
            Boolean overridden = PyUnresolvedReferencesVisitor.overriddenUnresolvedReferenceInspection(anchor.getContainingFile());
            this.myIsEnabled = Objects.requireNonNullElse(overridden, true);
        }
        return this.myIsEnabled;
    }

    @Nullable
    private static Boolean overriddenUnresolvedReferenceInspection(@NotNull PsiFile file) {
        if (file == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(22);
        }
        return PyInspectionExtension.EP_NAME.getExtensionList().stream().map(e -> e.overrideUnresolvedReferenceInspection(file)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void highlightUnusedImports() {
        List extensions = PyInspectionExtension.EP_NAME.getExtensionList();
        List<PsiElement> unused = this.collectUnusedImportElements();
        for (PsiElement element : unused) {
            if (extensions.stream().anyMatch(extension -> extension.ignoreUnused(element, this.myTypeEvalContext)) || element.getTextLength() <= 0) continue;
            OptimizeImportsQuickFix fix = new OptimizeImportsQuickFix();
            this.registerProblem(element, PyPsiBundle.message("INSP.unused.import.statement", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, null, fix);
        }
    }

    public void highlightImportsInsideGuards() {
        HashSet usedImportsInsideImportGuards = Sets.newHashSet(this.getImportsInsideGuard());
        usedImportsInsideImportGuards.retainAll(this.getUsedImports());
        for (PyImportedNameDefiner definer : usedImportsInsideImportGuards) {
            PyImportElement importElement = PyUtil.as(definer, PyImportElement.class);
            if (importElement == null) continue;
            PyTargetExpression asElement = importElement.getAsNameElement();
            PyReferenceOwner toHighlight = asElement != null ? asElement : importElement.getImportReferenceExpression();
            this.registerProblem((PsiElement)toHighlight, PyPsiBundle.message("INSP.try.except.import.error", importElement.getVisibleName()), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    public void optimizeImports() {
        List<PsiElement> elementsToDelete = this.collectUnusedImportElements();
        for (PsiElement element : elementsToDelete) {
            PyPsiUtils.assertValid(element);
            element.delete();
        }
    }

    protected List<PsiElement> collectUnusedImportElements() {
        if (this.getAllImports().isEmpty()) {
            return Collections.emptyList();
        }
        PyImportedNameDefiner first = this.getAllImports().iterator().next();
        if (first.getContainingFile() instanceof PyExpressionCodeFragment || PythonRuntimeService.getInstance().isInPydevConsole((PsiElement)first)) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        HashSet<PyImportedNameDefiner> unusedImports = new HashSet<PyImportedNameDefiner>(this.getAllImports());
        unusedImports.removeAll(this.getUsedImports());
        HashSet<PyImportedNameDefiner> unusedImportToSkip = new HashSet<PyImportedNameDefiner>();
        for (PyImportedNameDefiner pyImportedNameDefiner : unusedImports) {
            if (!PyInspectionExtension.EP_NAME.getExtensionList().stream().anyMatch(o -> o.ignoreUnusedImports(pyImportedNameDefiner))) continue;
            unusedImportToSkip.add(pyImportedNameDefiner);
        }
        unusedImports.removeAll(unusedImportToSkip);
        HashSet<String> usedImportNames = new HashSet<String>();
        for (PyImportedNameDefiner usedImport : this.getUsedImports()) {
            for (PyElement e : usedImport.iterateNames()) {
                usedImportNames.add(e.getName());
            }
        }
        HashSet<PyImportStatementBase> hashSet = new HashSet<PyImportStatementBase>();
        QualifiedName packageQName = null;
        List<String> dunderAll = null;
        block3: for (PyImportedNameDefiner unusedImport : unusedImports) {
            QualifiedName importedQName;
            PsiFileSystemItem importedElement;
            PyImportStatementBase importStatement;
            if (packageQName == null) {
                PsiFile file = unusedImport.getContainingFile();
                if (file instanceof PyFile) {
                    dunderAll = ((PyFile)file).getDunderAll();
                }
                if (file != null && PyUtil.isPackage(file)) {
                    packageQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)file);
                }
            }
            if ((importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)unusedImport, PyImportStatementBase.class)) == null || hashSet.contains(importStatement) || this.getUsedImports().contains(unusedImport)) continue;
            PyInspection inspection = this.myInspection;
            assert (inspection != null);
            if (inspection.isSuppressedFor((PsiElement)importStatement) || PsiTreeUtil.getParentOfType((PsiElement)importStatement, PyTryExceptStatement.class) != null) continue;
            if (PsiTreeUtil.getParentOfType((PsiElement)unusedImport, PyIfStatement.class) != null) {
                for (PyElement e : unusedImport.iterateNames()) {
                    if (!usedImportNames.contains(e.getName())) continue;
                    continue block3;
                }
            }
            if (unusedImport instanceof PyImportElement) {
                PyImportElement importElement = (PyImportElement)unusedImport;
                PsiElement element = importElement.resolve();
                if (element == null) {
                    if (importElement.getImportedQName() == null) continue;
                    if (PyUnresolvedReferencesVisitor.areAllImportsUnused(importStatement, unusedImports)) {
                        result.add((PsiElement)importStatement);
                        continue;
                    }
                    result.add((PsiElement)importElement);
                    continue;
                }
                if (dunderAll != null && dunderAll.contains(importElement.getVisibleName())) continue;
                importedElement = element.getContainingFile();
            } else {
                assert (importStatement instanceof PyFromImportStatement);
                importedElement = ((PyFromImportStatement)importStatement).resolveImportSource();
                if (importedElement == null) continue;
            }
            if (packageQName != null && importedElement != null && (importedQName = QualifiedNameFinder.findShortestImportableQName(importedElement)) != null && importedQName.matchesPrefix(packageQName)) continue;
            if (unusedImport instanceof PyStarImportElement || PyUnresolvedReferencesVisitor.areAllImportsUnused(importStatement, unusedImports)) {
                hashSet.add(importStatement);
                result.add((PsiElement)importStatement);
                continue;
            }
            result.add((PsiElement)unusedImport);
        }
        return result;
    }

    private static boolean areAllImportsUnused(PyImportStatementBase importStatement, Set<PyImportedNameDefiner> unusedImports) {
        PyImportElement[] elements;
        for (PyImportElement element : elements = importStatement.getImportElements()) {
            if (unusedImports.contains(element)) continue;
            return false;
        }
        return true;
    }

    boolean ignoreUnresolved(@NotNull PyElement node, @NotNull PsiReference reference) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(23);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(24);
        }
        boolean ignoreUnresolved = false;
        for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
            if (!extension.ignoreUnresolvedReference(node, reference, this.myTypeEvalContext)) continue;
            ignoreUnresolved = true;
            break;
        }
        return ignoreUnresolved;
    }

    Collection<PyImportedNameDefiner> getImportsInsideGuard() {
        return Collections.unmodifiableCollection(this.myImportsInsideGuard);
    }

    Collection<PyImportedNameDefiner> getAllImports() {
        return Collections.unmodifiableCollection(this.myAllImports);
    }

    Collection<PyImportedNameDefiner> getUsedImports() {
        return Collections.unmodifiableCollection(this.myUsedImports);
    }

    @Nullable
    private static PyExceptPart getImportErrorGuard(PyElement node) {
        PyTryExceptStatement tryExceptStatement;
        PyTryPart tryPart;
        PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class);
        if (importStatement != null && (tryPart = (PyTryPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyTryPart.class)) != null && (tryExceptStatement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)tryPart, PyTryExceptStatement.class)) != null) {
            for (PyExceptPart exceptPart : tryExceptStatement.getExceptParts()) {
                PyExpression expr = exceptPart.getExceptClass();
                if (expr == null || !"ImportError".equals(expr.getName())) continue;
                return exceptPart;
            }
        }
        return null;
    }

    private static boolean isContainingFileImportAllowed(PyElement node, PsiFile target) {
        return PyImportStatementNavigator.getImportStatementByElement((PsiElement)node) == null && target.getName().equals("__init__.py");
    }

    private static boolean shouldSkipMissingWriteInsideGuard(@NotNull PyExceptPart guard, @NotNull String name) {
        if (guard == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(25);
        }
        if (name == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(26);
        }
        return PyUnresolvedReferencesVisitor.isDefinedInParentScope(name, guard) || PyBuiltinCache.getInstance(guard).getByName(name) != null || PyUnresolvedReferencesVisitor.controlFlowAlwaysTerminatesInsideGuard(guard);
    }

    private static boolean isDefinedInParentScope(@NotNull String name, @NotNull PsiElement anchor) {
        if (name == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(27);
        }
        if (anchor == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(28);
        }
        return ScopeUtil.getDeclarationScopeOwner((PsiElement)ScopeUtil.getScopeOwner(anchor), name) != null;
    }

    private static boolean controlFlowAlwaysTerminatesInsideGuard(@NotNull PyExceptPart guard) {
        ScopeOwner owner;
        if (guard == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(29);
        }
        if ((owner = ScopeUtil.getScopeOwner(guard)) == null) {
            return false;
        }
        ControlFlow flow = ControlFlowCache.getControlFlow(owner);
        Instruction[] instructions = flow.getInstructions();
        int start = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)guard.getExceptClass());
        if (start <= 0) {
            return false;
        }
        Ref canEscapeGuard = Ref.create((Object)false);
        ControlFlowUtil.process((Instruction[])instructions, (int)start, instruction -> {
            PsiElement e = instruction.getElement();
            if (e != null && !PsiTreeUtil.isAncestor((PsiElement)guard, (PsiElement)e, (boolean)true)) {
                canEscapeGuard.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)canEscapeGuard.get() == false;
    }

    @Nullable
    private static PyExpression getReferenceQualifier(@NotNull PsiReference reference) {
        PyReferenceExpression source;
        PyFromImportStatement statement;
        PyExpression qualifier;
        PsiElement element;
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(30);
        }
        if ((element = reference.getElement()) instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)element).getQualifier()) != null) {
            return qualifier;
        }
        if (reference instanceof PyFromImportNameReference && (statement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyFromImportStatement.class)) != null && (source = statement.getImportSource()) != null) {
            return source;
        }
        return null;
    }

    @NotNull
    private static List<QualifiedName> getCanonicalNames(@NotNull PsiReference reference, @NotNull TypeEvalContext context2) {
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(31);
        }
        if (context2 == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(32);
        }
        PsiElement element = reference.getElement();
        SmartList result = new SmartList();
        if (reference instanceof PyOperatorReference && element instanceof PyQualifiedExpression) {
            PyType type2;
            PyExpression receiver = ((PyOperatorReference)reference).getReceiver();
            if (receiver != null && (type2 = context2.getType(receiver)) instanceof PyClassType) {
                String methodName = ((PyQualifiedExpression)element).getReferencedName();
                ContainerUtil.addIfNotNull((Collection)result, (Object)PyUnresolvedReferencesVisitor.extractAttributeQNameFromClassType(methodName, (PyClassType)type2));
            }
        } else if (element instanceof PyReferenceExpression) {
            PyReferenceExpression expr = (PyReferenceExpression)element;
            PyExpression qualifier = expr.getQualifier();
            String exprName = expr.getName();
            if (exprName != null) {
                if (qualifier != null) {
                    PyType qualifierType = context2.getType(qualifier);
                    PyTypeUtil.toStream(qualifierType).map(type -> {
                        QualifiedName path;
                        PyCallable callable;
                        String callableName;
                        if (type instanceof PyClassType) {
                            return PyUnresolvedReferencesVisitor.extractAttributeQNameFromClassType(exprName, (PyClassType)type);
                        }
                        if (type instanceof PyModuleType) {
                            PyFile file = ((PyModuleType)type).getModule();
                            QualifiedName name = QualifiedNameFinder.findCanonicalImportPath((PsiElement)file, element);
                            if (name != null) {
                                return name.append(exprName);
                            }
                        } else if (type instanceof PyImportedModuleType) {
                            QualifiedName path2;
                            PyImportedModule module = ((PyImportedModuleType)type).getImportedModule();
                            PsiElement resolved = module.resolve();
                            if (resolved != null && (path2 = QualifiedNameFinder.findCanonicalImportPath(resolved, element)) != null) {
                                return path2.append(exprName);
                            }
                        } else if (type instanceof PyFunctionType && (callableName = (callable = ((PyFunctionType)type).getCallable()).getName()) != null && (path = QualifiedNameFinder.findCanonicalImportPath((PsiElement)callable, element)) != null) {
                            return path.append(QualifiedName.fromComponents((String[])new String[]{callableName, exprName}));
                        }
                        return null;
                    }).nonNull().into((Collection)result);
                } else {
                    PsiElement parent = element.getParent();
                    if (parent instanceof PyImportElement) {
                        QualifiedName path;
                        PsiFileSystemItem resolved;
                        PyImportStatementBase importStmt = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, PyImportStatementBase.class);
                        if (importStmt instanceof PyImportStatement) {
                            ContainerUtil.addIfNotNull((Collection)result, (Object)QualifiedName.fromComponents((String[])new String[]{exprName}));
                        } else if (importStmt instanceof PyFromImportStatement && (resolved = ((PyFromImportStatement)importStmt).resolveImportSource()) != null && (path = QualifiedNameFinder.findCanonicalImportPath((PsiElement)resolved, element)) != null) {
                            ContainerUtil.addIfNotNull((Collection)result, (Object)path.append(exprName));
                        }
                    } else {
                        QualifiedName path = QualifiedNameFinder.findCanonicalImportPath(element, element);
                        if (path != null) {
                            ContainerUtil.addIfNotNull((Collection)result, (Object)path.append(exprName));
                        }
                    }
                }
            }
        } else if (reference instanceof DocStringParameterReference) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)QualifiedName.fromDottedString((String)reference.getCanonicalText()));
        }
        SmartList smartList = result;
        if (smartList == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(33);
        }
        return smartList;
    }

    private static QualifiedName extractAttributeQNameFromClassType(String exprName, PyClassType type) {
        String name = type.getClassQName();
        if (name != null) {
            return QualifiedName.fromDottedString((String)name).append(exprName);
        }
        return null;
    }

    private static boolean hasUnresolvedDynamicMember(@NotNull PyClassType type, PsiReference reference, @NotNull String name, TypeEvalContext typeEvalContext) {
        if (type == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(34);
        }
        if (name == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(35);
        }
        ArrayList<PyClassType> types = new ArrayList<PyClassType>(Collections.singletonList(type));
        types.addAll((Collection<PyClassType>)FluentIterable.from(type.getAncestorTypes(typeEvalContext)).filter(PyClassType.class).toList());
        for (PyClassType typeToCheck : types) {
            for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
                Collection<PyCustomMember> resolveResult = provider.getMembers(typeToCheck, reference.getElement(), typeEvalContext);
                for (PyCustomMember member : resolveResult) {
                    if (!member.getName().equals(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    Iterable<LocalQuickFix> getInstallPackageQuickFixes(@NotNull PyElement node, @NotNull PsiReference reference, String refName) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(36);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(37);
        }
        return Collections.emptyList();
    }

    Iterable<LocalQuickFix> getAddIgnoredIdentifierQuickFixes(List<QualifiedName> qualifiedNames) {
        return Collections.emptyList();
    }

    Iterable<LocalQuickFix> getImportStatementQuickFixes(PsiElement element) {
        return Collections.emptyList();
    }

    LocalQuickFix getAddParameterQuickFix(String refName, PyReferenceExpression expr) {
        PyFunction parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expr, PyFunction.class);
        PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)expr, PyDecorator.class);
        PyAnnotation annotation = (PyAnnotation)PsiTreeUtil.getParentOfType((PsiElement)expr, PyAnnotation.class);
        PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, PyImportStatement.class);
        if (parentFunction != null && decorator == null && annotation == null && importStatement == null) {
            return new UnresolvedReferenceAddParameterQuickFix(refName);
        }
        return null;
    }

    LocalQuickFix getCreateFunctionQuickFix(PyReferenceExpression expr) {
        PyCallExpression callExpression = PyCallExpressionNavigator.getPyCallExpressionByCallee((PsiElement)expr);
        if (!(callExpression == null || callExpression.getCallee() instanceof PyQualifiedExpression && ((PyQualifiedExpression)callExpression.getCallee()).getQualifier() != null)) {
            return new UnresolvedRefCreateFunctionQuickFix(callExpression, expr);
        }
        return null;
    }

    LocalQuickFix getTrueFalseQuickFix(PyReferenceExpression expr, String refText) {
        if (refText.equals("true") || refText.equals("false")) {
            return new UnresolvedRefTrueFalseQuickFix((PsiElement)expr);
        }
        return null;
    }

    Iterable<LocalQuickFix> getCreateMemberFromUsageFixes(PyType type, PsiReference reference, String refText) {
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        PsiElement element = reference.getElement();
        if (type instanceof PyClassTypeImpl) {
            PyClass cls = ((PyClassType)type).getPyClass();
            if (!PyBuiltinCache.getInstance(element).isBuiltin((PsiElement)cls)) {
                if (element.getParent() instanceof PyCallExpression) {
                    result.add(new AddMethodQuickFix(refText, cls.getName(), true));
                } else if (!(reference instanceof PyOperatorReference)) {
                    result.add(new AddFieldQuickFix(refText, "None", type.getName(), true));
                }
            }
        } else if (type instanceof PyModuleType) {
            PyFile file = ((PyModuleType)type).getModule();
            LocalQuickFix createClassQuickFix = this.getCreateClassFix(refText, element);
            if (createClassQuickFix != null) {
                result.add(createClassQuickFix);
            } else {
                result.add(new AddFunctionQuickFix(refText, file.getName()));
            }
        }
        return result;
    }

    Iterable<LocalQuickFix> getAddSelfFixes(TypeEvalContext typeEvalContext, PyElement node, PyReferenceExpression expr) {
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        PyClass containedClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class);
        if (containedClass != null && function != null) {
            PyParameter[] parameters = function.getParameterList().getParameters();
            if (parameters.length == 0) {
                return Collections.emptyList();
            }
            String qualifier = parameters[0].getText();
            PyDecoratorList decoratorList = function.getDecoratorList();
            boolean isClassMethod = false;
            if (decoratorList != null) {
                for (PyDecorator decorator : decoratorList.getDecorators()) {
                    PyExpression callee = decorator.getCallee();
                    if (callee == null || !"classmethod".equals(callee.getText())) continue;
                    isClassMethod = true;
                }
            }
            for (PyTargetExpression target : containedClass.getInstanceAttributes()) {
                if (isClassMethod || !Comparing.strEqual((String)node.getName(), (String)target.getName())) continue;
                result.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
            }
            for (PyStatement statement : containedClass.getStatementList().getStatements()) {
                PyType type;
                PyExpression assignedValue;
                PyExpression lhsExpression;
                if (!(statement instanceof PyAssignmentStatement) || (lhsExpression = ((PyAssignmentStatement)statement).getLeftHandSideExpression()) == null || !lhsExpression.getText().equals(expr.getText()) || !((assignedValue = ((PyAssignmentStatement)statement).getAssignedValue()) instanceof PyCallExpression) || !((type = typeEvalContext.getType(assignedValue)) instanceof PyClassTypeImpl) || !((PyCallExpression)assignedValue).isCalleeText("property")) continue;
                result.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
            }
            for (PyFunction method : containedClass.getMethods()) {
                if (!expr.getText().equals(method.getName())) continue;
                result.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
            }
        }
        return result;
    }

    protected Iterable<LocalQuickFix> getAutoImportFixes(PyElement node, PsiReference reference, PsiElement element) {
        return Collections.emptyList();
    }

    LocalQuickFix getCreateClassFix(@NonNls String refText, PsiElement element) {
        if (refText.length() > 2 && Character.isUpperCase(refText.charAt(0)) && !StringUtil.toUpperCase((String)refText).equals(refText)) {
            Object anchor = element;
            if (element instanceof PyQualifiedExpression) {
                PyFromImportStatement fromImport;
                PyExpression qualifier = ((PyQualifiedExpression)element).getQualifier();
                if (qualifier == null && (fromImport = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyFromImportStatement.class)) != null) {
                    qualifier = fromImport.getImportSource();
                }
                if (qualifier != null) {
                    PyType type = this.myTypeEvalContext.getType(qualifier);
                    anchor = type instanceof PyModuleType ? ((PyModuleType)type).getModule() : null;
                }
                if (anchor != null) {
                    return new CreateClassQuickFix(refText, (PsiElement)anchor);
                }
            }
        }
        return null;
    }

    void getPluginQuickFixes(List<LocalQuickFix> fixes, PsiReference reference) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 23: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 7: 
            case 12: 
            case 19: 
            case 24: 
            case 30: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 10: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guard";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 14: 
            case 16: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 18: 
            case 26: 
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesVisitor";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTargetExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPyImportElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyStarImportElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitComment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitPyElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markTargetImportsAsUsed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReference";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processReferenceInImportGuard";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerUnresolvedReferenceProblem";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredInSlots";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "ignoreUnresolvedMemberForType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDecoratedAsDynamic";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAwaitOnGeneratorBasedCoroutine";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "overriddenUnresolvedReferenceInspection";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "ignoreUnresolved";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipMissingWriteInsideGuard";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDefinedInParentScope";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "controlFlowAlwaysTerminatesInsideGuard";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceQualifier";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalNames";
                break;
            }
            case 33: {
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedDynamicMember";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getInstallPackageQuickFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

