/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.minor.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.minor.facet.PythonFacet;
import com.jetbrains.python.sdk.PythonSdkType;
import icons.PythonIcons;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonFacetType
extends FacetType<PythonFacet, PythonFacetConfiguration> {
    @NonNls
    private static final String ID = "Python";

    public static PythonFacetType getInstance() {
        return (PythonFacetType)PythonFacetType.findInstance(PythonFacetType.class);
    }

    public PythonFacetType() {
        super(PythonFacet.ID, ID, PyBundle.message("python.facet.name", new Object[0]));
    }

    public PythonFacetConfiguration createDefaultConfiguration() {
        PythonFacetConfiguration result = new PythonFacetConfiguration();
        List sdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)PythonSdkType.getInstance());
        if (sdks.size() > 0) {
            result.setSdk((Sdk)sdks.get(0));
        }
        return result;
    }

    public PythonFacet createFacet(@NotNull Module module, String name, @NotNull PythonFacetConfiguration configuration, @Nullable Facet underlyingFacet) {
        if (module == null) {
            PythonFacetType.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            PythonFacetType.$$$reportNull$$$0(1);
        }
        return new PythonFacet((FacetType)this, module, name, configuration, underlyingFacet);
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return !moduleType.getId().equals("PYTHON_MODULE");
    }

    public Icon getIcon() {
        return PythonIcons.Python.Python;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/minor/facet/PythonFacetType";
        objectArray[2] = "createFacet";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PythonFacetConfiguration
    extends PythonFacetSettings
    implements FacetConfiguration {
        private static final String SDK_NAME = "sdkName";

        public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
            return new FacetEditorTab[0];
        }

        public void readExternal(Element element) throws InvalidDataException {
            String sdkName = element.getAttributeValue(SDK_NAME);
            this.mySdk = StringUtil.isEmpty((String)sdkName) ? null : ProjectJdkTable.getInstance().findJdk(sdkName, PythonSdkType.getInstance().getName());
        }

        public void writeExternal(Element element) throws WriteExternalException {
            element.setAttribute(SDK_NAME, this.mySdk == null ? "" : this.mySdk.getName());
        }
    }
}

