/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.ProjectTopics;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.jetbrains.python.PythonCodeStyleService;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.module.PyModuleService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PythonLanguageLevelPusher
implements FilePropertyPusher<String> {
    private static final Key<String> KEY = new Key("python.language.level");
    private static final Map<LanguageLevel, LanguageLevel> COMPATIBLE_LEVELS;
    private final Map<Module, Sdk> myModuleSdks = ContainerUtil.createWeakMap();
    private static final FileAttribute PERSISTENCE;

    private static void addCompatiblePair(Map<LanguageLevel, LanguageLevel> levels, LanguageLevel l1, LanguageLevel l2) {
        levels.put(l1, l2);
        levels.put(l2, l1);
    }

    public void initExtra(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        Map<Module, Sdk> moduleSdks2 = PythonLanguageLevelPusher.getPythonModuleSdks(project);
        Set distinctSdks = (Set)StreamEx.ofValues(moduleSdks2).nonNull().collect(Collectors.toCollection(LinkedHashSet::new));
        this.myModuleSdks.putAll(moduleSdks2);
        PythonLanguageLevelPusher.resetProjectLanguageLevel(project);
        this.updateSdkLanguageLevels(project, distinctSdks);
        PythonLanguageLevelPusher.guessLanguageLevelWithCaching(project, distinctSdks);
    }

    @NotNull
    public Key<String> getFileDataKey() {
        Key<String> key = KEY;
        if (key == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public String getDefaultValue() {
        String string = LanguageLevel.getDefault().toPythonVersion();
        if (string == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Nullable
    private static Sdk getFileSdk(@NotNull Project project, @NotNull VirtualFile file) {
        Module module;
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null) {
            Sdk sdk = PythonSdkUtil.findPythonSdk(module);
            if (sdk != null) {
                return sdk;
            }
            return null;
        }
        return PythonLanguageLevelPusher.findSdkForFileOutsideTheProject(project, file);
    }

    @Nullable
    private static Sdk findSdkForFileOutsideTheProject(Project project, VirtualFile file) {
        if (file != null) {
            List orderEntries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file);
            for (OrderEntry orderEntry : orderEntries) {
                if (!(orderEntry instanceof JdkOrderEntry)) continue;
                return ((JdkOrderEntry)orderEntry).getJdk();
            }
        }
        return null;
    }

    @NotNull
    public String getImmediateValue(@NotNull Module module) {
        if (module == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && LanguageLevel.FORCE_LANGUAGE_LEVEL != null) {
            String string = LanguageLevel.FORCE_LANGUAGE_LEVEL.toPythonVersion();
            if (string == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(7);
            }
            return string;
        }
        Sdk sdk = PythonSdkUtil.findPythonSdk(module);
        String string = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk).toPythonVersion();
        if (string == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean acceptsFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(9);
        }
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(10);
        }
        return false;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(11);
        }
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(12);
        }
        return true;
    }

    private static boolean areLanguageLevelsCompatible(LanguageLevel oldLevel, LanguageLevel newLevel) {
        return oldLevel != null && newLevel != null && COMPATIBLE_LEVELS.get((Object)oldLevel) == newLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull String value) throws IOException {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(13);
        }
        if (fileOrDir == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(14);
        }
        if (value == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(15);
        }
        LanguageLevel level = LanguageLevel.fromPythonVersion(value);
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        LanguageLevel oldLanguageLevel = null;
        if (iStream != null) {
            try {
                int oldLevelOrdinal = DataInputOutputUtil.readINT((DataInput)iStream);
                if (oldLevelOrdinal == level.ordinal()) {
                    return;
                }
                oldLanguageLevel = (LanguageLevel)((Object)ContainerUtil.find((Object[])LanguageLevel.values(), it -> it.ordinal() == oldLevelOrdinal));
            }
            finally {
                iStream.close();
            }
        }
        try (DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);){
            DataInputOutputUtil.writeINT((DataOutput)oStream, (int)level.ordinal());
        }
        if (!PythonLanguageLevelPusher.areLanguageLevelsCompatible(oldLanguageLevel, level) || !ProjectFileIndex.getInstance((Project)project).isInContent(fileOrDir)) {
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, PythonLanguageLevelPusher::isPythonFile);
        }
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !PythonLanguageLevelPusher.isPythonFile(child)) continue;
            PythonLanguageLevelPusher.clearSdkPathCache(child);
        }
    }

    private static boolean isPythonFile(VirtualFile child) {
        return ((Object)((Object)PythonFileType.INSTANCE)).equals(FileTypeRegistry.getInstance().getFileTypeByFileName(child.getNameSequence()));
    }

    private static void clearSdkPathCache(@NotNull VirtualFile child) {
        Project[] projects;
        if (child == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(16);
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            Sdk sdk = PythonLanguageLevelPusher.getFileSdk(project, child);
            if (sdk == null) continue;
            PythonSdkPathCache pathCache = PythonSdkPathCache.getInstance(project, sdk);
            pathCache.clearCache();
        }
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(17);
        }
        Map<Module, Sdk> moduleSdks2 = PythonLanguageLevelPusher.getPythonModuleSdks(project);
        Set distinctSdks = (Set)StreamEx.ofValues(moduleSdks2).nonNull().collect(Collectors.toCollection(LinkedHashSet::new));
        boolean needToReparseOpenFiles = ContainerUtil.exists(moduleSdks2.entrySet(), entry -> {
            Module module = (Module)entry.getKey();
            Sdk newSdk = (Sdk)entry.getValue();
            Sdk oldSdk = this.myModuleSdks.get(module);
            return this.myModuleSdks.containsKey(module) && newSdk != oldSdk;
        });
        this.myModuleSdks.putAll(moduleSdks2);
        PythonLanguageLevelPusher.resetProjectLanguageLevel(project);
        this.updateSdkLanguageLevels(project, distinctSdks);
        if (needToReparseOpenFiles) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project.isDisposed()) {
                    return;
                }
                PythonCodeStyleService.getInstance().reparseOpenEditorFiles(project);
            });
        }
    }

    @NotNull
    private static Map<Module, Sdk> getPythonModuleSdks(@NotNull Project project) {
        ModuleManager moduleManager;
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(18);
        }
        if ((moduleManager = ModuleManager.getInstance((Project)project)) == null) {
            Map<Module, Sdk> map2 = Collections.emptyMap();
            if (map2 == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(19);
            }
            return map2;
        }
        LinkedHashMap<Module, Sdk> result = new LinkedHashMap<Module, Sdk>();
        for (Module module : moduleManager.getModules()) {
            result.put(module, PythonSdkUtil.findPythonSdk(module));
        }
        LinkedHashMap<Module, Sdk> linkedHashMap = result;
        if (linkedHashMap == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(20);
        }
        return linkedHashMap;
    }

    private void updateSdkLanguageLevels(@NotNull Project project, @NotNull Set<Sdk> sdks) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(21);
        }
        if (sdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(22);
        }
        if (sdks.isEmpty()) {
            return;
        }
        new MyDumbModeTask(project, sdks).queue(project);
    }

    private List<Runnable> getRootUpdateTasks(@NotNull Project project, @NotNull Set<Sdk> sdks) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(23);
        }
        if (sdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(24);
        }
        ArrayList<Runnable> results = new ArrayList<Runnable>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk = PythonSdkUtil.findPythonSdk(module);
            LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk);
            for (VirtualFile root : PyUtil.getSourceRoots(module)) {
                this.addRootIndexingTask(root, results, project, languageLevel);
            }
        }
        for (Sdk sdk : sdks) {
            if (PythonSdkUtil.isDisposed(sdk)) continue;
            LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk);
            for (VirtualFile root : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!root.isValid() || PyTypeShed.INSTANCE.isInside(root)) continue;
                this.addRootIndexingTask(root, results, project, languageLevel);
            }
        }
        return results;
    }

    private void addRootIndexingTask(@NotNull VirtualFile root, @NotNull List<Runnable> results, @NotNull Project project, @NotNull LanguageLevel languageLevel) {
        VirtualFile parent;
        if (root == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(25);
        }
        if (results == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(26);
        }
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(27);
        }
        if (languageLevel == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(28);
        }
        boolean shouldSuppressSizeLimit = (parent = root.getParent()) != null && parent.getName().equals("python_stubs");
        results.add(new UpdateRootTask(project, root, languageLevel, shouldSuppressSizeLimit));
    }

    @NotNull
    private static LanguageLevel guessLanguageLevelWithCaching(@NotNull Project project, @NotNull Collection<@Nullable Sdk> pythonModuleSdks) {
        LanguageLevel languageLevel;
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(29);
        }
        if (pythonModuleSdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(30);
        }
        if ((languageLevel = LanguageLevel.fromPythonVersion((String)project.getUserData(KEY))) == null) {
            languageLevel = PythonLanguageLevelPusher.guessLanguageLevel(pythonModuleSdks);
            project.putUserData(KEY, (Object)languageLevel.toPythonVersion());
        }
        LanguageLevel languageLevel2 = languageLevel;
        if (languageLevel2 == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(31);
        }
        return languageLevel2;
    }

    private static void resetProjectLanguageLevel(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(32);
        }
        project.putUserData(KEY, null);
    }

    @NotNull
    private static LanguageLevel guessLanguageLevel(@NotNull Collection<@Nullable Sdk> pythonModuleSdks) {
        if (pythonModuleSdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(33);
        }
        LanguageLevel maxLevel = null;
        for (Sdk sdk : pythonModuleSdks) {
            if (sdk == null) continue;
            LanguageLevel level = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk);
            if (maxLevel != null && !maxLevel.isOlderThan(level)) continue;
            maxLevel = level;
        }
        if (maxLevel != null) {
            LanguageLevel languageLevel = maxLevel;
            if (languageLevel == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(34);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(35);
        }
        return languageLevel;
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForVirtualFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Sdk sdk;
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(36);
        }
        if (virtualFile == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(37);
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        virtualFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)virtualFile);
        LanguageLevel forced = LanguageLevel.FORCE_LANGUAGE_LEVEL;
        if (ApplicationManager.getApplication().isUnitTestMode() && forced != null) {
            LanguageLevel languageLevel = forced;
            if (languageLevel == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(38);
            }
            return languageLevel;
        }
        LanguageLevel specified = PythonLanguageLevelPusher.specifiedFileLanguageLevel(virtualFile);
        if (specified != null) {
            LanguageLevel languageLevel = specified;
            if (languageLevel == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(39);
            }
            return languageLevel;
        }
        Sdk sdk2 = sdk = virtualFile instanceof LightVirtualFile ? null : PythonLanguageLevelPusher.getFileSdk(project, virtualFile);
        if (sdk != null) {
            LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk);
            if (languageLevel == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(40);
            }
            return languageLevel;
        }
        return PythonLanguageLevelPusher.guessLanguageLevelWithCaching(project, PythonLanguageLevelPusher.getPythonModuleSdks(project).values());
    }

    @TestOnly
    public static void setForcedLanguageLevel(@NotNull Project project, @Nullable LanguageLevel languageLevel) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(41);
        }
        LanguageLevel.FORCE_LANGUAGE_LEVEL = languageLevel;
        PushedFilePropertiesUpdater.getInstance((Project)project).pushAll(new FilePropertyPusher[]{new PythonLanguageLevelPusher()});
    }

    public static void specifyFileLanguageLevel(@NotNull VirtualFile file, @Nullable LanguageLevel languageLevel) {
        if (file == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(42);
        }
        file.putUserData(KEY, (Object)(languageLevel == null ? null : languageLevel.toPythonVersion()));
    }

    @Nullable
    private static LanguageLevel specifiedFileLanguageLevel(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        LanguageLevel specified = LanguageLevel.fromPythonVersion((String)file.getUserData(KEY));
        if (file.isDirectory()) {
            return specified;
        }
        return specified == null ? PythonLanguageLevelPusher.specifiedFileLanguageLevel(file.getParent()) : specified;
    }

    @TestOnly
    public void flushLanguageLevelCache() {
        this.myModuleSdks.clear();
    }

    static {
        EnumMap compatLevels = Maps.newEnumMap(LanguageLevel.class);
        PythonLanguageLevelPusher.addCompatiblePair(compatLevels, LanguageLevel.PYTHON26, LanguageLevel.PYTHON27);
        PythonLanguageLevelPusher.addCompatiblePair(compatLevels, LanguageLevel.PYTHON33, LanguageLevel.PYTHON34);
        COMPATIBLE_LEVELS = Maps.immutableEnumMap((Map)compatLevels);
        PERSISTENCE = new FileAttribute("python_language_level_persistence", 2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 19: 
            case 20: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 19: 
            case 20: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 19: 
            case 20: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonModuleSdks";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateValue";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonModuleSdks";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "guessLanguageLevelWithCaching";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "guessLanguageLevel";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initExtra";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 19: 
            case 20: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileSdk";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "clearSdkPathCache";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPythonModuleSdks";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkLanguageLevels";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRootUpdateTasks";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addRootIndexingTask";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "guessLanguageLevelWithCaching";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resetProjectLanguageLevel";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "guessLanguageLevel";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevelForVirtualFile";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setForcedLanguageLevel";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "specifyFileLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 19: 
            case 20: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyDumbModeTask
    extends DumbModeTask {
        @NotNull
        private final Project project;
        @NotNull
        private final Set<Sdk> sdks;
        private final SimpleMessageBusConnection connection;

        private MyDumbModeTask(final @NotNull Project project, Set<Sdk> sdks) {
            if (project == null) {
                MyDumbModeTask.$$$reportNull$$$0(0);
            }
            if (sdks == null) {
                MyDumbModeTask.$$$reportNull$$$0(1);
            }
            super((Object)Pair.create((Object)project, (Object)ImmutableSet.copyOf(sdks)));
            this.project = project;
            this.sdks = sdks;
            this.connection = project.getMessageBus().simpleConnect();
            this.connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DumbService.getInstance((Project)project).cancelTask((DumbModeTask)MyDumbModeTask.this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$MyDumbModeTask$1", "rootsChanged"));
                }
            });
        }

        public void dispose() {
            this.connection.disconnect();
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyDumbModeTask.$$$reportNull$$$0(2);
            }
            if (this.project.isDisposed()) {
                return;
            }
            indicator.setIndeterminate(true);
            indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
            List tasks = (List)ReadAction.compute(() -> PythonLanguageLevelPusher.this.getRootUpdateTasks(this.project, this.sdks));
            PushedFilePropertiesUpdater.getInstance((Project)this.project).runConcurrentlyIfPossible(tasks);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$MyDumbModeTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class UpdateRootTask
    implements Runnable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final LanguageLevel myLanguageLevel;
        private final boolean myShouldSuppressSizeLimit;

        UpdateRootTask(@NotNull Project project, @NotNull VirtualFile root, LanguageLevel languageLevel, boolean shouldSuppressSizeLimit) {
            if (project == null) {
                UpdateRootTask.$$$reportNull$$$0(0);
            }
            if (root == null) {
                UpdateRootTask.$$$reportNull$$$0(1);
            }
            if (languageLevel == null) {
                UpdateRootTask.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myRoot = root;
            this.myLanguageLevel = languageLevel;
            this.myShouldSuppressSizeLimit = shouldSuppressSizeLimit;
        }

        @Override
        public void run() {
            if (this.myProject.isDisposed() || !((Boolean)ReadAction.compute(() -> this.myRoot.isValid())).booleanValue()) {
                return;
            }
            final PushedFilePropertiesUpdater propertiesUpdater = PushedFilePropertiesUpdater.getInstance((Project)this.myProject);
            VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (Boolean)ReadAction.compute(() -> {
                        if (!file.isValid() || PyModuleService.getInstance().isFileIgnored(file)) {
                            return false;
                        }
                        if (file.isDirectory()) {
                            propertiesUpdater.findAndUpdateValue(file, (FilePropertyPusher)PythonLanguageLevelPusher.this, (Object)UpdateRootTask.this.myLanguageLevel.toPythonVersion());
                        }
                        if (UpdateRootTask.this.myShouldSuppressSizeLimit) {
                            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
                        }
                        return true;
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$UpdateRootTask$1", "visitFile"));
                }
            });
        }

        public String toString() {
            return "UpdateRootTask{myRoot=" + this.myRoot + ", myLanguageLevel=" + this.myLanguageLevel + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageLevel";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$UpdateRootTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

