/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.KeywordArgumentCompletionUtil;
import com.jetbrains.python.psi.impl.references.PyReferenceCustomTargetChecker;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.ImplicitResolveResult;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyOverridingReferenceResolveProvider;
import com.jetbrains.python.psi.resolve.PyReferenceResolveProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.PyDefUseUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyReferenceImpl
implements PsiReferenceEx,
PsiPolyVariantReference {
    protected final PyQualifiedExpression myElement;
    protected final PyResolveContext myContext;
    private static final boolean USE_CACHE = true;

    public PyReferenceImpl(PyQualifiedExpression element, @NotNull PyResolveContext context2) {
        if (context2 == null) {
            PyReferenceImpl.$$$reportNull$$$0(0);
        }
        this.myElement = element;
        this.myContext = context2;
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode nameElement = this.myElement.getNameElement();
        TextRange textRange = nameElement != null ? nameElement.getPsi().getTextRangeInParent() : TextRange.from((int)0, (int)this.myElement.getTextLength());
        if (textRange == null) {
            PyReferenceImpl.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    public PsiElement getElement() {
        PyQualifiedExpression pyQualifiedExpression = this.myElement;
        if (pyQualifiedExpression == null) {
            PyReferenceImpl.$$$reportNull$$$0(2);
        }
        return pyQualifiedExpression;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length >= 1 && !(results[0] instanceof ImplicitResolveResult) ? results[0].getElement() : null;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveCache cache2 = ResolveCache.getInstance((Project)this.getElement().getProject());
        ResolveResult[] resolveResultArray = cache2.resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)CachingResolver.INSTANCE, true, incompleteCode);
        if (resolveResultArray == null) {
            PyReferenceImpl.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    private ResolveResult @NotNull [] multiResolveInner() {
        String referencedName = this.myElement.getReferencedName();
        if (referencedName == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                PyReferenceImpl.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List<RatedResolveResult> targets = this.resolveInner();
        if (targets.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                PyReferenceImpl.$$$reportNull$$$0(5);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = RatedResolveResult.sorted(targets).toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            PyReferenceImpl.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    @NotNull
    private static ResolveResultList resolveToLatestDefs(@NotNull List<Instruction> instructions, @NotNull PsiElement element, @NotNull String name, @NotNull TypeEvalContext context2) {
        if (instructions == null) {
            PyReferenceImpl.$$$reportNull$$$0(7);
        }
        if (element == null) {
            PyReferenceImpl.$$$reportNull$$$0(8);
        }
        if (name == null) {
            PyReferenceImpl.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            PyReferenceImpl.$$$reportNull$$$0(10);
        }
        ResolveResultList ret = new ResolveResultList();
        for (Instruction instruction : instructions) {
            PsiElement definition = instruction.getElement();
            if (PyReferenceImpl.isInnerComprehension(element, definition)) continue;
            if (definition instanceof PyImportedNameDefiner && !(definition instanceof PsiNamedElement)) {
                PyImportedNameDefiner definer = (PyImportedNameDefiner)definition;
                List<RatedResolveResult> resolvedResults = definer.multiResolveName(name);
                for (RatedResolveResult result : resolvedResults) {
                    ret.add(new ImportedResolveResult(result.getElement(), result.getRate(), definer));
                }
                if (resolvedResults.isEmpty()) {
                    ret.add(new ImportedResolveResult(null, 0, definer));
                    continue;
                }
                ret.poke((PsiElement)definer, -1000);
                continue;
            }
            ret.poke(definition, PyReferenceImpl.getRate(definition, context2));
        }
        ResolveResultList results = new ResolveResultList();
        for (RatedResolveResult r : ret) {
            PsiElement e = r.getElement();
            if (e == element || element instanceof PyTargetExpression && e != null && PyUtil.inSameFile(element, e) && PyPsiUtils.isBefore(element, e)) continue;
            results.add(PyReferenceImpl.changePropertyMethodToSameNameGetter(r, name));
        }
        ResolveResultList resolveResultList = results;
        if (resolveResultList == null) {
            PyReferenceImpl.$$$reportNull$$$0(11);
        }
        return resolveResultList;
    }

    private static boolean isInnerComprehension(PsiElement referenceElement, PsiElement definition) {
        PyComprehensionElement elementComprehension;
        if (definition != null && definition.getParent() instanceof PyAssignmentExpression) {
            return false;
        }
        PyComprehensionElement definitionComprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)definition, PyComprehensionElement.class);
        return definitionComprehension != null && PyUtil.isOwnScopeComprehension(definitionComprehension) && ((elementComprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PyComprehensionElement.class)) == null || !PsiTreeUtil.isAncestor((PsiElement)definitionComprehension, (PsiElement)elementComprehension, (boolean)false));
    }

    @NotNull
    private static RatedResolveResult changePropertyMethodToSameNameGetter(@NotNull RatedResolveResult resolveResult, @NotNull String name) {
        Property property;
        PsiElement element;
        if (resolveResult == null) {
            PyReferenceImpl.$$$reportNull$$$0(12);
        }
        if (name == null) {
            PyReferenceImpl.$$$reportNull$$$0(13);
        }
        if ((element = resolveResult.getElement()) instanceof PyFunction && (property = ((PyFunction)element).getProperty()) != null) {
            PyCallable getter = property.getGetter().valueOrNull();
            PyCallable setter = property.getSetter().valueOrNull();
            PyCallable deleter = property.getDeleter().valueOrNull();
            if (getter != null && name.equals(getter.getName()) && (setter == null || name.equals(setter.getName())) && (deleter == null || name.equals(deleter.getName()))) {
                RatedResolveResult ratedResolveResult = resolveResult.replace((PsiElement)getter);
                if (ratedResolveResult == null) {
                    PyReferenceImpl.$$$reportNull$$$0(14);
                }
                return ratedResolveResult;
            }
        }
        RatedResolveResult ratedResolveResult = resolveResult;
        if (ratedResolveResult == null) {
            PyReferenceImpl.$$$reportNull$$$0(15);
        }
        return ratedResolveResult;
    }

    private boolean isInOwnScopeComprehension(@Nullable PsiElement uexpr) {
        if (uexpr == null || !this.myContext.getTypeEvalContext().maySwitchToAST(uexpr)) {
            return false;
        }
        PyComprehensionElement comprehensionElement = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)uexpr, PyComprehensionElement.class);
        return comprehensionElement != null && PyUtil.isOwnScopeComprehension(comprehensionElement);
    }

    @NotNull
    protected List<RatedResolveResult> resolveInner() {
        ResolveResultList overriddenResult = this.resolveByOverridingReferenceResolveProviders();
        if (!overriddenResult.isEmpty()) {
            ResolveResultList resolveResultList = overriddenResult;
            if (resolveResultList == null) {
                PyReferenceImpl.$$$reportNull$$$0(16);
            }
            return resolveResultList;
        }
        String referencedName = this.myElement.getReferencedName();
        if (referencedName == null) {
            List<RatedResolveResult> list = Collections.emptyList();
            if (list == null) {
                PyReferenceImpl.$$$reportNull$$$0(17);
            }
            return list;
        }
        if (this.myElement instanceof PyTargetExpression && PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyComprehensionElement.class) != null) {
            List<RatedResolveResult> list = ResolveResultList.to((PsiElement)this.myElement);
            if (list == null) {
                PyReferenceImpl.$$$reportNull$$$0(18);
            }
            return list;
        }
        PsiElement realContext = PyPsiUtils.getRealContext((PsiElement)this.myElement);
        if (!this.myContext.getTypeEvalContext().maySwitchToAST(realContext) && realContext instanceof PyFile) {
            List<RatedResolveResult> list = ((PyFile)realContext).multiResolveName(referencedName);
            if (list == null) {
                PyReferenceImpl.$$$reportNull$$$0(19);
            }
            return list;
        }
        PyResolveProcessor processor2 = new PyResolveProcessor(referencedName);
        PsiElement roof = this.findResolveRoof(referencedName, realContext);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, (PsiElement)this.myElement, referencedName, roof);
        List<RatedResolveResult> list = this.getResultsFromProcessor(referencedName, processor2, realContext, roof);
        if (list == null) {
            PyReferenceImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    protected final List<RatedResolveResult> getResultsFromProcessor(@NotNull String referencedName, @NotNull PyResolveProcessor processor2, @Nullable PsiElement realContext, @Nullable PsiElement resolveRoof) {
        if (referencedName == null) {
            PyReferenceImpl.$$$reportNull$$$0(21);
        }
        if (processor2 == null) {
            PyReferenceImpl.$$$reportNull$$$0(22);
        }
        boolean unreachableLocalDeclaration = false;
        Supplier<ScopeOwner> resolveInParentScope = null;
        ResolveResultList resultList = new ResolveResultList();
        ScopeOwner referenceOwner = ScopeUtil.getScopeOwner(realContext);
        TypeEvalContext typeEvalContext = this.myContext.getTypeEvalContext();
        ScopeOwner resolvedOwner = processor2.getOwner();
        Collection<PsiElement> resolvedElements = processor2.getElements();
        if (resolvedOwner != null && !resolvedElements.isEmpty() && !ControlFlowCache.getScope(resolvedOwner).isGlobal(referencedName)) {
            if (resolvedOwner == referenceOwner) {
                List<Instruction> instructions = this.getLatestDefinitions(referencedName, resolvedOwner, realContext);
                ResolveResultList latestDefs = PyReferenceImpl.resolveToLatestDefs(instructions, realContext, referencedName, typeEvalContext);
                if (!latestDefs.isEmpty()) {
                    if (ContainerUtil.exists((Iterable)latestDefs, result -> result.getElement() instanceof PyCallable)) {
                        return ((StreamEx)((StreamEx)StreamEx.of(resolvedElements).nonNull().filter(element -> PyUtil.inSameFile(element, realContext))).filter(element -> PyiUtil.isOverload(element, typeEvalContext))).map(element -> new RatedResolveResult(PyReferenceImpl.getRate(element, typeEvalContext), (PsiElement)element)).prepend((Collection)latestDefs).toList();
                    }
                    return latestDefs;
                }
                if (resolvedOwner instanceof PyClass) {
                    resolveInParentScope = () -> PyResolveUtil.parentScopeForUnresolvedClassLevelName((PyClass)resolvedOwner, referencedName);
                } else if (instructions.isEmpty() && this.allInOwnScopeComprehensions(resolvedElements)) {
                    resolveInParentScope = () -> ScopeUtil.getScopeOwner((PsiElement)resolvedOwner);
                } else {
                    unreachableLocalDeclaration = true;
                }
            } else if (referenceOwner != null) {
                PyClass outermostNestedClass;
                if (!PyReferenceImpl.allowsForwardOutgoingReferencesInClass(this.myElement) && (outermostNestedClass = PyReferenceImpl.outermostNestedClass(referenceOwner, resolvedOwner)) != null) {
                    List<Instruction> instructions = PyDefUseUtil.getLatestDefs(resolvedOwner, referencedName, (PsiElement)outermostNestedClass, false, true);
                    return PyReferenceImpl.resolveToLatestDefs(instructions, (PsiElement)outermostNestedClass, referencedName, typeEvalContext);
                }
                Scope referenceScope = ControlFlowCache.getScope(referenceOwner);
                if (referenceScope.containsDeclaration(referencedName)) {
                    unreachableLocalDeclaration = true;
                }
            }
        }
        if (!unreachableLocalDeclaration) {
            if (resolveInParentScope != null) {
                processor2 = new PyResolveProcessor(referencedName);
                ScopeOwner parentScope = (ScopeOwner)resolveInParentScope.get();
                if (parentScope != null) {
                    PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, parentScope, referencedName, resolveRoof);
                }
            }
            for (Map.Entry<PsiElement, PyImportedNameDefiner> entry : processor2.getResults().entrySet()) {
                PsiElement resolved = entry.getKey();
                PyImportedNameDefiner definer = entry.getValue();
                if (resolved != null) {
                    if (typeEvalContext.maySwitchToAST(resolved) && PyReferenceImpl.isInnerComprehension(realContext, resolved)) continue;
                    if (definer == null) {
                        resultList.poke(resolved, PyReferenceImpl.getRate(resolved, typeEvalContext));
                        continue;
                    }
                    resultList.poke((PsiElement)definer, PyReferenceImpl.getRate((PsiElement)definer, typeEvalContext));
                    resultList.add(new ImportedResolveResult(resolved, PyReferenceImpl.getRate(resolved, typeEvalContext), definer));
                    continue;
                }
                if (definer == null) continue;
                resultList.add(new ImportedResolveResult(null, -1000, definer));
            }
            if (!resultList.isEmpty()) {
                return resultList;
            }
        }
        return this.resolveByReferenceResolveProviders();
    }

    @NotNull
    protected List<Instruction> getLatestDefinitions(@NotNull String referencedName, @Nullable ScopeOwner resolvedOwner, @Nullable PsiElement realContext) {
        if (referencedName == null) {
            PyReferenceImpl.$$$reportNull$$$0(23);
        }
        List<Instruction> list = PyDefUseUtil.getLatestDefs(resolvedOwner, referencedName, realContext, false, true);
        if (list == null) {
            PyReferenceImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    private boolean allInOwnScopeComprehensions(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            PyReferenceImpl.$$$reportNull$$$0(25);
        }
        return StreamEx.of(elements).allMatch(this::isInOwnScopeComprehension);
    }

    private static boolean allowsForwardOutgoingReferencesInClass(@NotNull PyQualifiedExpression element) {
        if (element == null) {
            PyReferenceImpl.$$$reportNull$$$0(26);
        }
        return ContainerUtil.exists((Iterable)PyReferenceResolveProvider.EP_NAME.getExtensionList(), provider -> provider.allowsForwardOutgoingReferencesInClass(element));
    }

    @Nullable
    private static PyClass outermostNestedClass(@NotNull ScopeOwner referenceOwner, @NotNull ScopeOwner resolvedOwner) {
        if (referenceOwner == null) {
            PyReferenceImpl.$$$reportNull$$$0(27);
        }
        if (resolvedOwner == null) {
            PyReferenceImpl.$$$reportNull$$$0(28);
        }
        PyClass current = PyUtil.as(referenceOwner, PyClass.class);
        ScopeOwner outer = ScopeUtil.getScopeOwner((PsiElement)current);
        while (outer != resolvedOwner) {
            current = PyUtil.as(outer, PyClass.class);
            if (current == null) {
                return null;
            }
            outer = ScopeUtil.getScopeOwner((PsiElement)outer);
        }
        return current;
    }

    @NotNull
    private ResolveResultList resolveByOverridingReferenceResolveProviders() {
        ResolveResultList results = new ResolveResultList();
        TypeEvalContext context2 = this.myContext.getTypeEvalContext();
        PyReferenceResolveProvider.EP_NAME.getExtensionList().stream().filter(PyOverridingReferenceResolveProvider.class::isInstance).map(provider -> provider.resolveName(this.myElement, context2)).forEach(results::addAll);
        ResolveResultList resolveResultList = results;
        if (resolveResultList == null) {
            PyReferenceImpl.$$$reportNull$$$0(29);
        }
        return resolveResultList;
    }

    @NotNull
    private ResolveResultList resolveByReferenceResolveProviders() {
        ResolveResultList results = new ResolveResultList();
        TypeEvalContext context2 = this.myContext.getTypeEvalContext();
        for (PyReferenceResolveProvider provider : PyReferenceResolveProvider.EP_NAME.getExtensionList()) {
            if (provider instanceof PyOverridingReferenceResolveProvider) continue;
            results.addAll(provider.resolveName(this.myElement, context2));
        }
        ResolveResultList resolveResultList = results;
        if (resolveResultList == null) {
            PyReferenceImpl.$$$reportNull$$$0(30);
        }
        return resolveResultList;
    }

    private PsiElement findResolveRoof(String referencedName, PsiElement realContext) {
        ScopeOwner scopeOwner;
        if (PyUtil.isClassPrivateName(referencedName)) {
            PyElement one = this.myElement;
            while ((one = ScopeUtil.getScopeOwner((PsiElement)one)) instanceof PyFunction) {
            }
            if (one instanceof PyClass && !PsiTreeUtil.isAncestor((PsiElement)((PyClass)one).getSuperClassExpressionList(), (PsiElement)this.myElement, (boolean)false)) {
                return one;
            }
        }
        if (this.myElement instanceof PyTargetExpression && (scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, ScopeOwner.class)) != null) {
            ScopeOwner nonlocalOwner;
            String name;
            Scope scope = ControlFlowCache.getScope(scopeOwner);
            if (scope.isNonlocal(name = this.myElement.getName()) && (nonlocalOwner = ScopeUtil.getDeclarationScopeOwner((PsiElement)this.myElement, referencedName)) != null && !(nonlocalOwner instanceof PyFile)) {
                return nonlocalOwner;
            }
            if (!scope.isGlobal(name)) {
                return scopeOwner;
            }
        }
        return realContext.getContainingFile();
    }

    public static int getRate(@Nullable PsiElement elt, @NotNull TypeEvalContext context2) {
        PsiElement parent;
        if (context2 == null) {
            PyReferenceImpl.$$$reportNull$$$0(31);
        }
        int rate = elt instanceof PyTargetExpression && context2.maySwitchToAST(elt) ? ((parent = elt.getParent()) instanceof PyGlobalStatement || parent instanceof PyNonlocalStatement ? -1000 : 0) : (elt instanceof PyImportedNameDefiner || elt instanceof PyReferenceExpression || elt != null && !PyiUtil.isInsideStub(elt) && PyiUtil.isOverload(elt, context2) ? -1000 : 0);
        return rate;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            PyReferenceImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PyReferenceImpl.$$$reportNull$$$0(33);
        }
        ASTNode nameElement = this.myElement.getNameElement();
        for (PsiElement resolved : PyUtil.multiResolveTopPriority((PsiElement)this.myElement, this.myContext)) {
            if (resolved instanceof PyFile && newElementName.endsWith(".py")) {
                newElementName = StringUtil.trimEnd((String)newElementName, (String)".py");
                continue;
            }
            if (!(resolved instanceof PyiFile) || !newElementName.endsWith(".pyi")) continue;
            newElementName = StringUtil.trimEnd((String)newElementName, (String)".pyi");
        }
        if (nameElement != null && PyNames.isIdentifier(newElementName)) {
            ASTNode newNameElement = PyUtil.createNewName(this.myElement, newElementName);
            this.myElement.getNode().replaceChild(nameElement, newNameElement);
        }
        return this.myElement;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PyReferenceImpl.$$$reportNull$$$0(34);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PyReferenceImpl.$$$reportNull$$$0(35);
        }
        if (element instanceof PsiFileSystemItem) {
            PsiDirectory directory2;
            PyFile file;
            PsiElement resolveResult = this.resolve();
            if (resolveResult instanceof PyImportedModule) {
                resolveResult = resolveResult.getNavigationElement();
            }
            if (element instanceof PsiDirectory && (resolveResult instanceof PyFile ? PyUtil.isPackage(file = (PyFile)resolveResult) && file.getContainingDirectory() == element : resolveResult instanceof PsiDirectory && PyUtil.isPackage(directory2 = (PsiDirectory)resolveResult, null) && directory2 == element)) {
                return true;
            }
            return resolveResult == element;
        }
        if (element instanceof PsiNamedElement) {
            String elementName = ((PsiNamedElement)element).getName();
            if (Objects.equals(this.myElement.getReferencedName(), elementName) || "__init__".equals(elementName)) {
                if (!this.haveQualifiers(element)) {
                    ScopeOwner ourScopeOwner = ScopeUtil.getScopeOwner(this.getElement());
                    ScopeOwner theirScopeOwner = ScopeUtil.getScopeOwner(element);
                    if ((element instanceof PyParameter || element instanceof PyTargetExpression) && this.resolvesToSameLocal(element, elementName, ourScopeOwner, theirScopeOwner)) {
                        return true;
                    }
                    List resolveResults = ((StreamEx)StreamEx.of((Object[])this.multiResolve(false)).filter(r -> !(r instanceof ImplicitResolveResult))).map(r -> r.getElement()).toList();
                    for (PsiElement resolveResult : resolveResults) {
                        if (resolveResult == element) {
                            return true;
                        }
                        if (!this.haveQualifiers(element) && ourScopeOwner != null && theirScopeOwner != null && this.resolvesToSameGlobal(element, elementName, ourScopeOwner, theirScopeOwner, resolveResult)) {
                            return true;
                        }
                        if (!this.resolvesToWrapper(element, resolveResult)) continue;
                        return true;
                    }
                }
                if (element instanceof PyExpression) {
                    PyExpression expr = (PyExpression)element;
                    if (PyUtil.isClassAttribute((PsiElement)this.myElement) && (PyUtil.isClassAttribute((PsiElement)expr) || PyUtil.isInstanceAttribute(expr))) {
                        PyClass c1 = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
                        PyClass c2 = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyClass.class);
                        TypeEvalContext context2 = this.myContext.getTypeEvalContext();
                        if (c1 != null && c2 != null && (c1.isSubclass(c2, context2) || c2.isSubclass(c1, context2))) {
                            return true;
                        }
                    }
                }
            }
        }
        return PyReferenceCustomTargetChecker.Companion.isReferenceTo(this, element);
    }

    private boolean resolvesToSameLocal(PsiElement element, String elementName, ScopeOwner ourScopeOwner, ScopeOwner theirScopeOwner) {
        PsiElement ourContainer = PyReferenceImpl.findContainer(this.getElement());
        PsiElement theirContainer = PyReferenceImpl.findContainer(element);
        if (ourContainer != null) {
            if (ourContainer == theirContainer && ourScopeOwner == theirScopeOwner) {
                return true;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)theirContainer, (PsiElement)ourContainer, (boolean)true)) {
                if (ourContainer instanceof PyComprehensionElement && PyReferenceImpl.containsDeclaration((PyComprehensionElement)ourContainer, elementName)) {
                    return false;
                }
                ScopeOwner owner = ourScopeOwner;
                while (owner != theirScopeOwner && owner != null) {
                    if (ControlFlowCache.getScope(owner).containsDeclaration(elementName)) {
                        return false;
                    }
                    owner = ScopeUtil.getScopeOwner((PsiElement)owner);
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement findContainer(@NotNull PsiElement element) {
        PyElement parent;
        if (element == null) {
            PyReferenceImpl.$$$reportNull$$$0(36);
        }
        if ((parent = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{ScopeOwner.class, PyComprehensionElement.class})) instanceof PyListCompExpression && LanguageLevel.forElement(element).isPython2()) {
            return PyReferenceImpl.findContainer((PsiElement)parent);
        }
        return parent;
    }

    private static boolean containsDeclaration(@NotNull PyComprehensionElement comprehensionElement, @NotNull String variableName) {
        if (comprehensionElement == null) {
            PyReferenceImpl.$$$reportNull$$$0(37);
        }
        if (variableName == null) {
            PyReferenceImpl.$$$reportNull$$$0(38);
        }
        for (PyComprehensionForComponent forComponent : comprehensionElement.getForComponents()) {
            PyExpression iteratorVariable = forComponent.getIteratorVariable();
            if (iteratorVariable instanceof PyTupleExpression) {
                for (PyExpression variable : (PyTupleExpression)iteratorVariable) {
                    if (!(variable instanceof PyTargetExpression) || !variableName.equals(variable.getName())) continue;
                    return true;
                }
                continue;
            }
            if (!(iteratorVariable instanceof PyTargetExpression) || !variableName.equals(iteratorVariable.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean resolvesToSameGlobal(@NotNull PsiElement element, @Nullable String elementName, @NotNull ScopeOwner ourScopeOwner, @NotNull ScopeOwner theirScopeOwner, @Nullable PsiElement resolveResult) {
        ScopeOwner resolvedScopeOwner;
        PsiFile theirFile;
        PsiFile ourFile;
        if (element == null) {
            PyReferenceImpl.$$$reportNull$$$0(39);
        }
        if (ourScopeOwner == null) {
            PyReferenceImpl.$$$reportNull$$$0(40);
        }
        if (theirScopeOwner == null) {
            PyReferenceImpl.$$$reportNull$$$0(41);
        }
        if ((ourFile = this.getElement().getContainingFile()) == (theirFile = element.getContainingFile())) {
            boolean ourIsGlobal = ControlFlowCache.getScope(ourScopeOwner).isGlobal(elementName);
            boolean theirIsGlobal = ControlFlowCache.getScope(theirScopeOwner).isGlobal(elementName);
            if (ourIsGlobal && theirIsGlobal) {
                return true;
            }
        }
        if ((resolvedScopeOwner = ScopeUtil.getScopeOwner(resolveResult)) != null && resolveResult.getContainingFile() == theirFile && ControlFlowCache.getScope(resolvedScopeOwner).isGlobal(elementName) && ControlFlowCache.getScope(theirScopeOwner).isGlobal(elementName)) {
            return true;
        }
        return resolvedScopeOwner == ourFile && ControlFlowCache.getScope(theirScopeOwner).isGlobal(elementName);
    }

    protected boolean resolvesToWrapper(PsiElement element, PsiElement resolveResult) {
        PyCallExpression call;
        Pair<String, PyFunction> functionPair;
        PyExpression assignedValue;
        return element instanceof PyFunction && ((PyFunction)element).getContainingClass() != null && resolveResult instanceof PyTargetExpression && (assignedValue = ((PyTargetExpression)resolveResult).findAssignedValue()) instanceof PyCallExpression && (functionPair = PyCallExpressionHelper.interpretAsModifierWrappingCall(call = (PyCallExpression)assignedValue)) != null && functionPair.second == element;
    }

    private boolean haveQualifiers(PsiElement element) {
        if (this.myElement.isQualified()) {
            return true;
        }
        return element instanceof PyQualifiedExpression && ((PyQualifiedExpression)element).isQualified();
    }

    public Object @NotNull [] getVariants() {
        ArrayList<Object> ret = new ArrayList<Object>();
        PyQualifiedExpression originalElement = (PyQualifiedExpression)CompletionUtilCoreImpl.getOriginalElement((PsiElement)this.myElement);
        PyQualifiedExpression element = originalElement != null ? originalElement : this.myElement;
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)element);
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)this.myElement);
        CompletionVariantsProcessor processor2 = new CompletionVariantsProcessor((PsiElement)element, (Condition<PsiElement>)((Condition)e -> {
            if (builtinCache.isBuiltin((PsiElement)e)) {
                PyFile file;
                String name;
                if (e instanceof PyImportElement) {
                    return false;
                }
                String string = name = e instanceof PyElement ? ((PyElement)e).getName() : null;
                if (PyUtil.getInitialUnderscores(name) == 1) {
                    return false;
                }
                if (languageLevel.isPython2() && "print".equals(name) && (file = PyUtil.as(this.myElement.getContainingFile(), PyFile.class)) != null && !file.hasImportFromFuture(FutureFeature.PRINT_FUNCTION)) {
                    return false;
                }
            } else if (ScopeUtil.getScopeOwner(e) == ScopeUtil.getScopeOwner((PsiElement)element)) {
                return PyDefUseUtil.isDefinedBefore(e, (PsiElement)element);
            }
            return true;
        }), null);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, (PsiElement)element, null, null);
        TypeEvalContext context2 = TypeEvalContext.codeCompletion(element.getProject(), element.getContainingFile());
        KeywordArgumentCompletionUtil.collectFunctionArgNames(element, ret, context2, true);
        PyFile builtinsFile = builtinCache.getBuiltinsFile();
        if (builtinsFile != null) {
            PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, builtinsFile, null, null);
        }
        if (PyUtil.getInitialUnderscores(element.getName()) >= 2) {
            if (PyPsiUtils.getRealContext((PsiElement)element).getContainingFile() instanceof PyFile) {
                for (String name : PyModuleType.getPossibleInstanceMembers()) {
                    ret.add(LookupElementBuilder.create((String)name).withIcon(PlatformIcons.FIELD_ICON));
                }
            }
            if (!languageLevel.isPython2()) {
                Optional.ofNullable((PyFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyFunction.class)).map(PyPossibleClassMember::getContainingClass).ifPresent(pyClass -> ret.add(LookupElementBuilder.create((String)"__class__")));
            }
        }
        ret.addAll(this.getOriginalElements(processor2));
        Object[] objectArray = ret.toArray();
        if (objectArray == null) {
            PyReferenceImpl.$$$reportNull$$$0(42);
        }
        return objectArray;
    }

    protected List<LookupElement> getOriginalElements(@NotNull CompletionVariantsProcessor processor2) {
        if (processor2 == null) {
            PyReferenceImpl.$$$reportNull$$$0(43);
        }
        ArrayList<LookupElement> ret = new ArrayList<LookupElement>();
        for (LookupElement item : processor2.getResultList()) {
            PsiElement original;
            PsiElement e = item.getPsiElement();
            if (e != null && (original = CompletionUtilCoreImpl.getOriginalElement((PsiElement)e)) == null) continue;
            ret.add(item);
        }
        return ret;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context2) {
        if (this.isBuiltInConstant()) {
            return null;
        }
        PyExpression qualifier = this.myElement.getQualifier();
        if (qualifier == null) {
            return HighlightSeverity.ERROR;
        }
        if (context2.getType(qualifier) != null) {
            return HighlightSeverity.WARNING;
        }
        return null;
    }

    private boolean isBuiltInConstant() {
        String name = this.myElement.getReferencedName();
        return "None".equals(name) || "True".equals(name) || "False".equals(name) || "__debug__".equals(name);
    }

    @Override
    @Nullable
    public String getUnresolvedDescription() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyReferenceImpl that = (PyReferenceImpl)o;
        if (!this.myElement.equals(that.myElement)) {
            return false;
        }
        return this.myContext.equals(that.myContext);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 32: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 32: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/references/PyReferenceImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 8: 
            case 26: 
            case 34: 
            case 35: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedName";
                break;
            }
            case 22: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOwner";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedOwner";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comprehensionElement";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ourScopeOwner";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theirScopeOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/references/PyReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToLatestDefs";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "changePropertyMethodToSameNameGetter";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDefinitions";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveByOverridingReferenceResolveProviders";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveByReferenceResolveProviders";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 32: 
            case 42: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveToLatestDefs";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "changePropertyMethodToSameNameGetter";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getResultsFromProcessor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLatestDefinitions";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "allInOwnScopeComprehensions";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "allowsForwardOutgoingReferencesInClass";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "outermostNestedClass";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getRate";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findContainer";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "containsDeclaration";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToSameGlobal";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 32: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachingResolver
    implements ResolveCache.PolyVariantResolver<PyReferenceImpl> {
        public static final CachingResolver INSTANCE = new CachingResolver();

        private CachingResolver() {
        }

        public ResolveResult @NotNull [] resolve(@NotNull PyReferenceImpl ref, boolean incompleteCode) {
            if (ref == null) {
                CachingResolver.$$$reportNull$$$0(0);
            }
            ResolveResult[] resolveResultArray = ref.multiResolveInner();
            if (resolveResultArray == null) {
                CachingResolver.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/references/PyReferenceImpl$CachingResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/references/PyReferenceImpl$CachingResolver";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

