/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.PyDataclassParameters;
import com.jetbrains.python.codeInsight.PyDataclassesKt;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStub;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import com.jetbrains.python.psi.impl.stubs.PyDataclassFieldStubType;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.stubs.PyDataclassFieldStub;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\u0018\u0010\b\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/psi/impl/stubs/PyDataclassFieldStubImpl;", "Lcom/jetbrains/python/psi/stubs/PyDataclassFieldStub;", "calleeName", "Lcom/intellij/psi/util/QualifiedName;", "parameters", "Lcom/jetbrains/python/psi/impl/stubs/PyDataclassFieldStubImpl$FieldParameters;", "(Lcom/intellij/psi/util/QualifiedName;Lcom/jetbrains/python/psi/impl/stubs/PyDataclassFieldStubImpl$FieldParameters;)V", "getCalleeName", "getTypeClass", "Ljava/lang/Class;", "Lcom/jetbrains/python/psi/impl/stubs/CustomTargetExpressionStubType;", "Lcom/jetbrains/python/psi/impl/stubs/CustomTargetExpressionStub;", "hasDefault", "", "hasDefaultFactory", "initValue", "kwOnly", "serialize", "", "stream", "Lcom/intellij/psi/stubs/StubOutputStream;", "Companion", "FieldParameters", "intellij.python.psi.impl"})
public final class PyDataclassFieldStubImpl
implements PyDataclassFieldStub {
    private final QualifiedName calleeName;
    private final FieldParameters parameters;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Class<? extends CustomTargetExpressionStubType<? extends CustomTargetExpressionStub>> getTypeClass() {
        return PyDataclassFieldStubType.class;
    }

    @Override
    public void serialize(@NotNull StubOutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.writeName(this.calleeName.toString());
        stream.writeBoolean(this.parameters.getHasDefault());
        stream.writeBoolean(this.parameters.getHasDefaultFactory());
        stream.writeBoolean(this.parameters.getInitValue());
        stream.writeBoolean(this.parameters.getKwOnly());
    }

    @Override
    @NotNull
    public QualifiedName getCalleeName() {
        return this.calleeName;
    }

    @Override
    public boolean hasDefault() {
        return this.parameters.getHasDefault();
    }

    @Override
    public boolean hasDefaultFactory() {
        return this.parameters.getHasDefaultFactory();
    }

    @Override
    public boolean initValue() {
        return this.parameters.getInitValue();
    }

    @Override
    public boolean kwOnly() {
        return this.parameters.getKwOnly();
    }

    private PyDataclassFieldStubImpl(QualifiedName calleeName, FieldParameters parameters) {
        this.calleeName = calleeName;
        this.parameters = parameters;
    }

    public /* synthetic */ PyDataclassFieldStubImpl(QualifiedName calleeName, FieldParameters parameters, DefaultConstructorMarker $constructor_marker) {
        this(calleeName, parameters);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/python/psi/impl/stubs/PyDataclassFieldStubImpl$FieldParameters;", "", "hasDefault", "", "hasDefaultFactory", "initValue", "kwOnly", "(ZZZZ)V", "getHasDefault", "()Z", "getHasDefaultFactory", "getInitValue", "getKwOnly", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.python.psi.impl"})
    private static final class FieldParameters {
        private final boolean hasDefault;
        private final boolean hasDefaultFactory;
        private final boolean initValue;
        private final boolean kwOnly;

        public final boolean getHasDefault() {
            return this.hasDefault;
        }

        public final boolean getHasDefaultFactory() {
            return this.hasDefaultFactory;
        }

        public final boolean getInitValue() {
            return this.initValue;
        }

        public final boolean getKwOnly() {
            return this.kwOnly;
        }

        public FieldParameters(boolean hasDefault, boolean hasDefaultFactory, boolean initValue, boolean kwOnly) {
            this.hasDefault = hasDefault;
            this.hasDefaultFactory = hasDefaultFactory;
            this.initValue = initValue;
            this.kwOnly = kwOnly;
        }

        public final boolean component1() {
            return this.hasDefault;
        }

        public final boolean component2() {
            return this.hasDefaultFactory;
        }

        public final boolean component3() {
            return this.initValue;
        }

        public final boolean component4() {
            return this.kwOnly;
        }

        @NotNull
        public final FieldParameters copy(boolean hasDefault, boolean hasDefaultFactory, boolean initValue, boolean kwOnly) {
            return new FieldParameters(hasDefault, hasDefaultFactory, initValue, kwOnly);
        }

        public static /* synthetic */ FieldParameters copy$default(FieldParameters fieldParameters, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = fieldParameters.hasDefault;
            }
            if ((n & 2) != 0) {
                bl2 = fieldParameters.hasDefaultFactory;
            }
            if ((n & 4) != 0) {
                bl3 = fieldParameters.initValue;
            }
            if ((n & 8) != 0) {
                bl4 = fieldParameters.kwOnly;
            }
            return fieldParameters.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "FieldParameters(hasDefault=" + this.hasDefault + ", hasDefaultFactory=" + this.hasDefaultFactory + ", initValue=" + this.initValue + ", kwOnly=" + this.kwOnly + ")";
        }

        public int hashCode() {
            int n = this.hasDefault ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.hasDefaultFactory ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            int n4 = (n2 + n3) * 31;
            int n5 = this.initValue ? 1 : 0;
            if (n5 != 0) {
                n5 = 1;
            }
            int n6 = (n4 + n5) * 31;
            int n7 = this.kwOnly ? 1 : 0;
            if (n7 != 0) {
                n7 = 1;
            }
            return n6 + n7;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FieldParameters)) break block3;
                    FieldParameters fieldParameters = (FieldParameters)object;
                    if (this.hasDefault != fieldParameters.hasDefault || this.hasDefaultFactory != fieldParameters.hasDefaultFactory || this.initValue != fieldParameters.initValue || this.kwOnly != fieldParameters.kwOnly) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/psi/impl/stubs/PyDataclassFieldStubImpl$Companion;", "", "()V", "analyzeArguments", "Lcom/jetbrains/python/psi/impl/stubs/PyDataclassFieldStubImpl$FieldParameters;", "call", "Lcom/jetbrains/python/psi/PyCallExpression;", "type", "Lcom/jetbrains/python/codeInsight/PyDataclassParameters$PredefinedType;", "calculateCalleeNameAndType", "Lkotlin/Pair;", "Lcom/intellij/psi/util/QualifiedName;", "callee", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "create", "Lcom/jetbrains/python/psi/stubs/PyDataclassFieldStub;", "expression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "deserialize", "stream", "Lcom/intellij/psi/stubs/StubInputStream;", "intellij.python.psi.impl"})
    public static final class Companion {
        @Nullable
        public final PyDataclassFieldStub create(@NotNull PyTargetExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            PyExpression pyExpression = expression.findAssignedValue();
            if (!(pyExpression instanceof PyCallExpression)) {
                pyExpression = null;
            }
            PyCallExpression pyCallExpression = (PyCallExpression)pyExpression;
            if (pyCallExpression == null) {
                return null;
            }
            PyCallExpression value = pyCallExpression;
            PyExpression pyExpression2 = value.getCallee();
            if (!(pyExpression2 instanceof PyReferenceExpression)) {
                pyExpression2 = null;
            }
            PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)pyExpression2;
            if (pyReferenceExpression == null) {
                return null;
            }
            PyReferenceExpression callee = pyReferenceExpression;
            Pair<QualifiedName, PyDataclassParameters.PredefinedType> pair = this.calculateCalleeNameAndType(callee);
            if (pair == null) {
                return null;
            }
            Pair<QualifiedName, PyDataclassParameters.PredefinedType> calleeNameAndType = pair;
            FieldParameters fieldParameters = this.analyzeArguments(value, (PyDataclassParameters.PredefinedType)calleeNameAndType.getSecond());
            if (fieldParameters == null) {
                return null;
            }
            FieldParameters parameters = fieldParameters;
            return new PyDataclassFieldStubImpl((QualifiedName)calleeNameAndType.getFirst(), parameters, null);
        }

        @Nullable
        public final PyDataclassFieldStub deserialize(@NotNull StubInputStream stream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            String string = stream.readNameString();
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stream.readNameString() ?: return null");
            String calleeName = string;
            boolean hasDefault = stream.readBoolean();
            boolean hasDefaultFactory = stream.readBoolean();
            boolean initValue = stream.readBoolean();
            boolean kwOnly = stream.readBoolean();
            QualifiedName qualifiedName = QualifiedName.fromDottedString((String)calleeName);
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"QualifiedName.fromDottedString(calleeName)");
            return new PyDataclassFieldStubImpl(qualifiedName, new FieldParameters(hasDefault, hasDefaultFactory, initValue, kwOnly), null);
        }

        private final Pair<QualifiedName, PyDataclassParameters.PredefinedType> calculateCalleeNameAndType(PyReferenceExpression callee) {
            QualifiedName qualifiedName = callee.asQualifiedName();
            if (qualifiedName == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"callee.asQualifiedName() ?: return null");
            QualifiedName qualifiedName2 = qualifiedName;
            QualifiedName qualifiedName3 = QualifiedName.fromComponents((String[])new String[]{"dataclasses", "field"});
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedName3, (String)"QualifiedName.fromCompon\u2026s(\"dataclasses\", \"field\")");
            QualifiedName dataclassesField = qualifiedName3;
            QualifiedName qualifiedName4 = QualifiedName.fromComponents((String[])new String[]{"attr", "ib"});
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedName4, (String)"QualifiedName.fromComponents(\"attr\", \"ib\")");
            QualifiedName attrIb = qualifiedName4;
            QualifiedName qualifiedName5 = QualifiedName.fromComponents((String[])new String[]{"attr", "attr"});
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedName5, (String)"QualifiedName.fromComponents(\"attr\", \"attr\")");
            QualifiedName attrAttr = qualifiedName5;
            QualifiedName qualifiedName6 = QualifiedName.fromComponents((String[])new String[]{"attr", "attrib"});
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedName6, (String)"QualifiedName.fromComponents(\"attr\", \"attrib\")");
            QualifiedName attrAttrib = qualifiedName6;
            for (QualifiedName originalQName : PyResolveUtil.resolveImportedElementQNameLocally(callee)) {
                QualifiedName qualifiedName7 = originalQName;
                if (Intrinsics.areEqual((Object)qualifiedName7, (Object)dataclassesField)) {
                    return TuplesKt.to((Object)qualifiedName2, (Object)PyDataclassParameters.PredefinedType.STD);
                }
                if (!Intrinsics.areEqual((Object)qualifiedName7, (Object)attrIb) && !Intrinsics.areEqual((Object)qualifiedName7, (Object)attrAttr) && !Intrinsics.areEqual((Object)qualifiedName7, (Object)attrAttrib)) continue;
                return TuplesKt.to((Object)qualifiedName2, (Object)PyDataclassParameters.PredefinedType.ATTRS);
            }
            return null;
        }

        private final FieldParameters analyzeArguments(PyCallExpression call, PyDataclassParameters.PredefinedType type) {
            boolean initValue = PyEvaluator.evaluateAsBooleanNoResolve(call.getKeywordArgument("init"), true);
            if (type == PyDataclassParameters.PredefinedType.STD) {
                PyExpression pyExpression = call.getKeywordArgument("default");
                PyExpression defaultFactory = call.getKeywordArgument("default_factory");
                return new FieldParameters(pyExpression != null && !PyDataclassesKt.resolvesToOmittedDefault(pyExpression, type), defaultFactory != null && !PyDataclassesKt.resolvesToOmittedDefault(defaultFactory, type), initValue, false);
            }
            if (type == PyDataclassParameters.PredefinedType.ATTRS) {
                PyExpression pyExpression = call.getKeywordArgument("default");
                PyExpression pyExpression2 = call.getKeywordArgument("factory");
                boolean bl = false;
                boolean bl2 = false;
                PyExpression it = pyExpression2;
                boolean bl3 = false;
                boolean hasFactory = it != null && Intrinsics.areEqual((Object)it.getText(), (Object)"None") ^ true;
                boolean kwOnly = PyEvaluator.evaluateAsBooleanNoResolve(call.getKeywordArgument("kw_only"), false);
                if (pyExpression != null && !PyDataclassesKt.resolvesToOmittedDefault(pyExpression, type)) {
                    PyReferenceExpression callee;
                    PyExpression pyExpression3 = pyExpression;
                    if (!(pyExpression3 instanceof PyCallExpression)) {
                        pyExpression3 = null;
                    }
                    PyCallExpression pyCallExpression = (PyCallExpression)pyExpression3;
                    PyExpression pyExpression4 = pyCallExpression != null ? pyCallExpression.getCallee() : null;
                    if (!(pyExpression4 instanceof PyReferenceExpression)) {
                        pyExpression4 = null;
                    }
                    boolean hasFactoryInDefault = (callee = (PyReferenceExpression)pyExpression4) != null && PyResolveUtil.resolveImportedElementQNameLocally(callee).contains(QualifiedName.fromComponents((String[])new String[]{"attr", "Factory"}));
                    return new FieldParameters(!hasFactoryInDefault, hasFactory || hasFactoryInDefault, initValue, kwOnly);
                }
                return new FieldParameters(false, hasFactory, initValue, kwOnly);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

