/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyABCUtil {
    private PyABCUtil() {
    }

    public static boolean isSubclass(@NotNull PyClass subClass, @NotNull PyClass superClass, @Nullable TypeEvalContext context2) {
        String superName;
        if (subClass == null) {
            PyABCUtil.$$$reportNull$$$0(0);
        }
        if (superClass == null) {
            PyABCUtil.$$$reportNull$$$0(1);
        }
        if ((superName = superClass.getName()) != null) {
            return PyABCUtil.isSubclass(subClass, superName, true, context2);
        }
        return false;
    }

    public static boolean isSubclass(@NotNull PyClass subClass, @NotNull String superClassName, @Nullable TypeEvalContext context2) {
        if (subClass == null) {
            PyABCUtil.$$$reportNull$$$0(2);
        }
        if (superClassName == null) {
            PyABCUtil.$$$reportNull$$$0(3);
        }
        return PyABCUtil.isSubclass(subClass, superClassName, true, context2);
    }

    public static boolean isSubclass(@NotNull PyClass subClass, @NotNull String superClassName, boolean inherited, @Nullable TypeEvalContext context2) {
        if (subClass == null) {
            PyABCUtil.$$$reportNull$$$0(4);
        }
        if (superClassName == null) {
            PyABCUtil.$$$reportNull$$$0(5);
        }
        if ("Callable".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__call__", inherited, context2);
        }
        if ("Hashable".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__hash__", inherited, context2);
        }
        boolean hasIter = PyABCUtil.hasMethod(subClass, "__iter__", inherited, context2);
        boolean hasGetItem = PyABCUtil.hasMethod(subClass, "__getitem__", inherited, context2);
        if ("Iterable".equals(superClassName)) {
            return hasIter || hasGetItem;
        }
        if ("Iterator".equals(superClassName)) {
            return hasIter && (PyABCUtil.hasMethod(subClass, "next", inherited, context2) || PyABCUtil.hasMethod(subClass, "__next__", inherited, context2)) || hasGetItem;
        }
        boolean isSized = PyABCUtil.hasMethod(subClass, "__len__", inherited, context2);
        if ("Sized".equals(superClassName)) {
            return isSized;
        }
        boolean isContainer = PyABCUtil.hasMethod(subClass, "__contains__", inherited, context2);
        if ("Container".equals(superClassName)) {
            return isContainer;
        }
        if ("Sequence".equals(superClassName)) {
            return isSized && hasIter && isContainer && hasGetItem;
        }
        if ("Mapping".equals(superClassName)) {
            return isSized && hasIter && isContainer && hasGetItem && PyABCUtil.hasMethod(subClass, "keys", inherited, context2);
        }
        if ("MutableMapping".equals(superClassName)) {
            boolean hasSetItem = PyABCUtil.hasMethod(subClass, "__setitem__", inherited, context2);
            boolean hasUpdate = PyABCUtil.hasMethod(subClass, "update", inherited, context2);
            return isSized && hasIter && isContainer && hasGetItem && hasSetItem && hasUpdate;
        }
        if ("Set".equals(superClassName)) {
            return isSized && hasIter && isContainer;
        }
        if ("MutableSet".equals(superClassName)) {
            return isSized && hasIter && isContainer && PyABCUtil.hasMethod(subClass, "discard", inherited, context2) && PyABCUtil.hasMethod(subClass, "add", inherited, context2);
        }
        if ("Complex".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__complex__", inherited, context2);
        }
        if ("Real".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__float__", inherited, context2);
        }
        if ("Integral".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__int__", inherited, context2);
        }
        if ("Number".equals(superClassName) && "Decimal".equals(subClass.getName())) {
            return true;
        }
        if ("AsyncIterable".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__aiter__", inherited, context2);
        }
        if ("Awaitable".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__await__", inherited, context2);
        }
        return false;
    }

    public static boolean isSubtype(@NotNull PyType type, @NotNull String superClassName, @NotNull TypeEvalContext context2) {
        if (type == null) {
            PyABCUtil.$$$reportNull$$$0(6);
        }
        if (superClassName == null) {
            PyABCUtil.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            PyABCUtil.$$$reportNull$$$0(8);
        }
        if (type instanceof PyStructuralType) {
            return true;
        }
        if (type instanceof PyClassType) {
            PyClassType classType = (PyClassType)type;
            PyClass pyClass = classType.getPyClass();
            if (classType.isDefinition()) {
                PyClassLikeType metaClassType = classType.getMetaClassType(context2, true);
                if (metaClassType instanceof PyClassType) {
                    PyClassType metaClass = (PyClassType)metaClassType;
                    return PyABCUtil.isSubclass(metaClass.getPyClass(), superClassName, true, context2);
                }
            } else {
                return PyABCUtil.isSubclass(pyClass, superClassName, true, context2);
            }
        }
        if (type instanceof PyUnionType) {
            return PyTypeUtil.toStream(type).nonNull().anyMatch(it -> PyABCUtil.isSubtype(it, superClassName, context2));
        }
        return false;
    }

    private static boolean hasMethod(PyClass cls, String name, boolean inherited, TypeEvalContext context2) {
        return cls.findMethodByName(name, inherited, context2) != null || cls.findClassAttribute(name, inherited, context2) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/types/PyABCUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSubclass";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isSubtype";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

