/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFunctionTypeImpl
implements PyFunctionType {
    @NotNull
    private final PyCallable myCallable;
    @NotNull
    private final List<PyCallableParameter> myParameters;

    public PyFunctionTypeImpl(@NotNull PyCallable callable) {
        if (callable == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(0);
        }
        this(callable, ContainerUtil.map((Object[])callable.getParameterList().getParameters(), PyCallableParameterImpl::psi));
    }

    public PyFunctionTypeImpl(@NotNull PyCallable callable, @NotNull List<PyCallableParameter> parameters) {
        if (callable == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(2);
        }
        this.myCallable = callable;
        this.myParameters = parameters;
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(3);
        }
        return context2.getReturnType(this.myCallable);
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context2, @NotNull PyCallSiteExpression callSite) {
        if (context2 == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(4);
        }
        if (callSite == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(5);
        }
        return this.myCallable.getCallType(context2, callSite);
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(6);
        }
        return this.myParameters;
    }

    @Override
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        PyClassType delegate;
        if (name == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(7);
        }
        if (direction == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(8);
        }
        if (resolveContext == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(9);
        }
        if ((delegate = this.selectCallableType(location, resolveContext.getTypeEvalContext())) == null) {
            return Collections.emptyList();
        }
        return delegate.resolveMember(name, location, direction, resolveContext);
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context2) {
        PyClassType delegate;
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(location.getProject(), location.getContainingFile());
        if (location instanceof PyReferenceExpression) {
            delegate = this.selectCallableType(((PyReferenceExpression)location).getQualifier(), typeEvalContext);
        } else {
            PyClass cls = PyPsiFacade.getInstance(this.myCallable.getProject()).createClassByQName("types.FunctionType", (PsiElement)this.myCallable);
            PyClassType pyClassType = delegate = cls != null ? new PyClassTypeImpl(cls, false) : null;
        }
        if (delegate == null) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        return delegate.getCompletionVariants(completionPrefix, location, context2);
    }

    @Nullable
    private PyClassType selectCallableType(@Nullable PyExpression location, @NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(10);
        }
        String className = location instanceof PyReferenceExpression && this.isBoundMethodReference((PyReferenceExpression)location, context2) ? "types.UnboundMethodType" : "types.FunctionType";
        PyClass cls = PyPsiFacade.getInstance(this.myCallable.getProject()).createClassByQName(className, (PsiElement)this.myCallable);
        return cls != null ? new PyClassTypeImpl(cls, false) : null;
    }

    private boolean isBoundMethodReference(@NotNull PyReferenceExpression location, @NotNull TypeEvalContext context2) {
        PyFunction function;
        boolean isNonStaticMethod;
        if (location == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(11);
        }
        if (context2 == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(12);
        }
        boolean bl = isNonStaticMethod = (function = PyUtil.as(this.getCallable(), PyFunction.class)) != null && function.getContainingClass() != null && function.getModifier() != PyFunction.Modifier.STATICMETHOD;
        if (isNonStaticMethod) {
            PyType qualifierType;
            PyExpression qualifier;
            if (LanguageLevel.forElement((PsiElement)location).isPython2()) {
                return true;
            }
            if (location.isQualified()) {
                qualifier = location.getQualifier();
            } else {
                PyResolveContext resolveContext = PyResolveContext.defaultContext(context2);
                qualifier = (PyExpression)ContainerUtil.getLastItem(location.followAssignmentsChain(resolveContext).getQualifiers());
            }
            if (qualifier != null && PyTypeUtil.toStream(qualifierType = context2.getType(qualifier)).select(PyClassType.class).anyMatch(it -> !it.isDefinition())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return "function";
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public void assertValid(String message) {
    }

    @Override
    @NotNull
    public PyCallable getCallable() {
        PyCallable pyCallable = this.myCallable;
        if (pyCallable == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(13);
        }
        return pyCallable;
    }

    @Override
    @NotNull
    public PyFunctionType dropSelf(@NotNull TypeEvalContext context2) {
        List<PyCallableParameter> parameters;
        if (context2 == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(14);
        }
        if (!ContainerUtil.isEmpty(parameters = this.getParameters(context2)) && parameters.get(0).isSelf()) {
            return new PyFunctionTypeImpl(this.myCallable, ContainerUtil.subList(parameters, (int)1));
        }
        PyFunctionTypeImpl pyFunctionTypeImpl = this;
        if (pyFunctionTypeImpl == null) {
            PyFunctionTypeImpl.$$$reportNull$$$0(15);
        }
        return pyFunctionTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyFunctionTypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyFunctionTypeImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallable";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "dropSelf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectCallableType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isBoundMethodReference";
                break;
            }
            case 13: 
            case 15: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dropSelf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

